/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard.graph;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.HCDMColorHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.SalaryStdGridFieldSeqEnum;
import kd.swc.hcdm.common.utils.FieldDataUtils;
import kd.swc.hcdm.formplugin.salarystandard.SalaryStandardBaseEdit;
import kd.swc.hcdm.formplugin.salarystandard.graph.CustomChartData;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryStandGraphPlugin
extends SalaryStandardBaseEdit {
    private static final String PAGEKEY_CACHE_COLOR = "pagekey_cache_color";
    private static final String GRAPH = "customchartap";
    private static final String PROJECT_TYPE = "project_type";
    private static final String MULPROJECT_TYPE = "mulproject_type";
    private static final String[] COLORS_SIXTEEN = new String[]{"#1890FF", "#40A9FF", "#26C9C3", "#45DAD1", "#73D13D", "#95DE64", "#BAE637", "#FBE139", "#FFD666", "#FFA940", "#F88D48", "#FF762A", "#E65E67", "#F273B5", "#9F69E2", "#6682F5"};
    private static final String[] COLORS_NINE = new String[]{"#40A9FF", "#45DAD1", "#73D13D", "#FFC53D", "#FFA940", "#F57582", "#9F69E2", "#6682F5", "#F273B5"};
    private static final String DEFAULT_WIDTH = "1000";
    private static final int INCREMENTAL_VALUE = 500;
    private static final String SUFFIX = "px";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        SalaryStandardEntryData stdData = this.getSalaryStandardEntryData();
        if (null == stdData) {
            return;
        }
        SalaryStandardTypeEnum type = stdData.getStdBaseEntity().getType();
        this.setProjectVisible(type);
        switch (type) {
            case SALARYCOUNT: {
                this.initCombo(stdData.getItemEntities(), PROJECT_TYPE);
                this.initSalaryCountChart(stdData, null);
                break;
            }
            case BROADBAND: {
                this.initCombo(stdData.getItemEntities(), MULPROJECT_TYPE);
                this.initBroadBandChart(stdData, null);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        switch (key = args.getProperty().getName()) {
            case "project_type": {
                this.updateSalaryCountViewByType(args.getChangeSet()[0].getNewValue());
                break;
            }
            case "mulproject_type": {
                this.updateBroadViewByType(args.getChangeSet()[0].getNewValue());
                break;
            }
        }
    }

    private void setProjectVisible(SalaryStandardTypeEnum type) {
        Label label = (Label)this.getView().getControl("labelap");
        if (SalaryStandardTypeEnum.SALARYCOUNT == type) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MULPROJECT_TYPE});
            label.setText(SalaryStandardTypeEnum.SALARYCOUNT.getI18nName().loadKDString());
        } else if (SalaryStandardTypeEnum.BROADBAND == type) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PROJECT_TYPE});
            label.setText(SalaryStandardTypeEnum.BROADBAND.getI18nName().loadKDString());
        }
    }

    private void initCombo(List<SalaryStdItemEntity> stdItemEntities, String stdType) {
        Map<Long, String> nameByIdentity = this.getStandardItems(stdItemEntities);
        this.setComboItems(FieldDataUtils.buildComboItem(nameByIdentity), stdType);
    }

    private void initMultiCombo(List<SalaryStdItemEntity> stdItemEntities) {
        Map<Long, String> nameByIdentity = this.getStandardItems(stdItemEntities);
        this.setComboItems(FieldDataUtils.buildComboItem(nameByIdentity), MULPROJECT_TYPE);
    }

    private Map<Long, String> getStandardItems(List<SalaryStdItemEntity> stdItemEntities) {
        LinkedHashMap<Long, String> map = new LinkedHashMap<Long, String>(16);
        for (SalaryStdItemEntity stdItemEntity : stdItemEntities) {
            if (SalaryItemLabelEnum.STANDARD != stdItemEntity.getItemLabel()) continue;
            map.put(stdItemEntity.getItemIdentity(), stdItemEntity.getItemName());
        }
        return map;
    }

    private void updateSalaryCountViewByType(Object newValue) {
        if (null == newValue) {
            return;
        }
        String newStr = newValue.toString();
        Long itemIdentity = SWCStringUtils.isEmpty((String)newStr) ? Long.valueOf(0L) : Long.valueOf(newStr);
        this.initSalaryCountChart(this.getSalaryStandardEntryData(), itemIdentity);
        this.getView().updateView(GRAPH);
    }

    private void updateBroadViewByType(Object newValue) {
        if (null == newValue) {
            this.getView().updateView(GRAPH);
            return;
        }
        String ids = newValue.toString();
        List paramIds = Arrays.asList(StringUtils.split((String)ids, (String)",")).stream().map(str -> Long.parseLong(str.trim())).collect(Collectors.toList());
        SalaryStandardEntryData stdData = this.getSalaryStandardEntryData();
        List<Long> itemIds = stdData.getItemEntities().stream().filter(entity -> paramIds.contains(entity.getItemIdentity())).map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toList());
        this.initBroadBandChart(stdData, itemIds);
    }

    private void initSalaryCountChart(SalaryStandardEntryData stdData, Long itemIdentity) {
        if (null == itemIdentity) {
            SalaryStdItemEntity salaryStdItemEntity = stdData.getItemEntities().stream().filter(itemEntity -> SalaryItemLabelEnum.STANDARD == itemEntity.getItemLabel()).findFirst().orElse(null);
            if (null == salaryStdItemEntity) {
                return;
            }
            itemIdentity = salaryStdItemEntity.getItemIdentity();
            this.getModel().setValue(PROJECT_TYPE, (Object)itemIdentity);
        }
        Long itemId = itemIdentity;
        SalaryStdItemEntity salaryStdItemEntity = stdData.getItemEntities().stream().filter(itemEntity -> itemId.equals(itemEntity.getItemIdentity())).findFirst().orElse(null);
        if (null == salaryStdItemEntity) {
            return;
        }
        Chart chart = (Chart)this.getControl(GRAPH);
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass("kd.bos.form.chart.Chart");
            Field colorFld = clazz.getDeclaredField("chartData");
            ReflectionUtils.makeAccessible((Field)colorFld);
            colorFld.set(chart, (Object)new CustomChartData());
        }
        catch (Exception exp) {
            throw new KDException((Throwable)exp, new ErrorCode("SalaryStandGraphCustomChartData", exp.getMessage()), new Object[0]);
        }
        this.setChartXaxisTick(chart, stdData.getGradeEntities());
        this.setChartYaxisTick(chart, stdData);
        this.setPointLineChartData(chart, stdData, salaryStdItemEntity);
        this.setPointLineLegend(chart, stdData, salaryStdItemEntity);
        chart.setMerge(false);
        this.getView().updateView(GRAPH);
        this.getView().updateView(PROJECT_TYPE);
    }

    private void setPointLineLegend(Chart chart, SalaryStandardEntryData stdData, SalaryStdItemEntity salaryStdItemEntity) {
        List rankEntities = stdData.getRankEntities();
        if (rankEntities.size() == 1 && ((SalaryRankEntity)rankEntities.get(0)).getRankIsSysPreSet() == 1) {
            String formatter = "function (params) {return  '%s';}";
            String format = String.format(Locale.ROOT, formatter, salaryStdItemEntity.getItemName());
            ArrayList<String> toolTipFuncPath = new ArrayList<String>();
            chart.setLegendPropValue("formatter", (Object)format);
            toolTipFuncPath.add("legend");
            toolTipFuncPath.add("formatter");
            chart.addFuncPath(toolTipFuncPath);
        }
        chart.setLegendAlign(XAlign.center, YAlign.top);
        chart.setShowLegend(true);
        chart.setLegendPropValue("itemWidth", (Object)12);
        chart.setLegendPropValue("itemHeight", (Object)3);
        chart.setLegendPropValue("itemGap", (Object)16);
        chart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
    }

    private void initBroadBandChart(SalaryStandardEntryData stdData, List<Long> itemIds) {
        if (null == itemIds) {
            SalaryStdItemEntity salaryStdItemEntity = stdData.getItemEntities().stream().filter(itemEntity -> SalaryItemLabelEnum.STANDARD == itemEntity.getItemLabel()).findFirst().orElse(null);
            if (null == salaryStdItemEntity) {
                return;
            }
            itemIds = new ArrayList<Long>(10);
            itemIds.add(salaryStdItemEntity.getItemIdentity());
            this.getModel().setValue(MULPROJECT_TYPE, (Object)salaryStdItemEntity.getItemIdentity());
        }
        Chart chart = (Chart)this.getControl(GRAPH);
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass("kd.bos.form.chart.Chart");
            Field colorFld = clazz.getDeclaredField("chartData");
            ReflectionUtils.makeAccessible((Field)colorFld);
            colorFld.set(chart, (Object)new CustomChartData());
        }
        catch (Exception exp) {
            throw new KDException((Throwable)exp, new ErrorCode("SalaryStandGraphCustomChartData", exp.getMessage()), new Object[0]);
        }
        this.setChartXaxisTick(chart, stdData.getGradeEntities());
        this.setChartYaxisTick(chart, stdData);
        ArrayList<HCDMColorHelper.Color> colorList = new ArrayList<HCDMColorHelper.Color>(Collections.singletonList(HCDMColorHelper.Color.BLUE));
        List<Long> standardItemIds = stdData.getItemEntities().stream().filter(itemEntity -> SalaryItemLabelEnum.STANDARD == itemEntity.getItemLabel()).map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toList());
        Map<Long, HCDMColorHelper.Color> itemColorMap = this.buildItemColorMap(colorList, standardItemIds);
        for (int j = 0; j < itemIds.size(); ++j) {
            Long itemId = itemIds.get(j);
            SalaryStdItemEntity salaryStdItemEntity = stdData.getItemEntities().stream().filter(itemEntity -> itemId.equals(itemEntity.getItemIdentity())).findFirst().orElse(null);
            if (null == salaryStdItemEntity) {
                return;
            }
            this.setBarChartData(chart, stdData, salaryStdItemEntity, itemColorMap.get(itemId), j);
        }
        this.setBarChartLegend(stdData, itemIds, chart);
        chart.refresh();
        chart.setMerge(false);
        this.getView().updateView(GRAPH);
        this.getView().updateView(MULPROJECT_TYPE);
    }

    private Map<Long, HCDMColorHelper.Color> buildItemColorMap(List<HCDMColorHelper.Color> colorList, List<Long> standardItemIds) {
        HashMap colorMap = Maps.newHashMapWithExpectedSize((int)standardItemIds.size());
        int size = standardItemIds.size();
        for (int i = 0; i < size; ++i) {
            colorMap.put(standardItemIds.get(i), colorList.get(i % colorList.size()));
        }
        return colorMap;
    }

    private HCDMColorHelper.Color getColorByItemId(Long itemId, List<HCDMColorHelper.Color> colorList, int j1) {
        HCDMColorHelper.Color color;
        String pagekey_cache_color = this.getPageCache().get(PAGEKEY_CACHE_COLOR);
        Map<Long, HCDMColorHelper.Color> itemColorMap = new HashMap(16);
        if (pagekey_cache_color != null) {
            itemColorMap = (Map)SerializationUtils.deSerializeFromBase64((String)pagekey_cache_color);
        }
        if (null == (color = (HCDMColorHelper.Color)itemColorMap.get(itemId))) {
            color = this.popColor(colorList, j1);
            itemColorMap.put(itemId, color);
            this.getPageCache().put(PAGEKEY_CACHE_COLOR, SerializationUtils.serializeToBase64(itemColorMap));
        }
        return color;
    }

    private void setBarChartLegend(SalaryStandardEntryData stdData, List<Long> itemIds, Chart chart) {
        chart.setShowLegend(false);
        chart.setLegendPropValue("itemWidth", (Object)8);
        chart.setLegendPropValue("itemHeight", (Object)8);
        chart.setLegendPropValue("itemGap", (Object)16);
        chart.setLegendAlign(XAlign.center, YAlign.top);
        chart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
    }

    private HCDMColorHelper.Color popColor(List<HCDMColorHelper.Color> colorList, int j1) {
        int size = colorList.size();
        int index = j1 % size;
        HCDMColorHelper.Color popColor = colorList.get(index);
        colorList.remove(index);
        return popColor;
    }

    private Axis setChartXaxisTick(Chart chart, List<SalaryGradeEntity> gradeEntities) {
        Axis xAxis = chart.createXAxis(SalaryStandardConstants.FORM_STATIC_GRADE_FIELD_NAME(), AxisType.category);
        HashMap<String, Comparable<Boolean>> xAxisTick = new HashMap<String, Comparable<Boolean>>();
        xAxisTick.put("show", Boolean.FALSE);
        xAxisTick.put("interval", Integer.valueOf(0));
        xAxis.setPropValue("axisTick", xAxisTick);
        chart.setMargin(Position.right, "60px");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("color", "#212121");
        map.put("fontSize", "14px");
        xAxis.setPropValue("nameTextStyle", map);
        List sortedGradeEntities = gradeEntities.stream().sorted(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).collect(Collectors.toList());
        xAxis.setCategorys((String[])sortedGradeEntities.stream().map(SalaryGradeEntity::getGradeName).toArray(String[]::new));
        return xAxis;
    }

    private void setChartYaxisTick(Chart chart, SalaryStandardEntryData stdData) {
        Axis yAxis = chart.createYAxis(this.getYaxisName(stdData), AxisType.value);
        HashMap<String, Boolean> yAxisLine = new HashMap<String, Boolean>();
        yAxisLine.put("show", Boolean.FALSE);
        HashMap<String, Boolean> yAxisTick = new HashMap<String, Boolean>();
        yAxisTick.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisLine", yAxisLine);
        yAxis.setPropValue("axisTick", yAxisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", splitLine);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int[] aa = new int[]{0, 0, 20, 0};
        map.put("padding", aa);
        map.put("color", "#999999");
        map.put("fontSize", "12px");
        map.put("align", "left");
        yAxis.setPropValue("nameTextStyle", map);
    }

    private void setBarChartData(Chart chart, SalaryStandardEntryData stdData, SalaryStdItemEntity salaryStdItemEntity, HCDMColorHelper.Color color, int j2) {
        int amountScale;
        List gradeEntities = stdData.getGradeEntities();
        List rankEntities = stdData.getRankEntities();
        if (CollectionUtils.isEmpty((Collection)gradeEntities) || CollectionUtils.isEmpty((Collection)rankEntities) || rankEntities.size() == 1) {
            return;
        }
        List<SalaryGradeEntity> sortedGradeEntities = gradeEntities.stream().sorted(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).collect(Collectors.toList());
        List<SalaryRankEntity> sortedRankEntities = rankEntities.stream().filter(rankEntity -> SalaryRankLabelEnum.STANDARD == rankEntity.getRankLabel()).sorted(Comparator.comparingInt(SalaryRankEntity::getRankIndex)).collect(Collectors.toList());
        if (sortedRankEntities.size() == 0) {
            return;
        }
        int scale = stdData.getStdBaseEntity().getCurrencyEntity().getAmtPrecision();
        List sortedGradeIds = sortedGradeEntities.stream().map(SalaryGradeEntity::getGradeIdentity).collect(Collectors.toList());
        List<Long> sortedRankIds = sortedRankEntities.stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toList());
        SalaryRankEntity gearEntity = (SalaryRankEntity)GradeRankHelper.fetchSpecialRankByIdentity((List)rankEntities, Collections.singletonList(SalaryStandardConstants.S_RANK_GEARDIFFERENCE)).get(0);
        SalaryRankEntity medianEntity = (SalaryRankEntity)GradeRankHelper.fetchSpecialRankByIdentity((List)rankEntities, Collections.singletonList(SalaryStandardConstants.S_RANK_MEDIANVALUE)).get(0);
        List gearEntities = stdData.getStdDataEntities().stream().filter(entity -> salaryStdItemEntity.getItemIdentity().equals(entity.getItemIdentity()) && entity.getRankIdentity().equals(gearEntity.getRankIdentity()) && sortedGradeIds.contains(entity.getGradeIdentity())).sorted(Comparator.comparingInt(entity -> sortedGradeIds.indexOf(entity.getGradeIdentity()))).collect(Collectors.toList());
        List gearData = gearEntities.stream().map(SalaryStdDataEntity::getMin).collect(Collectors.toList());
        List<SalaryStdDataEntity> medianEntities = stdData.getStdDataEntities().stream().filter(entity -> salaryStdItemEntity.getItemIdentity().equals(entity.getItemIdentity()) && entity.getRankIdentity().equals(medianEntity.getRankIdentity()) && sortedGradeIds.contains(entity.getGradeIdentity())).sorted(Comparator.comparingInt(entity -> sortedGradeIds.indexOf(entity.getGradeIdentity()))).collect(Collectors.toList());
        List stdDataEntities = stdData.getStdDataEntities().stream().filter(entity -> salaryStdItemEntity.getItemIdentity().equals(entity.getItemIdentity()) && sortedGradeIds.contains(entity.getGradeIdentity()) && sortedRankIds.contains(entity.getRankIdentity())).sorted(Comparator.comparingInt(entity -> sortedGradeIds.indexOf(entity.getGradeIdentity()))).collect(Collectors.toList());
        List stdDataEntities1 = stdData.getStdDataEntities().stream().filter(entity -> salaryStdItemEntity.getItemIdentity().equals(entity.getItemIdentity()) && sortedGradeIds.contains(entity.getGradeIdentity()) && sortedRankIds.contains(entity.getRankIdentity())).sorted(Comparator.comparingInt(entity -> sortedRankIds.indexOf(entity.getRankIdentity()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(stdDataEntities)) {
            return;
        }
        Map<Long, List<SalaryStdDataEntity>> dataEntityByRankIdentity = stdDataEntities.stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getRankIdentity));
        Map<Long, List<SalaryStdDataEntity>> dataEntityByGradeIdentity = stdDataEntities1.stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getGradeIdentity));
        ArrayList gradeRankDataList = Lists.newArrayListWithExpectedSize((int)dataEntityByGradeIdentity.size());
        for (Long gradeId : sortedGradeIds) {
            gradeRankDataList.add(dataEntityByGradeIdentity.get(gradeId));
        }
        BigDecimal[] dataArray = new BigDecimal[sortedGradeIds.size()];
        this.getAssistBarData(dataEntityByRankIdentity, sortedRankIds, dataArray, gradeRankDataList);
        BarSeries assistBarSeries = this.creatAssistBarSeries(salaryStdItemEntity.getItemName(), chart, dataArray, scale);
        kd.bos.form.chart.Label label = this.getLabelByPosition(Position.top, "-13");
        assistBarSeries.setLabel(label);
        int rankSize = sortedRankEntities.size();
        List colors = HCDMColorHelper.getColors((HCDMColorHelper.ColorParam)new HCDMColorHelper.ColorParam(salaryStdItemEntity.getItemName(), rankSize, color, "#"));
        SalaryStandardBaseEntity salaryStandardBaseEntity = stdData.getStdBaseEntity();
        String sign = salaryStandardBaseEntity.getCurrencyEntity().getSign();
        int n = amountScale = salaryStandardBaseEntity.getCurrencyEntity() == null ? 2 : salaryStandardBaseEntity.getCurrencyEntity().getAmtPrecision();
        if (rankSize == 1) {
            SalaryRankEntity rankEntity2 = (SalaryRankEntity)sortedRankEntities.get(0);
            BigDecimal[] rankData = (BigDecimal[])dataEntityByRankIdentity.get(rankEntity2.getRankIdentity()).stream().map(SalaryStdDataEntity::getMin).toArray(BigDecimal[]::new);
            BigDecimal[] chartValueData = new BigDecimal[rankData.length];
            String[] hoverChartData = new String[rankData.length];
            String[] hoverGradeRankData = new String[rankData.length];
            String[] labelData = new String[rankData.length];
            this.getOneBarChartData(rankData, gradeRankDataList, chartValueData, hoverChartData, hoverGradeRankData, labelData, sortedRankEntities, sortedGradeEntities, sign, amountScale);
            List<Object> datas = this.assembleChartData(Arrays.asList(chartValueData), Arrays.asList(hoverChartData), Arrays.asList(labelData), Arrays.asList(hoverGradeRankData), salaryStdItemEntity.getItemName(), SalaryStandardConstants.SALARY_STD_RANGE(), null, amountScale);
            BarSeries barSeries = chart.createBarSeries(rankEntity2.getRankName());
            barSeries.setBarWidth("32px");
            barSeries.setPropValue("stack", (Object)salaryStdItemEntity.getItemName());
            barSeries.setPropValue("data", datas);
            barSeries.setItemColor((String)colors.get(0));
            this.setEmphasisItemStyle((Series)barSeries, (String)colors.get(0));
            barSeries.setLabel(this.setLabelVisible(Boolean.FALSE));
            kd.bos.form.chart.Label label1 = this.getLabelByPosition(Position.top, "3");
            String formatter = "function(param){return param.data.labelVal}";
            label1.setFormatter(formatter);
            ArrayList<String> seriesLabelFuncPath = new ArrayList<String>();
            seriesLabelFuncPath.add("series");
            int index = 0;
            index = rankSize != 1 ? (rankSize + 1) * j2 + rankSize - 1 : 1;
            seriesLabelFuncPath.add(String.valueOf(index));
            seriesLabelFuncPath.add("label");
            seriesLabelFuncPath.add("normal");
            seriesLabelFuncPath.add("formatter");
            chart.addFuncPath(seriesLabelFuncPath);
            barSeries.setLabel(label1);
        } else {
            for (int i = 0; i < rankSize - 1; ++i) {
                SalaryRankEntity rankEntity3 = (SalaryRankEntity)sortedRankEntities.get(i);
                BigDecimal[] rankData = (BigDecimal[])dataEntityByRankIdentity.get(rankEntity3.getRankIdentity()).stream().map(SalaryStdDataEntity::getMin).toArray(BigDecimal[]::new);
                BigDecimal[] chartValueData = new BigDecimal[rankData.length];
                String[] hoverChartData = new String[rankData.length];
                String[] hoverGradeRankData = new String[rankData.length];
                String[] labelData = new String[rankData.length];
                this.getBarChartData(i, rankData, gradeRankDataList, chartValueData, hoverChartData, hoverGradeRankData, labelData, sortedRankEntities, sortedGradeEntities, sign, amountScale);
                List<Object> datas = this.assembleChartData(Arrays.asList(chartValueData), Arrays.asList(hoverChartData), Arrays.asList(labelData), Arrays.asList(hoverGradeRankData), salaryStdItemEntity.getItemName(), SalaryStandardConstants.SALARY_STD_RANGE(), null, amountScale);
                BarSeries barSeries = chart.createBarSeries(rankEntity3.getRankName());
                barSeries.setBarWidth("32px");
                barSeries.setPropValue("stack", (Object)salaryStdItemEntity.getItemName());
                barSeries.setPropValue("data", datas);
                barSeries.setItemColor((String)colors.get(i));
                this.setEmphasisItemStyle((Series)barSeries, (String)colors.get(i));
                barSeries.setLabel(this.setLabelVisible(Boolean.FALSE));
                if (i != rankSize - 2) continue;
                kd.bos.form.chart.Label label1 = this.getLabelByPosition(Position.top, "3");
                String formatter = "function(param){return param.data.labelVal}";
                label1.setFormatter(formatter);
                ArrayList<String> seriesLabelFuncPath = new ArrayList<String>();
                seriesLabelFuncPath.add("series");
                int index = (rankSize + 1) * j2 + rankSize - 1;
                seriesLabelFuncPath.add(String.valueOf(index));
                seriesLabelFuncPath.add("label");
                seriesLabelFuncPath.add("normal");
                seriesLabelFuncPath.add("formatter");
                chart.addFuncPath(seriesLabelFuncPath);
                barSeries.setLabel(label1);
            }
            this.creatMedianBar(chart, salaryStdItemEntity, medianEntities, stdData.getStdBaseEntity().getCurrencyEntity().getAmtPrecision());
        }
        chart.addTooltip("trigger", (Object)"item");
        chart.setShowTooltip(true);
        String formatter = "function (params){var html ='';if(params.data.title != undefined && params.data.isScatter == null){html ='<div style=\"clear: both\"> <p style=\"float:left;\">%s\uff1a</p><p style=\"float:right;margin-bottom:4px;\">'+params.data.title+'</p></div><div style=\"clear: both;border-bottom:1px solid White;\"><p style=\"float:left;margin-top:4px;\">%s\uff1a</p><p style=\"float:right;margin-bottom:4px;margin-top:4px;\">'+params.data.gradeRankVal+'</p></div><div style=\"clear: both;border-bottom:1px solid White;\"><p style=\"float:left;margin-top:4px;\">'+params.data.displayName+'\uff1a</p><p style=\"float:right;margin-top:4px;\">'+params.data.hoverVal+'</p></div>';}else if(params.data.title != undefined && params.data.isScatter == 1){html ='<div style=\"clear: both\"> <p style=\"float:left;\">%s\uff1a</p><p style=\"float:right;margin-bottom:4px;\">'+params.data.title+'</p></div><div style=\"clear: both;border-bottom:1px solid White;\"><p style=\"float:left;margin-top:4px;\">'+params.data.displayName+'\uff1a</p><p style=\"float:right;margin-top:4px;\">%s'+params.data.hoverVal+'</p></div>';} return html;}";
        String format = String.format(formatter, SalaryStandardConstants.SALARY_STD_ITEM(), SalaryStandardConstants.FORM_STATIC_GRADE_RANK_FIELD_NAME(), SalaryStandardConstants.SALARY_STD_ITEM(), sign);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        chart.addTooltip("formatter", (Object)format);
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        chart.addFuncPath(toolTipFuncPath);
    }

    private void creatMedianBar(Chart chart, SalaryStdItemEntity salaryStdItemEntity, List<SalaryStdDataEntity> medianEntities, int scale) {
        BarSeries medianSeries = chart.createBarSeries(null);
        medianSeries.setPropValue("type", (Object)"scatter");
        medianSeries.setPropValue("symbolSize", (Object)6);
        medianSeries.setItemColor("#ffffff");
        medianSeries.setLabel(this.setLabelVisible(Boolean.FALSE));
        List<BigDecimal> medianDecimals = medianEntities.stream().map(SalaryStdDataEntity::getMin).collect(Collectors.toList());
        ArrayList<String> medainStringList = new ArrayList<String>();
        medianDecimals.forEach(bigDecimal -> {
            String string = null == bigDecimal ? null : bigDecimal.setScale(scale, 4).toPlainString();
            medainStringList.add(string);
        });
        List<Object> objects = this.assembleChartData(medianDecimals, medainStringList, Arrays.asList(new String[medianDecimals.size()]), Arrays.asList(new String[medianDecimals.size()]), salaryStdItemEntity.getItemName(), SalaryStdGridFieldSeqEnum.MIDDLE_SEQ.getI18nName().loadKDString(), "1", scale);
        medianSeries.setPropValue("data", objects);
    }

    private void getAssistBarData(Map<Long, List<SalaryStdDataEntity>> dataEntityByRankIdentity, List<Long> sortedRankIds, BigDecimal[] result, List<List<SalaryStdDataEntity>> gradeRankDataList) {
        List<SalaryStdDataEntity> salaryStdDataEntities = dataEntityByRankIdentity.get(sortedRankIds.get(0));
        block0: for (int k = 0; k < salaryStdDataEntities.size(); ++k) {
            BigDecimal min = salaryStdDataEntities.get(k).getMin();
            List<SalaryStdDataEntity> rankDataList = gradeRankDataList.get(k);
            if (!this.judgeHasEffectiveData(rankDataList)) continue;
            if (null != min) {
                result[k] = min;
                continue;
            }
            for (int i = 1; i < rankDataList.size(); ++i) {
                BigDecimal minVal = rankDataList.get(i).getMin();
                if (minVal == null) continue;
                result[k] = minVal;
                continue block0;
            }
        }
    }

    private boolean judgeHasEffectiveData(List<SalaryStdDataEntity> gradeDataEntityes) {
        int temp = 0;
        for (SalaryStdDataEntity dataEntity : gradeDataEntityes) {
            if (null != dataEntity.getMin()) {
                ++temp;
            }
            if (temp < 1) continue;
            return true;
        }
        return false;
    }

    private void setEmphasisItemStyle(Series series, String color) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        HashMap itemStyleMap = Maps.newHashMapWithExpectedSize((int)1);
        map.put("color", color);
        itemStyleMap.put("itemStyle", map);
        series.setPropValue("emphasis", (Object)itemStyleMap);
    }

    private List<String> getHoverChartData(List<BigDecimal> rankData, List<BigDecimal> nextRankData) {
        if (null == rankData || null == nextRankData || rankData.size() != nextRankData.size()) {
            return Lists.newArrayList();
        }
        ArrayList hoverData = Lists.newArrayListWithExpectedSize((int)rankData.size());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < rankData.size(); ++i) {
            builder.append("hha").append('~');
            hoverData.add(builder.toString());
            builder.setLength(0);
        }
        return hoverData;
    }

    private List<Object> assembleChartData(List<BigDecimal> valueList, List<String> hoverValList, List<String> labelData, List<String> hoverGradeRankList, String itemName, String displayName, String isScatter, int scale) {
        if (null == valueList || null == hoverValList || valueList.size() != hoverValList.size()) {
            return Lists.newArrayList();
        }
        ArrayList<Object> datas = new ArrayList<Object>(valueList.size());
        for (int i = 0; i < valueList.size(); ++i) {
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)3);
            String value = valueList.get(i) == null ? BigDecimal.ZERO.toPlainString() : valueList.get(i).setScale(scale, 4).toPlainString();
            dataMap.put("value", value);
            dataMap.put("hoverVal", hoverValList.get(i));
            dataMap.put("title", itemName);
            dataMap.put("displayName", displayName);
            dataMap.put("isScatter", isScatter);
            dataMap.put("labelVal", labelData.get(i));
            dataMap.put("gradeRankVal", hoverGradeRankList.get(i));
            datas.add(dataMap);
        }
        return datas;
    }

    private List<Object> assembleChartDataByGear(List<BigDecimal> rankData, List<BigDecimal> gearData, String itemName, String displayName) {
        if (null == rankData || null == gearData || rankData.size() != gearData.size()) {
            return Lists.newArrayList();
        }
        ArrayList<Object> datas = new ArrayList<Object>(rankData.size());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rankData.size(); ++i) {
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)4);
            if (rankData.get(i).compareTo(BigDecimal.ZERO) == 0) {
                datas.add(dataMap);
                continue;
            }
            dataMap.put("value", gearData.get(i));
            sb.setLength(0);
            dataMap.put("hoverVal", "hoverVal");
            dataMap.put("title", itemName);
            dataMap.put("labelVal", "500");
            dataMap.put("displayName", displayName);
            datas.add(dataMap);
        }
        return datas;
    }

    private void setPointLineChartData(Chart chart, SalaryStandardEntryData stdData, SalaryStdItemEntity salaryStdItemEntity) {
        String format;
        String formatter;
        List gradeEntities = stdData.getGradeEntities();
        List rankEntities = GradeRankHelper.fetchStandardRank((Collection)stdData.getRankEntities());
        if (CollectionUtils.isEmpty((Collection)gradeEntities) || CollectionUtils.isEmpty((Collection)rankEntities)) {
            return;
        }
        List sortedGradeEntities = gradeEntities.stream().sorted(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).collect(Collectors.toList());
        List sortedRankEntities = rankEntities.stream().sorted(Comparator.comparingInt(SalaryRankEntity::getRankIndex)).collect(Collectors.toList());
        List sortedGradeIds = sortedGradeEntities.stream().map(SalaryGradeEntity::getGradeIdentity).collect(Collectors.toList());
        List sortedRankIds = sortedRankEntities.stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toList());
        SalaryStandardBaseEntity salaryStandardBaseEntity = stdData.getStdBaseEntity();
        String sign = salaryStandardBaseEntity.getCurrencyEntity().getSign();
        int scale = salaryStandardBaseEntity.getCurrencyEntity().getAmtPrecision();
        if (salaryStdItemEntity.getItemIsUseSalaryRank() == 1) {
            List stdDataEntities = stdData.getStdDataEntities().stream().filter(entity -> salaryStdItemEntity.getItemIdentity().equals(entity.getItemIdentity()) && sortedGradeIds.contains(entity.getGradeIdentity()) && sortedRankIds.contains(entity.getRankIdentity())).sorted(Comparator.comparingInt(entity -> sortedGradeIds.indexOf(entity.getGradeIdentity()))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(stdDataEntities)) {
                return;
            }
            Map<Long, List<SalaryStdDataEntity>> dataEntityByRankIdentity = stdDataEntities.stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getRankIdentity));
            for (int i = 0; i < sortedRankEntities.size(); ++i) {
                SalaryRankEntity rankEntity = (SalaryRankEntity)sortedRankEntities.get(i);
                List<SalaryStdDataEntity> dataEntities = dataEntityByRankIdentity.get(rankEntity.getRankIdentity());
                if (CollectionUtils.isEmpty(dataEntities)) continue;
                LineSeries series = chart.createLineSeries(rankEntity.getRankName());
                series.setItemColor(COLORS_NINE[i % COLORS_NINE.length]);
                series.setPropValue("symbol", (Object)"emptyCircle");
                List<String> datas = this.getChartDataString(dataEntities, scale);
                series.setPropValue("data", datas);
                HashMap map = Maps.newHashMapWithExpectedSize((int)1);
                map.put("focus", "series");
                series.setPropValue("emphasis", (Object)map);
            }
        } else if (salaryStdItemEntity.getItemIsUseSalaryRank() == 0) {
            List<SalaryStdDataEntity> dataEntities = stdData.getStdDataEntities().stream().filter(entity -> salaryStdItemEntity.getItemIdentity().equals(entity.getItemIdentity()) && sortedGradeIds.contains(entity.getGradeIdentity()) && ((Long)sortedRankIds.get(0)).equals(entity.getRankIdentity())).sorted(Comparator.comparingInt(entity -> sortedGradeIds.indexOf(entity.getGradeIdentity()))).collect(Collectors.toList());
            LineSeries series = chart.createLineSeries(salaryStdItemEntity.getItemName());
            series.setItemColor(COLORS_NINE[0]);
            series.setPropValue("symbol", (Object)"emptyCircle");
            List<String> datas = this.getChartDataString(dataEntities, scale);
            series.setPropValue("data", datas);
        }
        chart.addTooltip("trigger", (Object)"item");
        if (salaryStdItemEntity.getItemIsUseSalaryRank() == 0) {
            formatter = "function (params) {return '<div style=\"clear: both\"> <p style=\"float:left;\">%s\uff1a</p><p style=\"float:right;margin-bottom:4px;\">%s</p></div><div style=\"clear: both;border-bottom:1px solid #FFFFFF;\"><p style=\"float:left;margin-top:4px;\">%s\uff1a</p><p style=\"float:right;margin-bottom:4px;margin-top:4px;\">'+params.name+'</p></div><div style=\"clear: both;border-bottom:1px solid #FFFFFF;\"><p style=\"float:left;margin-top:4px;\">%s\uff1a</p><p style=\"float:right;margin-top:4px;\">%s'+params.value+'</p></div>';}";
            format = String.format(formatter, SalaryStandardConstants.SALARY_STD_ITEM(), salaryStdItemEntity.getItemName(), SalaryStandardConstants.FORM_STATIC_GRADE_FIELD_NAME(), SalaryStandardConstants.SALARY_STD_AMOUNT(), sign);
        } else {
            formatter = "function (params) {return '<div style=\"clear: both;\"> <p style=\"float:left;\">%s\uff1a</p><p style=\"float:right;margin-bottom:4px;\">%s</p></div><div style=\"clear: both;border-bottom:1px solid #FFFFFF;\"><p style=\"float:left;margin-top:4px;\">%s\uff1a</p><p style=\"float:right;margin-bottom:4px;margin-top:4px;\">'+params.name+params.seriesName+'</p></div><div style=\"clear: both;border-bottom:1px solid #FFFFFF;\"><p style=\"float:left;margin-top:4px;\">%s\uff1a</p><p style=\"float:right;margin-top:4px;\">%s'+params.value+'</p></div>';}";
            format = String.format(formatter, SalaryStandardConstants.SALARY_STD_ITEM(), salaryStdItemEntity.getItemName(), SalaryStandardConstants.FORM_STATIC_GRADE_RANK_FIELD_NAME(), SalaryStandardConstants.SALARY_STD_AMOUNT(), sign);
        }
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        chart.addTooltip("formatter", (Object)format);
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        chart.addFuncPath(toolTipFuncPath);
        chart.setShowTooltip(true);
    }

    private List<String> getChartDataString(List<SalaryStdDataEntity> dataEntities, int scale) {
        List bigDecimals = dataEntities.stream().map(SalaryStdDataEntity::getMin).collect(Collectors.toList());
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)bigDecimals.size());
        bigDecimals.stream().forEach(bigDecimal -> {
            String string = null == bigDecimal ? null : bigDecimal.setScale(scale, 4).toPlainString();
            datas.add(string);
        });
        return datas;
    }

    private SalaryStandardEntryData getSalaryStandardEntryData() {
        return SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
    }

    private void setComboItems(List<ComboItem> gradeComboItems, String ... keys) {
        for (String key : keys) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(key);
            if (comboEdit == null) continue;
            comboEdit.setComboItems(gradeComboItems);
        }
    }

    private void setMulComboItems(List<ComboItem> gradeComboItems, String ... keys) {
        for (String key : keys) {
            MulComboEdit mulComboEdit = (MulComboEdit)this.getControl(key);
            if (mulComboEdit == null) continue;
            mulComboEdit.setComboItems(gradeComboItems);
        }
    }

    private BarSeries creatAssistBarSeries(String barName, Chart chart, BigDecimal[] data, int scale) {
        BarSeries barSeries = chart.createBarSeries(barName + "Assist");
        barSeries.setBarWidth("32px");
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)data.length);
        for (int i = 0; i < data.length; ++i) {
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)1);
            if (null == data[i]) {
                datas.add(dataMap);
                continue;
            }
            dataMap.put("value", data[i].setScale(scale, 4).toPlainString());
            datas.add(dataMap);
        }
        barSeries.setPropValue("data", (Object)datas);
        barSeries.setItemColor("rgba(0,0,0,0)");
        barSeries.setPropValue("stack", (Object)barName);
        return barSeries;
    }

    private void createBarSeriesForLengend(Chart chart, String color, String itemName) {
        BarSeries barSeries = chart.createBarSeries(itemName);
        barSeries.setItemColor(color);
        barSeries.setPropValue("barCategoryGap", (Object)"50%");
        barSeries.setPropValue("stack", (Object)itemName);
    }

    private void getOneBarChartData(BigDecimal[] rankData, List<List<SalaryStdDataEntity>> gradeRankDataList, BigDecimal[] chartData, String[] hoverChartData, String[] hoverGradeRankData, String[] labelData, List<SalaryRankEntity> sortedRankEntities, List<SalaryGradeEntity> sortedGradeEntities, String sign, int amountScale) {
        if (null == rankData || null == gradeRankDataList) {
            return;
        }
        String curRankName = sortedRankEntities.get(0).getRankName();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < rankData.length; ++i) {
            builder.setLength(0);
            String gradeName = sortedGradeEntities.get(i).getGradeName();
            BigDecimal curMin = rankData[i];
            labelData[i] = " ";
            builder.append(sign).append(curMin.setScale(amountScale, 4).toPlainString());
            hoverChartData[i] = builder.toString();
            builder.setLength(0);
            builder.append(gradeName).append(curRankName);
            hoverGradeRankData[i] = builder.toString();
            chartData[i] = BigDecimal.valueOf(0.03).setScale(amountScale, 4);
        }
    }

    private void getBarChartData(int rankIndex, BigDecimal[] rankData, List<List<SalaryStdDataEntity>> gradeRankDataList, BigDecimal[] chartData, String[] hoverChartData, String[] hoverGradeRankData, String[] labelData, List<SalaryRankEntity> sortedRankEntities, List<SalaryGradeEntity> sortedGradeEntites, String sign, int amountScale) {
        if (null == rankData || null == gradeRankDataList) {
            return;
        }
        String curRankName = sortedRankEntities.get(rankIndex).getRankName();
        StringBuilder builder = new StringBuilder();
        block0: for (int i = 0; i < rankData.length; ++i) {
            int j;
            builder.setLength(0);
            String gradeName = sortedGradeEntites.get(i).getGradeName();
            List<SalaryStdDataEntity> rankStdDatas = gradeRankDataList.get(i);
            BigDecimal curMin = rankData[i];
            if (null == curMin) {
                if (rankIndex != rankStdDatas.size() - 2 || !this.judgeHasEffectiveData(rankStdDatas)) continue;
                for (j = rankStdDatas.size() - 1; j > 0; --j) {
                    BigDecimal min = rankStdDatas.get(j).getMin();
                    if (null == min) continue;
                    labelData[i] = min.setScale(amountScale, 4).toPlainString();
                    continue block0;
                }
                continue;
            }
            for (j = rankIndex + 1; j < rankStdDatas.size(); ++j) {
                BigDecimal nextMin = rankStdDatas.get(j).getMin();
                String nextRankName = sortedRankEntities.get(j).getRankName();
                if (null != nextMin) {
                    BigDecimal nextMinBigDecimal = nextMin.setScale(amountScale, 4);
                    chartData[i] = nextMin.subtract(curMin);
                    builder.append(sign).append(curMin.setScale(amountScale, 4).toPlainString()).append('~').append(sign).append(nextMinBigDecimal.toPlainString());
                    hoverChartData[i] = builder.toString();
                    labelData[i] = nextMinBigDecimal.toPlainString();
                    builder.setLength(0);
                    builder.append(gradeName).append(curRankName).append('~').append(gradeName).append(nextRankName);
                    hoverGradeRankData[i] = builder.toString();
                    continue block0;
                }
                if (null != nextMin || rankIndex != rankStdDatas.size() - 2 || !this.judgeHasEffectiveData(rankStdDatas)) continue;
                labelData[i] = curMin.setScale(amountScale, 4).toPlainString();
            }
        }
    }

    private static BigDecimal[] getBarChartDataByGear(BigDecimal[] rankData, BigDecimal[] gearData) {
        if (null == rankData || null == gearData || rankData.length != gearData.length) {
            return null;
        }
        BigDecimal[] data = new BigDecimal[rankData.length];
        for (int i = 0; i < rankData.length; ++i) {
            data[i] = rankData[i].add(gearData[i]);
        }
        return data;
    }

    private kd.bos.form.chart.Label getLabelByPosition(Position position, String distance) {
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setShow(true);
        label.setPosition(position);
        label.setColor("#999999");
        label.setDistance(distance);
        return label;
    }

    private kd.bos.form.chart.Label setLabelVisible(Boolean flag) {
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setShow(flag.booleanValue());
        return label;
    }

    private String getYaxisName(SalaryStandardEntryData stdData) {
        StringBuilder sb = new StringBuilder();
        String moneyaryUnitStr = EntityConverter.generateMoneyaryUnitStr((SalaryStandardBaseEntity)stdData.getStdBaseEntity());
        sb.append(SalaryStandardConstants.SALARY_STD_TABLE()).append(' ').append(SalaryStandardConstants.UNIT()).append('\uff1a').append(moneyaryUnitStr);
        return sb.toString();
    }
}

