/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard.view;

import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hcdm.business.salarystandard.CartesianFetchDataHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandContrastGridViewHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.export.SWCExportDynamicEntryPlugin;

public class StdViewExportDynamicEntryPlugin
extends SWCExportDynamicEntryPlugin {
    private static final String CONFIRM_EXPORT_CUR = "confirm_exprot_cur";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("export_curpagedata".equals(operateKey)) {
            IFormView view = this.getView();
            String entryKey = (String)view.getFormShowParameter().getCustomParam("EXPORT_ENTRYKEY");
            entryKey = SWCStringUtils.isEmpty((String)entryKey) ? "entryentity" : entryKey;
            this.getView().getPageCache().put("EXPORT_ENTRYKEY", entryKey);
            int rowCount = this.getEntryCurPageRowCount(view, entryKey);
            this.getView().getPageCache().put("EXPORT_TOTAL", String.valueOf(rowCount));
            String noDataMsg = this.getNoDataMsg();
            if (rowCount == 0) {
                this.getView().showTipNotification(noDataMsg);
                return;
            }
            String msg = this.getExportConfirmMsg(rowCount);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_EXPORT_CUR, (IFormPlugin)this);
            view.showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_EXPORT_CUR.equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            Object mainPageId = this.getView().getFormShowParameter().getCustomParam("main_page");
            if (mainPageId != null) {
                SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)this.getView().getView((String)mainPageId), (boolean)true);
            }
            FormShowParameter showParameter = this.createExportCurProgress(this.getView().getPageId());
            this.getView().showForm(showParameter);
        }
    }

    private int getEntryCurPageRowCount(IFormView gridView, String entryKey) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        AbstractGrid.GridState entryState = proxy.getEntryState(entryKey);
        int total = 0;
        String mainPageId = (String)gridView.getFormShowParameter().getCustomParam("main_page");
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hcdm_contrastgrid".equals(formId)) {
            total = CartesianFetchDataHelper.getMaxTotalRow((IFormView)this.getView(), (String)mainPageId, (String)gridView.getPageId());
        } else if ("hcdm_salstdcontrastview".equals(formId)) {
            total = SalaryStandContrastGridViewHelper.getMaxTotalRow((IFormView)this.getView(), (String)mainPageId, (String)gridView.getPageId());
        }
        if (total == 0) {
            return total;
        }
        Integer pageRows = entryState.getPageRows();
        Integer currentPageIndex = entryState.getCurrentPageIndex();
        int startIndex = (currentPageIndex - 1) * pageRows;
        int endIndex = Math.min(startIndex + pageRows, total);
        this.getView().getPageCache().put("CUSTOM_PARAM_START_INDEX", String.valueOf(startIndex));
        this.getView().getPageCache().put("CUSTOM_PARAM_END_INDEX", String.valueOf(endIndex));
        return endIndex - startIndex;
    }

    public int getEntryRowCount(IFormView gridView, String entryKey) {
        String mainPageId = (String)gridView.getFormShowParameter().getCustomParam("main_page");
        String formId = this.getView().getFormShowParameter().getFormId();
        int total = 0;
        if ("hcdm_contrastgrid".equals(formId)) {
            total = CartesianFetchDataHelper.getMaxTotalRow((IFormView)this.getView(), (String)mainPageId, (String)gridView.getPageId());
        } else if ("hcdm_salstdcontrastview".equals(formId)) {
            total = SalaryStandContrastGridViewHelper.getMaxTotalRow((IFormView)this.getView(), (String)mainPageId, (String)gridView.getPageId());
        }
        if (total > 1000000) {
            total = 1000000;
        }
        return total;
    }

    private FormShowParameter createExportCurProgress(String pageId) {
        FormShowParameter exportProgress = this.createExportProgress(pageId);
        exportProgress.setCustomParam("CUSTOM_PARAM_EXPORT_CURPAGE", (Object)"true");
        exportProgress.setCustomParam("CUSTOM_PARAM_START_INDEX", (Object)this.getView().getPageCache().get("CUSTOM_PARAM_START_INDEX"));
        exportProgress.setCustomParam("CUSTOM_PARAM_END_INDEX", (Object)this.getView().getPageCache().get("CUSTOM_PARAM_END_INDEX"));
        return exportProgress;
    }

    protected FormShowParameter createExportProgress(String pageId) {
        FormShowParameter exportProgress = super.createExportProgress(pageId);
        exportProgress.setCustomParam("CUSTOM_PARAM_FETCH_DATA", (Object)"true");
        return exportProgress;
    }
}

