/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.stdscm;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.coefficient.CoeffShowFormHelper;
import kd.swc.hcdm.business.coefficient.CoefficientTabServiceHelper;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.business.country.CountryPolicy;
import kd.swc.hcdm.business.country.CountryRefChanged;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCGridUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.lang3.StringUtils;

public class StdScmEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
HyperLinkClickListener,
CountryRefChanged {
    private static final String ADD_ITEM_RTN = "addItemReturn";
    private static final String MATCH_VALUE = "1";
    private static final String TICK_ROW_BACKCOLOR = "#F2F6FF";
    public static final String SALARY_STRUCTURE = "salaystructure";
    public static final String SALSTRUCTUR_ENT = "salstructurent";
    public static final String COEFFICIENTTAB_ENT = "coefficienttabent";
    public static final String LATESTCOEFFICI_ENT = "latestcoefficientnum";
    private static final String CONFIRM_CALL_BACK_ID_CHECK = "confirm_call_back_id_check";
    private static final String CONFIRM_CALL_BACK_BSED_CHANGE = "confirm_call_back_bsed";
    private static final String[] colNames = new String[]{"ismatchgraderank", "matchstrategy", "excesscontrol"};

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit entBaseDataField = (BasedataEdit)this.getView().getControl(COEFFICIENTTAB_ENT);
        entBaseDataField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Label label = (Label)this.getView().getControl("latestcoefnum");
        if (label != null) {
            label.addClickListener((ClickListener)this);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        CountryHelper.registerListenerForBaseData((AbstractFormPlugin)this, Arrays.asList(SALARY_STRUCTURE, "salarystandard", "country"));
    }

    public void beforeBindData(EventObject eventObject) {
        List stdTableIdList;
        DynamicObjectCollection ents = this.getModel().getEntryEntity("entryentity");
        MulBasedataDynamicObjectCollection salaystructures = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity().get(SALARY_STRUCTURE);
        if (!SWCListUtils.isEmpty((List)salaystructures)) {
            for (DynamicObject ent : ents) {
                DynamicObject coefficienttabent = ent.getDynamicObject(COEFFICIENTTAB_ENT);
                if (SWCObjectUtils.isEmpty((Object)coefficienttabent)) continue;
                int lateStcOefNum = coefficienttabent.getInt("latestcoefnum");
                String lateStcOefNumStr = lateStcOefNum != 0 ? String.valueOf(lateStcOefNum) : "";
                ent.set(LATESTCOEFFICI_ENT, (Object)lateStcOefNumStr);
            }
        } else {
            DynamicObject coefficientTab = (DynamicObject)this.getModel().getDataEntity().get("coefficienttab");
            if (!SWCObjectUtils.isEmpty((Object)coefficientTab)) {
                int lateStcOefNum = coefficientTab.getInt("latestcoefnum");
                for (DynamicObject ent : ents) {
                    ent.set(COEFFICIENTTAB_ENT, (Object)coefficientTab);
                    String lateStcOefNumStr = lateStcOefNum != 0 ? String.valueOf(lateStcOefNum) : "";
                    ent.set(LATESTCOEFFICI_ENT, (Object)lateStcOefNumStr);
                }
            }
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String parentFormId = formShowParameter.getParentFormId();
        String sourceSign = (String)formShowParameter.getCustomParam("sourceSign");
        if (StringUtils.isEmpty((CharSequence)sourceSign)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"salaryadjfilematch"});
        } else if (StringUtils.equals((CharSequence)(parentFormId + "_stdscmhis"), (CharSequence)sourceSign) && !SWCListUtils.isEmpty((List)(stdTableIdList = (List)formShowParameter.getCustomParam("stdTableId")))) {
            this.salaryAdjFileMatch(stdTableIdList);
        }
        this.lockIsMatchGradeRank();
        this.getView().updateView("entryentity");
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.checkEffVersionItem();
    }

    private void salaryAdjFileMatch(List<Long> stdTableIdList) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        ArrayList rowColors = Lists.newArrayListWithExpectedSize((int)10);
        if (!SWCListUtils.isEmpty((List)entryEntity)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject salarystandardDyobj = ((DynamicObject)entryEntity.get(i)).getDynamicObject("salarystandard");
                if (SWCObjectUtils.isEmpty((Object)salarystandardDyobj) || !new HashSet<Long>(stdTableIdList).contains(salarystandardDyobj.getLong("id"))) continue;
                this.getModel().setValue("salaryadjfilematch", (Object)MATCH_VALUE, i);
                rowColors.add(i);
            }
        }
        entryGrid.setRowBackcolor(TICK_ROW_BACKCOLOR, rowColors.stream().mapToInt(Integer::intValue).toArray());
    }

    public void click(EventObject evt) {
        DynamicObject coefficientObject;
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"latestcoefnum", (CharSequence)source.getKey()) && !SWCBaseUtils.isEmpty((DynamicObject)(coefficientObject = (DynamicObject)this.getModel().getValue("coefficienttab")))) {
            String tableId = coefficientObject.getString("id");
            String errMsg = CoefficientTabServiceHelper.getStatusErrorMsgByPkId((String)tableId);
            if (SWCStringUtils.isEmpty((String)errMsg)) {
                FormShowParameter coefficientList = CoeffShowFormHelper.getCoefficientList((String)tableId);
                this.getView().showForm(coefficientList);
            } else {
                this.getView().showErrorNotification(errMsg);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (SWCStringUtils.equals((String)fieldName, (String)LATESTCOEFFICI_ENT)) {
            String tableId = this.getModel().getEntryRowEntity("entryentity", hyperLinkClickEvent.getRowIndex()).getString("coefficienttabent.id");
            FormShowParameter coefficientList = CoeffShowFormHelper.getCoefficientList((String)tableId);
            this.getView().showForm(coefficientList);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String clickedKey;
        super.itemClick(evt);
        switch (clickedKey = evt.getItemKey()) {
            case "addsalarystandard": {
                ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"hcdm_salarystandard", (boolean)true);
                List<QFilter> qFilters = this.salarystandardFilter();
                showParam.setListFilterParameter(new ListFilterParameter(qFilters, null));
                showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_ITEM_RTN));
                this.getView().showForm((FormShowParameter)showParam);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        switch (event.getCallBackId()) {
            case "salaystructure": {
                this.updateSalaryStructure((AbstractFormPlugin)this, event);
                break;
            }
            case "country": {
                CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).putClearPolicy(SALARY_STRUCTURE, CountryPolicy.ClearDataPolicyEnum.DELETE_DATA_ONLY, true).putClearPolicy(SALSTRUCTUR_ENT, CountryPolicy.ClearDataPolicyEnum.COMMON_DELETE_ENTITY_REFERENCE, true).putClearPolicy("salarystandard", CountryPolicy.ClearDataPolicyEnum.DELETE_DATA_ONLY, false).build();
                CountryHelper.confirmCallBackForCountry((AbstractFormPlugin)this, (MessageBoxClosedEvent)event, (CountryPolicy)countryPolicy);
                break;
            }
            case "confirm_call_back_id_check": {
                if (MessageBoxResult.Cancel.equals((Object)event.getResult())) break;
                if (!SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_stdscm", (String)"4715a0df000000ac")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61\u201c\u85aa\u916c\u4f53\u7cfb\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"StdScmEdit_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().invokeOperation("insertdata_his");
                break;
            }
            case "confirm_call_back_bsed": {
                if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
                    String bsedStr = this.getView().getPageCache().get("temp_bsed_confirm");
                    try {
                        Date bsed = new SimpleDateFormat("yyyy-MM-dd").parse(bsedStr);
                        this.getModel().beginInit();
                        this.getModel().setValue("bsed", (Object)bsed);
                        this.getModel().endInit();
                        this.getView().updateView("bsed");
                    }
                    catch (ParseException bsed) {}
                    break;
                }
                DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
                Date bsed = this.getModel().getDataEntity().getDate("bsed");
                for (DynamicObject dyObj : dyColl) {
                    Date date = dyObj.getDate("salarystandard.firstbsed");
                    if (date == null || !date.after(bsed)) continue;
                    dyObj.set("salarystandard", null);
                }
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public StringJoiner getChangedInfoOfRefField(boolean isGeneral) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long countryId = dataEntity.getLong("country.id");
        Map errMsgMap = CountryHelper.getSortLinkedMap(Arrays.asList(HCDMErrInfoEnum.COMMON_SAL_STRUCTURE, HCDMErrInfoEnum.SCM_ENTITY_SET, HCDMErrInfoEnum.COMMON_SAL_STANDARD));
        HashSet<Long> allSalStructIdSet = new HashSet<Long>(16);
        HashSet<Long> allSalStdIdSet = new HashSet<Long>(16);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entryEntity) {
            DynamicObject salStructDy = entity.getDynamicObject(SALSTRUCTUR_ENT);
            if (this.isCountryChanged(countryId, errMsgMap, allSalStructIdSet, salStructDy, HCDMErrInfoEnum.COMMON_SAL_STRUCTURE, false)) {
                errMsgMap.computeIfAbsent(HCDMErrInfoEnum.SCM_ENTITY_SET, key -> new StringJoiner(HCDMErrInfoEnum.COMMON_STOP_SIGN.getMsg())).add(salStructDy.getString("name"));
                continue;
            }
            this.isCountryChanged(countryId, errMsgMap, allSalStdIdSet, entity.getDynamicObject("salarystandard"), HCDMErrInfoEnum.COMMON_SAL_STANDARD, false);
        }
        StringJoiner entitySet = (StringJoiner)errMsgMap.get(HCDMErrInfoEnum.SCM_ENTITY_SET);
        if (entitySet.length() > 0) {
            errMsgMap.put(HCDMErrInfoEnum.SCM_ENTITY_SET, new StringJoiner("").add(HCDMErrInfoEnum.SCM_ENTITY_CLEAR_CONFIRM.getMsg(new Object[]{entitySet.toString()})));
        }
        return CountryHelper.getErrMsg((Map)errMsgMap);
    }

    private boolean isCountryChanged(long countryId, Map<HCDMErrInfoEnum, StringJoiner> errMsgMap, Set<Long> allSalStructIdSet, DynamicObject baseDataDy, HCDMErrInfoEnum hcdmErrInfoEnum, boolean refChanged) {
        boolean countryChanged;
        long basedDataDyId = baseDataDy != null ? baseDataDy.getLong("id") : 0L;
        boolean bl = countryChanged = basedDataDyId != 0L && (allSalStructIdSet.contains(basedDataDyId) || CountryHelper.setErrMsgMap((long)countryId, errMsgMap, (DynamicObject)baseDataDy, (boolean)refChanged, (HCDMErrInfoEnum)hcdmErrInfoEnum));
        if (countryChanged) {
            allSalStructIdSet.add(basedDataDyId);
        }
        return countryChanged;
    }

    private List<QFilter> salarystandardFilter() {
        QFilter dataRuleForBdPropFilter;
        IDataModel entryOperate = this.getModel();
        DynamicObjectCollection collection = entryOperate.getEntryEntity("entryentity");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List itemIds = collection.stream().map(object -> object.getLong("salarystandard.id")).collect(Collectors.toList());
        if (itemIds.size() != 0) {
            QFilter idFilter = new QFilter("id", "not in", itemIds);
            filters.add(idFilter);
        }
        filters.add(new QFilter("enable", "=", (Object)MATCH_VALUE));
        filters.add(new QFilter("status", "=", (Object)"C"));
        Long orgId = this.getModel().getDataEntity().getLong("createorg.id");
        QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_salarystandard", (Long)orgId);
        if (orgFilter != null) {
            filters.add(orgFilter);
        }
        if ((dataRuleForBdPropFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"0VO5EV13=I9W", (String)"hcdm_stdscm", (String)"salarystandard")) != null) {
            filters.add(dataRuleForBdPropFilter);
        }
        return filters;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String callBackValue;
        super.closedCallBack(closedCallBackEvent);
        switch (callBackValue = closedCallBackEvent.getActionId()) {
            case "addItemReturn": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                this.newEntriesOperate(rows);
                break;
            }
        }
    }

    private void newEntriesOperate(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        List fIds = rows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter values = new TableValueSetter(new String[0]);
        values.addField("salarystandard", new Object[0]);
        for (Long fId : fIds) {
            values.addRow(new Object[]{fId});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", values);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "salaystructure": {
                this.delStructureMsg(args);
                this.getView().updateView("entryentity");
                break;
            }
            case "coefficienttabent": {
                DynamicObject dy = (DynamicObject)args.getChangeSet()[0].getNewValue();
                int lateStcOefNum = 0;
                if (!SWCObjectUtils.isEmpty((Object)dy)) {
                    lateStcOefNum = dy.getInt("latestcoefnum");
                }
                String lateStcOefNumStr = lateStcOefNum != 0 ? String.valueOf(lateStcOefNum) : "";
                this.getModel().setValue(LATESTCOEFFICI_ENT, (Object)lateStcOefNumStr, args.getChangeSet()[0].getRowIndex());
                this.lockIsMatchGradeRank();
                this.getView().updateView("entryentity");
                break;
            }
            case "salarystandard": {
                if (null == args.getChangeSet()[0].getNewValue()) {
                    int rowIndex = args.getChangeSet()[0].getRowIndex();
                    this.getModel().setValue("ismatchgraderank", null, rowIndex);
                    this.getModel().setValue("matchstrategy", null, rowIndex);
                    this.getModel().setValue("excesscontrol", null, rowIndex);
                }
                this.lockIsMatchGradeRank();
                this.getView().updateView("entryentity");
                break;
            }
            case "bsed": {
                this.bsedChangeConfirm(args);
                break;
            }
        }
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).delAfterConfirm(true).build();
        CountryHelper.propertyChangedForCountry((AbstractFormPlugin)this, (PropertyChangedArgs)args, (CountryPolicy)countryPolicy);
    }

    private boolean bsedChangeConfirm(PropertyChangedArgs args) {
        DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
        Date bsed = this.getModel().getDataEntity().getDate("bsed");
        if (dyColl.isEmpty() || bsed == null) {
            return true;
        }
        int nullCount = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject dyObj : dyColl) {
            Date date = dyObj.getDate("salarystandard.firstbsed");
            if (date == null) {
                ++nullCount;
                continue;
            }
            if (!date.after(bsed)) {
                ++nullCount;
                continue;
            }
            stringBuilder.append(dyObj.getString("salstructurent.name")).append('-').append(dyObj.getString("standarditem.name")).append('\uff1a').append(dyObj.getString("salarystandard.name")).append("\r\n");
        }
        if (nullCount == dyColl.size()) {
            return true;
        }
        String msg = ResManager.loadKDString((String)"\u4fee\u6539\u751f\u6548\u65e5\u671f\u540e\uff0c\u4ee5\u4e0b\u85aa\u916c\u6807\u51c6\u8868\u5c06\u65e0\u6cd5\u4f7f\u7528\uff0c\u7cfb\u7edf\u5c06\u6e05\u7a7a\u5df2\u586b\u5199\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"StdScmEdit_8", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, stringBuilder.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_CALL_BACK_BSED_CHANGE));
        Date oldValue = (Date)args.getChangeSet()[0].getOldValue();
        this.getView().getPageCache().put("temp_bsed_confirm", SWCDateTimeUtils.format((Date)oldValue));
        return false;
    }

    private void delStructureMsg(PropertyChangedArgs args) {
        String confirmMsg = ResManager.loadKDString((String)"\u4fee\u6539\u85aa\u916c\u7ed3\u6784\uff0c\u4ee5\u4e0b\u5b58\u5728\u5173\u8054\u5173\u7cfb\u7684\u6570\u636e\u5c06\u88ab\u6e05\u7a7a\u3002", (String)"StdScmEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        MulBasedataDynamicObjectCollection oldValue = (MulBasedataDynamicObjectCollection)args.getChangeSet()[0].getOldValue();
        List structureIdsList = oldValue.stream().map(old -> old.getLong("fbasedataid_id")).collect(Collectors.toList());
        MulBasedataDynamicObjectCollection newValue = (MulBasedataDynamicObjectCollection)args.getChangeSet()[0].getNewValue();
        List updStructureIdsList = newValue.stream().map(old -> old.getLong("fbasedataid_id")).collect(Collectors.toList());
        Set dells = structureIdsList.stream().filter(item -> !updStructureIdsList.contains(item)).collect(Collectors.toSet());
        SWCDataServiceHelper service = new SWCDataServiceHelper("hcdm_salaystructure");
        QFilter qFilter = new QFilter("id", "in", dells);
        DynamicObject[] structureObj = service.query("id,name", new QFilter[]{qFilter});
        List structureNameList = Arrays.stream(structureObj).map(object -> object.getString("name")).collect(Collectors.toList());
        List<Long> adds = updStructureIdsList.stream().filter(item -> !structureIdsList.contains(item)).collect(Collectors.toList());
        if (SWCListUtils.isEmpty(structureNameList) && !SWCListUtils.isEmpty(adds)) {
            this.addSalaryStructure(adds);
            return;
        }
        if (SWCListUtils.isEmpty(structureNameList)) {
            return;
        }
        String structureNames = StringUtils.join(structureNameList, (String)",");
        String oldStructureIds = StringUtils.join(structureIdsList, (String)",");
        this.getView().showConfirm(confirmMsg, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4f53\u7cfb\u8bbe\u7f6e\uff1a%s\u4e0b\u6240\u6709\u6570\u636e\u3002", (String)"StdScmEdit_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), structureNames), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(SALARY_STRUCTURE), null, oldStructureIds);
    }

    private void addSalaryStructure(List<Long> adds) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hcdm_salaystructure");
        QFilter qFilter = new QFilter("id", "in", adds);
        DynamicObject[] structureEntObjs = service.query("id,name, entryentity, entryentity.standarditem, entryentity.standarditem.enable", new QFilter[]{qFilter});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter values = new TableValueSetter(new String[0]);
        values.addField(SALSTRUCTUR_ENT, new Object[0]);
        values.addField("standarditem", new Object[0]);
        values.addField("salarystandard", new Object[0]);
        for (DynamicObject structureEntObj : structureEntObjs) {
            DynamicObjectCollection slyItems = structureEntObj.getDynamicObjectCollection("entryentity");
            if (SWCListUtils.isEmpty((List)slyItems)) continue;
            for (DynamicObject item : slyItems) {
                values.addRow(new Object[]{structureEntObj.getLong("id"), item.get("standarditem.id"), 0});
            }
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        Iterator iterator = rows.iterator();
        ArrayList<Integer> delIndex = new ArrayList<Integer>(10);
        while (iterator.hasNext()) {
            DynamicObject slyItems = (DynamicObject)iterator.next();
            Long salStructureEntId = slyItems.getLong("salstructurent.id");
            if (salStructureEntId != 0L) continue;
            delIndex.add(slyItems.getInt("seq") - 1);
        }
        int[] dataIndexs = delIndex.stream().mapToInt(Number::intValue).toArray();
        model.beginInit();
        model.deleteEntryRows("entryentity", dataIndexs);
        model.batchCreateNewEntryRow("entryentity", values);
        model.endInit();
        this.lockIsMatchGradeRank();
        this.getView().updateView("entryentity");
    }

    private void updateSalaryStructure(AbstractFormPlugin plugin, MessageBoxClosedEvent event) {
        String oldValue = event.getCustomVaule();
        List structureIdsList = Arrays.asList(oldValue.split(",")).stream().map(m1 -> Long.valueOf(m1)).collect(Collectors.toList());
        if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            IDataModel model = plugin.getView().getModel();
            model.beginInit();
            model.setValue(event.getCallBackId(), (Object)structureIdsList.toArray());
            model.endInit();
            plugin.getView().updateView(event.getCallBackId());
        } else {
            DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
            MulBasedataDynamicObjectCollection salaystructures = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity().get(SALARY_STRUCTURE);
            List updStructureIdsList = salaystructures.stream().map(old -> old.getLong("fbasedataid_id")).collect(Collectors.toList());
            List adds = updStructureIdsList.stream().filter(item -> !structureIdsList.contains(item)).collect(Collectors.toList());
            SWCDataServiceHelper service = new SWCDataServiceHelper("hcdm_salaystructure");
            QFilter qFilter = new QFilter("id", "in", adds);
            DynamicObject[] structureEntObjs = service.query("id,name, entryentity, entryentity.standarditem, entryentity.standarditem.enable", new QFilter[]{qFilter});
            Set dells = structureIdsList.stream().filter(item -> !updStructureIdsList.contains(item)).collect(Collectors.toSet());
            ArrayList<Integer> delIndex = new ArrayList<Integer>(10);
            for (DynamicObject slyItems : rows) {
                Long salStructureEntId = slyItems.getLong("salstructurent.id");
                if (!dells.contains(salStructureEntId) && salStructureEntId != 0L) continue;
                delIndex.add(slyItems.getInt("seq") - 1);
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            TableValueSetter values = new TableValueSetter(new String[0]);
            values.addField(SALSTRUCTUR_ENT, new Object[0]);
            values.addField("standarditem", new Object[0]);
            values.addField("salarystandard", new Object[0]);
            for (DynamicObject structureEntObj : structureEntObjs) {
                DynamicObjectCollection slyItems = structureEntObj.getDynamicObjectCollection("entryentity");
                if (SWCListUtils.isEmpty((List)slyItems)) continue;
                for (DynamicObject item2 : slyItems) {
                    values.addRow(new Object[]{structureEntObj.getLong("id"), item2.get("standarditem.id"), 0});
                }
            }
            int[] dataIndexs = delIndex.stream().mapToInt(Number::intValue).toArray();
            model.beginInit();
            model.deleteEntryRows("entryentity", dataIndexs);
            model.batchCreateNewEntryRow("entryentity", values);
            model.endInit();
            this.lockIsMatchGradeRank();
            this.getView().updateView("entryentity");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String fieldKey = args.getProperty().getName();
        Long createOrgId = this.getModel().getDataEntity().getLong("createorg.id");
        switch (fieldKey) {
            case "coefficienttab": {
                long orgID = RequestContext.get().getOrgId();
                QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_coefficienttab", (Long)orgID);
                args.addCustomQFilter(orgFilter);
                break;
            }
            case "salaystructure": {
                if (CountryHelper.checkInvalidAndSetFilter((AbstractFormPlugin)this, (IMetadata)args.getProperty(), null, (List)args.getCustomQFilters(), (boolean)true)) {
                    args.setCancel(true);
                    return;
                }
                QFilter salayStructureQFilter = new QFilter("status", "=", (Object)"C");
                salayStructureQFilter.and(new QFilter("enable", "=", (Object)MATCH_VALUE));
                QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_salaystructure", (Long)createOrgId);
                if (useOrgFilter != null) {
                    salayStructureQFilter.and(useOrgFilter);
                }
                args.addCustomQFilter(salayStructureQFilter);
                break;
            }
            case "salarystandard": {
                if (CountryHelper.checkInvalidAndSetFilter((AbstractFormPlugin)this, (IMetadata)args.getProperty(), null, (List)args.getCustomQFilters(), (boolean)true)) {
                    args.setCancel(true);
                    return;
                }
                Date bsed = (Date)this.getModel().getValue("bsed");
                if (bsed == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u751f\u6548\u65e5\u671f\u3002", (String)"StdScmEdit_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", args.getRow());
                Long standarditem = dynamicObject.getLong("standarditem.id");
                QFilter qFilter = new QFilter("salarystditem.salaryitem", "=", (Object)standarditem);
                QFilter salaryStandardQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_salarystandard", (Long)createOrgId);
                if (salaryStandardQFilter != null) {
                    salaryStandardQFilter.and(qFilter);
                    args.addCustomQFilter(salaryStandardQFilter);
                } else {
                    args.addCustomQFilter(qFilter);
                }
                QFilter firstBsedQFilter = new QFilter("firstbsed", "<=", (Object)bsed);
                args.addCustomQFilter(firstBsedQFilter);
                break;
            }
            case "coefficienttabent": {
                QFilter coefficienttabEntqFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_coefficienttab", (Long)createOrgId);
                if (coefficienttabEntqFilter == null) break;
                args.addCustomQFilter(coefficienttabEntqFilter);
                break;
            }
        }
    }

    private void lockIsMatchGradeRank() {
        int i1 = 0;
        DynamicObjectCollection ents = this.getModel().getEntryEntity("entryentity");
        ArrayList withoutSalaryStandarRow = Lists.newArrayListWithExpectedSize((int)ents.size());
        for (DynamicObject ent : ents) {
            if (SWCObjectUtils.isEmpty((Object)ent.getDynamicObject("salarystandard"))) {
                withoutSalaryStandarRow.add(i1);
            }
            ++i1;
        }
        IClientViewProxy clientService = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        SWCGridUtils.lockCell((IClientViewProxy)clientService, (String)"entryentity", (int[])withoutSalaryStandarRow.stream().mapToInt(Integer::valueOf).toArray(), (String[])colNames, (boolean)true);
    }

    private void checkEffVersionItem() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (!(MATCH_VALUE.equals(dataEntity.getString("enable")) && "C".equals(dataEntity.getString("status")) && MATCH_VALUE.equals(dataEntity.getString("datastatus")))) {
            return;
        }
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return;
        }
        if (!SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_stdscm", (String)"4715a0df000000ac")) {
            return;
        }
        HashSet<Long> itemOutIds = new HashSet<Long>(16);
        Map<Long, List<Long>> structAndItemIdMap = this.queryStructItemId(dataEntity, itemOutIds);
        if (!this.isNeedModify(dataEntity, structAndItemIdMap)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_standarditem");
        DynamicObjectCollection itemDyColl = helper.queryOriginalCollection("id, name", new QFilter("id", "in", itemOutIds).toArray());
        if (itemDyColl == null || itemDyColl.isEmpty()) {
            return;
        }
        StringBuilder sbTip = new StringBuilder();
        sbTip.append(ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u916c\u4f53\u7cfb\u4e2d\u5305\u542b\u5b9a\u8c03\u85aa\u9879\u76ee\u6709\uff1a", (String)"StdScmEdit_9", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        for (DynamicObject obj : dataEntity.getDynamicObjectCollection("entryentity")) {
            sbTip.append(obj.getString("standarditem.name")).append('\u3001');
        }
        if (sbTip.toString().endsWith("\u3001")) {
            sbTip.deleteCharAt(sbTip.lastIndexOf("\u3001"));
        }
        sbTip.append("\r\n").append(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u85aa\u916c\u7ed3\u6784\u4e2d\u5305\u542b\u5b9a\u8c03\u85aa\u9879\u76ee\u6709\uff1a", (String)"StdScmEdit_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        for (DynamicObject obj : itemDyColl) {
            sbTip.append(obj.getString("name")).append('\u3001');
        }
        if (sbTip.toString().endsWith("\u3001")) {
            sbTip.deleteCharAt(sbTip.lastIndexOf("\u3001"));
        }
        String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u6821\u9a8c\u51fa\uff0c\u85aa\u916c\u7ed3\u6784\u4e2d\u5b9a\u8c03\u85aa\u9879\u76ee\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u53d8\u66f4\u85aa\u916c\u4f53\u7cfb\uff1f", (String)"StdScmEdit_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, sbTip.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_CALL_BACK_ID_CHECK));
    }

    private boolean isNeedModify(DynamicObject dataEntity, Map<Long, List<Long>> structAndItemIdMap) {
        HashMap<Long, List> curStructAndItemIdMap = new HashMap<Long, List>(16);
        DynamicObjectCollection entryDyColl = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : entryDyColl) {
            List itemIds = curStructAndItemIdMap.computeIfAbsent(obj.getLong("salstructurent.id"), list -> new ArrayList(16));
            itemIds.add(obj.getLong("standarditem.id"));
        }
        boolean isNeedModify = false;
        block1: for (Map.Entry<Long, List<Long>> mapEntry : structAndItemIdMap.entrySet()) {
            List curItemIds = (List)curStructAndItemIdMap.get(mapEntry.getKey());
            if (curItemIds == null) {
                isNeedModify = true;
                break;
            }
            List<Long> itemIds = mapEntry.getValue();
            if (itemIds == null) continue;
            if (curItemIds.size() != itemIds.size()) {
                isNeedModify = true;
                break;
            }
            for (Long itemId : itemIds) {
                if (curItemIds.contains(itemId)) continue;
                isNeedModify = true;
                break block1;
            }
        }
        return isNeedModify;
    }

    private Map<Long, List<Long>> queryStructItemId(DynamicObject dataEntity, Set<Long> itemOutIds) {
        HashSet<Long> structIds = new HashSet<Long>(16);
        DynamicObjectCollection dyColl = dataEntity.getDynamicObjectCollection(SALARY_STRUCTURE);
        if (dyColl != null && !dyColl.isEmpty()) {
            for (DynamicObject dynamicObject : dyColl) {
                structIds.add(dynamicObject.getLong("fbasedataid.id"));
            }
        }
        String sql = "SELECT FID,FSTANDARDITEMID FROM T_HCDM_SLYSTRUCTUREENT WHERE FID in " + HCDMDbHelper.getFidHolder((int)structIds.size());
        Object[] params = new Object[structIds.size()];
        int index = 0;
        for (Long structId : structIds) {
            params[index++] = structId;
        }
        return (Map)SWCDbUtil.query((DBRoute)new DBRoute("hcdm"), (String)sql, (Object[])params, rs -> {
            HashMap<Long, List> result = new HashMap<Long, List>(16);
            while (rs.next()) {
                List itemIds = result.computeIfAbsent(rs.getLong("FID"), list -> new ArrayList(16));
                itemIds.add(rs.getLong("FSTANDARDITEMID"));
                itemOutIds.add(rs.getLong("FSTANDARDITEMID"));
            }
            return result;
        });
    }
}

