/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.stdscm;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.IBaseDataService;
import kd.swc.hcdm.business.coefficient.CoefficientTabServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class StdScmList
extends SWCDataBaseList {
    private static final Log logger = LogFactory.getLog(StdScmList.class);

    public void registerListener(EventObject object) {
        super.registerListener(object);
        this.addItemClickListeners(new String[]{"tblcopy"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if ("copy".equals(formOperate.getOperateKey())) {
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            if (primaryKeyValues.length > 1) {
                return;
            }
            Long cnfId = Long.valueOf(String.valueOf(primaryKeyValues[0]));
            this.setCopyData(cnfId);
        }
    }

    private void setCopyData(Long enrollId) {
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        String fieldName = hyperLinkClickEvent.getFieldName();
        Object primaryKeyValue = currentRow.getPrimaryKeyValue();
        Object entryPrimaryKeyValue = currentRow.getEntryPrimaryKeyValue();
        String billFormId = ((ListView)this.getView()).getBillFormId();
        switch (fieldName) {
            case "salarystandard_name": {
                this.openSalaryStandardPage(args, primaryKeyValue, entryPrimaryKeyValue, billFormId);
                break;
            }
            case "coefficienttab_name": {
                this.openCoefficientTabPage(args, primaryKeyValue, billFormId);
                break;
            }
            case "coefficienttabent_name": {
                this.openCoefficientTabEntPage(args, primaryKeyValue, entryPrimaryKeyValue, billFormId);
                break;
            }
            case "salaystructure_name": {
                this.openSalayStructurePage(args, primaryKeyValue, entryPrimaryKeyValue, billFormId);
                break;
            }
        }
    }

    private void openSalayStructurePage(HyperLinkClickArgs args, Object primaryKeyValue, Object entryPrimaryKeyValue, String billFormId) {
        args.setCancel(true);
        DynamicObject object = this.getStdscmData(primaryKeyValue, billFormId);
        MulBasedataDynamicObjectCollection salaryStructureObjects = (MulBasedataDynamicObjectCollection)object.get("salaystructure");
        List<Long> salaryStructureIdList = salaryStructureObjects.stream().map(object1 -> object1.getLong("fbasedataid_id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_salaystructure");
        QFilter qFilter = new QFilter("id", "in", salaryStructureIdList);
        DynamicObject[] dynamicObjects = helper.query("number,name", new QFilter[]{qFilter});
        HashMap<String, List<String>> filterColumnParamMap = new HashMap<String, List<String>>(2);
        List numbers = Arrays.stream(dynamicObjects).map(object1 -> object1.getString("number")).collect(Collectors.toList());
        List names = Arrays.stream(dynamicObjects).map(object1 -> object1.getString("name")).collect(Collectors.toList());
        filterColumnParamMap.put("number", numbers);
        filterColumnParamMap.put("name", names);
        this.getView().getFormShowParameter().setCustomParam("notOpenDefaultHyperLink", (Object)"salaystructure_name");
        this.openSalayStructure(salaryStructureIdList.toArray(new Long[salaryStructureIdList.size()]), filterColumnParamMap);
    }

    private void openCoefficientTabEntPage(HyperLinkClickArgs args, Object primaryKeyValue, Object entryPrimaryKeyValue, String billFormId) {
        DynamicObjectCollection dys;
        args.setCancel(true);
        DynamicObject object = this.getStdscmData(primaryKeyValue, billFormId);
        if (!SWCBaseUtils.isEmpty((DynamicObject)object) && (dys = object.getDynamicObjectCollection("entryentity")) != null && dys.size() > 0) {
            for (DynamicObject dy : dys) {
                if (!entryPrimaryKeyValue.toString().equals(dy.getString("id"))) continue;
                DynamicObject coefficientObject = dy.getDynamicObject("coefficienttabent");
                HashMap<String, String> filterColumnParamMap = new HashMap<String, String>(2);
                String number = coefficientObject.getString("number");
                String name = coefficientObject.getString("name");
                filterColumnParamMap.put("number", number);
                filterColumnParamMap.put("name", name);
                this.getView().getFormShowParameter().setCustomParam("notOpenDefaultHyperLink", (Object)"coefficienttabent_name");
                this.opencoefficient(coefficientObject.getLong("id"), filterColumnParamMap);
            }
        }
    }

    private void openCoefficientTabPage(HyperLinkClickArgs args, Object primaryKeyValue, String billFormId) {
        args.setCancel(true);
        DynamicObject object = this.getStdscmData(primaryKeyValue, billFormId);
        DynamicObject coefficientObject = object.getDynamicObject("coefficienttab");
        HashMap<String, String> filterColumnParamMap = new HashMap<String, String>(2);
        String number = coefficientObject.getString("number");
        String name = coefficientObject.getString("name");
        filterColumnParamMap.put("number", number);
        filterColumnParamMap.put("name", name);
        this.getView().getFormShowParameter().setCustomParam("notOpenDefaultHyperLink", (Object)"coefficienttab_name");
        this.opencoefficient(coefficientObject.getLong("id"), filterColumnParamMap);
    }

    private void openSalaryStandardPage(HyperLinkClickArgs args, Object primaryKeyValue, Object entryPrimaryKeyValue, String billFormId) {
        DynamicObjectCollection dys;
        args.setCancel(true);
        DynamicObject object = this.getStdscmData(primaryKeyValue, billFormId);
        if (!SWCBaseUtils.isEmpty((DynamicObject)object) && (dys = object.getDynamicObjectCollection("entryentity")) != null && dys.size() > 0) {
            for (DynamicObject dy : dys) {
                if (!entryPrimaryKeyValue.toString().equals(dy.getString("id"))) continue;
                DynamicObject salarystandardObject = dy.getDynamicObject("salarystandard");
                Long pkId = salarystandardObject.getLong("id");
                HashMap<String, String> filterColumnParamMap = new HashMap<String, String>(2);
                String number = salarystandardObject.getString("number");
                String name = salarystandardObject.getString("name");
                filterColumnParamMap.put("number", number);
                filterColumnParamMap.put("name", name);
                this.getView().getFormShowParameter().setCustomParam("notOpenDefaultHyperLink", (Object)"salarystandard_name");
                this.openSalarystandard(pkId, filterColumnParamMap);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    public void setFilter(SetFilterEvent setfilterevent) {
        super.setFilter(setfilterevent);
        setfilterevent.setOrderBy("id desc,entryentity.seq asc");
    }

    private DynamicObject getStdscmData(Object primaryKeyValue, String billFormId) {
        IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(primaryKeyValue.toString()));
        SWCDataServiceHelper helper = new SWCDataServiceHelper(billFormId);
        String createOrg = this.getPageCache().get("createOrg");
        if (SWCStringUtils.isNotEmpty((String)createOrg)) {
            long orgID = Long.parseLong(createOrg);
            QFilter qFilter = baseDataService.getBaseDataFilter("hcdm_stdscm", Long.valueOf(orgID));
            idFilter.and(qFilter);
        }
        String selectFields = SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_stdscm");
        return helper.queryOne(selectFields, new QFilter[]{idFilter});
    }

    private void openSalarystandard(Long pkId, Map<String, String> filterColumnParamMap) {
        ListShowParameter salarystandard = new ListShowParameter();
        salarystandard.setBillFormId("hcdm_salarystandard");
        salarystandard.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (pkId != null) {
            salarystandard.setSelectedRow((Object)pkId);
        }
        salarystandard.setCustomParam("filterColumnParam", filterColumnParamMap);
        this.getView().showForm((FormShowParameter)salarystandard);
    }

    private void opencoefficient(Long tableId, Map<String, String> filterColumnParamMap) {
        String errMsg = CoefficientTabServiceHelper.getStatusErrorMsgByPkId((String)tableId.toString());
        if (SWCStringUtils.isEmpty((String)errMsg)) {
            ListShowParameter coefficienttab = new ListShowParameter();
            coefficienttab.setBillFormId("hcdm_coefficienttab");
            coefficienttab.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            coefficienttab.setSelectedRow((Object)tableId);
            coefficienttab.setCustomParam("filterColumnParam", filterColumnParamMap);
            this.getView().showForm((FormShowParameter)coefficienttab);
        } else {
            this.getView().showErrorNotification(errMsg);
        }
    }

    private void openSalayStructure(Long[] tableIds, Map<String, List<String>> filterColumnParamMap) {
        ListShowParameter coefficienttab = new ListShowParameter();
        coefficienttab.setBillFormId("hcdm_salaystructure");
        coefficienttab.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        coefficienttab.setSelectedRows((Object[])tableIds);
        coefficienttab.setCustomParam("filterColumnParam", filterColumnParamMap);
        this.getView().showForm((FormShowParameter)coefficienttab);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        List qFilters = args.getQfilters();
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"0VO5EV13=I9W", (String)"hcdm_stdscm", (String)"47150e89000000ac");
        logger.info("StdScmList#filterContainerBeforeF7Select qFilters1 :{}", (Object)qFilters);
        logger.info("StdScmList#filterContainerBeforeF7Select permOrgs :{}", (Object)permOrgs);
        Set countrySet = SWCPermissionServiceHelper.getCountrySetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_stdscm", (String)"47150e89000000ac");
        switch (fieldName) {
            case "salstructurent.name": {
                QFilter qFilter;
                if (null != permOrgs && !permOrgs.hasAllOrgPerm() && null != (qFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_salaystructure", (List)permOrgs.getHasPermOrgs(), (boolean)true))) {
                    qFilters.add(qFilter);
                }
                if (null == countrySet) break;
                QFilter filter = new QFilter("country", "in", (Object)countrySet);
                qFilters.add(filter);
                break;
            }
            case "standarditem.name": {
                QFilter qFilter;
                if (null != permOrgs && !permOrgs.hasAllOrgPerm() && null != (qFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_standarditem", (List)permOrgs.getHasPermOrgs(), (boolean)true))) {
                    qFilters.add(qFilter);
                }
                if (null == countrySet) break;
                QFilter filter = new QFilter("country", "in", (Object)countrySet);
                filter.or(new QFilter("areatype", "=", (Object)"1"));
                qFilters.add(filter);
                break;
            }
            case "salarystandard.name": {
                QFilter qFilter;
                if (null != permOrgs && !permOrgs.hasAllOrgPerm() && null != (qFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_salarystandard", (List)permOrgs.getHasPermOrgs(), (boolean)true))) {
                    qFilters.add(qFilter);
                }
                if (null == countrySet) break;
                QFilter filter = new QFilter("country", "in", (Object)countrySet);
                qFilters.add(filter);
                break;
            }
            case "coefficienttabent.name": {
                QFilter qFilter;
                if (null == permOrgs || permOrgs.hasAllOrgPerm() || null == (qFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_coefficienttab", (List)permOrgs.getHasPermOrgs(), (boolean)true))) break;
                qFilters.add(qFilter);
                break;
            }
        }
        logger.info("StdScmList#filterContainerBeforeF7Select qFilters2 :{}", (Object)qFilters);
    }
}

