/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.activity;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.OnBrdInfoPushToCandSetSalApplService;
import kd.swc.hcdm.opplugin.validator.activity.CandidateActValidator;

public class CreateApplOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(CreateApplOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("onbrdinfoid");
        fieldKeys.add("activitybase.activitystatus");
        fieldKeys.add("candsetsalapplid");
        fieldKeys.add("candsetsalapplnum");
        fieldKeys.add("iscandsetsal");
        fieldKeys.add("activitybase.number");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new CandidateActValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        Object[] dataEntities = args.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        Map<Long, Long> onBrdInfoIdToActIdMap = Arrays.stream(dataEntities).collect(Collectors.toMap(dy -> dy.getLong("onbrdinfoid"), dy -> dy.getLong("id"), (o1, o2) -> o2));
        this.getOption().setVariableValue("onBrdInfoIdToActIdMap", SerializationUtils.serializeToBase64(onBrdInfoIdToActIdMap));
        Map<Long, String> onBrdInfoIdToActNumMap = Arrays.stream(dataEntities).collect(Collectors.toMap(dy -> dy.getLong("onbrdinfoid"), dy -> dy.getString("activitybase.number"), (o1, o2) -> o2));
        this.getOption().setVariableValue("onBrdInfoIdToActNumMap", SerializationUtils.serializeToBase64(onBrdInfoIdToActNumMap));
        List result = null;
        try {
            result = OnBrdInfoPushToCandSetSalApplService.pushToCandSetSalAppl(onBrdInfoIdToActIdMap);
            this.getOption().setVariableValue("result", SerializationUtils.serializeToBase64((Object)result));
            CandSetSalActHelper.updateActStatus((List)Lists.newArrayList((Object[])dataEntities), (List)result);
            HRBaseServiceHelper CANDSETSALACT_HELPER = new HRBaseServiceHelper("hcdm_candsetsalact");
            HRBaseServiceHelper ACTIVITYBASE_HELPER = new HRBaseServiceHelper("hcdm_activitybase");
            try (TXHandle required = TX.required();){
                DynamicObject[] actBaseDys = (DynamicObject[])Arrays.stream(dataEntities).map(dy -> dy.getDynamicObject("activitybase")).toArray(DynamicObject[]::new);
                CANDSETSALACT_HELPER.save((DynamicObject[])dataEntities);
                ACTIVITYBASE_HELPER.save(actBaseDys);
            }
        }
        catch (Exception exception) {
            LOGGER.error("CreateApplOp beforeExecuteOperationTransaction throw exception is", (Throwable)exception);
        }
    }

    public void onReturnOperation(ReturnOperationArgs args) {
        String resultStr = this.getOption().getVariableValue("result", "");
        if (Strings.isNullOrEmpty((String)resultStr)) {
            return;
        }
        List result = (List)SerializationUtils.deSerializeFromBase64((String)resultStr);
        String onBrdInfoIdToActIdMapStr = this.getOption().getVariableValue("onBrdInfoIdToActIdMap");
        Map onBrdInfoIdToActIdMap = (Map)SerializationUtils.deSerializeFromBase64((String)onBrdInfoIdToActIdMapStr);
        String onBrdInfoIdToActNumMapStr = this.getOption().getVariableValue("onBrdInfoIdToActNumMap");
        Map onBrdInfoIdToActNumMap = (Map)SerializationUtils.deSerializeFromBase64((String)onBrdInfoIdToActNumMapStr);
        OperationResult operationResult = (OperationResult)args.getOperationResult();
        operationResult.setSuccess(false);
        ArrayList successPKIds = Lists.newArrayListWithExpectedSize((int)result.size());
        for (Map map : result) {
            Boolean success = (Boolean)map.get("success");
            if (!success.booleanValue()) continue;
            operationResult.setSuccess(true);
            Long onBrdInfoId = (Long)map.get("onbrdinfoid");
            successPKIds.add(onBrdInfoIdToActIdMap.get(onBrdInfoId));
        }
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Set errorPkValues = allErrorOrValidateInfo.stream().map(IOperateInfo::getPkValue).collect(Collectors.toSet());
        operationResult.setBillCount(result.size() + errorPkValues.size());
        operationResult.setSuccessPkIds((List)successPKIds);
        operationResult.setShowMessage(true);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            for (Map map : result) {
                Boolean mapSuccess = (Boolean)map.get("success");
                if (mapSuccess.booleanValue()) continue;
                Long onBrdInfoId = (Long)map.get("onbrdinfoid");
                String actNum = (String)onBrdInfoIdToActNumMap.get(onBrdInfoId);
                String errMsg = ResManager.loadKDString((String)"{0}\uff1a{1}\u3002", (String)"CreateApplOp_0", (String)"swc-hcdm-opplugin", (Object[])new Object[]{actNum, map.get("message")});
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setMessage(errMsg);
                operateErrorInfo.setErrorLevel("FatalError");
                operationResult.addErrorInfo(operateErrorInfo);
            }
        }
    }
}

