/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.coefficient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class CoefficientCalLatestNumOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("coefficienttab.id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        HashSet<Long> tableIdSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            tableIdSet.add(dataEntity.getLong("coefficienttab.id"));
        }
        this.updateTable(tableIdSet);
    }

    private void updateTable(Set<Long> tableIdSet) {
        DynamicObject[] dataEntities;
        String sql = "select t.fid tabid,max(c.fismodify) modifytype,count(c.fid) coeffnum from t_hcdm_coefficienttab t left join t_hcdm_coefficient c on c.fcoefficienttabid = t.fid where t.fid in " + HCDMDbHelper.getFidHolder((int)tableIdSet.size()) + " and c.fstatus = ? and c.fenable = ? and c.fiscurrentversion = ? group by t.fid";
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        for (Long tableId : tableIdSet) {
            paramList.add(tableId);
        }
        paramList.add("C");
        paramList.add("1");
        paramList.add("1");
        HashMap<Long, Integer> lastNumMap = new HashMap<Long, Integer>(tableIdSet.size());
        HashMap<Long, Boolean> hasModifyNumMap = new HashMap<Long, Boolean>(tableIdSet.size());
        try (DataSet queryDataSet = HCDMDbHelper.queryDataSet((String)sql, (Object[])paramList.toArray());){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                lastNumMap.put(row.getLong("tabid"), row.getInteger("coeffnum"));
                hasModifyNumMap.put(row.getLong("tabid"), row.getInteger("modifytype") > 0);
            }
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_coefficienttab");
        for (DynamicObject dataEntity : dataEntities = helper.query("hasmodifyingcoef,latestcoefnum", new QFilter[]{new QFilter("id", "in", tableIdSet)})) {
            long tableId = dataEntity.getLong("id");
            dataEntity.set("latestcoefnum", lastNumMap.get(tableId));
            dataEntity.set("hasmodifyingcoef", hasModifyNumMap.get(tableId));
        }
        helper.update(dataEntities);
    }
}

