/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.coefficient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.swc.hcdm.business.HCDMDbHelper;

public class CoefficientHasModifyOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("coefficienttab.id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        HashSet<Long> tableIdSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            tableIdSet.add(dataEntity.getLong("coefficienttab.id"));
        }
        Map<Long, Integer> tableLatestNumMap = this.queryLatestNum(tableIdSet);
        this.updateTable(tableLatestNumMap, tableIdSet);
    }

    private Map<Long, Integer> queryLatestNum(Set<Long> tableIdSet) {
        String sql = "select t.fid tabid,max(c.fismodify) hasmodify,count(c.fismodify) type from t_hcdm_coefficienttab t left join t_hcdm_coefficient c on c.fcoefficienttabid = t.fid where t.fid in " + HCDMDbHelper.getFidHolder((int)tableIdSet.size()) + " and c.fstatus = ? and c.fenable = ? and c.fismodify = ? group by t.fid";
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        for (Long tableId : tableIdSet) {
            paramList.add(tableId);
        }
        paramList.add("C");
        paramList.add(Integer.valueOf("1"));
        paramList.add(Boolean.TRUE);
        HashMap<Long, Integer> group = new HashMap<Long, Integer>(tableIdSet.size());
        try (DataSet queryDataSet = HCDMDbHelper.queryDataSet((String)sql, (Object[])paramList.toArray());){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                group.put(row.getLong("tabid"), row.getInteger("type"));
            }
        }
        return group;
    }

    private void updateTable(Map<Long, Integer> tableLatestNumMap, Set<Long> tableIdSet) {
        String updateProperties = "hasmodifyingcoef";
        MainEntityType tabEntityType = EntityMetadataCache.getDataEntityType((String)"hcdm_coefficienttab");
        DynamicObjectCollection colls = new DynamicObjectCollection();
        DynamicObject up = null;
        for (Long tableId : tableIdSet) {
            Integer isModifyNum = tableLatestNumMap.get(tableId);
            boolean tabIsModify = isModifyNum != null && isModifyNum > 0;
            up = new DynamicObject((DynamicObjectType)tabEntityType);
            up.set("id", (Object)tableId);
            up.set(updateProperties, (Object)tabIsModify);
            colls.add((Object)up);
        }
        Object[] dataEntities = new DynamicObject[colls.size()];
        dataEntities = (DynamicObject[])colls.toArray(dataEntities);
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }
}

