/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.coefficient;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class CoefficientUpdateModifyNumOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CoefficientUpdateModifyNumOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("coefficienttab.id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        HashSet<Long> tableIdSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            long coefficienttabId = dataEntity.getLong("coefficienttab.id");
            if (coefficienttabId == 0L) continue;
            tableIdSet.add(coefficienttabId);
        }
        for (Long tableId : tableIdSet) {
            this.updateTable(tableId);
        }
    }

    private void updateTable(Long tableId) {
        logger.info("CoefficientUpdateModifyNumOp.updateTable,tableId = {}", (Object)tableId);
        SWCDataServiceHelper coeHelper = new SWCDataServiceHelper("hcdm_coefficient");
        QFilter idFilter = new QFilter("coefficienttab.id", "=", (Object)tableId);
        QFilter sFilter = new QFilter("status", "=", (Object)"C");
        QFilter eFilter = new QFilter("enable", "=", (Object)"1");
        QFilter modifyFilter = new QFilter("ismodify", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{idFilter, sFilter, eFilter, modifyFilter};
        int count = coeHelper.count(filters);
        Boolean hasModifyingCoeff = count > 0 ? Boolean.TRUE : Boolean.FALSE;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_coefficienttab");
        DynamicObject up2 = helper.queryOne("hasmodifyingcoef", (Object)tableId);
        boolean oldHasModifyingCoeff = up2.getBoolean("hasmodifyingcoef");
        if (oldHasModifyingCoeff ^ hasModifyingCoeff) {
            up2.set("hasmodifyingcoef", (Object)hasModifyingCoeff);
            helper.updateOne(up2);
        }
    }
}

