/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.revision.validator;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.adjfile.AdjFileMatchParam;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileMatchResult;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileNotFoundErrorEnum;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.decadjrecordrevision.DecAdjRecordRevisionHelper;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.util.MultiLangHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class RevisionSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(RevisionSaveValidator.class);
    private final AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);

    public void validate() {
        Object dataEntity;
        int n;
        Object[] dataEntities = this.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        String type = this.getOption().getVariableValue("type", "");
        List dynamicObjects = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        boolean isFail = false;
        for (Object dataEntity2 : dataEntities) {
            DynamicObjectCollection entryDys = dataEntity2.getDataEntity().getDynamicObjectCollection("revisionentry");
            isFail = this.validateBsledAndBsed((ExtendedDataEntity)dataEntity2, entryDys);
        }
        if (isFail) {
            return;
        }
        HashSet<Long> salaryAdjFileVersionSet = new HashSet<Long>(16);
        isFail = this.checkMatchAdjfileVersion((ExtendedDataEntity[])dataEntities, salaryAdjFileVersionSet);
        if (isFail) {
            return;
        }
        Map checkResult = this.adjFileApplicationService.checkEmpposorgrelAvailable(salaryAdjFileVersionSet);
        for (Object dataEntity3 : dataEntities) {
            isFail = !this.validateEmpposorgrelAvailable(checkResult, (ExtendedDataEntity)dataEntity3, ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\uff08{0}\uff09\uff1a\u6863\u6848\u7248\u672c\u5173\u8054\u4efb\u804c\u5df2\u5e9f\u5f03\uff0c\u8bf7\u8c03\u6574\u6863\u6848\u57fa\u672c\u4fe1\u606f\u3002", (String)"RevisionSaveValidator_23", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
        }
        if (isFail) {
            return;
        }
        Set salaryAdjFileBoidSet = dynamicObjects.stream().flatMap(dy -> dy.getDynamicObjectCollection("revisionentry").stream()).map(dy -> dy.getLong("salaryadjfile_r.boid")).collect(Collectors.toSet());
        if ("addnew".equals(type)) {
            Map adjFileMap = DecAdjRecordRevisionHelper.getAdjFilesByBoIds(salaryAdjFileBoidSet);
            Object[] entryDys = dataEntities;
            int dataEntity3 = entryDys.length;
            for (n = 0; !(n >= dataEntity3 || (isFail = this.validateAdjFileStatus(adjFileMap, (ExtendedDataEntity)(dataEntity = entryDys[n]), ResManager.loadKDString((String)"\u65b0\u589e\u5b9a\u8c03\u85aa\u6570\u636e\u65f6\uff0c\u5b9a\u8c03\u85aa\u6863\u6848\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u6216\u5df2\u5931\u6548\u3002", (String)"RevisionSaveValidator_12", (String)"swc-hcdm-opplugin", (Object[])new Object[0]))) || (isFail = this.validateSalaryAdjRsnType((ExtendedDataEntity)dataEntity)) || (isFail = this.validateEffectiveDate((ExtendedDataEntity)dataEntity))); ++n) {
            }
            if (isFail) {
                return;
            }
        }
        if ("revise".equals(type)) {
            Map adjFileMap = DecAdjRecordRevisionHelper.getAdjFilesByBoIds(salaryAdjFileBoidSet);
            Object[] entryDys = dataEntities;
            int dataEntity3 = entryDys.length;
            for (n = 0; n < dataEntity3 && !(isFail = this.validateAdjFileStatus(adjFileMap, (ExtendedDataEntity)(dataEntity = entryDys[n]), ResManager.loadKDString((String)"\u4fee\u6b63\u5b9a\u8c03\u85aa\u6570\u636e\u65f6\uff0c\u5b9a\u8c03\u85aa\u6863\u6848\u5fc5\u987b\u662f\u201c\u5df2\u5ba1\u6838\u201d\u6216\u201c\u5df2\u5931\u6548\u201d\u72b6\u6001\u3002", (String)"RevisionSaveValidator_22", (String)"swc-hcdm-opplugin", (Object[])new Object[0]))); ++n) {
            }
            if (isFail) {
                return;
            }
        }
        Set stdScmVIdSet = dynamicObjects.stream().flatMap(dy -> dy.getDynamicObjectCollection("revisionentry").stream()).map(dy -> dy.getLong("stdscm_p.id")).collect(Collectors.toSet());
        Map stdScmMap = DecAdjRecordRevisionHelper.getStdScmMapByVidSet(stdScmVIdSet);
        for (Object dataEntity4 : dataEntities) {
            isFail = this.validateStandardItemAndStdScm((ExtendedDataEntity)dataEntity4, stdScmMap);
        }
        if (isFail) {
            return;
        }
        Map influencedHisData = this.adjFileApplicationService.getInfluencedHisDataByFileBoidAndItemId(dynamicObjects);
        Set adminOrgSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_salaryadjrecordquery", (String)"47156aff000000ac", (String)"hcdm_decadjrelperson.assoadminorg");
        logger.info("RevisionSaveValidator adminOrgSet is {}", (Object)adminOrgSet);
        List recordDyList = influencedHisData.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        logger.info("RevisionSaveValidator recordDyList id list is {}", recordDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        Map decAdjPersonInfoMap = DecAdjRecordRevisionHelper.getDecAdjPersonInfoByRecord(recordDyList);
        if (!CollectionUtils.isEmpty((Map)decAdjPersonInfoMap)) {
            logger.info("RevisionSaveValidator decAdjPersonInfoMap key is {}", decAdjPersonInfoMap.keySet());
        }
        for (Object dataEntity5 : dataEntities) {
            this.checkAdminOrg(adminOrgSet, decAdjPersonInfoMap, influencedHisData, (ExtendedDataEntity)dataEntity5);
            this.checkCalcType((ExtendedDataEntity)dataEntity5);
        }
        Map<Integer, Long> seqToDepEmpIdMap = dynamicObjects.stream().flatMap(dy -> dy.getDynamicObjectCollection("revisionentry").stream()).collect(Collectors.toMap(dy -> dy.getInt("seq"), dy -> dy.getLong("depemp_p.id"), (o1, o2) -> o2));
        HashSet depEmpIds = Sets.newHashSet(seqToDepEmpIdMap.values());
        Map adjBillMap = CommonHcdmBizHelper.getInvalidAdjBillByDepEmpId((Set)depEmpIds);
        Map candSetMap = CommonHcdmBizHelper.getCandSetSalApplidInTransitMap((Collection)depEmpIds);
        HashMap<Long, List<DynamicObject>> initMap = new HashMap<Long, List<DynamicObject>>(16);
        try {
            initMap.putAll(CommonHcdmBizHelper.getInvalidAdjRecordByAdjFileId(salaryAdjFileBoidSet));
        }
        catch (Exception ex) {
            logger.error("CommonHcdmBizHelper.getInvalidAdjRecordByAdjFileId error:", (Throwable)ex);
        }
        Map itemUseRankFlag = DecAdjRecordRevisionHelper.getItemUseRankFlag(dynamicObjects.stream().flatMap(dy -> dy.getDynamicObjectCollection("revisionentry").stream()).collect(Collectors.toList()));
        for (Object dataEntity6 : dataEntities) {
            this.checkOnBoardOtherBillsForAdjFile(adjBillMap, initMap, candSetMap, (ExtendedDataEntity)dataEntity6);
            this.validateGradeAndRank((ExtendedDataEntity)dataEntity6, itemUseRankFlag);
        }
    }

    private boolean checkMatchAdjfileVersion(ExtendedDataEntity[] dataEntities, Set<Long> salaryAdjFileVersionSet) {
        ArrayList<AdjFileMatchParam> matchFileParams = new ArrayList<AdjFileMatchParam>(10);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entryDys = dataEntity.getDataEntity().getDynamicObjectCollection("revisionentry");
            if (CollectionUtils.isEmpty((Collection)entryDys)) continue;
            for (DynamicObject entry : entryDys) {
                Date entBsed = entry.getDate("bsed_r");
                if (entBsed == null) continue;
                Long adjFileId = entry.getLong("salaryadjfile_r.boid");
                Long stdItemId = entry.getLong("standarditem_r.id");
                Date entBsled = entry.getDate("bsled_r") == null ? SWCDateTimeUtils.getMaxBsled() : entry.getDate("bsled_r");
                AdjFileMatchParam fileMatchParam = new AdjFileMatchParam();
                fileMatchParam.setAdjFileBoId(adjFileId);
                fileMatchParam.setBsed(entBsed);
                fileMatchParam.setBsled(entBsled);
                String unionId = DecAdjApprCreateGridHelper.combineStrings((String[])new String[]{String.valueOf(adjFileId), String.valueOf(stdItemId), SWCDateTimeUtils.format((Date)entBsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)entBsled, (String)"yyyy-MM-dd")});
                fileMatchParam.setUnionId(unionId);
                matchFileParams.add(fileMatchParam);
            }
        }
        Map adjfileMatchResultMap = this.adjFileApplicationService.batchMatchEffectiveAdjfileVersion(matchFileParams);
        boolean isFail = false;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entryDys = dataEntity.getDataEntity().getDynamicObjectCollection("revisionentry");
            if (CollectionUtils.isEmpty((Collection)entryDys)) continue;
            for (DynamicObject entry : entryDys) {
                Date entBsed = entry.getDate("bsed_r");
                if (entBsed == null) continue;
                Long adjFileId = entry.getLong("salaryadjfile_r.boid");
                Long stdItemId = entry.getLong("standarditem_r.id");
                Date entBsled = entry.getDate("bsled_r") == null ? SWCDateTimeUtils.getMaxBsled() : entry.getDate("bsled_r");
                String unionId = DecAdjApprCreateGridHelper.combineStrings((String[])new String[]{String.valueOf(adjFileId), String.valueOf(stdItemId), SWCDateTimeUtils.format((Date)entBsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)entBsled, (String)"yyyy-MM-dd")});
                logger.info("RevisionSaveValidator checkMatchAdjfileVersion unionId is {}", (Object)unionId);
                AdjfileMatchResult adjfileMatchResult = (AdjfileMatchResult)adjfileMatchResultMap.get(unionId);
                if (null == adjfileMatchResult) continue;
                DynamicObject adjfileVersion = adjfileMatchResult.getAdjfileVersion();
                if (null == adjfileVersion) {
                    logger.info("RevisionSaveValidator checkMatchAdjfileVersion AdjfileNotFoundError is {}", (Object)adjfileMatchResult.getAdjfileNotFoundErrorEnum().getLocaleName().loadKDString());
                    String errorMsg = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\uff08{0}\uff09\uff1a\u5f53\u524d\u6240\u9009\u751f\u6548\u65e5\u671f\u4e0b\uff0c\u5b9a\u8c03\u85aa\u6863\u6848\u5df2\u5931\u6548\uff0c\u4e0d\u53ef\u8fdb\u884c\u5b9a\u8c03\u85aa\uff0c\u8bf7\u8c03\u6574\u3002", (String)"RevisionSaveValidator_24", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entry.getString("standarditem_r.name")});
                    if (adjfileMatchResult.getAdjfileNotFoundErrorEnum() == AdjfileNotFoundErrorEnum.COVER_UNABLE_FILE) {
                        errorMsg = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\uff08{0}\uff09\uff1a\u5f53\u524d\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185\uff0c\u5b58\u5728\u5b9a\u8c03\u85aa\u6863\u6848\u5931\u6548\u4e0d\u53ef\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u5b9a\u8c03\u85aa\uff0c\u8bf7\u8c03\u6574\u3002", (String)"RevisionSaveValidator_25", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entry.getString("standarditem_r.name")});
                    }
                    this.addFatalErrorMessage(dataEntity, errorMsg);
                    isFail = true;
                    continue;
                }
                salaryAdjFileVersionSet.add(adjfileVersion.getLong("id"));
                entry.set("salaryadjfilevid_r", (Object)adjfileVersion);
                logger.info("RevisionSaveValidator checkMatchAdjfileVersion adjfileVersionId is {}", (Object)adjfileVersion.getLong("id"));
            }
        }
        return isFail;
    }

    private boolean validateEmpposorgrelAvailable(Map<Long, Boolean> checkResult, ExtendedDataEntity dataEntity, String errorMsg) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("revisionentry");
        boolean checkPass = true;
        for (DynamicObject entryDy : entryEntity) {
            long fileId = entryDy.getLong("salaryadjfilevid_r.id");
            String itemName = entryDy.getString("standarditem_r.name");
            if (checkResult.getOrDefault(fileId, Boolean.FALSE).booleanValue()) continue;
            checkPass = false;
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(errorMsg, itemName));
        }
        return checkPass;
    }

    private void checkCalcType(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("revisionentry");
        for (DynamicObject entryDy : entryEntity) {
            String adjType = entryDy.getString("salaryadjrsn_r.attributiontype");
            String calcType = entryDy.getString("calctype_r");
            int seq = entryDy.getInt("seq");
            if (!AdjAttributionType.ADJATTRTYPE.getCode().equals(adjType) || !Strings.isNullOrEmpty((String)calcType)) continue;
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff1a\u201c\u8c03\u85aa\u65b9\u5f0f\u201d\u3002", (String)"RevisionSaveValidator_17", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), seq);
            this.addFatalErrorMessage(dataEntity, errorMsg);
        }
    }

    private boolean validateBsledAndBsed(ExtendedDataEntity dataEntity, DynamicObjectCollection entryDys) {
        boolean fail = false;
        for (DynamicObject entryDy : entryDys) {
            Date mBsed = entryDy.getDate("bsed_r");
            Date mBsled = entryDy.getDate("bsled_r");
            if (!Objects.isNull(mBsed) && !Objects.isNull(mBsled) && mBsled.compareTo(mBsed) >= 0) continue;
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a\u8bf7\u586b\u5199\u6b63\u786e\u7684\u751f\u5931\u6548\u65e5\u671f\uff0c\u4e14\u751f\u6548\u65e5\u671f\u8981\u65e9\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"RevisionSaveValidator_01", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entryDy.getInt("seq")});
            this.addFatalErrorMessage(dataEntity, msg);
            fail = true;
        }
        return fail;
    }

    private void validateGradeAndRank(ExtendedDataEntity dataEntity, Map<Long, Map<Long, Boolean>> itemUseRankFlag) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("revisionentry");
        for (DynamicObject entryDy : entryEntity) {
            String adjType = entryDy.getString("salaryadjrsn_r.attributiontype");
            DynamicObject salaryStdDyObj = entryDy.getDynamicObject("salarystd_r");
            DynamicObject stdItemDyObj = entryDy.getDynamicObject("standarditem_r");
            String salaryToGradeAndRankRel = entryDy.getString("salargrel_r");
            String itemName = entryDy.getString("standarditem_r.name");
            String stdTableErrorMsg = ResManager.loadKDString((String)"{0}\u672a\u5339\u914d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u6dfb\u52a0\u3002", (String)"RevisionSaveValidator_13", (String)"swc-hcdm-opplugin", (Object[])new Object[]{itemName});
            if (stdItemDyObj != null && salaryStdDyObj != null && StringUtils.isEmpty((CharSequence)salaryToGradeAndRankRel)) {
                this.addFatalErrorMessage(dataEntity, stdTableErrorMsg);
                continue;
            }
            if (Objects.isNull(salaryStdDyObj)) continue;
            int seq = entryDy.getInt("seq");
            String isMatchGradeRank = entryDy.getString("ismatchgraderank");
            if (!SWCStringUtils.equals((String)"1", (String)isMatchGradeRank)) continue;
            DynamicObject gradeDyObj = entryDy.getDynamicObject("grade_r");
            DynamicObject rankDyObj = entryDy.getDynamicObject("rank_r");
            String calcType = entryDy.getString("calctype_r");
            boolean isUseRank = DecAdjRecordRevisionHelper.checkItemUseRank((DynamicObject)entryDy, itemUseRankFlag);
            String gradeErrorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff1a\u201c\u85aa\u7b49\u201d\u3002", (String)"RevisionSaveValidator_14", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), seq);
            String rankErrorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff1a\u201c\u85aa\u6863\u201d\u3002", (String)"RevisionSaveValidator_15", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), seq);
            if (!AdjAttributionType.DECATTRTYPE.getCode().equals(adjType) && (!AdjAttributionType.ADJATTRTYPE.getCode().equals(adjType) || !CalcType.GRADE_RANK.getCode().equals(calcType))) continue;
            if (gradeDyObj == null) {
                this.addFatalErrorMessage(dataEntity, gradeErrorMsg);
            }
            if (rankDyObj != null || !isUseRank) continue;
            this.addFatalErrorMessage(dataEntity, rankErrorMsg);
        }
    }

    private void checkAdminOrg(Set<Long> adminOrgSet, Map<Long, DynamicObject> decAdjPersonInfoMap, Map<String, List<DynamicObject>> influencedHisData, ExtendedDataEntity dataEntity) {
        if (CollectionUtils.isEmpty(influencedHisData)) {
            return;
        }
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("revisionentry");
        block0: for (DynamicObject entryDy : entryEntity) {
            long fileBoid = entryDy.getLong("salaryadjfile_r.boid");
            long itemId = entryDy.getLong("standarditem_r.id");
            String key = String.valueOf(fileBoid) + String.valueOf(itemId);
            List<DynamicObject> influencedHisDataList = influencedHisData.get(key);
            if (CollectionUtils.isEmpty(influencedHisDataList)) continue;
            logger.info("RevisionSaveValidator influencedHisDataList is not empty");
            for (DynamicObject influencedRecordData : influencedHisDataList) {
                DynamicObject decAdjPersonInfo;
                long relPersonId = influencedRecordData.getLong("relpersonid");
                logger.info("RevisionSaveValidator checkAdminOrg relPersonId is {}", (Object)relPersonId);
                if (relPersonId == 0L || CollectionUtils.isEmpty(decAdjPersonInfoMap) || !Objects.nonNull(decAdjPersonInfo = decAdjPersonInfoMap.get(relPersonId))) continue;
                logger.info("RevisionSaveValidator decAdjPersonInfo is not empty");
                long assoAdminOrgId = decAdjPersonInfo.getLong("assoadminorg.id");
                logger.info("RevisionSaveValidator assoAdminOrgId is {}", (Object)assoAdminOrgId);
                logger.info("RevisionSaveValidator adminOrgSet is {}", adminOrgSet);
                if (CollectionUtils.isEmpty(adminOrgSet) || adminOrgSet.contains(assoAdminOrgId)) continue;
                String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u6682\u65e0{2}\u884c\u653f\u7ec4\u7ec7\u7684\u6743\u9650\uff0c\u4e0d\u5141\u8bb8{3}\u3002", (String)"RevisionSaveValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entryDy.getString("personname_p"), entryDy.getString("empnumber_p"), decAdjPersonInfo.getString("assoadminorg.name"), this.getOperateName()});
                this.addFatalErrorMessage(dataEntity, msg);
                continue block0;
            }
        }
    }

    private String getOperateName() {
        String type = this.getOption().getVariableValue("type", "");
        if ("addnew".equals(type)) {
            return ResManager.loadKDString((String)"\u65b0\u589e", (String)"RevisionSaveValidator_07", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4fee\u6b63", (String)"RevisionSaveValidator_08", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
    }

    private void checkOnBoardOtherBillsForAdjFile(Map<Long, Set<String>> invalidAdjApprBillMap, Map<Long, List<DynamicObject>> invalidAdjRecordMap, Map<Long, Set<String>> invalidCandSetSalApplMap, ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("revisionentry");
        for (DynamicObject entryDy : entryEntity) {
            Date mBsed = entryDy.getDate("bsed_r");
            Date mBsled = entryDy.getDate("bsled_r");
            DynamicObject salaryAdjRsn = entryDy.getDynamicObject("salaryadjrsn_r");
            if (SWCObjectUtils.isEmpty((Object)salaryAdjRsn)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9a\u8c03\u85aa\u7c7b\u578b\u201d\u3002", (String)"RevisionSaveValidator_06", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, msg);
                continue;
            }
            DynamicObject thisRecord = entryDy.getDynamicObject("thisrecord");
            if (thisRecord != null && thisRecord.getDate("bsed").compareTo(mBsed) == 0 && thisRecord.getDate("bsled").compareTo(mBsled) == 0) continue;
            long depEmpId = entryDy.getLong("depemp_p.id");
            long fileBoid = entryDy.getLong("salaryadjfile_r.boid");
            HashSet invalidCandSetSalApplList = CollectionUtils.isEmpty(invalidCandSetSalApplMap) ? Sets.newHashSet() : invalidCandSetSalApplMap.get(depEmpId);
            HashSet invalidAdjApprBillList = CollectionUtils.isEmpty(invalidAdjApprBillMap) ? Sets.newHashSet() : invalidAdjApprBillMap.get(depEmpId);
            ArrayList invalidAdjRecordList = CollectionUtils.isEmpty(invalidAdjRecordMap) ? Lists.newArrayList() : invalidAdjRecordMap.get(fileBoid);
            String candApprErrorMsg = !CollectionUtils.isEmpty((Collection)invalidCandSetSalApplList) ? ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a{0}\uff09", (String)"RevisionSaveValidator_02", (String)"swc-hcdm-opplugin", (Object[])new Object[]{String.join((CharSequence)MultiLangHelper.getMultiLangCommaDelimiter(), invalidCandSetSalApplList)}) : "";
            String adjApprErrorMsg = !CollectionUtils.isEmpty((Collection)invalidAdjApprBillList) ? ResManager.loadKDString((String)"\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a{0}\uff09", (String)"RevisionSaveValidator_03", (String)"swc-hcdm-opplugin", (Object[])new Object[]{String.join((CharSequence)MultiLangHelper.getMultiLangCommaDelimiter(), invalidAdjApprBillList)}) : "";
            String adjRecordErrorMsg = !CollectionUtils.isEmpty((Collection)invalidAdjRecordList) ? ResManager.loadKDString((String)"\u521d\u59cb\u5316", (String)"RevisionSaveValidator_04", (String)"swc-hcdm-opplugin", (Object[])new Object[0]) : "";
            ArrayList allBillErrorMsgList = Lists.newArrayList();
            if (!Strings.isNullOrEmpty((String)candApprErrorMsg)) {
                allBillErrorMsgList.add(candApprErrorMsg);
            }
            if (!Strings.isNullOrEmpty((String)adjApprErrorMsg)) {
                allBillErrorMsgList.add(adjApprErrorMsg);
            }
            if (!Strings.isNullOrEmpty((String)adjRecordErrorMsg)) {
                allBillErrorMsgList.add(adjRecordErrorMsg);
            }
            if (allBillErrorMsgList.isEmpty()) continue;
            String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5b58\u5728\u6b63\u5728\u8fdb\u884c\u4e2d\u7684{2}\uff0c\u65e0\u6cd5\u8fdb\u884c\u5b9a\u8c03\u85aa\u6570\u636e{3}\u3002", (String)"RevisionSaveValidator_05", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entryDy.getString("personname_p"), entryDy.getString("empnumber_p"), String.join((CharSequence)"/", allBillErrorMsgList), this.getOperateName()});
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }

    private void checkOnBoardOtherBills(Map<String, List<String>> invalidAdjApprBillMap, Map<String, List<String>> invalidAdjRecordMap, Map<String, List<String>> invalidCandSetSalApplMap, ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("revisionentry");
        for (DynamicObject entryDy : entryEntity) {
            Date mBsed = entryDy.getDate("bsed_r");
            Date mBsled = entryDy.getDate("bsled_r");
            DynamicObject salaryAdjRsn = entryDy.getDynamicObject("salaryadjrsn_r");
            if (SWCObjectUtils.isEmpty((Object)salaryAdjRsn)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9a\u8c03\u85aa\u7c7b\u578b\u201d\u3002", (String)"RevisionSaveValidator_06", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, msg);
                continue;
            }
            DynamicObject thisRecord = entryDy.getDynamicObject("thisrecord");
            if (thisRecord != null && thisRecord.getDate("bsed").compareTo(mBsed) == 0 && thisRecord.getDate("bsled").compareTo(mBsled) == 0) continue;
            long depEmpId = entryDy.getLong("depemp_p.id");
            long itemId = entryDy.getLong("standarditem_r.id");
            String key = String.valueOf(depEmpId) + String.valueOf(itemId);
            ArrayList invalidCandSetSalApplList = CollectionUtils.isEmpty(invalidCandSetSalApplMap) ? Lists.newArrayList() : invalidCandSetSalApplMap.get(key);
            ArrayList invalidAdjApprBillList = CollectionUtils.isEmpty(invalidAdjApprBillMap) ? Lists.newArrayList() : invalidAdjApprBillMap.get(key);
            ArrayList invalidAdjRecordList = CollectionUtils.isEmpty(invalidAdjRecordMap) ? Lists.newArrayList() : invalidAdjRecordMap.get(key);
            String candApprErrorMsg = !CollectionUtils.isEmpty((Collection)invalidCandSetSalApplList) ? ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a{0}\uff09", (String)"RevisionSaveValidator_02", (String)"swc-hcdm-opplugin", (Object[])new Object[]{String.join((CharSequence)MultiLangHelper.getMultiLangCommaDelimiter(), invalidCandSetSalApplList)}) : "";
            String adjApprErrorMsg = !CollectionUtils.isEmpty((Collection)invalidAdjApprBillList) ? ResManager.loadKDString((String)"\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a{0}\uff09", (String)"RevisionSaveValidator_03", (String)"swc-hcdm-opplugin", (Object[])new Object[]{String.join((CharSequence)MultiLangHelper.getMultiLangCommaDelimiter(), invalidAdjApprBillList)}) : "";
            String adjRecordErrorMsg = !CollectionUtils.isEmpty((Collection)invalidAdjRecordList) ? ResManager.loadKDString((String)"\u521d\u59cb\u5316", (String)"RevisionSaveValidator_04", (String)"swc-hcdm-opplugin", (Object[])new Object[0]) : "";
            ArrayList allBillErrorMsgList = Lists.newArrayList();
            if (!Strings.isNullOrEmpty((String)candApprErrorMsg)) {
                allBillErrorMsgList.add(candApprErrorMsg);
            }
            if (!Strings.isNullOrEmpty((String)adjApprErrorMsg)) {
                allBillErrorMsgList.add(adjApprErrorMsg);
            }
            if (!Strings.isNullOrEmpty((String)adjRecordErrorMsg)) {
                allBillErrorMsgList.add(adjRecordErrorMsg);
            }
            if (allBillErrorMsgList.isEmpty()) continue;
            String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5b58\u5728\u6b63\u5728\u8fdb\u884c\u4e2d\u7684{2}\uff0c\u65e0\u6cd5\u8fdb\u884c\u5b9a\u8c03\u85aa\u6570\u636e{3}\u3002", (String)"RevisionSaveValidator_05", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entryDy.getString("personname_p"), entryDy.getString("empnumber_p"), String.join((CharSequence)"/", allBillErrorMsgList), this.getOperateName()});
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }

    private boolean validateStandardItemAndStdScm(ExtendedDataEntity dataEntity, Map<Long, DynamicObject> stdScmMap) {
        boolean validateDateFlag = false;
        DynamicObjectCollection entryDys = dataEntity.getDataEntity().getDynamicObjectCollection("revisionentry");
        if (CollectionUtils.isEmpty((Collection)entryDys)) {
            return validateDateFlag;
        }
        for (DynamicObject entryDy : entryDys) {
            Set salaryStructureDyIds;
            Long stdScmVid = entryDy.getLong("stdscm_p.id");
            Long stdItemId = entryDy.getLong("standarditem_r.id");
            long salaryStructureId = entryDy.getLong("salaystructure_p.id");
            DynamicObject stdScmDy = stdScmMap.get(stdScmVid);
            if (!Objects.nonNull(stdScmDy)) continue;
            DynamicObjectCollection salaryStructureDys = stdScmDy.getDynamicObjectCollection("salaystructure");
            if (!CollectionUtils.isEmpty((Collection)salaryStructureDys) && !(salaryStructureDyIds = salaryStructureDys.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet())).contains(salaryStructureId)) {
                String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a{1}\u85aa\u916c\u4f53\u7cfb\u4e2d\u672a\u5305\u542b{2}\uff0c\u5bfc\u81f4\u65e0\u6cd5\u5339\u914d\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u5148\u5728\u85aa\u916c\u4f53\u7cfb\u4e2d\u8bbe\u7f6e\u3002", (String)"RevisionSaveValidator_21", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entryDy.getInt("seq"), stdScmDy.getString("name"), entryDy.getString("salaystructure_p.name")});
                this.addFatalErrorMessage(dataEntity, msg);
                validateDateFlag = true;
                continue;
            }
            DynamicObjectCollection entryEntity = stdScmDy.getDynamicObjectCollection("entryentity");
            Set standardItemIdSet = entryEntity.stream().filter(entry -> entry.getLong("salstructurent.id") == salaryStructureId).map(dy -> dy.getLong("standarditem.id")).collect(Collectors.toSet());
            if (standardItemIdSet.contains(stdItemId)) continue;
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a{1}\u85aa\u916c\u4f53\u7cfb\u4e2d\u672a\u5305\u542b{2}\uff0c\u5bfc\u81f4\u65e0\u6cd5\u5339\u914d\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u5148\u5728\u85aa\u916c\u7ed3\u6784\u548c\u85aa\u916c\u4f53\u7cfb\u4e2d\u8bbe\u7f6e\u3002", (String)"RevisionSaveValidator_19", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entryDy.getInt("seq"), stdScmDy.getString("name"), entryDy.getString("standarditem_r.name")});
            this.addFatalErrorMessage(dataEntity, msg);
            validateDateFlag = true;
        }
        return validateDateFlag;
    }

    private boolean validateSalaryAdjRsnType(ExtendedDataEntity dataEntity) {
        boolean validateDateFlag = false;
        DynamicObjectCollection entryDys = dataEntity.getDataEntity().getDynamicObjectCollection("revisionentry");
        if (CollectionUtils.isEmpty((Collection)entryDys)) {
            return validateDateFlag;
        }
        ArrayList decTypeRowIndexList = Lists.newArrayListWithExpectedSize((int)entryDys.size());
        ArrayList adjTypeRowIndexList = Lists.newArrayListWithExpectedSize((int)entryDys.size());
        for (DynamicObject entryDy : entryDys) {
            String salaryAdjRsnType = entryDy.getString("salaryadjrsn_r.attributiontype");
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(salaryAdjRsnType)) {
                decTypeRowIndexList.add(String.valueOf(entryDy.getInt("seq")));
                continue;
            }
            if (!AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryAdjRsnType)) continue;
            adjTypeRowIndexList.add(String.valueOf(entryDy.getInt("seq")));
        }
        if (!CollectionUtils.isEmpty((Collection)decTypeRowIndexList) && !CollectionUtils.isEmpty((Collection)adjTypeRowIndexList)) {
            String msg = ResManager.loadKDString((String)"\u540c\u4e00\u6b21\u65b0\u589e\u9700\u4f7f\u7528\u76f8\u540c\u7684\u5b9a\u8c03\u85aa\u7c7b\u578b\uff08\u7b2c{0}\u884c\u4e3a\u5b9a\u85aa\uff0c\u7b2c{1}\u884c\u4e3a\u8c03\u85aa\uff09\u3002", (String)"RevisionSaveValidator_18", (String)"swc-hcdm-opplugin", (Object[])new Object[]{String.join((CharSequence)MultiLangHelper.getMultiLangSlightDelimiter(), decTypeRowIndexList), String.join((CharSequence)MultiLangHelper.getMultiLangSlightDelimiter(), adjTypeRowIndexList)});
            this.addFatalErrorMessage(dataEntity, msg);
            validateDateFlag = true;
        }
        return validateDateFlag;
    }

    private boolean validateEffectiveDate(ExtendedDataEntity dataEntity) {
        boolean validateDateFlag = false;
        DynamicObjectCollection entryDys = dataEntity.getDataEntity().getDynamicObjectCollection("revisionentry");
        if (CollectionUtils.isEmpty((Collection)entryDys)) {
            return validateDateFlag;
        }
        String salaryAdjRsnType = ((DynamicObject)entryDys.get(0)).getString("salaryadjrsn_r.attributiontype");
        Set dbAdjFileIdSet = entryDys.stream().map(item -> item.getDynamicObject("salaryadjfile_r").getLong("id")).collect(Collectors.toSet());
        Map maxBsedOfFile = null;
        Map maxBsedOfFileForAdjBill = null;
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(salaryAdjRsnType)) {
            maxBsedOfFile = this.adjFileApplicationService.getMaxBsedOfRecordForDecType(dbAdjFileIdSet);
        } else if (AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryAdjRsnType)) {
            Map<Long, Set<Long>> fileItemIdMap = RevisionSaveValidator.getFileItemMapFromEntry(entryDys);
            maxBsedOfFileForAdjBill = this.adjFileApplicationService.getMaxBsedOfRecordForAdjType(fileItemIdMap);
        }
        for (DynamicObject entry : entryDys) {
            Map adjFileToItemMaxDateEntityMap;
            Date entBsed = entry.getDate("bsed_r");
            if (entBsed == null) continue;
            Long adjFileId = entry.getLong("salaryadjfile_r.id");
            Long stdItemId = entry.getLong("standarditem_r.id");
            String number = entry.getString("empnumber_p");
            Date maxBsed = null;
            if (maxBsedOfFile != null && AdjAttributionType.DECATTRTYPE.getCode().equals(salaryAdjRsnType)) {
                maxBsed = (Date)maxBsedOfFile.get(adjFileId);
            } else if (maxBsedOfFileForAdjBill != null && AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryAdjRsnType) && (adjFileToItemMaxDateEntityMap = (Map)maxBsedOfFileForAdjBill.get(adjFileId)) != null) {
                maxBsed = (Date)adjFileToItemMaxDateEntityMap.get(stdItemId);
            }
            if (maxBsed == null) continue;
            Integer seq = entry.getInt("seq");
            logger.info("entry row seq={}, salaryAdjRsnType={}, adjFileId={}, stdItemId={}, entBsed={}, maxBsed={}", new Object[]{seq, salaryAdjRsnType, adjFileId, stdItemId, entBsed, maxBsed});
            StringBuilder errorMsg = new StringBuilder();
            if (entBsed.compareTo(maxBsed) > 0) continue;
            String formatEntBsed = HRInteDateTimeUtil.formatDate((String)"hcdm_salaryadjrecord", (String)"bsed", (Date)entBsed);
            String formatMaxBsed = HRInteDateTimeUtil.formatDate((String)"hcdm_salaryadjrecord", (String)"bsed", (Date)maxBsed);
            errorMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u5de5\u53f7\uff08{0}\uff09\uff1a\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08{1}\uff09\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u6b21\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08{2}\uff09\u3002", (String)"RevisionSaveValidator_11", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), number, formatEntBsed, formatMaxBsed));
            this.addFatalErrorMessage(dataEntity, errorMsg.toString());
            validateDateFlag = true;
        }
        return validateDateFlag;
    }

    private static Map<Long, Set<Long>> getFileItemMapFromEntry(DynamicObjectCollection entryDys) {
        HashMap<Long, Set<Long>> fileToItemMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject entryDy : entryDys) {
            long fileId = entryDy.getLong("salaryadjfile_r.id");
            long itemId = entryDy.getLong("standarditem_r.id");
            if (fileId <= 0L) continue;
            Set itemIdList = fileToItemMap.computeIfAbsent(fileId, value -> Sets.newHashSet());
            if (itemId <= 0L) continue;
            itemIdList.add(itemId);
        }
        return fileToItemMap;
    }

    private boolean validateAdjFileStatus(Map<Long, DynamicObject> adjFileMap, ExtendedDataEntity dataEntity, String errorMsg) {
        boolean fail = false;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection entryDys = dynamicObject.getDynamicObjectCollection("revisionentry");
        for (DynamicObject entryDy : entryDys) {
            long adjFileBoid = entryDy.getLong("salaryadjfile_r.id");
            DynamicObject adjFileDy = adjFileMap.get(adjFileBoid);
            if (adjFileDy == null || "C".equals(adjFileDy.getString("status")) || "D".equals(adjFileDy.getString("status"))) continue;
            this.addFatalErrorMessage(dataEntity, errorMsg);
            fail = true;
            break;
        }
        return fail;
    }
}

