/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.salaryadjfile;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprBillSynService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.enums.SubmitType;
import kd.swc.hcdm.business.adjapprscm.AdjApprscmHelper;
import kd.swc.hcdm.common.entity.adjapprbill.AdjApprBillOpEntity;
import kd.swc.hcdm.common.enums.ConfirmStatusEnum;
import kd.swc.hcdm.common.enums.DecAdjSynStatusEnum;
import kd.swc.hcdm.common.enums.SynOperationEnum;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.AdjApprovalSaveValidator;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.DecAdjCommonValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.opplugin.web.SWCCoreBaseBillOp;
import org.apache.commons.collections4.CollectionUtils;

public class AdjApprovalOp
extends SWCCoreBaseBillOp {
    private static Log logger = LogFactory.getLog(AdjApprovalOp.class);
    public static final String RE_CALCRATE_CONFIRMED = "re_calcrate_confirmed";
    private AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("auditstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("bsed");
        fieldKeys.add("salaryadjrsn");
        fieldKeys.add("effectivedate");
        fieldKeys.add("adjcurrency");
        fieldKeys.add("approvalbillid");
        fieldKeys.add("submittype");
        fieldKeys.add("exctable");
        fieldKeys.add("exchangeratedate");
        fieldKeys.add("currency");
        fieldKeys.add("totalamount");
        fieldKeys.add("totalperson");
        fieldKeys.add("billname");
        fieldKeys.add("billno");
        fieldKeys.add("exchangeratedate");
        fieldKeys.add("salaryadjscm");
        fieldKeys.add("auditdate");
        fieldKeys.add("isdraft");
        fieldKeys.add("adjfieldcfg");
        fieldKeys.add("creator");
        fieldKeys.add("adjapprdetailentry");
        fieldKeys.add("adjapprdetailent");
        fieldKeys.add("country");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new DecAdjCommonValidator());
        args.addValidator((AbstractValidator)new AdjApprovalSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String operationKey;
        switch (operationKey = args.getOperationKey()) {
            case "donothing_submiteffect": {
                this.setSubmitEffectFlag(args);
                break;
            }
            case "unsubmit": {
                this.setUnSubmit(args);
                break;
            }
            case "save": 
            case "submit": {
                this.reCalcWithLatestRate(args.getDataEntities());
                break;
            }
        }
    }

    private void reCalcWithLatestRate(DynamicObject[] dataEntities) {
        Map variables = this.getOption().getVariables();
        if ("true".equals(variables.get(RE_CALCRATE_CONFIRMED))) {
            for (DynamicObject dataEntity : dataEntities) {
                DecAdjApprGridHelper.calcWithLatestRate((DynamicObject)dataEntity);
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey;
        DynamicObject[] dataEntities = args.getDataEntities();
        switch (operationKey = args.getOperationKey()) {
            case "save": {
                for (DynamicObject dataEntity : dataEntities) {
                    dataEntity.set("isdraft", (Object)Boolean.FALSE);
                }
                break;
            }
            case "delete": {
                List adjApprBillIds = Arrays.stream(dataEntities).map(item -> item.getLong("id")).collect(Collectors.toList());
                DecAdjApprGridHelper.deleteAdjApprPerson(adjApprBillIds);
                break;
            }
            case "donothing_wfauditing": {
                this.wfAuditing(args);
                break;
            }
            case "donothing_wfauditpass": {
                this.wfAuditPass(args);
                break;
            }
            case "donothing_wfauditnotpass": {
                this.wfAuditNotPass(args);
                break;
            }
            case "donothing_wfrejecttosubmit": {
                this.wfRejectToSubmit(args);
                break;
            }
            case "donothing_wfreject": {
                this.wfReJect(args);
                break;
            }
            case "donothing_wfsubmit": {
                this.wfSubmit(args);
                break;
            }
            case "donothing_submiteffect": {
                for (DynamicObject dataEntity : dataEntities) {
                    dataEntity.set("isdraft", (Object)Boolean.FALSE);
                }
                this.wfAuditPass(args);
                break;
            }
        }
    }

    private void wfSubmit(BeginOperationTransactionArgs args) {
        AdjApprBillOpEntity adjApprBillOpEntity = this.getAdjApprBillOpEntity(args.getDataEntities());
        List adjDataEntities = adjApprBillOpEntity.getAdjDataEntities();
        List decDataEntities = adjApprBillOpEntity.getDecDataEntities();
        if (CollectionUtils.isNotEmpty((Collection)adjDataEntities)) {
            this.wfUpdateStatus(adjDataEntities.toArray(new DynamicObject[0]), "B", "B");
        }
        if (CollectionUtils.isNotEmpty((Collection)decDataEntities)) {
            this.wfUpdateStatus(decDataEntities.toArray(new DynamicObject[0]), "B", "B");
        }
    }

    private void wfAuditing(BeginOperationTransactionArgs args) {
        AdjApprBillOpEntity adjApprBillOpEntity = this.getAdjApprBillOpEntity(args.getDataEntities());
        List adjDataEntities = adjApprBillOpEntity.getAdjDataEntities();
        List decDataEntities = adjApprBillOpEntity.getDecDataEntities();
        if (CollectionUtils.isNotEmpty((Collection)adjDataEntities)) {
            this.wfUpdateStatus(adjDataEntities.toArray(new DynamicObject[0]), "B", "D");
        }
        if (CollectionUtils.isNotEmpty((Collection)decDataEntities)) {
            this.wfUpdateStatus(decDataEntities.toArray(new DynamicObject[0]), "B", "D");
        }
    }

    private void wfAuditPass(BeginOperationTransactionArgs args) {
        AdjApprBillOpEntity adjApprBillOpEntity = this.getAdjApprBillOpEntity(args.getDataEntities());
        List adjDataEntities = adjApprBillOpEntity.getAdjDataEntities();
        List decDataEntities = adjApprBillOpEntity.getDecDataEntities();
        logger.info("go in to the wfAuditPass");
        try (TXHandle tx = TX.required();){
            try {
                if (CollectionUtils.isNotEmpty((Collection)adjDataEntities)) {
                    this.adjDoSomeThingAfterWfPass(adjDataEntities.toArray(new DynamicObject[0]));
                }
                if (CollectionUtils.isNotEmpty((Collection)decDataEntities)) {
                    this.wfUpdateStatus(decDataEntities.toArray(new DynamicObject[0]), "C", "C");
                    this.wfUpdateAdjApprPerSynStatus(decDataEntities.toArray(new DynamicObject[0]), ConfirmStatusEnum.HAS_CONFIRM, DecAdjSynStatusEnum.TO_SYNC);
                }
            }
            catch (Exception ex) {
                tx.markRollback();
                throw ex;
            }
        }
    }

    private AdjApprBillOpEntity getAdjApprBillOpEntity(DynamicObject[] dataEntities) {
        List decDataEntities = Arrays.stream(dataEntities).filter(item -> !item.getDynamicObject("salaryadjrsn").getString("attributiontype").equals(AdjAttributionType.ADJATTRTYPE.getCode())).collect(Collectors.toList());
        List adjDataEntities = Arrays.stream(dataEntities).filter(item -> item.getDynamicObject("salaryadjrsn").getString("attributiontype").equals(AdjAttributionType.ADJATTRTYPE.getCode())).collect(Collectors.toList());
        AdjApprBillOpEntity adjApprBillOpEntity = new AdjApprBillOpEntity();
        adjApprBillOpEntity.setDecDataEntities(decDataEntities);
        adjApprBillOpEntity.setAdjDataEntities(adjDataEntities);
        return adjApprBillOpEntity;
    }

    private void adjDoSomeThingAfterWfPass(DynamicObject[] adjDataEntities) {
        Date date = new Date();
        HashSet salaryadjscmVid = Sets.newHashSetWithExpectedSize((int)adjDataEntities.length);
        for (DynamicObject dataEntity : adjDataEntities) {
            Long sourcevid = dataEntity.getLong("salaryadjscm.sourcevid");
            salaryadjscmVid.add(sourcevid);
        }
        Map boidApprScmMap = AdjApprscmHelper.queryAdjApprScmByIds((Set)salaryadjscmVid);
        for (DynamicObject dataEntity : adjDataEntities) {
            dataEntity.set("auditdate", (Object)date);
            logger.info(MessageFormat.format("date is[{0}], set after auditdate[{1}]", date, dataEntity.getDate("auditdate")));
            Long boId = dataEntity.getLong("salaryadjscm.id");
            dataEntity.set("salaryadjscm", boidApprScmMap.get(boId));
        }
        this.wfUpdateStatus(adjDataEntities, "C", "C");
        this.wfUpdateAdjApprPerSynStatus(adjDataEntities, ConfirmStatusEnum.HAS_CONFIRM, DecAdjSynStatusEnum.TO_SYNC);
        this.tryCreateAdjConfirmInfo(adjDataEntities);
    }

    private void wfUpdateAdjApprPerSynStatus(DynamicObject[] dataEntities, ConfirmStatusEnum confirmStatus, DecAdjSynStatusEnum decAdjSynStatus) {
        ArrayList<Long> adjApprBillIdList = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject billEntity : dataEntities) {
            if (billEntity.getBoolean("salaryadjscm.enableconfirm") && billEntity.getString("salaryadjscm.datasyncondition").equals("2")) continue;
            Long adjApprBillId = billEntity.getLong("id");
            adjApprBillIdList.add(adjApprBillId);
        }
        if (CollectionUtils.isNotEmpty(adjApprBillIdList)) {
            this.adjApprovalApplicationService.updateAdjApprPerStatus(confirmStatus, decAdjSynStatus, adjApprBillIdList, null);
        }
    }

    private void tryCreateAdjConfirmInfo(DynamicObject[] billEntities) {
        List billIds = Arrays.stream(billEntities).map(object -> object.getLong("id")).collect(Collectors.toList());
        SWCThreadPoolFactory.getAsyncPushThreadpool().execute(() -> this.adjApprovalApplicationService.createAdjConfirmPerson(billIds));
    }

    private void wfAuditNotPass(BeginOperationTransactionArgs args) {
        AdjApprBillOpEntity adjApprBillOpEntity = this.getAdjApprBillOpEntity(args.getDataEntities());
        List adjDataEntities = adjApprBillOpEntity.getAdjDataEntities();
        List decDataEntities = adjApprBillOpEntity.getDecDataEntities();
        if (CollectionUtils.isNotEmpty((Collection)adjDataEntities)) {
            this.adjDoSomeThingAfterAuditNoPass(adjDataEntities.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)decDataEntities)) {
            this.wfUpdateStatus(decDataEntities.toArray(new DynamicObject[0]), "A", "E");
        }
    }

    private void adjDoSomeThingAfterAuditNoPass(DynamicObject[] dataEntities) {
        HashSet salaryadjscmVid = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Long sourcevid = dataEntity.getLong("salaryadjscm.sourcevid");
            salaryadjscmVid.add(sourcevid);
        }
        Map boidApprScmMap = AdjApprscmHelper.queryAdjApprScmByIds((Set)salaryadjscmVid);
        for (DynamicObject dataEntity : dataEntities) {
            Long boid = dataEntity.getLong("salaryadjscm.id");
            dataEntity.set("salaryadjscm", boidApprScmMap.get(boid));
        }
        this.wfUpdateStatus(dataEntities, "A", "E");
    }

    private void wfRejectToSubmit(BeginOperationTransactionArgs args) {
        AdjApprBillOpEntity adjApprBillOpEntity = this.getAdjApprBillOpEntity(args.getDataEntities());
        List adjDataEntities = adjApprBillOpEntity.getAdjDataEntities();
        List decDataEntities = adjApprBillOpEntity.getDecDataEntities();
        if (CollectionUtils.isNotEmpty((Collection)adjDataEntities)) {
            this.wfUpdateStatus(adjDataEntities.toArray(new DynamicObject[0]), "A", "G");
        }
        if (CollectionUtils.isNotEmpty((Collection)decDataEntities)) {
            this.wfUpdateStatus(decDataEntities.toArray(new DynamicObject[0]), "A", "G");
        }
    }

    private void wfReJect(BeginOperationTransactionArgs args) {
        AdjApprBillOpEntity adjApprBillOpEntity = this.getAdjApprBillOpEntity(args.getDataEntities());
        List adjDataEntities = adjApprBillOpEntity.getAdjDataEntities();
        List decDataEntities = adjApprBillOpEntity.getDecDataEntities();
        if (CollectionUtils.isNotEmpty((Collection)adjDataEntities)) {
            this.wfUpdateStatus(adjDataEntities.toArray(new DynamicObject[0]), "B", "D");
        }
        if (CollectionUtils.isNotEmpty((Collection)decDataEntities)) {
            this.wfUpdateStatus(decDataEntities.toArray(new DynamicObject[0]), "B", "D");
        }
    }

    private void wfUpdateStatus(DynamicObject[] dataEntities, String auditstatus, String billstatus) {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("auditstatus", (Object)auditstatus);
            dataEntity.set("billstatus", (Object)billstatus);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjapprbill");
        helper.update(dataEntities);
    }

    private void setSubmitEffectFlag(BeforeOperationArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            dataEntity.set("submittype", (Object)SubmitType.SUBMIT_EFFECT.getCode());
        }
    }

    private void setUnSubmit(BeforeOperationArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            String billStatus = dataEntity.getString("billstatus");
            if (!"B".equals(billStatus)) continue;
            dataEntity.set("billstatus", (Object)"A");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String operationKey;
        switch (operationKey = args.getOperationKey()) {
            case "donothing_wfauditpass": 
            case "donothing_submiteffect": {
                DynamicObject[] dataEntities = args.getDataEntities();
                DecAdjApprBillSynService decAdjApprBillSynService = new DecAdjApprBillSynService();
                decAdjApprBillSynService.asynDecAdjApprBillPersonDatas(dataEntities, SynOperationEnum.getCodeByOperationCode((String)operationKey));
                break;
            }
        }
    }
}

