/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.salaryadjfile;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salaryadjfile.AdjFilePersonHelper;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartEnum;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.AdjFileDeleteValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class AdjFileDeleteOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(AdjFileDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("number");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new AdjFileDeleteValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            long id = dataEntity.getLong("id");
            idSet.add(id);
        }
        SalaryAdjFilePartEnum[] values = SalaryAdjFilePartEnum.values();
        QFilter[] filters = new QFilter[]{new QFilter("salaryadjfile.id", "in", idSet)};
        logger.info("SalaryAdjFile is ready to delete all parts");
        for (SalaryAdjFilePartEnum value : values) {
            if (value == SalaryAdjFilePartEnum.baseInfo) continue;
            logger.info("{} begin to delete", (Object)value.getNameParam().loadKDString());
            String entityId = value.getEntityId();
            SWCDataServiceHelper helper = new SWCDataServiceHelper(entityId);
            int delNum = helper.deleteByFilter(filters);
            logger.info("{} is deleted,count is {}", (Object)value.getNameParam().loadKDString(), (Object)delNum);
        }
        this.syncAdjFilePerson(args.getDataEntities());
    }

    private void syncAdjFilePerson(DynamicObject[] dataEntities) {
        Set adjFileIdSet = Arrays.stream(dataEntities).map(o1 -> o1.getLong("id")).collect(Collectors.toSet());
        AdjFilePersonHelper.syncAdjFilePerson(adjFileIdSet);
    }
}

