/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.salaryadjfile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountQueryParam;
import kd.swc.hcdm.business.adjapprbill.AdjBillEntryImpHelper;
import kd.swc.hcdm.business.adjapprbill.AdjPersonPackageHelper;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.CalculateUtils;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.entity.adjapprbill.AddFileReturnData;
import kd.swc.hcdm.common.enums.CalcSceneType;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.DecAdjSaveDraftValidator;
import kd.swc.hsbp.opplugin.web.SWCCoreBaseBillOp;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DecAdjEntrySaveDraftOp
extends SWCCoreBaseBillOp {
    private static Log logger = LogFactory.getLog(DecAdjEntrySaveDraftOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        String invokeType = this.getOption().getVariableValue("invokeType", "");
        logger.info("DecAdjSaveDraftOp.onAddValidators invokeType:{}", (Object)invokeType);
        if (!StringUtils.isNotBlank((CharSequence)invokeType) || !invokeType.equals("excelImport")) {
            args.addValidator((AbstractValidator)new DecAdjSaveDraftValidator());
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs ex) {
        long startTime = System.currentTimeMillis();
        String invokeType = this.getOption().getVariableValue("invokeType", "");
        String dyncolname = this.getOption().getVariableValue("dyncolname", "");
        Set colNameSet = (Set)SerializationUtils.deSerializeFromBase64((String)dyncolname);
        Object[] personDynams = ex.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])personDynams)) {
            return;
        }
        Long billId = personDynams[0].getLong("adjapprbill");
        logger.info("DecAdjSaveDraftOp.setLastAdjInfo billId is:{0},personNumber is:{1}", (Object)billId, (Object)personDynams.length);
        DynamicObject adjBillObj = AdjBillEntryImpHelper.queryAdjBillById((Long)billId);
        logger.info("AdjBillEntryImpHelper.queryAdjBillById use time:{}", (Object)(System.currentTimeMillis() - startTime));
        if (ObjectUtils.isEmpty((Object)adjBillObj)) {
            logger.info("DecAdjSaveDraftOp.beforeExecuteOperationTransaction adjBillObj is null");
            return;
        }
        startTime = System.currentTimeMillis();
        logger.info("setExtItemFromPanel use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        this.setDefaultData(adjBillObj, (DynamicObject[])personDynams);
        logger.info("setDefaultData use time:{}", (Object)(System.currentTimeMillis() - startTime));
        String salaryadjrsnType = adjBillObj.getString("salaryadjrsn.attributiontype");
        if (AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryadjrsnType)) {
            if (StringUtils.isNotBlank((CharSequence)invokeType) && invokeType.equals("excelImport")) {
                startTime = System.currentTimeMillis();
                HashSet<StdAmountQueryParam> salaryStdAmountParams = new HashSet<StdAmountQueryParam>(10);
                EntityType entityType = (EntityType)personDynams[0].getDynamicObjectCollection("entryentity").getDynamicObjectType();
                Map apprBillEntryPropertyMap = DecAdjApprCreateGridHelper.getApprBillEntryPropertyMap((EntityType)entityType);
                Set entryPropertySet = apprBillEntryPropertyMap.keySet();
                List<Object> adjApprPersonList = Arrays.asList(personDynams);
                Map matchStdResult = DecAdjApprGridHelper.getMatchStdResult(adjApprPersonList, null);
                BillExRateManager rateManager = new BillExRateManager();
                long tableCurrency = adjBillObj.getLong("currency.id");
                long exctableId = adjBillObj.getLong("exctable.id");
                Date rateDate = adjBillObj.getDate("exchangeratedate");
                HashMap<Long, Set> fileItemSetMap = new HashMap<Long, Set>(personDynams.length);
                for (Object personObj : personDynams) {
                    DynamicObjectCollection personEntryCollect = personObj.getDynamicObjectCollection("entryentity");
                    Set subSet = fileItemSetMap.computeIfAbsent(personObj.getLong("adjfile.id"), key -> new HashSet(personEntryCollect.size()));
                    personEntryCollect.stream().forEach(obj -> subSet.add(obj.getLong("standarditem.id")));
                }
                Map lastAdjInfo = AdjBillEntryImpHelper.getLastAdjInfo(fileItemSetMap);
                for (Object personObj : personDynams) {
                    Long adjFileId = personObj.getLong("adjfile.id");
                    DynamicObjectCollection entryCollect = personObj.getDynamicObjectCollection("entryentity");
                    if (ObjectUtils.isEmpty((Object)entryCollect)) continue;
                    Map matMap = null;
                    if (!MapUtils.isEmpty((Map)lastAdjInfo)) {
                        matMap = (Map)lastAdjInfo.get(adjFileId);
                    }
                    for (DynamicObject entryObj : entryCollect) {
                        String calcType = entryObj.getString("calctype");
                        if (!MapUtils.isEmpty((Map)matMap)) {
                            this.setLastAdjInfo(entryObj, matMap);
                        }
                        if (CalcType.GRADE_RANK.getCode().equals(calcType)) {
                            this.doSetGradeAndRank(matchStdResult, adjFileId, entryObj);
                            Long standardItemId = entryObj.getLong("standarditem.id");
                            Object gradeObj = entryObj.get("grade");
                            Long gradeId = gradeObj instanceof Long ? (Long)gradeObj : (Objects.isNull(gradeObj) ? 0L : ((DynamicObject)gradeObj).getLong("id"));
                            Object rankObj = entryObj.get("rank");
                            Long rankId = rankObj instanceof Long ? (Long)rankObj : (Objects.isNull(rankObj) ? 0L : ((DynamicObject)rankObj).getLong("id"));
                            Long salaryStdId = entryObj.getLong("salarystd.id");
                            if (standardItemId == 0L || salaryStdId == 0L || gradeId == 0L) continue;
                            String unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId);
                            StdAmountQueryParam stdAmountQueryParam = AdjPersonPackageHelper.buildStdAmountQueryParam((Long)gradeId, (Long)rankId, (Long)salaryStdId, (Long)standardItemId, (String)unionId);
                            salaryStdAmountParams.add(stdAmountQueryParam);
                            continue;
                        }
                        CalculateUtils.calAdjAmount((long)tableCurrency, (long)exctableId, (Date)rateDate, (DynamicObject)entryObj, (BillExRateManager)rateManager);
                    }
                }
                logger.info("getStdAmountQueryResult params is={}", (Object)JSON.toJSONString(salaryStdAmountParams));
                SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
                List salaryStdAmountQueryResult = salaryStdApplicationService.queryAmountAndSalaryCount(new ArrayList(salaryStdAmountParams));
                logger.info("getStdAmountQueryResult result is={}", (Object)JSON.toJSONString((Object)salaryStdAmountQueryResult));
                Map salaryCountQueryResultMap = salaryStdAmountQueryResult.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity(), (key1, key2) -> key1));
                logger.info("setStdAmountRelationInfo salaryCountQueryResultMap result is={}", (Object)JSON.toJSONString(salaryCountQueryResultMap));
                Map salaryCountAmountMatchResultMap = CalculateUtils.getSalaryCountAmountMatchResultMap((long)exctableId, (Date)rateDate, adjApprPersonList, (BillExRateManager)rateManager);
                for (Object personObj : personDynams) {
                    Long adjFileId = personObj.getLong("adjfile.id");
                    DynamicObjectCollection adjApprPersonEntry = personObj.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entryObj : adjApprPersonEntry) {
                        String calcType = entryObj.getString("calctype");
                        if (CalcType.GRADE_RANK.getCode().equals(calcType)) {
                            BigDecimal amount = entryObj.getBigDecimal("amount");
                            if (Objects.isNull(amount)) {
                                AdjPersonPackageHelper.doSetStdAmountRelationInfo(entryPropertySet, salaryCountQueryResultMap, (Long)adjFileId, (DynamicObject)entryObj);
                                AdjPersonPackageHelper.doSetFinalAmountRelationInfo(entryPropertySet, (long)exctableId, (Date)rateDate, (BillExRateManager)rateManager, (DynamicObject)entryObj);
                            } else {
                                AdjPersonPackageHelper.doSetExchangeRateInfo(entryPropertySet, (long)exctableId, (Date)rateDate, (BillExRateManager)rateManager, (DynamicObject)entryObj);
                                this.calAmountLogic(entryObj, amount);
                            }
                            AdjPersonPackageHelper.doSetActualAmountOrRatio(entryPropertySet, (long)exctableId, (Date)rateDate, (DynamicObject)entryObj);
                            AdjPersonPackageHelper.doSetSalaryPercentAndSeepRateInfo(entryPropertySet, (long)exctableId, (Date)rateDate, (BillExRateManager)rateManager, salaryCountQueryResultMap, (Long)adjFileId, (DynamicObject)entryObj);
                            continue;
                        }
                        CalculateUtils.doSetAdjCalcFieldAfter((long)exctableId, (Date)rateDate, entryPropertySet, (BillExRateManager)rateManager, (Map)salaryCountAmountMatchResultMap, (long)adjFileId, (DynamicObject)entryObj);
                    }
                }
                AdjPersonPackageHelper.setOverStandardType(adjApprPersonList, entryPropertySet, (String)salaryadjrsnType, (long)exctableId, (Date)rateDate);
                AdjPersonPackageHelper.setGradeAndRankByStdScmMatchStrategy((Map)matchStdResult, adjApprPersonList, entryPropertySet, (CalcSceneType)CalcSceneType.EXCEL_IMPORT_ADD);
            }
        } else if (StringUtils.isNotBlank((CharSequence)invokeType) && invokeType.equals("excelImport")) {
            long tableExctable = adjBillObj.getLong("exctable.id");
            Date tableRateDate = adjBillObj.getDate("exchangeratedate");
            List adjApprPersonList = Arrays.stream(personDynams).collect(Collectors.toList());
            startTime = System.currentTimeMillis();
            Map matchStdResult = DecAdjApprGridHelper.getMatchStdResult(adjApprPersonList, null);
            logger.info("DecAdjApprGridHelper.getMatchStdResult use time:{}", (Object)(System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            AdjPersonPackageHelper.setExchangeRateInfo(adjApprPersonList, (Set)colNameSet, (long)tableExctable, (Date)tableRateDate);
            logger.info("AdjPersonPackageHelper.setExchangeRateInfo use time:{}", (Object)(System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            AdjPersonPackageHelper.setOverStandardType(adjApprPersonList, (Set)colNameSet, (String)salaryadjrsnType, (long)tableExctable, (Date)tableRateDate);
            logger.info("AdjPersonPackageHelper.setOverStandardType use time:{}", (Object)(System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            CalculateUtils.setCalcFieldAfter((long)tableExctable, (Date)tableRateDate, (Set)colNameSet, adjApprPersonList, null);
            logger.info("AdjPersonPackageHelper.setCalcFieldAfter use time:{}", (Object)(System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            CalculateUtils.setGradeAndRankByStdScmMatchStrategy((Map)matchStdResult, adjApprPersonList, (Set)colNameSet);
            logger.info("AdjPersonPackageHelper.setGradeAndRankByStdScmMatchStrategy use time:{}", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void doSetGradeAndRank(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, Long adjFileId, DynamicObject entryObj) {
        String isMatchGradeRank = entryObj.getString("ismatchgraderank");
        String matchStrategy = entryObj.getString("matchstrategy");
        if (MapUtils.isNotEmpty(matchStdResult.get(adjFileId)) && !"1".equals(isMatchGradeRank) && StringUtils.isNotEmpty((CharSequence)matchStrategy)) {
            Long standardItemId = entryObj.getLong("standarditem.id");
            SalaryStdMatchResultNew salaryStdMatchResult = matchStdResult.get(adjFileId).get(standardItemId);
            Long gradeId = salaryStdMatchResult.getGradeId();
            Long rankId = salaryStdMatchResult.getRankId();
            entryObj.set("grade", (Object)gradeId);
            entryObj.set("rank", (Object)rankId);
        }
    }

    private void calAmountLogic(DynamicObject entryObj, BigDecimal amount) {
        int currencyScale = entryObj.getInt("currency.amtprecision");
        BigDecimal exrateValue = entryObj.getBigDecimal("exratevalue");
        boolean quoteType = entryObj.getBoolean("quotetype");
        if (exrateValue != null && exrateValue.compareTo(BigDecimal.ZERO) != 0) {
            if (quoteType) {
                BigDecimal logicAmount = amount.multiply(exrateValue).setScale(currencyScale, 4);
                entryObj.set("amountlogic", (Object)logicAmount);
            } else {
                BigDecimal logicAmount = amount.divide(exrateValue, currencyScale, 4);
                entryObj.set("amountlogic", (Object)logicAmount);
            }
        } else {
            entryObj.set("amountlogic", (Object)amount);
        }
    }

    public void setLastAdjInfo(DynamicObject entryObj, Map<Long, DynamicObject> matMap) {
        long stdItemId = entryObj.getLong("standarditem.id");
        DynamicObject lastInfo = matMap.get(stdItemId);
        if (ObjectUtils.isEmpty((Object)lastInfo)) {
            return;
        }
        entryObj.set("presalarystd", (Object)lastInfo.getDynamicObject("salarystd"));
        entryObj.set("pregrade", (Object)lastInfo.getDynamicObject("grade"));
        entryObj.set("prerank", (Object)lastInfo.getDynamicObject("rank"));
        entryObj.set("precurrency", (Object)lastInfo.getDynamicObject("currency"));
        entryObj.set("presalary", (Object)lastInfo.getBigDecimal("amount"));
        entryObj.set("prefrequency", (Object)lastInfo.getDynamicObject("frequency"));
        entryObj.set("presalarypercent", (Object)lastInfo.getBigDecimal("salarypercent"));
        entryObj.set("presalaryseeprate", (Object)lastInfo.getBigDecimal("salaryseeprate"));
        entryObj.set("preamountstdrange", (Object)lastInfo.getString("amountstdrange"));
    }

    private void setDefaultData(DynamicObject adjBillObj, DynamicObject[] personDynams) {
        Long salayStrucId;
        if (ObjectUtils.isEmpty((Object)adjBillObj) || ArrayUtils.isEmpty((Object[])personDynams)) {
            return;
        }
        DynamicObject tableCurrency = adjBillObj.getDynamicObject("currency");
        Date effectivedate = adjBillObj.getDate("effectivedate");
        HashMap<Long, Map> paramMap = new HashMap<Long, Map>(16);
        for (DynamicObject person : personDynams) {
            DynamicObject adjFile = person.getDynamicObject("adjFile");
            Long adjFileId = adjFile.getLong("id");
            Long stdScmVId = this.getStdScmVId(person, adjFile);
            salayStrucId = adjFile.getLong("salaystructure.id");
            Map idStcIdMap = paramMap.computeIfAbsent(adjFileId, value -> Maps.newHashMap());
            Set salayStrucIdSet = idStcIdMap.computeIfAbsent(stdScmVId, value -> Sets.newHashSet());
            salayStrucIdSet.add(salayStrucId);
        }
        List addFileReturnDataList = DecAdjApprGridHelper.getStdScmEntryDataByAdjFileData(paramMap);
        Map<String, AddFileReturnData> fileDataMap = addFileReturnDataList.stream().collect(Collectors.toMap(item -> item.getAdjFileId() + "_" + item.getSalayStructureId() + "_" + item.getStandardItemId(), item -> item));
        for (DynamicObject person : personDynams) {
            Long adjFileId = person.getLong("adjfile.id");
            salayStrucId = person.getLong("salarystructure.id");
            DynamicObjectCollection entryCollection = person.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryObj : entryCollection) {
                AddFileReturnData addFileReturnData;
                Long itemId = entryObj.getLong("standarditem.id");
                AddFileReturnData addFileReturnData2 = addFileReturnData = fileDataMap == null ? null : fileDataMap.get(adjFileId + "_" + salayStrucId + "_" + itemId);
                if (addFileReturnData != null) {
                    entryObj.set("excesscontrol", (Object)addFileReturnData.getExcessControl());
                    entryObj.set("ismatchgraderank", (Object)addFileReturnData.getisMatchGradeRank());
                    entryObj.set("matchstrategy", (Object)addFileReturnData.getMatchStrategy());
                }
                if (ObjectUtils.isEmpty((Object)entryObj.get("currency"))) {
                    entryObj.set("currency", (Object)tableCurrency);
                }
                if (!ObjectUtils.isEmpty((Object)entryObj.get("salbsed"))) continue;
                entryObj.set("salbsed", (Object)effectivedate);
            }
        }
    }

    private Long getStdScmVId(DynamicObject person, DynamicObject adjFile) {
        Long stdScmVId = person.getLong("stdscm.id");
        if (stdScmVId <= 0L && ObjectUtils.isNotEmpty((Object)adjFile.get("stdscm")) && ((DynamicObject)adjFile.get("stdscm")).getDataEntityType().getProperties().containsKey((Object)"sourcevid")) {
            stdScmVId = adjFile.getLong("stdscm.sourcevid");
        }
        return stdScmVId;
    }
}

