/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.salaryadjfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.api.HisDiscardApiBo;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.service.AdjFileDomainService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFilePersonHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncFacade;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.SalaryAjdFileAbandonValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.opplugin.web.SWCCoreBaseBillOp;
import org.apache.commons.collections.CollectionUtils;

public class SalaryAdjFileAbandonOp
extends SWCCoreBaseBillOp {
    private static Log logger = LogFactory.getLog(SalaryAdjFileAbandonOp.class);
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private AdjFileDomainService adjFileDomainService = (AdjFileDomainService)DomainFactory.getInstance(AdjFileDomainService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("person.number");
        fieldKeys.add("person.name");
        fieldKeys.add("person.id");
        fieldKeys.add("person.personindexid");
        fieldKeys.add("person.name");
        fieldKeys.add("boid");
        fieldKeys.add("status");
        fieldKeys.add("employee.empnumber");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new SalaryAjdFileAbandonValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        long startTime = System.currentTimeMillis();
        for (DynamicObject data : dataEntities = args.getDataEntities()) {
            data.set("status", (Object)"E");
        }
        Set fileIds = Arrays.stream(dataEntities).map(object -> object.getLong("id")).collect(Collectors.toSet());
        Set fileBOIDs = Arrays.stream(dataEntities).map(object -> object.getLong("boid")).collect(Collectors.toSet());
        Set itemBOIds = this.adjFileApplicationService.getAllItemBOId(fileIds);
        ArrayList eventDynList = new ArrayList(10);
        String eventId = this.getOption().getVariableValue("abandonEventId", null);
        HisModelController hisModelController = new HisModelController();
        try (TXHandle txHandle = TX.required();){
            logger.info("SalaryAdjFileAbandonOp.beginOperationTransaction: begin to deal with adjFileInfo.");
            HisDiscardApiBo hisDiscardApiBo = new HisDiscardApiBo();
            hisDiscardApiBo.setBoIdSet(fileBOIDs);
            hisDiscardApiBo.setEntityNumber("hcdm_adjfileinfo");
            hisModelController.discardBoData(hisDiscardApiBo);
            if (CollectionUtils.isNotEmpty((Collection)itemBOIds)) {
                logger.info("SalaryAdjFileAbandonOp.beginOperationTransaction: begin to deal with record.");
                DynamicObject eventDyn = this.adjFileDomainService.queryByEvent(eventId);
                Long eventPkId = 0L;
                if (null == eventDyn) {
                    eventPkId = this.adjFileApplicationService.genEventDyn(eventId, eventDynList, EventTypeEnum.ADJFILE_ABANDON.getCode(), "0");
                    if (CollectionUtils.isNotEmpty(eventDynList)) {
                        this.adjFileDomainService.saveDecAdjEvent(eventDynList);
                    }
                } else {
                    eventPkId = eventDyn.getLong("id");
                }
                HisDiscardApiBo salRecordHisDiscardApiBo = new HisDiscardApiBo();
                salRecordHisDiscardApiBo.setBoIdSet(itemBOIds);
                salRecordHisDiscardApiBo.setEntityNumber("hcdm_salaryadjrecord");
                salRecordHisDiscardApiBo.setEventId(eventPkId);
                hisModelController.discardBoData(salRecordHisDiscardApiBo);
                SalaryAdjSyncFacade.generateSyncDataFromAbandonBoId((Object)eventPkId, (Collection)itemBOIds);
            }
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("SalaryAdjFileAbandonOp.beginOperationTransaction: it takes {} milliseconds.", (Object)costTime);
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        long startTime = System.currentTimeMillis();
        DynamicObject[] dataEntities = args.getDataEntities();
        Set<Long> adjFileIdSet = Arrays.stream(dataEntities).map(object -> object.getLong("boid")).collect(Collectors.toSet());
        AdjFilePersonHelper.syncAdjFilePerson(adjFileIdSet);
        Set itemBOIds = this.adjFileApplicationService.getAllItemBOId(adjFileIdSet);
        this.updateStatusAbandoned(adjFileIdSet, "hcdm_adjfileinfo");
        if (CollectionUtils.isNotEmpty((Collection)itemBOIds)) {
            this.updateStatusAbandoned(itemBOIds, "hcdm_salaryadjrecord");
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("SalaryAdjFileAbandonOp.endOperationTransaction: it takes {} milliseconds.", (Object)costTime);
        List pIds = Arrays.stream(args.getDataEntities()).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        AdjFileCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    private void updateStatusAbandoned(Set<Long> boIds, String entityId) {
        DynamicObject[] dyObjs;
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityId);
        QFilter boFilter = new QFilter("boid", "in", boIds);
        for (DynamicObject dynamicObject : dyObjs = serviceHelper.query("status", new QFilter[]{boFilter})) {
            dynamicObject.set("status", (Object)"E");
        }
        serviceHelper.save(dyObjs);
    }
}

