/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.salaryadjfile;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFilePersonHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.AdjFileCertValidator;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.AdjFileCommonValidator;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.SalaryAdjFileAgainEffectValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCCoreBaseBillOp;

public class SalaryAdjFileAgainEffectOp
extends SWCCoreBaseBillOp {
    private static Log logger = LogFactory.getLog(SalaryAdjFileAgainEffectOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bsled");
        fieldKeys.add("bsed");
        fieldKeys.add("status");
        fieldKeys.add("number");
        fieldKeys.add("boid");
        fieldKeys.add("id");
        fieldKeys.add("person.name");
        fieldKeys.add("employee.empnumber");
        fieldKeys.add("enable");
        fieldKeys.add("person.id");
        fieldKeys.add("empposorgrel");
        fieldKeys.add("empposorgrel.id");
        fieldKeys.add("stdscm.id");
        fieldKeys.add("stdscm.firstbsed");
        fieldKeys.add("depemp.id");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new AdjFileCommonValidator());
        args.addValidator((AbstractValidator)new SalaryAdjFileAgainEffectValidator());
        args.addValidator((AbstractValidator)new AdjFileCertValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dys = args.getDataEntities();
        if (dys == null || dys.length < 1) {
            return;
        }
        Date newBsed = this.getNewBsed();
        Set fileBOIds = Arrays.stream(dys).map(object -> object.getLong("boid")).collect(Collectors.toSet());
        Set fileIds = Arrays.stream(dys).map(object -> object.getLong("id")).collect(Collectors.toSet());
        if (Objects.nonNull(newBsed)) {
            try (TXHandle txHandle = TX.required();){
                SalaryAdjFileServiceHelper.enableToHis((String)"hcdm_adjfileinfo", fileBOIds, (Date)newBsed, (boolean)false);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        Set adjFileIdSet = Arrays.stream(dataEntities).map(object -> object.getLong("id")).collect(Collectors.toSet());
        AdjFilePersonHelper.syncAdjFilePerson(adjFileIdSet);
        Date newBsed = this.getNewBsed();
        if (Objects.nonNull(newBsed)) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjfileinfo");
            for (DynamicObject dy2 : dataEntities) {
                Date now = SWCDateTimeUtils.getTodayDateWithoutTime();
                if (newBsed.compareTo(now) > 0) continue;
                dy2.set("status", (Object)"C");
            }
            serviceHelper.save(dataEntities);
        }
        List pIds = Arrays.stream(args.getDataEntities()).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        AdjFileCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    private Date getNewBsed() {
        Map variables = this.getOption().getVariables();
        String bsedValue = (String)variables.get("var_bsed");
        Date newBsed = null;
        try {
            if (SWCStringUtils.isNotEmpty((String)bsedValue)) {
                newBsed = SWCDateTimeUtils.parseDate((String)bsedValue);
            }
        }
        catch (ParseException e1) {
            newBsed = null;
            logger.error("\u586b\u5199\u7684\u751f\u6548\u65e5\u671f\u8f6c\u6362\u51fa\u9519,\u83b7\u53d6\u5230\u7684\u5b57\u7b26\u4e32\u503c\u4e3a{}", (Object)bsedValue);
            logger.error("\u9519\u8bef\u4fe1\u606f\u4e3a{}", (Object)e1.getMessage());
        }
        return newBsed;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String showWarningTip = this.getOption().getVariableValue("showWarningTip", null);
        String preMsg = ResManager.loadKDString((String)"\u751f\u6548\u6210\u529f\u3002", (String)"SalaryAdjFileAgainEffectOp_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        if (showWarningTip != null) {
            this.getOperationResult().setMessage(preMsg + showWarningTip);
        } else {
            this.getOperationResult().setMessage(preMsg);
        }
        this.getOperationResult().setShowMessage(true);
    }
}

