/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.salaryadjfile;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFilePersonHelper;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.AdjFileCertValidator;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.AdjFileCommonValidator;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryAdjFileEffectOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bsled");
        fieldKeys.add("status");
        fieldKeys.add("person");
        fieldKeys.add("person.id");
        fieldKeys.add("empposorgrel");
        fieldKeys.add("empposorgrel.id");
        fieldKeys.add("number");
        fieldKeys.add("stdscm.id");
        fieldKeys.add("stdscm.firstbsed");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new AdjFileCommonValidator());
        args.addValidator((AbstractValidator)new AdjFileCertValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        Set idSet = Arrays.asList(dataEntities).stream().map(object -> object.getLong("id")).collect(Collectors.toSet());
        AdjFilePersonHelper.syncAdjFilePerson(idSet);
        List pIds = Arrays.stream(args.getDataEntities()).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        AdjFileCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String showWarningTip = this.getOption().getVariableValue("showWarningTip", null);
        String preMsg = ResManager.loadKDString((String)"\u751f\u6548\u6210\u529f\u3002", (String)"SalaryAdjFileEffectOp_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        if (SWCStringUtils.equals((String)args.getOperationKey(), (String)"audit")) {
            preMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"SalaryAdjFileEffectOp_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        }
        DynamicObject[] dataEntities = args.getDataEntities();
        if (showWarningTip != null) {
            this.getOperationResult().setMessage(preMsg + showWarningTip + "adjfilecertwarn");
        } else if (dataEntities.length == 1) {
            this.getOperationResult().setMessage(preMsg);
        }
        this.getOperationResult().setShowMessage(true);
    }
}

