/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.salaryadjfile;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.service.AdjFileDomainService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFilePersonHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncFacade;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.SalaryAdjFileUnableValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCCoreBaseBillOp;
import org.apache.commons.collections.CollectionUtils;

public class SalaryAdjFileUnableOp
extends SWCCoreBaseBillOp {
    private static Log logger = LogFactory.getLog(SalaryAdjFileUnableOp.class);
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private AdjFileDomainService adjFileDomainService = (AdjFileDomainService)DomainFactory.getInstance(AdjFileDomainService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bsled");
        fieldKeys.add("bsed");
        fieldKeys.add("vid");
        fieldKeys.add("status");
        fieldKeys.add("number");
        fieldKeys.add("sourcevid");
        fieldKeys.add("boid");
        fieldKeys.add("id");
        fieldKeys.add("bred");
        fieldKeys.add("person.name");
        fieldKeys.add("employee.empnumber");
        fieldKeys.add("person.personindexid");
        fieldKeys.add("person.id");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new SalaryAdjFileUnableValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        long startTime = System.currentTimeMillis();
        DynamicObject[] dys = args.getDataEntities();
        if (dys == null || dys.length < 1) {
            return;
        }
        Date newBsled = this.getNewBsled();
        Set setBrledBOIds = Arrays.stream(dys).map(object -> object.getLong("boid")).collect(Collectors.toSet());
        Set fileIds = Arrays.stream(dys).map(object -> object.getLong("id")).collect(Collectors.toSet());
        Set itemBOIds = this.adjFileApplicationService.getAllItemBOId(fileIds);
        ArrayList eventDynList = new ArrayList(10);
        String event = this.getOption().getVariableValue("unableEventId", null);
        try (TXHandle txHandle = TX.required();){
            SalaryAdjFileServiceHelper.enableToHis((String)"hcdm_adjfileinfo", setBrledBOIds, (Date)newBsled, (boolean)true);
            if (CollectionUtils.isNotEmpty((Collection)itemBOIds)) {
                DynamicObject eventDyn = this.adjFileDomainService.queryByEvent(event);
                Long eventPkId = 0L;
                if (null == eventDyn) {
                    eventPkId = this.adjFileApplicationService.genEventDyn(event, eventDynList, EventTypeEnum.ADJFILE_UNABLE.getCode(), "0");
                    if (CollectionUtils.isNotEmpty(eventDynList)) {
                        this.adjFileDomainService.saveDecAdjEvent(eventDynList);
                    }
                } else {
                    eventPkId = eventDyn.getLong("id");
                }
                SalaryAdjFileServiceHelper.enableToHis((String)"hcdm_salaryadjrecord", (Set)itemBOIds, (Date)newBsled, (boolean)true, (Long)eventPkId);
                SalaryAdjSyncFacade.generateSyncDataFromExpireBoId((Object)eventPkId, (Collection)itemBOIds, (Date)newBsled);
            }
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("SalaryAdjFileUnableOp.beginOperationTransaction: it takes {} milliseconds.", (Object)costTime);
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        long startTime = System.currentTimeMillis();
        Date newBsled = this.getNewBsled();
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        for (DynamicObject dy2 : dataEntities) {
            Date now;
            Date bsed = dy2.getDate("bsed");
            if (newBsled == null || newBsled.compareTo(bsed) < 0 || newBsled.compareTo(now = SWCDateTimeUtils.getTodayDateWithoutTime()) > 0) continue;
            dy2.set("status", (Object)"D");
        }
        serviceHelper.save(dataEntities);
        Set adjFileIdSet = Arrays.stream(dataEntities).map(object -> object.getLong("id")).collect(Collectors.toSet());
        AdjFilePersonHelper.syncAdjFilePerson(adjFileIdSet);
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("SalaryAdjFileUnableOp.endOperationTransaction: it takes {} milliseconds before expiring and abandon data.", (Object)costTime);
        costTime = System.currentTimeMillis() - startTime;
        logger.info("SalaryAdjFileUnableOp.endOperationTransaction: it takes {} milliseconds after expiring and abandon data.", (Object)costTime);
        List pIds = Arrays.stream(args.getDataEntities()).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        AdjFileCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    private Date getNewBsled() {
        Map variables = this.getOption().getVariables();
        String bsledValue = (String)variables.get("var_bsled");
        Date newBsled = null;
        try {
            if (SWCStringUtils.isNotEmpty((String)bsledValue)) {
                newBsled = SWCDateTimeUtils.parseDate((String)bsledValue);
            }
        }
        catch (ParseException e1) {
            newBsled = null;
            logger.error("\u586b\u5199\u7684\u5931\u6548\u65e5\u671f\u8f6c\u6362\u51fa\u9519,\u83b7\u53d6\u5230\u7684\u5b57\u7b26\u4e32\u503c\u4e3a {}", (Object)bsledValue);
            logger.error("\u9519\u8bef\u4fe1\u606f\u4e3a{}", (Object)e1.getMessage());
        }
        return newBsled;
    }
}

