/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hcdm.business.SalaryStandardSerializationUtils;
import kd.swc.hcdm.common.entity.Pair;
import kd.swc.hcdm.opplugin.validator.EntityRelationLink;

public class BaseDataRefValidator
extends AbstractValidator {
    private BasedataEntityType entityType;
    private OperateOption option;
    private boolean draftValidReference;

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.draftValidReference = false;
        this.entityType = (BasedataEntityType)this.getValidateContext().getBillEntityType();
        this.option = this.getOption();
    }

    public void validate() {
        HashMap<Object, ExtendedDataEntity> objMap = new HashMap<Object, ExtendedDataEntity>(16);
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        for (int i = 0; i < dataEntities.length; ++i) {
            ExtendedDataEntity dataObj = dataEntities[i];
            Object idValue = dataObj.getBillPkId();
            objMap.put(idValue, dataObj);
        }
        if (!objMap.isEmpty()) {
            BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
            this.addIgnoreRefEntityIds(checker);
            checker.setDraftValidReference(this.draftValidReference);
            Map checkResult = checker.checkRef(this.entityType, objMap.keySet().toArray());
            for (Map.Entry entry : checkResult.entrySet()) {
                String msg;
                if (!((BaseDataCheckRefrenceResult)entry.getValue()).isRefence()) continue;
                ExtendedDataEntity dataObj = (ExtendedDataEntity)objMap.get(entry.getKey());
                BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
                MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
                IDataEntityProperty property = null;
                String fieldName = refrenceResult.getRefenceKey().getRefCol();
                for (IDataEntityProperty tempProp : refMainType.getAllFields().values()) {
                    if (tempProp instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)tempProp.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                        property = tempProp;
                        fieldName = property.getDisplayName().toString();
                        break;
                    }
                    if (!(tempProp instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)tempProp.getAlias())) continue;
                    property = tempProp;
                    fieldName = property.getDisplayName().toString();
                    break;
                }
                Pair<String, List<Long>> targetRelationData = this.queryEntityPkByRelation(refrenceResult, property, entry.getKey());
                DynamicObject[] refDataSet = this.queryByPkId((String)targetRelationData.getKey(), (List)targetRelationData.getValue());
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)targetRelationData.getKey()));
                String numberProp = null;
                if (dataEntityType instanceof BasedataEntityType) {
                    numberProp = ((BasedataEntityType)dataEntityType).getNumberProperty();
                } else if (dataEntityType instanceof BillEntityType) {
                    numberProp = ((BillEntityType)dataEntityType).getBillNo();
                }
                if (numberProp != null && dataEntityType.getProperty(numberProp) != null && !dataEntityType.getProperty(numberProp).isDbIgnore()) {
                    StringJoiner joiner = new StringJoiner("\u3001");
                    for (DynamicObject dynamicObject : refDataSet) {
                        joiner.add(dynamicObject.getString(numberProp));
                    }
                    msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab%1$s\uff1a\u201c%2$s\u201d\u7684\u5b57\u6bb5\u201c%3$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\uff0c\u7f16\u7801\u4e3a \u201c%4$s\u201d\u3002", (String)"BaseDataRefValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), this.getOperationName(), dataEntityType.getDisplayName().toString(), fieldName, joiner.toString());
                } else {
                    msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab%1$s\uff1a\u201c%2$s\u201d\u7684\u5b57\u6bb5\u201c%3$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"BaseDataRefValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), this.getOperationName(), dataEntityType.getDisplayName().toString(), fieldName);
                }
                this.addErrorMessage(dataObj, msg);
            }
        }
    }

    private DynamicObject[] queryByPkId(String entity, List<Long> pkIds) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])pkIds.toArray(new Object[0]), (DynamicObjectType)dataEntityType);
        return load;
    }

    private Pair<String, List<Long>> queryEntityPkByRelation(BaseDataCheckRefrenceResult reference, IDataEntityProperty property, Object key) {
        EntityRelationLink.EntityRelationNode before;
        EntityRelationLink entityRelationLink;
        LinkedList<EntityRelationLink.EntityRelationNode> tempLink;
        Object[] pks = new Object[]{key};
        BaseDataRefenceKey referenceKey = reference.getRefenceKey();
        String entityName = referenceKey.getRefEntityKey();
        List<Long> query = (List<Long>)DB.query((DBRoute)DBRoute.of((String)referenceKey.getRefDBRouteKey()), (String)String.format("select distinct fid from %s where %s in (%s) ", referenceKey.getRefTable(), referenceKey.getRefCol(), StringUtils.join((Object[])pks, (String)",")), rs -> {
            ArrayList<Long> entityNumbers = new ArrayList<Long>(16);
            while (rs.next()) {
                entityNumbers.add(rs.getLong("fid"));
            }
            return entityNumbers;
        });
        RefObject opValue = new RefObject();
        EntityRelationLink relationLink = new EntityRelationLink();
        relationLink.relate(referenceKey.getRefEntityKey(), null, null);
        LinkedList<EntityRelationLink.EntityRelationNode> link = relationLink.getLink(referenceKey.getRefEntityKey());
        if (this.option.tryGetVariableValue("enityrelationlink", opValue) && StringUtils.isNotEmpty((CharSequence)((CharSequence)opValue.getValue())) && (tempLink = (entityRelationLink = (EntityRelationLink)SalaryStandardSerializationUtils.fromJsonString((String)((String)opValue.getValue()), EntityRelationLink.class)).getLink(referenceKey.getRefEntityKey())) != null) {
            link = tempLink;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)(before = link.pop()).getEntityId(), (CharSequence)referenceKey.getRefEntityKey()) && link.size() >= 1) {
            EntityRelationLink.EntityRelationNode after = null;
            while (!link.isEmpty()) {
                after = link.pop();
                BasedataEntityType beforeDataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)before.getEntityId());
                String tableName = beforeDataEntityType.getAlias();
                RefObject fieldName = new RefObject((Object)beforeDataEntityType.getProperty(before.getRefFileName()).getAlias());
                DynamicProperty tempProp = beforeDataEntityType.getProperty(before.getRefFileName());
                if (tempProp.getParent() instanceof EntryType) {
                    EntryType entryType = (EntryType)tempProp.getParent();
                    tableName = entryType.getAlias();
                }
                if (tempProp instanceof MulBasedataProp) {
                    MulBasedataProp mulbaseProp = (MulBasedataProp)tempProp;
                    tableName = mulbaseProp.getDynamicCollectionItemPropertyType().getAlias();
                    fieldName.setValue((Object)"fbasedataid");
                }
                query = this.queryRefBaseDataField(query, beforeDataEntityType, tableName, (RefObject<String>)fieldName);
                entityName = after.getEntityId();
                before = after;
            }
        }
        return new Pair((Object)entityName, (Object)query);
    }

    private List<Long> queryRefBaseDataField(List<Long> query, BasedataEntityType currentEntityType, String currentTable, RefObject<String> refFieldName) {
        return (List)DB.query((DBRoute)DBRoute.of((String)currentEntityType.getDBRouteKey()), (String)String.format("select distinct %s from %s where fid in (%s)", refFieldName, currentTable, StringUtils.join((Object[])query.toArray(), (String)",")), rs -> {
            ArrayList<Long> pkList = new ArrayList<Long>(16);
            while (rs.next()) {
                pkList.add(rs.getLong((String)refFieldName.getValue()));
            }
            return pkList;
        });
    }

    private void addIgnoreRefEntityIds(BaseDataCheckRefrence checker) {
        String entityId;
        int i;
        String[] entityIds;
        RefObject opValue = new RefObject();
        if (this.option.tryGetVariableValue("ignorerefentityids", opValue) && StringUtils.isNotEmpty((CharSequence)((CharSequence)opValue.getValue()))) {
            entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",");
            for (i = 0; i < entityIds.length; ++i) {
                entityId = entityIds[i];
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getIgnoreRefEntityIds().add(entityId);
            }
        }
        if (this.option.tryGetVariableValue("checkrefentityids", opValue = new RefObject()) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",");
            for (i = 0; i < entityIds.length; ++i) {
                entityId = entityIds[i];
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getCheckRefEntityIds().add(entityId);
            }
        }
    }
}

