/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class CustomDataScopeValidator
extends AbstractValidator {
    private final String appId;
    private final String entityName;
    private final String permissionStatus;
    private final String orgViewType;
    private Function<ExtendedDataEntity, Long> idGenFunc;
    private Function<ExtendedDataEntity, String> msgGenFunc;

    public CustomDataScopeValidator(String appId, String entityName, String permissionStatus, String orgViewType) {
        this.appId = appId;
        this.entityName = entityName;
        this.permissionStatus = permissionStatus;
        this.orgViewType = orgViewType;
    }

    public CustomDataScopeValidator ofIdGenFunc(Function<ExtendedDataEntity, Long> idGenFunc) {
        this.idGenFunc = idGenFunc;
        return this;
    }

    public CustomDataScopeValidator ofMsgGenFunc(Function<ExtendedDataEntity, String> msgGenFunc) {
        this.msgGenFunc = msgGenFunc;
        return this;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.idGenFunc = this.idGenFunc == null ? data -> data.getDataEntity().getLong("id") : this.idGenFunc;
        Set ids = Arrays.stream(dataEntities).map(data -> this.idGenFunc.apply((ExtendedDataEntity)data)).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", ids);
        List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)this.appId, (String)this.entityName, (String)this.permissionStatus);
        if (permissionFilter != null) {
            for (QFilter authFilter : permissionFilter) {
                filter.and(authFilter);
            }
        } else {
            filter.and(new QFilter("1", "!=", (Object)1));
        }
        HasPermOrgResult permOrgRes = SWCPermissionServiceHelper.getPermOrgs((String)this.orgViewType, (String)this.appId, (String)this.entityName, (String)this.permissionStatus);
        if (!permOrgRes.hasAllOrgPerm()) {
            List hasPermOrg = permOrgRes.getHasPermOrgs();
            QFilter qFilter = new QFilter("org", "in", (Object)hasPermOrg);
            filter.and(qFilter);
        }
        String msg = this.msgGenFunc == null ? ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6570\u636e\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"CustomDataScopeValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]) : null;
        this.msgGenFunc = this.msgGenFunc == null ? entity -> msg : this.msgGenFunc;
        SWCDataServiceHelper helper = new SWCDataServiceHelper(this.entityName);
        Object[] hasPermIds = helper.queryOriginalArray("id", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])hasPermIds)) {
            for (ExtendedDataEntity entity2 : dataEntities) {
                this.addFatalErrorMessage(entity2, this.msgGenFunc.apply(entity2));
            }
        } else {
            Set id = Arrays.stream(hasPermIds).map(object -> object.getLong("id")).collect(Collectors.toSet());
            for (ExtendedDataEntity entity3 : dataEntities) {
                if (id.contains(this.idGenFunc.apply(entity3))) continue;
                this.addFatalErrorMessage(entity3, this.msgGenFunc.apply(entity3));
            }
        }
    }
}

