/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;

public class EntityRelationLink
implements Serializable {
    private static final long serialVersionUID = 8201244451260062001L;
    private Map<String, LinkedList<EntityRelationNode>> relationMap = new HashMap<String, LinkedList<EntityRelationNode>>();

    public Map<String, LinkedList<EntityRelationNode>> getRelationMap() {
        return this.relationMap;
    }

    public void setRelationMap(Map<String, LinkedList<EntityRelationNode>> relationMap) {
        this.relationMap = relationMap;
    }

    public LinkedList<EntityRelationNode> getLink(String sourceEntity) {
        return this.relationMap.get(sourceEntity);
    }

    public EntityRelationNode relate(String sourceEntity, String refFileName, String refTarget) {
        LinkedList<EntityRelationNode> link = this.relationMap.get(sourceEntity);
        if (link == null) {
            link = this.initLink(sourceEntity);
        }
        if (StringUtils.isNotEmpty((CharSequence)refFileName)) {
            EntityRelationNode node = new EntityRelationNode();
            node.setEntityId(refTarget);
            link.getLast().setRefFileName(refFileName);
            link.add(node);
        }
        return link.getLast();
    }

    private LinkedList<EntityRelationNode> initLink(String sourceEntity) {
        LinkedList list = Lists.newLinkedList();
        this.relationMap.put(sourceEntity, list);
        EntityRelationNode node = new EntityRelationNode();
        node.setEntityId(sourceEntity);
        list.offer(node);
        return list;
    }

    static class EntityRelationNode
    implements Serializable {
        private static final long serialVersionUID = 8319244451260062001L;
        private String entityId;
        private String refFileName;

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public String getRefFileName() {
            return this.refFileName;
        }

        public void setRefFileName(String refFileName) {
            this.refFileName = refFileName;
        }
    }
}

