/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.activity.dealer.ActivityDealer;
import kd.swc.hcdm.business.candidatesetsalaryappl.syncfile.CandSetSalApplySyncFileTask;

public class CandSetSalActConsentValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(CandSetSalApplySyncFileTask.class);

    public void validate() {
        log.info("CandSetSalActConsentValidator.validate start...");
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String actBaseMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u534f\u4f5c%s\u6d3b\u52a8\u57fa\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6392\u67e5\u3002", (String)"CandSetSalActConsentValidator_3", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String doneStatusMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u534f\u4f5c%s\u5df2\u7ed3\u675f\uff0c\u4e0d\u9700\u8981\u518d\u6b21\u7ed3\u675f\u3002", (String)"CandSetSalActConsentValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String invalidStatusMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u534f\u4f5c%s\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u7ed3\u675f\u3002", (String)"CandSetSalActConsentValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String applyMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u534f\u4f5c%s\u5df2\u5b58\u5728\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u7ed3\u675f\u3002", (String)"CandSetSalActConsentValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        ArrayList candSetSalActDyns = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        HashMap extendedEntityMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject candSetSalActDyn = dataEntity.getDataEntity();
            String actNumber = candSetSalActDyn.getString("activitybase.number");
            DynamicObject actBaseDyn = candSetSalActDyn.getDynamicObject("activitybase");
            if (actBaseDyn == null) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, actBaseMsg, actNumber));
                continue;
            }
            String actStatus = actBaseDyn.getString("activitystatus");
            if (StringUtils.equals((CharSequence)actStatus, (CharSequence)"30")) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, doneStatusMsg, actNumber));
                continue;
            }
            if (StringUtils.equals((CharSequence)actStatus, (CharSequence)"40")) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, invalidStatusMsg, actNumber));
                continue;
            }
            if (StringUtils.equals((CharSequence)actStatus, (CharSequence)"10")) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, applyMsg, actNumber));
                continue;
            }
            candSetSalActDyns.add(candSetSalActDyn);
            extendedEntityMap.put(candSetSalActDyn, dataEntity);
        }
        if (CollectionUtils.isEmpty((Collection)candSetSalActDyns)) {
            return;
        }
        ActivityDealer activityDealer = ActivityDealer.getActivityDealer((String)"hcdm_candsetsalact");
        activityDealer.batchConsentActivity(candSetSalActDyns.toArray(new DynamicObject[candSetSalActDyns.size()]));
        for (DynamicObject candSetSalActDyn : candSetSalActDyns) {
            DynamicObject actBaseDyn = candSetSalActDyn.getDynamicObject("activitybase");
            if (actBaseDyn.getBoolean("isactright")) continue;
            this.addFatalErrorMessage((ExtendedDataEntity)extendedEntityMap.get(candSetSalActDyn), actBaseDyn.getString("errormsg"));
        }
        log.info("CandSetSalActConsentValidator.validate end...");
    }
}

