/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.activity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class CandSetSalActDeleteValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if ("deleteappl".equals(operateKey)) {
            ArrayList extendedDataEntities = Lists.newArrayList((Object[])this.getDataEntities());
            Map<ExtendedDataEntity, Long> dataEntityAndCandSetSalApplIdMap = extendedDataEntities.stream().collect(Collectors.toMap(dataEntity -> dataEntity, dataEntity -> dataEntity.getDataEntity().getLong("candsetsalapplid"), (oldVal, newVal) -> oldVal));
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_singlecandsetsalappl");
            QFilter filter = new QFilter("id", "in", dataEntityAndCandSetSalApplIdMap.values());
            DynamicObjectCollection singleCandSetSalApplDys = helper.queryOriginalCollection("id,billstatus,billno", filter.toArray());
            Map<Long, DynamicObject> singleCandSetSalApplIdAndDyMap = singleCandSetSalApplDys.stream().collect(Collectors.toMap(singleCandSetSalApplDy -> singleCandSetSalApplDy.getLong("id"), singleCandSetSalApplDy -> singleCandSetSalApplDy, (oldVal, newVal) -> oldVal));
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
                String activityBaseNumber = dataEntity2.getString("activitybase.number");
                DynamicObjectCollection entryEntity = dataEntity2.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryEntity) {
                    Long singleCandSetSalApplId = dataEntityAndCandSetSalApplIdMap.get(extendedDataEntity);
                    DynamicObject singleCandSetSalApplDy2 = singleCandSetSalApplIdAndDyMap.get(singleCandSetSalApplId);
                    String candidateName = entry.getString("candidate.name");
                    String candidateNumber = entry.getString("candidate.number");
                    if (singleCandSetSalApplDy2 == null) {
                        this.addErrorMessage(extendedDataEntity, HCDMErrInfoEnum.CANDIDATE_SET_SALARY_APPL_NOT_EXISTS.getMsg(new Object[]{candidateName, candidateNumber, activityBaseNumber}));
                        continue;
                    }
                    if ("A".equals(singleCandSetSalApplDy2.getString("billstatus"))) continue;
                    this.addErrorMessage(extendedDataEntity, HCDMErrInfoEnum.CANDIDATE_SET_SALARY_APPL_DEL_TIPS.getMsg(new Object[]{candidateName, candidateNumber, singleCandSetSalApplDy2.getString("billno")}));
                }
            }
        }
    }
}

