/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.activity;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class CandidateActValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (!this.validatePerm()) {
            return;
        }
        Set candSetSalApplIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("candsetsalapplid")).collect(Collectors.toSet());
        Map candSetSalApplDyMap = CandidateSetSalApplyHelper.getCandSetSalApplDysById(candSetSalApplIds);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String msg;
            String billStatus;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long candSetSalApplId = dynamicObject.getLong("candsetsalapplid");
            String activityStatus = dynamicObject.getString("activitybase.activitystatus");
            DynamicObject candSetSalApplDy = (DynamicObject)candSetSalApplDyMap.get(candSetSalApplId);
            if (Objects.nonNull(candSetSalApplDy) && !"F".equals(billStatus = candSetSalApplDy.getString("billstatus")) && !"E".equals(billStatus) && "10".equals(activityStatus)) {
                msg = ResManager.loadKDString((String)"{0}\uff1a\u5df2\u5b58\u5728\u5b9a\u85aa\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u518d\u6b21\u521b\u5efa\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u3002", (String)"CandidateActValidator_5", (String)"swc-hcdm-opplugin", (Object[])new Object[]{dynamicObject.getString("activitybase.number")});
                this.addFatalErrorMessage(dataEntity, msg);
                continue;
            }
            if ("20".equals(activityStatus) || "30".equals(activityStatus) || "40".equals(activityStatus)) {
                String msg2 = null;
                switch (activityStatus) {
                    case "20": {
                        msg2 = ResManager.loadKDString((String)"{0}\uff1a\u5019\u9009\u4eba\u5b9a\u85aa\u534f\u4f5c\u5f85\u7ed3\u675f\uff0c\u65e0\u6cd5\u521b\u5efa\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u3002", (String)"CandidateActValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[]{dynamicObject.getString("activitybase.number")});
                        break;
                    }
                    case "30": {
                        msg2 = ResManager.loadKDString((String)"{0}\uff1a\u5019\u9009\u4eba\u5b9a\u85aa\u534f\u4f5c\u5df2\u7ed3\u675f\uff0c\u65e0\u6cd5\u521b\u5efa\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u3002", (String)"CandidateActValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[]{dynamicObject.getString("activitybase.number")});
                        break;
                    }
                    case "40": {
                        msg2 = ResManager.loadKDString((String)"{0}\uff1a\u5019\u9009\u4eba\u5b9a\u85aa\u534f\u4f5c\u5df2\u7ecf\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u521b\u5efa\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u3002", (String)"CandidateActValidator_3", (String)"swc-hcdm-opplugin", (Object[])new Object[]{dynamicObject.getString("activitybase.number")});
                        break;
                    }
                }
                this.addFatalErrorMessage(dataEntity, msg2);
                continue;
            }
            boolean iscandsetsal = dynamicObject.getBoolean("iscandsetsal");
            if (iscandsetsal) continue;
            msg = ResManager.loadKDString((String)"{0}\uff1a\u53ea\u6709\u5019\u9009\u4eba\u5b9a\u85aa\u534f\u4f5c\u7684\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u662f\u201d\u624d\u80fd\u521b\u5efa\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u3002", (String)"CandidateActValidator_4", (String)"swc-hcdm-opplugin", (Object[])new Object[]{dynamicObject.getString("activitybase.number")});
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }

    private boolean validatePerm() {
        boolean hasNewPermssion;
        String isHasRight = this.getOption().getVariableValue("ishasright", String.valueOf(false));
        if (!StringUtils.equals((CharSequence)"true", (CharSequence)isHasRight) && !(hasNewPermssion = SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"47156aff000000ac"))) {
            String entityDescName = EntityMetadataCache.getDataEntityType((String)"hcdm_singlecandsetsalappl").getDisplayName().getLocaleValue();
            String msg = ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CandidateActValidator_6", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entityDescName});
            Arrays.stream(this.dataEntities).forEach(obj -> this.addFatalErrorMessage((ExtendedDataEntity)obj, msg));
            return false;
        }
        return true;
    }
}

