/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.adjapprbill.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.DateProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.adjapprbill.analysis.BizDataEntryHelper;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.common.enums.DataTypeEnum;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BizDataSaveValidator
extends SWCDataBaseValidator {
    private static final Log logger = LogFactory.getLog(BizDataSaveValidator.class);
    private DecimalConverter decimalConverter = new DecimalConverter();
    private String errorTipOfNotBelongInterval = ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\uff1a\u4e1a\u52a1\u6570\u636e\u4e0d\u5728\u201c%3$s\u201d\u7684\u503c\u5217\u8868\u533a\u95f4\u8303\u56f4\u5185\u3002", (String)"BizDataSaveValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
    private String errorTipOfValueError = ResManager.loadKDString((String)"\u503c\u683c\u5f0f\u9519\u8bef", (String)"BizDataSaveValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
    private String errorTipOfValueNotEmpty = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizDataSaveValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        long start = System.currentTimeMillis();
        if (StringUtils.equals((CharSequence)this.getOperateKey(), (CharSequence)"submit") || StringUtils.equals((CharSequence)this.getOperateKey(), (CharSequence)"save")) {
            boolean importTag = Boolean.parseBoolean(this.getOption().getVariableValue("importtag_of_datasource", "false"));
            boolean needCheckValueNull = false;
            Map<Long, List<ExtendedDataEntity>> groupWithItem = Arrays.stream(dataEntities).collect(Collectors.groupingBy(k1 -> k1.getDataEntity().getLong("bizitem.id")));
            for (Map.Entry<Long, List<ExtendedDataEntity>> entry : groupWithItem.entrySet()) {
                List<ExtendedDataEntity> bizDataOfOneItem = entry.getValue();
                boolean existError = this.checkFieldValueCompleteBatch(bizDataOfOneItem, importTag, bizDataOfOneItem.get(0).getDataEntity().getDynamicObject("bizitem"));
                if (!existError) continue;
                needCheckValueNull = true;
            }
            if (needCheckValueNull) {
                this.getOption().setVariableValue("isValueNull", "true");
            }
            HashSet personNumberSets = Sets.newHashSetWithExpectedSize((int)16);
            HashSet adminorgIdsSets = Sets.newHashSetWithExpectedSize((int)16);
            HashSet employeeIdSets = new HashSet(16);
            for (ExtendedDataEntity dataEntitie : dataEntities) {
                personNumberSets.add(dataEntitie.getDataEntity().getString("person.number"));
                adminorgIdsSets.add(dataEntitie.getDataEntity().getLong("adminorg.id"));
            }
            Object[] depempDyn = CommonHcdmBizHelper.queryEmployeeFromHrpi((Set)personNumberSets, (Set)adminorgIdsSets);
            if (ArrayUtils.isEmpty((Object[])depempDyn)) {
                return;
            }
            Map<String, List<DynamicObject>> depempMap = Arrays.stream(depempDyn).collect(Collectors.groupingBy(obj -> obj.getString("person.number") + "_" + obj.getLong("adminorg.id")));
            Arrays.stream(depempDyn).forEach(obj -> employeeIdSets.add(obj.getLong("employee.id")));
            Object[] employeeDyn = CommonHcdmBizHelper.queryEmployeeByIds(employeeIdSets);
            Map<Object, Object> idToEmployeeMap = new HashMap(16);
            if (ArrayUtils.isNotEmpty((Object[])employeeDyn)) {
                idToEmployeeMap = Arrays.stream(employeeDyn).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (dy1, dy2) -> dy1));
            }
            for (ExtendedDataEntity dataEntitie : dataEntities) {
                String key;
                List<DynamicObject> depempList;
                String personNumber = dataEntitie.getDataEntity().getString("person.number");
                Long adminorgId = dataEntitie.getDataEntity().getLong("adminorg.id");
                Date bizdatatime = dataEntitie.getDataEntity().getDate("bizdatatime");
                DynamicObject matchObj = CommonHcdmBizHelper.matchEmployee((Date)bizdatatime, depempList = depempMap.get(key = personNumber + "_" + adminorgId), idToEmployeeMap);
                if (matchObj == null) continue;
                dataEntitie.getDataEntity().set("employee", (Object)matchObj);
            }
        }
        long cost = System.currentTimeMillis() - start;
        logger.info("BizDataSaveValidator cost: {}", (Object)cost);
    }

    @Deprecated
    private boolean checkFieldValueComplete(ExtendedDataEntity extEntity, boolean importTag) {
        return false;
    }

    private boolean checkFieldValueCompleteBatch(List<ExtendedDataEntity> extEntities, boolean importTag, DynamicObject bizItemDyObj) {
        IDataEntityType dataEntityType = extEntities.get(0).getDataEntity().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        boolean needCheckValueNull = false;
        if (bizItemDyObj == null) {
            return needCheckValueNull;
        }
        boolean isInterval = bizItemDyObj.getBoolean("isinterval");
        DataTypeEnum datatype = DataTypeEnum.getByCode((int)bizItemDyObj.getInt("datatype"));
        String bizItemName = bizItemDyObj.getString("name");
        ArrayList needCheckValueAccurate = Lists.newArrayListWithExpectedSize((int)extEntities.size());
        ArrayList valuesOfNeedCheckValueAccurate = Lists.newArrayListWithExpectedSize((int)extEntities.size());
        for (ExtendedDataEntity extEntity : extEntities) {
            DynamicObject entity = extEntity.getDataEntity();
            String value = this.formatFieldVal(extEntity, entity.getString("value"), datatype, bizItemDyObj);
            entity.set("value", (Object)value);
            if (importTag) {
                if (StringUtils.isNotBlank((CharSequence)value) && !this.isFieldValueFormat(value, datatype, properties)) {
                    this.addMessage(extEntity, this.errorTipOfValueError);
                    needCheckValueNull = true;
                    continue;
                }
                needCheckValueAccurate.add(extEntity);
                valuesOfNeedCheckValueAccurate.add(value);
                continue;
            }
            if (isInterval && StringUtils.isBlank((CharSequence)value) || !isInterval && entity.getDynamicObject("bizitement") == null) {
                this.addMessage(extEntity, this.errorTipOfValueNotEmpty);
                needCheckValueNull = true;
                continue;
            }
            needCheckValueAccurate.add(extEntity);
            valuesOfNeedCheckValueAccurate.add(value);
        }
        if (CollectionUtils.isNotEmpty((Collection)needCheckValueAccurate)) {
            if (isInterval) {
                this.checkFieldValueBatch(datatype, valuesOfNeedCheckValueAccurate, properties, isInterval, bizItemDyObj, needCheckValueAccurate, importTag);
            } else {
                for (int i = 0; i < needCheckValueAccurate.size(); ++i) {
                    DynamicObject bizItemEntDyObj;
                    ExtendedDataEntity extEntity;
                    extEntity = (ExtendedDataEntity)needCheckValueAccurate.get(i);
                    String value = (String)valuesOfNeedCheckValueAccurate.get(i);
                    DynamicObject entity = extEntity.getDataEntity();
                    DynamicObject bizItemEnt = entity.getDynamicObject("bizitement");
                    if (SWCBaseUtils.isEmpty((DynamicObject)bizItemEnt) && StringUtils.isBlank((CharSequence)value)) {
                        this.addFatalErrorMessage(extEntity, this.errorTipOfValueNotEmpty);
                        needCheckValueNull = true;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)value) || !SWCBaseUtils.isEmpty((DynamicObject)(bizItemEntDyObj = this.convertValueToBizItemEnt(entity, properties, datatype, importTag)))) continue;
                    String personName = entity.getString("person.name");
                    String personNumber = entity.getString("person.number");
                    String tipNotificationMeg = String.format(this.errorTipOfNotBelongInterval, personName, personNumber, bizItemName);
                    this.addFatalErrorMessage(extEntity, tipNotificationMeg);
                    needCheckValueNull = true;
                }
            }
        }
        return needCheckValueNull;
    }

    private DynamicObject convertValueToBizItemEnt(DynamicObject dataEntity, DataEntityPropertyCollection properties, DataTypeEnum datatype, boolean importTag) {
        DynamicObject bizItemDyObj = dataEntity.getDynamicObject("bizitem");
        DynamicObjectCollection bizItemEntColl = bizItemDyObj.getDynamicObjectCollection("entryentity");
        String inputValue = dataEntity.getString("value");
        for (DynamicObject bizItemEnt : bizItemEntColl) {
            String bizItemEntValue = bizItemEnt.getString("value");
            if (datatype == DataTypeEnum.DATE && importTag) {
                DateProp dateProp = (DateProp)properties.get((Object)"bizitementdate");
                SimpleDateFormat dateFormat = (SimpleDateFormat)dateProp.getDateFormat();
                try {
                    Date date = dateFormat.parse(inputValue);
                    inputValue = String.valueOf(date.getTime());
                }
                catch (ParseException e) {
                    logger.error("\u8f6c\u6362\u65f6\u95f4\u51fa\u9519");
                }
            }
            if (!bizItemEntValue.equals(inputValue)) continue;
            dataEntity.set("bizitement", (Object)bizItemEnt);
            dataEntity.set("value", (Object)"");
            return bizItemEnt;
        }
        return null;
    }

    @Deprecated
    private void checkFieldValue(DataTypeEnum datatype, String value, DataEntityPropertyCollection properties, boolean isInterval, DynamicObject bizItemDyObj, ExtendedDataEntity extEntity, String tipNotificationMeg, Boolean importTag) {
        DynamicObject entity = extEntity.getDataEntity();
        switch (datatype) {
            case NUMBER: 
            case PERCENT: {
                BigDecimal valueBigDecimal;
                String scale = bizItemDyObj.getString("scale");
                if (!StringUtils.isNotBlank((CharSequence)scale) || BizDataEntryHelper.isBizItemMinMaxValueRange((boolean)isInterval, (DataTypeEnum)datatype, (DynamicObject)bizItemDyObj, (String)(valueBigDecimal = new BigDecimal(value).setScale(Integer.parseInt(scale), 4)).toString())) break;
                this.addFatalErrorMessage(extEntity, tipNotificationMeg);
                break;
            }
            case DATE: {
                DateProp dateProp = (DateProp)properties.get((Object)"bizitementdate");
                SimpleDateFormat dateFormat = (SimpleDateFormat)dateProp.getDateFormat();
                if (importTag.booleanValue()) {
                    try {
                        Date date = dateFormat.parse(value);
                        value = String.valueOf(date.getTime());
                    }
                    catch (ParseException e) {
                        logger.error("\u8f6c\u6362\u65f6\u95f4\u51fa\u9519");
                    }
                }
                if (!BizDataEntryHelper.isBizItemMinMaxValueRange((boolean)isInterval, (DataTypeEnum)datatype, (DynamicObject)bizItemDyObj, (String)value)) {
                    this.addFatalErrorMessage(extEntity, tipNotificationMeg);
                    break;
                }
                entity.set("value", (Object)value);
                break;
            }
        }
    }

    private boolean checkFieldValueBatch(DataTypeEnum datatype, List<String> valueArr, DataEntityPropertyCollection properties, boolean isInterval, DynamicObject bizItemDyObj, List<ExtendedDataEntity> extEntities, Boolean importTag) {
        String scale = bizItemDyObj.getString("scale");
        DateProp dateProp = (DateProp)properties.get((Object)"bizitementdate");
        List<Object> valueArrAfterFormat = Lists.newArrayListWithExpectedSize((int)valueArr.size());
        String bizItemName = bizItemDyObj.getString("name");
        boolean existError = false;
        switch (datatype) {
            case NUMBER: 
            case PERCENT: {
                if (!StringUtils.isNotBlank((CharSequence)scale)) break;
                valueArrAfterFormat = valueArr.stream().map(o1 -> new BigDecimal((String)o1).setScale(Integer.parseInt(scale), 4).toString()).collect(Collectors.toList());
                break;
            }
            case DATE: {
                SimpleDateFormat dateFormat = (SimpleDateFormat)dateProp.getDateFormat();
                valueArrAfterFormat = valueArr.stream().map(o1 -> {
                    if (importTag.booleanValue()) {
                        try {
                            Date date = dateFormat.parse((String)o1);
                            return String.valueOf(date.getTime());
                        }
                        catch (ParseException e) {
                            logger.error("\u8f6c\u6362\u65f6\u95f4\u51fa\u9519");
                            return "";
                        }
                    }
                    return o1;
                }).collect(Collectors.toList());
                break;
            }
        }
        List checkResult = BizDataEntryHelper.isBizItemMinMaxValueRangeBatch((boolean)isInterval, (DataTypeEnum)datatype, (DynamicObject)bizItemDyObj, (List)valueArrAfterFormat);
        for (int i = 0; i < valueArr.size(); ++i) {
            String valueAfterFormat = (String)valueArrAfterFormat.get(i);
            Boolean checkPass = (Boolean)checkResult.get(i);
            ExtendedDataEntity extDataEntity = extEntities.get(i);
            DynamicObject entity = extDataEntity.getDataEntity();
            if (!checkPass.booleanValue()) {
                String personName = entity.getString("person.name");
                String personNumber = entity.getString("person.number");
                String tipNotificationMeg = String.format(this.errorTipOfNotBelongInterval, personName, personNumber, bizItemName);
                this.addFatalErrorMessage(extDataEntity, tipNotificationMeg);
                existError = true;
                continue;
            }
            extDataEntity.getDataEntity().set("value", (Object)valueAfterFormat);
        }
        return existError;
    }

    private boolean isFieldValueFormat(String fieldVal, DataTypeEnum datatype, DataEntityPropertyCollection properties) {
        boolean isSuccess = true;
        switch (datatype) {
            case NUMBER: 
            case PERCENT: {
                ValidateResults validateResults = this.decimalConverter.checkType((Object)fieldVal);
                isSuccess = validateResults.isSuccess();
                break;
            }
            case DATE: {
                DateProp dateProp = (DateProp)properties.get((Object)"bizitementdate");
                SimpleDateFormat dateFormat = (SimpleDateFormat)dateProp.getDateFormat();
                try {
                    dateFormat.parse(fieldVal);
                }
                catch (ParseException e) {
                    isSuccess = false;
                }
                break;
            }
        }
        return isSuccess;
    }

    public String formatFieldVal(ExtendedDataEntity extEntity, String fieldVal, DataTypeEnum datatype, DynamicObject bizItemDyObj) {
        if (StringUtils.isBlank((CharSequence)fieldVal)) {
            return fieldVal;
        }
        switch (datatype) {
            case NUMBER: 
            case PERCENT: {
                ValidateResults validateResults = this.decimalConverter.checkType((Object)fieldVal);
                if (validateResults.isSuccess()) {
                    String bizItemScale = bizItemDyObj.getString("scale");
                    BigDecimal convertVal = new BigDecimal(fieldVal);
                    int scale = Integer.parseInt(bizItemScale);
                    BigDecimal val = convertVal.setScale(scale, 4);
                    fieldVal = val.toPlainString();
                    break;
                }
                List errorList = validateResults.getErrorList();
                this.addFatalErrorMessage(extEntity, (String)errorList.get(0));
                break;
            }
        }
        return fieldVal;
    }
}

