/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.adjapprbill.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.adjapprbill.analysis.BizItemEntryHelper;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.common.enums.DataTypeEnum;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import org.apache.commons.lang.StringUtils;

public class BizItemEntrySaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getOperateKey(), (CharSequence)"submit") || org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getOperateKey(), (CharSequence)"save")) {
            this.checkBaseDataFieldEffective(dataEntities);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                StringJoiner errMandatoryField = CountryHelper.validate((DynamicObject)dataEntity.getDataEntity());
                if (errMandatoryField.length() > 0) {
                    this.addErrorMessage(dataEntity, HCDMErrInfoEnum.COMMON_MUST_INPUT_VALUE.getMsg(new Object[]{errMandatoryField.toString()}));
                    continue;
                }
                this.checkValueComplete(dataEntity);
                this.checkValueLength(dataEntity);
                this.checkMinMaxValue(dataEntity);
                this.checkValueRepeat(dataEntity);
            }
        }
    }

    private void checkBaseDataFieldEffective(ExtendedDataEntity[] dataEntities) {
        if (dataEntities.length == 0) {
            return;
        }
        HashSet categoryIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        String fieldName = "bizitemcategory";
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long id = dataEntity.getDataEntity().getLong(fieldName + ".id");
            if (id <= 0L) continue;
            categoryIds.add(id);
        }
        if (categoryIds.isEmpty()) {
            return;
        }
        BasedataProp property = (BasedataProp)dataEntities[0].getDataEntity().getDataEntityType().getProperties().get((Object)"bizitemcategory");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(property.getBaseEntityId());
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter audit = new QFilter("status", "=", (Object)"C");
        QFilter ids = new QFilter("id", "in", (Object)categoryIds);
        DynamicObject[] results = serviceHelper.query("id", new QFilter[]{enable, audit, ids});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)results.length);
        for (DynamicObject result : results) {
            resultMap.put(result.getLong("id"), result);
        }
        String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u7c7b\u522b\u201c%s\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\u4e14\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u8c03\u6574\u3002", (String)"BizItemEntrySaveValidator_5", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long categoryId = dataEntity.getDataEntity().getLong(fieldName + ".id");
            if (resultMap.containsKey(categoryId)) continue;
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, msg, dataEntity.getDataEntity().getString(fieldName + "." + "number")));
        }
    }

    private void checkValueRepeat(ExtendedDataEntity extEntity) {
        DynamicObject entity = extEntity.getDataEntity();
        DataTypeEnum datatype = DataTypeEnum.getByCode((int)entity.getInt("datatype"));
        boolean isInterval = entity.getBoolean("isinterval");
        DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection("entryentity");
        LocaleString entryName = entryEntity.getDynamicObjectType().getDisplayName();
        HashMap repeatRowMap = Maps.newHashMap();
        byte[] repeatFlags = new byte[entryEntity.size()];
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject row = (DynamicObject)entryEntity.get(i);
            if (repeatFlags[i] != 0) continue;
            String value = row.getString("value");
            for (int j = 0; j < entryEntity.size(); ++j) {
                DynamicObject anotherRow;
                String tempValue;
                if (i == j || repeatFlags[j] != 0 || !this.compareEqualsOrOverlap(value, tempValue = (anotherRow = (DynamicObject)entryEntity.get(j)).getString("value"), datatype, isInterval)) continue;
                List targetRowIndex = repeatRowMap.getOrDefault(i, Lists.newArrayList());
                repeatRowMap.put(i, targetRowIndex);
                targetRowIndex.add(j);
                repeatFlags[i] = 1;
                repeatFlags[j] = 1;
            }
        }
        if (!repeatRowMap.isEmpty()) {
            String rowRepeatMsg = ResManager.loadKDString((String)"\u884c\u6570\u636e\u91cd\u590d", (String)"BizItemEntrySaveValidator_4", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
            StringBuilder sb = new StringBuilder();
            sb.append(entryName);
            StringJoiner stringJoiner = new StringJoiner("\uff0c");
            for (Map.Entry entry : repeatRowMap.entrySet()) {
                StringJoiner joiner = new StringJoiner("\u3001");
                joiner.add((Integer)entry.getKey() + 1 + "");
                for (Integer integer : (List)entry.getValue()) {
                    joiner.add(integer + 1 + "");
                }
                stringJoiner.add(joiner.toString() + rowRepeatMsg);
            }
            sb.append(stringJoiner);
            this.addErrorMessage(extEntity, sb.toString());
        }
    }

    private boolean compareEqualsOrOverlap(String value, String tempValue, DataTypeEnum datatype, boolean isInterval) {
        if (!isInterval) {
            return org.apache.commons.lang3.StringUtils.equals((CharSequence)value, (CharSequence)tempValue);
        }
        return BizItemEntryHelper.checkIntervalOverlap((String)value, (String)tempValue, (DataTypeEnum)datatype);
    }

    private void checkValueComplete(ExtendedDataEntity extEntity) {
        DynamicObject entity = extEntity.getDataEntity();
        DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection("entryentity");
        if (entryEntity.isEmpty()) {
            this.addFatalErrorMessage(extEntity, ResManager.loadKDString((String)"\u503c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizItemEntrySaveValidator_3", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder();
        String overLengthMessage = ResManager.loadKDString((String)"\u503c\u5217\u8868\u7b2c{0}\u884c\u503c\u5b57\u6bb5\u672a\u586b\u5199\u3002", (String)"BizItemEntrySaveValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        boolean complete = true;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject row = (DynamicObject)entryEntity.get(i);
            String value = row.getString("value");
            if (!StringUtils.isEmpty((String)(value = org.apache.commons.lang3.StringUtils.trim((String)value)))) continue;
            complete = false;
            sb.append(MessageFormat.format(overLengthMessage, i + 1)).append("\r\n");
        }
        if (!complete) {
            this.addErrorMessage(extEntity, sb.toString());
        }
    }

    private void checkValueLength(ExtendedDataEntity extEntity) {
        DynamicObject entity = extEntity.getDataEntity();
        DataTypeEnum datatype = DataTypeEnum.getByCode((int)entity.getInt("datatype"));
        if (datatype == DataTypeEnum.TEXT) {
            int dataLength = entity.getInt("datalength");
            DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection("entryentity");
            boolean overLength = false;
            StringBuilder sb = new StringBuilder();
            String overLengthMessage = ResManager.loadKDString((String)"\u503c\u5217\u8868\u7b2c{0}\u884c\u503c\u5b57\u6bb5\u957f\u5ea6\u8d85\u8fc7{1}\u3002", (String)"BizItemEntrySaveValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                String value = row.getString("value");
                if (StringUtils.length((String)value) <= dataLength) continue;
                overLength = true;
                sb.append(MessageFormat.format(overLengthMessage, i + 1, dataLength)).append("\r\n");
            }
            if (overLength) {
                this.addErrorMessage(extEntity, sb.toString());
            }
        }
    }

    private void checkMinMaxValue(ExtendedDataEntity extEntity) {
        DynamicObject entity = extEntity.getDataEntity();
        DataTypeEnum datatype = DataTypeEnum.getByCode((int)entity.getInt("datatype"));
        boolean isInterval = entity.getBoolean("isinterval");
        if (isInterval && (datatype == DataTypeEnum.NUMBER || datatype == DataTypeEnum.PERCENT)) {
            DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection("entryentity");
            boolean overLength = false;
            StringBuilder sb = new StringBuilder();
            String lessThanMessage = ResManager.loadKDString((String)"\u503c\u5217\u8868\u7b2c{0}\u884c\u6700\u5c0f\u503c\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u6700\u5927\u503c\u3002", (String)"BizItemEntrySaveValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                BigDecimal minValue = BizItemEntryHelper.stringToDecimalRange((String)row.getString("value"), (boolean)true);
                BigDecimal maxValue = BizItemEntryHelper.stringToDecimalRange((String)row.getString("value"), (boolean)false);
                if (minValue == null || maxValue == null || minValue.compareTo(maxValue) <= 0) continue;
                overLength = true;
                sb.append(MessageFormat.format(lessThanMessage, i + 1)).append("\r\n");
            }
            if (overLength) {
                this.addErrorMessage(extEntity, sb.toString());
            }
        }
    }
}

