/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.adjapprscm;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

public class AdjApprLittleKCfgSaveAndSumbitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        if (StringUtils.equals((CharSequence)this.getOperateKey(), (CharSequence)"submit") || StringUtils.equals((CharSequence)this.getOperateKey(), (CharSequence)"save") || StringUtils.equals((CharSequence)this.getOperateKey(), (CharSequence)"changesave")) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.checkNineGridEntryMustInput(dataEntity);
            }
        }
    }

    private void checkNineGridEntryMustInput(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection littlekDataEnt;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        if (dynamicObject.getBoolean("islittlek") && CollectionUtil.isNotEmpty((Collection)(littlekDataEnt = dynamicObject.getDynamicObjectCollection("littlekentryentity")))) {
            for (DynamicObject littlekData : littlekDataEnt) {
                String content = littlekData.getString("content");
                String removeHtmlContent = AdjApprLittleKCfgSaveAndSumbitValidator.removeHtmlTag(content);
                int length = this.calcStringLength(removeHtmlContent);
                if (length <= 1000) continue;
                String fmt = ResManager.loadKDString((String)"\u201c\u667a\u80fd\u5206\u6790\u5361\u7247\u5206\u5f55\u201d\u7b2c%s\u884c\uff0c\u6a21\u677f\u6b63\u6587\u5b57\u6bb5\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\uff080,1000\uff09\u3002", (String)"AdjApprLittleKCfgSaveAndSumbitValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                int seq = littlekData.getInt("seq");
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, fmt, seq));
            }
        }
    }

    private int calcStringLength(String str) {
        try {
            return str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            return 0;
        }
    }

    private static String removeHtmlTag(String htmlStr) {
        String regEx_script = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
        String regEx_style = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
        String regEx_html = "<[^>]+>";
        String regEx_special = "\\&[a-zA-Z]{1,10};";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        Pattern p_special = Pattern.compile(regEx_special, 2);
        Matcher m_special = p_special.matcher(htmlStr);
        htmlStr = m_special.replaceAll("");
        return htmlStr;
    }
}

