/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.candidatesetsalappl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshService;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.RefreshResult;
import org.apache.commons.lang3.StringUtils;

public class CandSetSalApplRefreshValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList canRefreshApplies = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        LinkedHashMap dynAndEntityMap = Maps.newLinkedHashMapWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject apply = dataEntity.getDataEntity();
            String msg = CandSetSalApplyRefreshHelper.validateApplyIsCanRefresh((DynamicObject)apply);
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            canRefreshApplies.add(apply);
            dynAndEntityMap.put(apply, dataEntity);
        }
        if (CollectionUtils.isEmpty((Collection)canRefreshApplies)) {
            return;
        }
        Map resultMap = CandSetSalApplyRefreshService.refreshPersonAndItemByApplies((List)canRefreshApplies);
        if (CollectionUtils.isEmpty((Map)resultMap)) {
            resultMap = Maps.newHashMapWithExpectedSize((int)0);
        }
        for (DynamicObject appl : canRefreshApplies) {
            ExtendedDataEntity entity = (ExtendedDataEntity)dynAndEntityMap.get(appl);
            DynamicObjectCollection personDyns = appl.getDynamicObjectCollection("candsetsalperson");
            if (personDyns == null || personDyns.size() == 0) continue;
            for (DynamicObject personDyn : personDyns) {
                long personDynId = personDyn.getLong("id");
                RefreshResult result = (RefreshResult)resultMap.get(personDynId);
                String msg = CandSetSalApplyRefreshHelper.getMsgFromRefreshResult((RefreshResult)result);
                if (result != null && result.isSuccess() && result.isChange()) continue;
                this.addErrorMessage(entity, msg);
            }
        }
    }
}

