/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.candidatesetsalappl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapprbill.enums.ExcessControlEnum;
import kd.swc.hcdm.business.adjapprbill.enums.OverStandardTypeEnum;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyService;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.model.ValidateResult;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CandidateValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(CandidateValidator.class);
    private static final Set<String> mustInputFieldsOnAuditPass = new HashSet<String>(16);
    private static final Set<String> mustInputFieldOnSpecial;
    Map<String, IDataEntityProperty> mainFieldPropMap = new HashMap<String, IDataEntityProperty>(16);
    Map<String, IDataEntityProperty> personFieldPropMap = new HashMap<String, IDataEntityProperty>(16);
    Map<String, IDataEntityProperty> itemFieldPropMap = new HashMap<String, IDataEntityProperty>(16);

    public void validate() {
        this.initFieldPropMap();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "submiteffect".equals(operateKey) || "donothing_wfvalidate".equals(operateKey)) {
            Collection<Long> itemIds;
            Boolean isExistProc;
            Object[] dataEntities = this.getDataEntities();
            if (ArrayUtils.isEmpty((Object[])dataEntities)) {
                return;
            }
            if ("submit".equals(operateKey) && !(isExistProc = WorkflowServiceHelper.existProcDefByEntityNumber((String)"hcdm_singlecandsetsalappl")).booleanValue()) {
                String msg = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"CandidateValidator_18", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                for (Object dataEntity : dataEntities) {
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, msg);
                }
                return;
            }
            long[] ids = DB.genLongIds((String)"T_HCDM_CANDSETSALAPPL", (int)dataEntities.length);
            int i2 = 0;
            ArrayList applys = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
            for (Object dataEntity : dataEntities) {
                DynamicObject dy2 = dataEntity.getDataEntity();
                applys.add(dy2);
                if (dy2.getLong("id") != 0L) continue;
                dy2.set("id", (Object)ids[i2]);
                ++i2;
            }
            Map<Long, DynamicObject> idToApplDyMap = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
            Map matchMsgMap = CandidateSetSalApplyService.matchAndSetExistFile((List)applys, (boolean)false);
            Map candSetSalApplIdToAdjFileMap = CandidateSetSalApplyHelper.getValidateRepeatAdjFileMap((DynamicObject[])idToApplDyMap.values().toArray(new DynamicObject[0]));
            LOGGER.info("CandidateValidator resultMap1 values dy ids is [{}]", candSetSalApplIdToAdjFileMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
            String entityDescName = EntityMetadataCache.getDataEntityType((String)"hcdm_singlecandsetsalappl").getDisplayName().getLocaleValue();
            HashMap idToStdScmVidMap = Maps.newHashMapWithExpectedSize((int)idToApplDyMap.size());
            HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet onBrdInfoIdSet = Sets.newHashSetWithExpectedSize((int)16);
            HashSet candidateIdSet = Sets.newHashSetWithExpectedSize((int)16);
            for (DynamicObject dy3 : idToApplDyMap.values()) {
                DynamicObjectCollection personEntries = dy3.getDynamicObjectCollection("candsetsalperson");
                for (DynamicObject personEntry : personEntries) {
                    long candidateId = personEntry.getLong("candidate.id");
                    long stdScmVidId = personEntry.getLong("stdscmvid.id");
                    long onBrdInfoId = personEntry.getLong("onbrdinfo");
                    idToStdScmVidMap.put(dy3.getLong("id"), stdScmVidId);
                    onBrdInfoIdSet.add(onBrdInfoId);
                    candidateIdSet.add(candidateId);
                }
            }
            DynamicObject[] existCandidateSetSalApplDys = CandidateSetSalApplyHelper.getCandidateSetSalApplByCandidateIds((Set)candidateIdSet);
            List filterDys = Arrays.stream(existCandidateSetSalApplDys).filter(dy -> !idToApplDyMap.containsKey(dy.getLong("id"))).collect(Collectors.toList());
            Map<Long, DynamicObject> candidateIdMap = filterDys.stream().flatMap(dy -> dy.getDynamicObjectCollection("candsetsalperson").stream()).map(dy -> dy.getDynamicObject("candidate")).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
            Map onBrdBillIdToDepempIdMap = CandidateSetSalApplyHelper.getDepEmpIdByOnBrdBillId((Set)onBrdInfoIdSet);
            HashSet depEmpIds = Sets.newHashSet(onBrdBillIdToDepempIdMap.values());
            Map invalidAdjApprBills = CommonHcdmBizHelper.getInvalidAdjApprBillByDepEmpIdForCandApplValidation((Set)depEmpIds);
            Map invalidAdjRecords = CommonHcdmBizHelper.getInvalidAdjRecordByDepEmpId((Set)depEmpIds);
            Map stdScmMap = CandidateSetSalApplyHelper.getStdScmMapByVid((Set)Sets.newHashSet(idToStdScmVidMap.values()));
            HashMap excessControlMap = Maps.newHashMapWithExpectedSize((int)stdScmMap.size());
            HashMap isMatchGradeRankMap = Maps.newHashMapWithExpectedSize((int)stdScmMap.size());
            for (Map.Entry entry : stdScmMap.entrySet()) {
                DynamicObject stdScmDy = (DynamicObject)entry.getValue();
                long stdScmId = (Long)entry.getKey();
                DynamicObjectCollection entryEntity = stdScmDy.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryDy : entryEntity) {
                    long salStructureId = entryDy.getLong("salstructurent.id");
                    long standardItemId = entryDy.getLong("standarditem.id");
                    String excessControl = entryDy.getString("excesscontrol");
                    String isMatchGradeRank = entryDy.getString("ismatchgraderank");
                    String stdScmIdStr = String.valueOf(stdScmId);
                    String salStructureIdStr = String.valueOf(salStructureId);
                    String standardItemIdStr = String.valueOf(standardItemId);
                    String key = String.join((CharSequence)"-", stdScmIdStr, salStructureIdStr, standardItemIdStr);
                    excessControlMap.put(key, excessControl);
                    isMatchGradeRankMap.put(key, isMatchGradeRank);
                }
            }
            Map onBrdBillMap = CandidateSetSalApplyHelper.getOnBrdBillSelectPropsById((String)"id,effectdate,enrollstatus", (Set)onBrdInfoIdSet);
            Set hasDataRuleIds = null;
            QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"stdscmvid");
            if (dataRuleForBdProp != null) {
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_stdscm");
                dataRuleForBdProp.and("status", "=", (Object)"C");
                dataRuleForBdProp.and("enable", "=", (Object)"1");
                DynamicObject[] stdScmDys = helper.query("id", dataRuleForBdProp.toArray());
                hasDataRuleIds = Arrays.stream(stdScmDys).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toCollection(() -> new HashSet(stdScmDys.length)));
            }
            for (Object dataEntity : dataEntities) {
                DynamicObject dy4 = dataEntity.getDataEntity();
                DynamicObject personDy = (DynamicObject)dy4.getDynamicObjectCollection("candsetsalperson").get(0);
                DynamicObjectCollection records = personDy.getDynamicObjectCollection("persetsalrec");
                if (CollectionUtils.isEmpty((Collection)records)) continue;
                for (DynamicObject record : records) {
                    long salaryStdId = record.getLong("salarystd.id");
                    itemIds = stdItemMap.computeIfAbsent(salaryStdId, v2 -> Lists.newArrayList());
                    itemIds.add(record.getLong("standarditem.id"));
                }
            }
            SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
            Map salaryItemUseRankFlag = service.getSalaryItemUseRankFlag((Map)stdItemMap);
            HashMap orgAndSalaryStructureMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
            Set globalShareSalaryStructureIdSet = CandidateSetSalApplyHelper.getGlobalShareSalaryStructureIdSet();
            for (Object dataEntity : dataEntities) {
                ValidateResult validateResult2;
                ValidateResult validateResult;
                DynamicObject onBrdInfoDy;
                DynamicObject adjFileDy;
                DynamicObject personEntry;
                String matchMsg;
                DynamicObject personDy;
                DynamicObjectCollection recordDys;
                boolean isMustInputPass;
                String msg;
                DynamicObject personDy2;
                DynamicObject personDy3;
                DynamicObject onBrdInfoDy2;
                ValidateResult result1;
                String billStatus;
                DynamicObject dynamicObject2 = dataEntity.getDataEntity();
                DynamicObjectCollection personDys = dynamicObject2.getDynamicObjectCollection("candsetsalperson");
                if ("submit".equals(operateKey) && !"A".equals(billStatus = dynamicObject2.getString("billstatus")) && !"G".equals(billStatus)) {
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u6216\u5f85\u91cd\u65b0\u63d0\u4ea4\u7684\u5355\u636e\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"CandidateValidator_16", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if ("submiteffect".equals(operateKey) && !"A".equals(billStatus = dynamicObject2.getString("billstatus"))) {
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u53ef\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"CandidateValidator_17", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)personDys) && !(result1 = CandidateSetSalApplyHelper.checkCandidateEnrollStatus((DynamicObject)dynamicObject2, (DynamicObject)(onBrdInfoDy2 = (DynamicObject)onBrdBillMap.get((personDy3 = (DynamicObject)personDys.get(0)).getLong("onbrdinfo"))))).isSuccess()) {
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, (String)result1.getData());
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)personDys)) {
                    boolean pass = true;
                    personDy2 = (DynamicObject)personDys.get(0);
                    long candidateId = personDy2.getLong("candidate.id");
                    DynamicObject candidateDy = candidateIdMap.get(candidateId);
                    if (Objects.nonNull(candidateDy)) {
                        pass = false;
                        this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5019\u9009\u4eba{0}\u5df2\u5b58\u5728\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u65b0\u5efa\u3002", (String)"CandidateValidator_26", (String)"swc-hcdm-opplugin", (Object[])new Object[]{candidateDy.getString("name")}));
                    }
                    if (!pass) continue;
                }
                if (!CollectionUtils.isEmpty((Map)invalidAdjApprBills)) {
                    List adjApprBillList;
                    boolean pass = true;
                    personDy2 = (DynamicObject)personDys.get(0);
                    long onBrdInfoId = personDy2.getLong("onbrdinfo");
                    Long depEmpId = (Long)onBrdBillIdToDepempIdMap.get(onBrdInfoId);
                    if (Objects.nonNull(depEmpId) && !CollectionUtils.isEmpty((Collection)(adjApprBillList = (List)invalidAdjApprBills.get(depEmpId)))) {
                        pass = false;
                        msg = ResManager.loadKDString((String)"{0}{1}\u5df2\u5b58\u5728\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u521b\u5efa\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u3002", (String)"CandidateValidator_5", (String)"swc-hcdm-opplugin", (Object[])new Object[]{personDy2.getString("employeeno"), personDy2.getString("name")});
                        this.addErrorMessage((ExtendedDataEntity)dataEntity, msg);
                    }
                    if (!pass) continue;
                }
                if (!CollectionUtils.isEmpty((Map)invalidAdjRecords)) {
                    List invalidAdjRecordList;
                    boolean pass = true;
                    personDy2 = (DynamicObject)personDys.get(0);
                    long onBrdInfoId = personDy2.getLong("onbrdinfo");
                    Long depEmpId = (Long)onBrdBillIdToDepempIdMap.get(onBrdInfoId);
                    if (Objects.nonNull(depEmpId) && !CollectionUtils.isEmpty((Collection)(invalidAdjRecordList = (List)invalidAdjRecords.get(depEmpId)))) {
                        pass = false;
                        msg = ResManager.loadKDString((String)"{0}{1}\u5df2\u5b58\u5728\u5b9a\u8c03\u85aa\u8bb0\u5f55\uff0c\u65e0\u6cd5\u521b\u5efa\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u3002", (String)"CandidateValidator_6", (String)"swc-hcdm-opplugin", (Object[])new Object[]{personDy2.getString("employeeno"), personDy2.getString("name")});
                        this.addErrorMessage((ExtendedDataEntity)dataEntity, msg);
                    }
                    if (!pass) continue;
                }
                if (!dynamicObject2.getDataEntityState().getFromDatabase() && dynamicObject2.getBoolean("isdraft") || !(isMustInputPass = this.checkMustInputWithExt(isMatchGradeRankMap, salaryItemUseRankFlag, (ExtendedDataEntity)dataEntity, personDys))) continue;
                if (("submit".equals(operateKey) || "submiteffect".equals(operateKey)) && dynamicObject2.getBoolean("isdraft")) {
                    String msg2 = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u4e3a\u8349\u7a3f\u72b6\u6001\u65f6\uff0c\u65e0\u6cd5\u63d0\u4ea4\u6216\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"CandidateValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, msg2);
                    continue;
                }
                itemIds = Sets.newHashSetWithExpectedSize((int)16);
                if (!CollectionUtils.isEmpty((Collection)personDys) && !CollectionUtils.isEmpty((Collection)(recordDys = (personDy = (DynamicObject)personDys.get(0)).getDynamicObjectCollection("persetsalrec")))) {
                    for (DynamicObject recordDy : recordDys) {
                        long itemId = recordDy.getLong("standarditem.id");
                        if (itemIds.contains(itemId)) {
                            String msg3 = ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u4e2d\u7684\u540c\u4e00\u4e2a\u5019\u9009\u4eba\u5b58\u5728\u76f8\u540c\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\u3002", (String)"CandidateValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                            this.addErrorMessage((ExtendedDataEntity)dataEntity, msg3);
                            break;
                        }
                        itemIds.add(itemId);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)personDys)) {
                    Set useIds;
                    personDy = (DynamicObject)personDys.get(0);
                    long countryId = personDy.getLong("salarystructure.country.id");
                    if (countryId != dynamicObject2.getLong("country.id")) {
                        String msg4 = ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u4e2d\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u548c\u85aa\u916c\u7ed3\u6784\u4e0d\u5339\u914d\u3002", (String)"CandidateValidator_35", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage((ExtendedDataEntity)dataEntity, msg4);
                        continue;
                    }
                    long orgId = dynamicObject2.getLong("org.id");
                    long salaryStructureId = personDy.getLong("salarystructure.id");
                    if (!orgAndSalaryStructureMap.containsKey(orgId)) {
                        Set salaryStructureIdSet = CandidateSetSalApplyHelper.getSalaryStructureByOrgId((long)orgId);
                        orgAndSalaryStructureMap.put(orgId, salaryStructureIdSet);
                    }
                    if (!(!CollectionUtils.isEmpty((Collection)(useIds = (Set)orgAndSalaryStructureMap.get(orgId))) && useIds.contains(salaryStructureId) || globalShareSalaryStructureIdSet.contains(salaryStructureId))) {
                        String msg5 = ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u9875\u9762\u201c\u85aa\u916c\u7ed3\u6784\u201d\u6570\u636e\u8303\u56f4\u6743\u9650\u3002", (String)"CandidateValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entityDescName});
                        this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, msg5);
                        continue;
                    }
                    DynamicObject stdScmDy = personDy.getDynamicObject("stdscmvid");
                    if (Objects.nonNull(stdScmDy) && hasDataRuleIds != null && !hasDataRuleIds.contains(stdScmDy.getLong("id"))) {
                        this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u85aa\u916c\u4f53\u7cfb\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u6216\u65e0\u85aa\u916c\u4f53\u7cfb\u6570\u636e\u6743\u9650\u3002", (String)"CandidateValidator_33", (String)"swc-hcdm-opplugin", (Object[])new Object[]{entityDescName}));
                        continue;
                    }
                    String msg6 = CandidateSetSalApplyHelper.validSalStructAndStdScm((DynamicObject)personDy);
                    if (!StringUtils.isEmpty((CharSequence)msg6)) {
                        this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, msg6);
                        continue;
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)(matchMsg = (String)matchMsgMap.get(personEntry = (DynamicObject)personDys.get(0))))) {
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, matchMsg);
                    continue;
                }
                if (Objects.isNull(personEntry.getDynamicObject("salaryadjfile")) && Objects.nonNull(adjFileDy = (DynamicObject)candSetSalApplIdToAdjFileMap.get(dynamicObject2.getLong("id")))) {
                    Date bsled = adjFileDy.getDate("bsled");
                    Date setSalaryEffDt = personEntry.getDate("setsalaryeffdt");
                    if (Objects.nonNull(setSalaryEffDt) && !bsled.before(setSalaryEffDt)) {
                        String msg7 = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u5df2\u5b58\u5728\u5b9a\u8c03\u85aa\u6863\u6848{2}\u4e14\u751f\u5931\u6548\u65e5\u671f\u4e3a{3}\u81f3{4}\uff0c\u4e0d\u5141\u8bb8\u5728\u91cd\u590d\u7684\u65f6\u95f4\u6bb5\u518d\u521b\u5efa\u4e0d\u540c\u4fe1\u606f\u7684\u6863\u6848\uff0c\u8bf7\u8c03\u6574\u4ee5\u4e0b\u4efb\u4e00\u4fe1\u606f\u518d\u8bd5\uff1a\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u3001\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u3001\u85aa\u916c\u4f53\u7cfb\u3001\u751f\u6548\u65e5\u671f\u3002", (String)"CandidateValidator_4", (String)"swc-hcdm-opplugin", (Object[])new Object[]{personEntry.getString("candidate.name"), personEntry.getString("candidate.number"), adjFileDy.getString("number"), SWCDateTimeUtils.format((Date)adjFileDy.getDate("bsed"), (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)adjFileDy.getDate("bsled"), (String)"yyyy-MM-dd")});
                        this.addErrorMessage((ExtendedDataEntity)dataEntity, msg7);
                        continue;
                    }
                }
                long onBrdInfoId = personEntry.getLong("onbrdinfo");
                if (!CollectionUtils.isEmpty((Map)onBrdBillMap) && Objects.nonNull(onBrdInfoDy = (DynamicObject)onBrdBillMap.get(onBrdInfoId))) {
                    Date setSalaryEffDt = personEntry.getDate("setsalaryeffdt");
                    Date effectDateFromOnBrdInfo = onBrdInfoDy.getDate("effectdate");
                    if (Objects.nonNull(setSalaryEffDt) && Objects.nonNull(effectDateFromOnBrdInfo) && setSalaryEffDt.before(effectDateFromOnBrdInfo)) {
                        String msg8 = ResManager.loadKDString((String)"\u9ed8\u8ba4\u5b9a\u85aa\u751f\u6548\u65e5\u671f\u9700\u665a\u4e8e\u5165\u804c\u65e5\u671f\u3002", (String)"CandidateValidator_8", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage((ExtendedDataEntity)dataEntity, msg8);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)personDys)) {
                    DynamicObject personDy4 = (DynamicObject)personDys.get(0);
                    long stdScmVidId = personDy4.getLong("stdscmvid.id");
                    long salaryStructureId = personDy4.getLong("salarystructure.id");
                    DynamicObjectCollection recordDys2 = personDy4.getDynamicObjectCollection("persetsalrec");
                    if (!CollectionUtils.isEmpty((Collection)recordDys2)) {
                        for (DynamicObject recordDy : recordDys2) {
                            long standardItemId = recordDy.getLong("standarditem.id");
                            String overStandardType = recordDy.getString("overstandardtype");
                            String stdScmIdStr = String.valueOf(stdScmVidId);
                            String salStructureIdStr = String.valueOf(salaryStructureId);
                            String standardItemIdStr = String.valueOf(standardItemId);
                            String excessControl = (String)excessControlMap.get(String.join((CharSequence)"-", stdScmIdStr, salStructureIdStr, standardItemIdStr));
                            if (!ExcessControlEnum.CANNOT_EXCCONTROL.getCode().equals(excessControl) || !OverStandardTypeEnum.BELOW_LIMIT.getCode().equals(overStandardType) && !OverStandardTypeEnum.UPPER_LIMIT.getCode().equals(overStandardType)) continue;
                            String msg9 = ResManager.loadKDString((String)"\u5de5\u53f7\u201c{0}\u201d\u5019\u9009\u4eba\u59d3\u540d\u201c{1}\u201d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee{2}\u7684\u91d1\u989d\u8d85\u6807\u51c6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"CandidateValidator_7", (String)"swc-hcdm-opplugin", (Object[])new Object[]{personDy4.getString("employeeno"), personDy4.getString("name"), recordDy.getString("standarditem.name")});
                            this.addErrorMessage((ExtendedDataEntity)dataEntity, msg9);
                        }
                    }
                }
                if (!(validateResult = CandidateSetSalApplyHelper.checkStdScmEffectTimeAndEffectTime((DynamicObject)dynamicObject2)).isSuccess()) {
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, (String)validateResult.getData());
                    continue;
                }
                ValidateResult validateResult1 = CandidateSetSalApplyHelper.checkItemBsedAndEffectTime((DynamicObject)dynamicObject2);
                if (!validateResult1.isSuccess()) {
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, (String)validateResult1.getData());
                }
                if ((validateResult2 = CandidateSetSalApplyHelper.checkItemBsedAndBsled((DynamicObject)dynamicObject2)).isSuccess()) continue;
                this.addErrorMessage((ExtendedDataEntity)dataEntity, (String)validateResult2.getData());
            }
        }
    }

    private boolean checkMustInputWithExt(Map<String, String> isMatchGradeRankMap, Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag, ExtendedDataEntity dataEntity, DynamicObjectCollection personDys) {
        DynamicObject personDy;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        boolean pass = true;
        String billNo = dynamicObject.getString("billno");
        if (this.readMetaMustInputInfo("billno") && Strings.isNullOrEmpty((String)billNo)) {
            pass = false;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CandidateValidator_34", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
        }
        DynamicObject org = dynamicObject.getDynamicObject("org");
        if (this.readMetaMustInputInfo("org") && Objects.isNull(org)) {
            pass = false;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CandidateValidator_30", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
        }
        DynamicObject country = dynamicObject.getDynamicObject("country");
        if (this.readMetaMustInputInfo("country") && Objects.isNull(country)) {
            pass = false;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u201d\u3002", (String)"CandidateValidator_31", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
        }
        DynamicObject salaryAdjRsn = dynamicObject.getDynamicObject("salaryadjrsn");
        if (this.readMetaMustInputInfo("salaryadjrsn") && Objects.isNull(salaryAdjRsn)) {
            pass = false;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u7c7b\u578b\u201d\u3002", (String)"CandidateValidator_32", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)personDys)) {
            personDy = (DynamicObject)personDys.get(0);
            DynamicObject depcyType = personDy.getDynamicObject("depcytype");
            if (this.readMetaMustInputInfo("depcytype") && Objects.isNull(depcyType)) {
                pass = false;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5c5e\u5730\u5458\u5de5\u7c7b\u522b\u201d\u3002", (String)"CandidateValidator_10", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
            }
            DynamicObject salaryStructure = personDy.getDynamicObject("salarystructure");
            if (this.readMetaMustInputInfo("salarystructure") && Objects.isNull(salaryStructure)) {
                pass = false;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u85aa\u916c\u7ed3\u6784\u201d\u3002", (String)"CandidateValidator_11", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
            }
            DynamicObject stdScmVid = personDy.getDynamicObject("stdscmvid");
            if (this.readMetaMustInputInfo("stdscmvid") && Objects.isNull(stdScmVid)) {
                pass = false;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u85aa\u916c\u4f53\u7cfb\u201d\u3002", (String)"CandidateValidator_12", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
            }
            DynamicObject adminOrg = personDy.getDynamicObject("adminorg");
            if (this.readMetaMustInputInfo("adminorg") && Objects.isNull(adminOrg)) {
                pass = false;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\u3002", (String)"CandidateValidator_13", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
            }
            DynamicObject empGroup = personDy.getDynamicObject("empgroup");
            if (this.readMetaMustInputInfo("empgroup") && Objects.isNull(empGroup)) {
                pass = false;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4\u201d\u3002", (String)"CandidateValidator_14", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
            }
            Date setSalaryEffDt = personDy.getDate("setsalaryeffdt");
            if (this.readMetaMustInputInfo("setsalaryeffdt") && Objects.isNull(setSalaryEffDt)) {
                pass = false;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9ed8\u8ba4\u5b9a\u85aa\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"CandidateValidator_15", (String)"swc-hcdm-opplugin", (Object[])new Object[0]));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)personDys)) {
            personDy = (DynamicObject)personDys.get(0);
            DynamicObjectCollection recordDys = personDy.getDynamicObjectCollection("persetsalrec");
            if (!CollectionUtils.isEmpty((Collection)recordDys)) {
                for (DynamicObject recordDy : recordDys) {
                    long gradeId;
                    String standardItemIdStr;
                    String salStructureIdStr;
                    long salaryStdId;
                    Map<Long, Boolean> flagMap;
                    BigDecimal amount;
                    DynamicObject standardItemDy = recordDy.getDynamicObject("standarditem");
                    if (this.readMetaMustInputInfo("standarditem") && Objects.isNull(standardItemDy)) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c{0}\u884c\uff1a\u5b9a\u8c03\u85aa\u9879\u76ee\u3002", (String)"CandidateValidator_21", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getInt("seq")});
                        pass = false;
                        this.addFatalErrorMessage(dataEntity, msg);
                    }
                    DynamicObject frequencyDy = recordDy.getDynamicObject("frequency");
                    if (this.readMetaMustInputInfo("frequency") && Objects.isNull(frequencyDy)) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c{0}\u884c\uff1a\u9891\u5ea6\u3002", (String)"CandidateValidator_22", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getInt("seq")});
                        pass = false;
                        this.addFatalErrorMessage(dataEntity, msg);
                    }
                    if (Objects.isNull(amount = recordDy.getBigDecimal("amount")) && this.readMetaMustInputInfo("amount")) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c{0}\u884c\uff1a\u91d1\u989d\u3002", (String)"CandidateValidator_23", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getInt("seq")});
                        pass = false;
                        this.addFatalErrorMessage(dataEntity, msg);
                    }
                    DynamicObject currency = recordDy.getDynamicObject("currency");
                    if (this.readMetaMustInputInfo("currency") && Objects.isNull(currency)) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c{0}\u884c\uff1a\u5b9a\u85aa\u5e01\u79cd\u3002", (String)"CandidateValidator_39", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getInt("seq")});
                        pass = false;
                        this.addFatalErrorMessage(dataEntity, msg);
                    }
                    String issend = recordDy.getString("issend");
                    if (this.readMetaMustInputInfo("issend") && Strings.isNullOrEmpty((String)issend)) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c{0}\u884c\uff1a\u8bd5\u7528\u671f\u662f\u5426\u5168\u989d\u53d1\u653e\u3002", (String)"CandidateValidator_24", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getInt("seq")});
                        pass = false;
                        this.addFatalErrorMessage(dataEntity, msg);
                    }
                    Date itemBsed = recordDy.getDate("itembsed");
                    if (this.readMetaMustInputInfo("itembsed") && Objects.isNull(itemBsed)) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c{0}\u884c\uff1a\u751f\u6548\u65e5\u671f\u3002", (String)"CandidateValidator_25", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getInt("seq")});
                        pass = false;
                        this.addFatalErrorMessage(dataEntity, msg);
                    }
                    long itemId = recordDy.getLong("standarditem.id");
                    DynamicObject salaryStdDy = recordDy.getDynamicObject("salarystd");
                    if (Objects.isNull(salaryStdDy)) continue;
                    String salaRel = recordDy.getString("salarel");
                    if (Strings.isNullOrEmpty((String)salaRel)) {
                        String msg = ResManager.loadKDString((String)"{0}\uff1a\u672a\u5339\u914d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u6dfb\u52a0\u3002", (String)"CandidateValidator_36", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getString("standarditem.name")});
                        pass = false;
                        this.addFatalErrorMessage(dataEntity, msg);
                    }
                    if (CollectionUtils.isEmpty(flagMap = salaryItemUseRankFlag.get(salaryStdId = salaryStdDy.getLong("id")))) continue;
                    Boolean useRank = flagMap.get(itemId);
                    long stdScmVidId = personDy.getLong("stdscmvid.id");
                    long salaryStructureId = personDy.getLong("salarystructure.id");
                    String stdScmIdStr = String.valueOf(stdScmVidId);
                    String isMatchGradeRank = isMatchGradeRankMap.get(String.join((CharSequence)"-", stdScmIdStr, salStructureIdStr = String.valueOf(salaryStructureId), standardItemIdStr = String.valueOf(itemId)));
                    if (!SWCStringUtils.equals((String)"1", (String)isMatchGradeRank)) continue;
                    if (useRank.booleanValue()) {
                        String msg;
                        gradeId = recordDy.getLong("grade.id");
                        long rankId = recordDy.getLong("rank.id");
                        if (gradeId == 0L) {
                            msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c{0}\u884c\uff1a\u85aa\u7b49\u3002", (String)"CandidateValidator_19", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getInt("seq")});
                            pass = false;
                            this.addFatalErrorMessage(dataEntity, msg);
                        }
                        if (rankId != 0L) continue;
                        msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c{0}\u884c\uff1a\u85aa\u6863\u3002", (String)"CandidateValidator_20", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getInt("seq")});
                        pass = false;
                        this.addFatalErrorMessage(dataEntity, msg);
                        continue;
                    }
                    gradeId = recordDy.getLong("grade.id");
                    if (gradeId != 0L) continue;
                    String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u201d\u7b2c{0}\u884c\uff1a\u85aa\u7b49\u3002", (String)"CandidateValidator_19", (String)"swc-hcdm-opplugin", (Object[])new Object[]{recordDy.getInt("seq")});
                    this.addFatalErrorMessage(dataEntity, msg);
                    pass = false;
                }
            } else if (this.readMetaMustInputInfo("persetsalrec")) {
                String msg = ResManager.loadKDString((String)"\u5b9a\u85aa\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CandidateValidator_28", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, msg);
                pass = false;
            }
        }
        return pass;
    }

    private void initFieldPropMap() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hcdm_singlecandsetsalappl");
        this.mainFieldPropMap = mainType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (v1, v2) -> v2));
        EntityType personType = (EntityType)mainType.getAllEntities().get("candsetsalperson");
        this.personFieldPropMap = personType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (v1, v2) -> v2));
        EntityType itemType = (EntityType)mainType.getAllEntities().get("persetsalrec");
        this.itemFieldPropMap = itemType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (v1, v2) -> v2));
    }

    private boolean readMetaMustInputInfo(String field) {
        if (mustInputFieldsOnAuditPass.contains(field) && ("submiteffect".equals(this.getOperateKey()) || "donothing_wfvalidate".equals(this.getOperateKey()))) {
            return true;
        }
        if (mustInputFieldOnSpecial.contains(field)) {
            return true;
        }
        IDataEntityProperty iDataEntityProperty = null;
        if (this.mainFieldPropMap.containsKey(field)) {
            iDataEntityProperty = this.mainFieldPropMap.get(field);
        } else if (this.personFieldPropMap.containsKey(field)) {
            iDataEntityProperty = this.personFieldPropMap.get(field);
        } else if (this.itemFieldPropMap.containsKey(field)) {
            iDataEntityProperty = this.itemFieldPropMap.get(field);
        }
        if (iDataEntityProperty == null) {
            return true;
        }
        if (iDataEntityProperty instanceof LongProp) {
            return ((LongProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof TextProp) {
            return ((TextProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof BillStatusProp) {
            return ((BillStatusProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof CreaterProp) {
            return ((CreaterProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof OrgProp) {
            return ((OrgProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof BasedataProp) {
            return ((BasedataProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof BooleanProp) {
            return ((BooleanProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof ComboProp) {
            return ((ComboProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof IntegerProp) {
            return ((IntegerProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof DateProp) {
            return ((DateProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof DateTimeProp) {
            return ((DateTimeProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof BigIntProp) {
            return ((BigIntProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof MuliLangTextProp) {
            return ((MuliLangTextProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof MulBasedataProp) {
            return ((MulBasedataProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof CurrencyProp) {
            return ((CurrencyProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof AmountProp) {
            return ((AmountProp)iDataEntityProperty).isMustInput();
        }
        if (iDataEntityProperty instanceof DecimalProp) {
            return ((DecimalProp)iDataEntityProperty).isMustInput();
        }
        return true;
    }

    static {
        mustInputFieldsOnAuditPass.add("standarditem");
        mustInputFieldsOnAuditPass.add("itembsed");
        mustInputFieldOnSpecial = new HashSet<String>(16);
        mustInputFieldOnSpecial.add("depcytype");
        mustInputFieldOnSpecial.add("salarystructure");
        mustInputFieldOnSpecial.add("stdscmvid");
        mustInputFieldOnSpecial.add("adminorg");
        mustInputFieldOnSpecial.add("empgroup");
        mustInputFieldOnSpecial.add("setsalaryeffdt");
    }
}

