/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.canditate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.salarystandardscm.SalaryStandardScmHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class CandidateSaveValidator
extends AbstractValidator {
    private final Log LOGGER = LogFactory.getLog(CandidateSaveValidator.class);

    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        HashMap salaryadjOrgMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        HashMap salaryStructureMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (Object dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            if (null == dy.get("salaryadjorg")) {
                salaryadjOrgMap.put(dy.getLong("offerid"), dataEntity);
            }
            if (null != dy.get("stdscm") || null == dy.get("salarystructure")) continue;
            List list = salaryStructureMap.computeIfAbsent(dy.getLong("salarystructure.id"), key -> Lists.newArrayListWithExpectedSize((int)4));
            list.add(dataEntity);
        }
        this.getSalaryAdjOrgByOfferID(salaryadjOrgMap);
        this.getStdScm(salaryStructureMap);
    }

    private void getSalaryAdjOrgByOfferID(HashMap<Long, ExtendedDataEntity> salaryAdjOrgMap) {
        if (CollectionUtils.isEmpty(salaryAdjOrgMap)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("tso_somk_offerbase");
        QFilter filter = new QFilter("id", "in", salaryAdjOrgMap.keySet());
        Object[] dys = helper.query("id,peadminorg.id", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)dys.length);
        for (Object dy : dys) {
            List list = map.computeIfAbsent(dy.getLong("peadminorg.id"), key -> Lists.newArrayListWithExpectedSize((int)16));
            list.add(dy.getLong("id"));
        }
        if (!CollectionUtils.isEmpty((Map)map)) {
            HashMap orgId2BusinessType = Maps.newHashMapWithExpectedSize((int)map.size());
            for (Long aAdminOrgId : map.keySet()) {
                orgId2BusinessType.put(aAdminOrgId, Sets.newHashSet((Object[])new Long[]{107020L}));
            }
            this.LOGGER.info("CandidateSaveValidator.getSalaryadjOrgByofferID pram= {}", (Object)orgId2BusinessType);
            List result = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, 1010L});
            this.LOGGER.info("CandidateSaveValidator.getSalaryadjOrgByofferID result= {}", (Object)result);
            HashMap buMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty((Collection)result)) {
                for (Map map2 : result) {
                    buMap.put(map2.get("adminOrgId"), map2.get("hrBuId"));
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                Long hrBuId = (Long)buMap.get(entry.getKey());
                for (Long offerID : (List)entry.getValue()) {
                    ExtendedDataEntity dataEntity = salaryAdjOrgMap.get(offerID);
                    dataEntity.getDataEntity().set("salaryadjorg", (Object)hrBuId);
                }
            }
        }
    }

    private void getStdScm(HashMap<Long, List<ExtendedDataEntity>> salaryStructureMap) {
        if (CollectionUtils.isEmpty(salaryStructureMap)) {
            return;
        }
        Map listMap = SalaryStandardScmHelper.queryStdScmMapByStructureIds(salaryStructureMap.keySet());
        if (CollectionUtils.isEmpty((Map)listMap)) {
            return;
        }
        for (Map.Entry<Long, List<ExtendedDataEntity>> entry : salaryStructureMap.entrySet()) {
            for (ExtendedDataEntity dataEntity : entry.getValue()) {
                List list = (List)listMap.get(entry.getKey());
                this.getStdScmVid(dataEntity, list);
            }
        }
    }

    private void getStdScmVid(ExtendedDataEntity dataEntity, List<DynamicObject> list) {
        if (!CollectionUtils.isEmpty(list)) {
            if (list.size() == 1) {
                dataEntity.getDataEntity().set("stdscm", (Object)list.get(0).getLong("sourcevid"));
                return;
            }
            if (null == dataEntity.getDataEntity().get("salaryadjorg")) {
                return;
            }
            for (DynamicObject stdScmDy : list) {
                if (stdScmDy.getLong("createorg.id") != dataEntity.getDataEntity().getLong("salaryadjorg.id")) continue;
                dataEntity.getDataEntity().set("stdscm", (Object)stdScmDy.getLong("sourcevid"));
            }
        }
    }
}

