/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.coefficient;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hcdm.business.HCDMDbHelper;

public class CoefficientTabUnAuditValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, ExtendedDataEntity> tabIdEntityMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        ArrayList<Long> tabIdList = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long tabId = dataEntity.getDataEntity().getLong("id");
            tabIdEntityMap.put(tabId, dataEntity);
            tabIdList.add(tabId);
        }
        Set<Long> receivedTabIds = this.queryReceivedTabIds(tabIdList);
        String pattern = ResManager.loadKDString((String)"\u201c\u85aa\u916c\u6807\u51c6\u7cfb\u6570\u8868-{0}\u201d\u5df2\u5173\u8054\u7cfb\u6570\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"CoefficientTabUnAuditValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        for (Long receivedTabId : receivedTabIds) {
            ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)tabIdEntityMap.get(receivedTabId);
            if (extendedDataEntity == null) continue;
            String content = MessageFormat.format(pattern, extendedDataEntity.getDataEntity().getString("name"));
            this.addFatalErrorMessage(extendedDataEntity, content);
        }
    }

    private Set<Long> queryReceivedTabIds(List<Long> tabIdList) {
        String sql = "select c.fcoefficienttabid tabid,count(c.fid) coeffnum from t_hcdm_coefficient c where  c.fcoefficienttabid in " + HCDMDbHelper.getFidHolder((int)tabIdList.size()) + " group by c.fcoefficienttabid";
        ArrayList<Long> paramList = new ArrayList<Long>(10);
        paramList.addAll(tabIdList);
        HashSet<Long> errorSet = new HashSet<Long>(tabIdList.size());
        try (DataSet queryDataSet = HCDMDbHelper.queryDataSet((String)sql, (Object[])paramList.toArray());){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                Integer coeffNum = row.getInteger("coeffnum");
                if (coeffNum == null || coeffNum <= 0) continue;
                errorSet.add(row.getLong("tabid"));
            }
        }
        return errorSet;
    }
}

