/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.salaryadjfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprValidateHelper;
import kd.swc.hcdm.business.adjapprbill.entity.ExRateKey;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.adjapprbill.enums.ExcessControlEnum;
import kd.swc.hcdm.business.adjapprbill.enums.OverStandardTypeEnum;
import kd.swc.hcdm.opplugin.validator.InteractionExceptionWrapper;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.DecAdjApprBaseValidator;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.StringUtils;

public class AdjApprovalSaveValidator
extends DecAdjApprBaseValidator {
    private static final String NOT_CHOOSE_ADJSCM = "0";
    private MainEntityType adjPersonEntityType;
    private BillExRateManager rateManager = new BillExRateManager();
    private Map<Long, List<String>> mustInputFields;

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String attributionTypeStr = dataEntity.getDataEntity().getString("salaryadjrsn.attributiontype");
            AdjAttributionType adjAttributionType = AdjAttributionType.getByCode((String)attributionTypeStr);
            this.validateDecAdjEntity(dataEntity, adjAttributionType);
        }
        if (this.checkIsOverStandardException != null && dataEntities.length == 1 && !this.getFalseDataEntities().contains(dataEntities[0])) {
            throw this.completeInteractionMsg(this.checkIsOverStandardException);
        }
        if (this.checkExRateChangedException != null && dataEntities.length == 1 && !this.getFalseDataEntities().contains(dataEntities[0])) {
            throw this.completeInteractionMsg(this.checkExRateChangedException);
        }
    }

    private void validateDecAdjEntity(ExtendedDataEntity dataEntity, AdjAttributionType attributionType) {
        String operateKey = this.getOperateKey();
        if (this.validateCountry(dataEntity)) {
            return;
        }
        this.checkOperationWithScm(dataEntity);
        this.checkHasPersonNew(dataEntity, attributionType);
        List<Long> allAdjApprPersonId = this.getAllAdjApprPersonId(dataEntity.getDataEntity());
        int batch = Integer.parseInt(System.getProperty("swc_hcdm_enableAdjBillEntryValidateBatch", "500"));
        ListUtils.partition(allAdjApprPersonId, (int)batch).forEach(list -> {
            DynamicObject[] adjApprPersonData = this.getAdjApprPersonData(dataEntity.getDataEntity(), (List<Long>)list);
            this.checkEntryRowMustInput(dataEntity, adjApprPersonData, attributionType);
            this.checkMatchStdRange(dataEntity, adjApprPersonData);
            this.checkGradeOrRankIsEmpty(dataEntity, adjApprPersonData, attributionType);
            this.checkExRateDataNotSet(dataEntity, adjApprPersonData, attributionType);
            this.checkIsOverStandard(dataEntity, adjApprPersonData, attributionType);
            this.checkEmpposorgrelAvailable(dataEntity, adjApprPersonData);
            this.checkRepeatDecAdj(dataEntity, adjApprPersonData);
            this.checkStandardItemRepeat(dataEntity, adjApprPersonData);
            this.checkSalBsledDate(dataEntity, adjApprPersonData, attributionType);
            this.checkEffectiveDate(dataEntity, adjApprPersonData, attributionType);
            this.checkExRateChanged(dataEntity, attributionType, adjApprPersonData);
            this.checkCandidateExists(dataEntity, attributionType, adjApprPersonData);
            this.checkInitExists(dataEntity, adjApprPersonData);
        });
    }

    private KDInteractionException completeInteractionMsg(InteractionExceptionWrapper checkIsOverStandardException) {
        String msg = StringUtils.join((Collection)((List)checkIsOverStandardException.getCustomParam().get("msgList")), (String)"<br/>");
        KDInteractionException exception = checkIsOverStandardException.getException();
        exception.getInteractionContext().getCustShowParameter().put("errorMsg", msg);
        return exception;
    }

    private void checkIsOverStandard(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData, AdjAttributionType attributionType) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkIsOverStandard", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        List<Object> excErrorMsgList = new ArrayList(adjApprPersonData.length);
        String msgTplOfCanNot = ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\uff1a%3$s\u7684\u91d1\u989d\u8d85\u6807\u51c6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjApproveBillEdit_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String confirmTitle = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\u5df2\u8d85\u6807\u51c6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdjApproveBillEdit_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String msgTplOfNeedConfirm = ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\uff1a%3$s\u7684\u91d1\u989d\u8d85\u6807\u51c6\u3002", (String)"AdjApproveBillEdit_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        ArrayList<String> noExcErrorMsgList = new ArrayList<String>(10);
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            String name = adjPersonDyObj.getString("name");
            String number = adjPersonDyObj.getString("number");
            DynamicObjectCollection adjApprPersonEntryDyObjs = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntryDyObj : adjApprPersonEntryDyObjs) {
                String errorMsg2;
                String excessControl = adjApprPersonEntryDyObj.getString("excesscontrol");
                String overStandardType = adjApprPersonEntryDyObj.getString("overstandardtype");
                String standardItemName = adjApprPersonEntryDyObj.getString("standarditem.name");
                if (ExcessControlEnum.CANNOT_EXCCONTROL.getCode().equals(excessControl) && (OverStandardTypeEnum.BELOW_LIMIT.getCode().equals(overStandardType) || OverStandardTypeEnum.UPPER_LIMIT.getCode().equals(overStandardType))) {
                    errorMsg2 = String.format(Locale.ROOT, msgTplOfCanNot, name, number, standardItemName);
                    excErrorMsgList.add(errorMsg2);
                    continue;
                }
                if (!ExcessControlEnum.CAN_EXCCONTROL.getCode().equals(excessControl) || !OverStandardTypeEnum.BELOW_LIMIT.getCode().equals(overStandardType) && !OverStandardTypeEnum.UPPER_LIMIT.getCode().equals(overStandardType)) continue;
                errorMsg2 = String.format(Locale.ROOT, msgTplOfNeedConfirm, name, number, standardItemName);
                noExcErrorMsgList.add(errorMsg2);
            }
        }
        excErrorMsgList = excErrorMsgList.stream().distinct().collect(Collectors.toList());
        excErrorMsgList.forEach(errorMsg -> this.addFatalErrorMessage(dataEntity, (String)errorMsg));
        if (!this.getFalseDataEntities().contains(dataEntity) && excErrorMsgList.isEmpty() && noExcErrorMsgList.size() >= 1) {
            String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
            InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
            String result = (String)confirmResult.getResults().get(CHECKISOVERSTANDARD_SPONSOR);
            boolean approveWfPageFlag = this.getOption().tryGetVariableValue("approvewfpageflag", new RefObject());
            if (result == null && !approveWfPageFlag) {
                if (this.checkIsOverStandardException == null) {
                    InteractionContext interactionContext = new InteractionContext();
                    interactionContext.setCustShowFormId("hsbp_operationconfirm");
                    interactionContext.getCustShowParameter().put("title", confirmTitle);
                    interactionContext.getCustShowParameter().put("errorMsg", null);
                    KDInteractionException exception = new KDInteractionException(CHECKISOVERSTANDARD_SPONSOR, interactionContext);
                    this.checkIsOverStandardException = new InteractionExceptionWrapper(exception);
                    this.checkIsOverStandardException.getCustomParam().put("msgList", noExcErrorMsgList);
                } else {
                    List msgList = (List)this.checkIsOverStandardException.getCustomParam().get("msgList");
                    if (msgList != null) {
                        msgList.addAll(noExcErrorMsgList);
                    }
                }
            }
        }
    }

    private List<String> getMustInputFieldFromCfg(DynamicObject dataEntity) {
        long adjFieldCfgId = dataEntity.getLong("adjfieldcfg.id");
        if (adjFieldCfgId > 0L) {
            if (this.mustInputFields == null) {
                this.mustInputFields = Maps.newHashMapWithExpectedSize((int)16);
            }
            if (!this.mustInputFields.containsKey(adjFieldCfgId)) {
                DynamicObject adjFieldCfgWithPerm = this.adjApprovalApplicationService.getAdjFieldCfgById(Long.valueOf(adjFieldCfgId));
                DynamicObjectCollection adjFieldCfgWithPermDetail = adjFieldCfgWithPerm.getDynamicObjectCollection("entryentity");
                List collect = adjFieldCfgWithPermDetail.stream().filter(val -> StringUtils.equals((String)val.getString("adjdetailfield.mustinput"), (String)"1")).map(key -> key.getString("adjdetailfield.fieldnumber")).collect(Collectors.toList());
                this.mustInputFields.put(adjFieldCfgId, collect);
            }
            return Lists.newArrayList((Iterable)this.mustInputFields.get(adjFieldCfgId));
        }
        return Collections.emptyList();
    }

    private void checkEmpposorgrelAvailable(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkEmpposorgrelAvailable", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        ArrayList fileIds = Lists.newArrayListWithExpectedSize((int)adjApprPersonData.length);
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            long fileId = adjPersonDyObj.getLong("adjfile.id");
            if (fileId <= 0L) continue;
            fileIds.add(fileId);
        }
        Map checkResult = this.fileApplicationService.checkEmpposorgrelAvailable((Collection)fileIds);
        String messageTpl = ResManager.loadKDString((String)"\u5de5\u53f7\uff08%1$s\uff09\uff1a\u6863\u6848\u5173\u8054\u4efb\u804c\u5df2\u5e9f\u5f03\uff0c\u8bf7\u8c03\u6574\u6863\u6848\u57fa\u672c\u4fe1\u606f\u3002", (String)"DecAdjApprBaseValidator_16", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            String number = adjPersonDyObj.getString("number");
            long fileId = adjPersonDyObj.getLong("adjfile.id");
            if (fileId <= 0L || checkResult.getOrDefault(fileId, Boolean.FALSE).booleanValue()) continue;
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, messageTpl, number));
        }
    }

    private void checkMatchStdRange(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkMatchStdRange", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        List<Object> errorMessageList = new ArrayList(adjApprPersonData.length);
        String messageTpl = ResManager.loadKDString((String)"%1$s\uff1a%2$s\uff08%3$s\uff09\u672a\u5339\u914d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u6dfb\u52a0\u3002", (String)"DecAdjApprValidateHelper_2", (String)"swc-hcdm-business", (Object[])new Object[0]);
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            DynamicObjectCollection itemEntry = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            String adjFileNumber = adjPersonDyObj.getString("adjfile.number");
            String personName = adjPersonDyObj.getString("name");
            String empNumber = adjPersonDyObj.getString("number");
            for (DynamicObject itemRow : itemEntry) {
                DynamicObject salaryStdDyObj = itemRow.getDynamicObject("salarystd");
                DynamicObject stdItemDyObj = itemRow.getDynamicObject("standarditem");
                String salaryToGradeAndRankRel = itemRow.getString("salargrel");
                if (stdItemDyObj == null || salaryStdDyObj == null || !StringUtils.isBlank((String)salaryToGradeAndRankRel)) continue;
                String stdTableErrorMsg = String.format(Locale.ROOT, messageTpl, adjFileNumber, personName, empNumber);
                errorMessageList.add(stdTableErrorMsg);
            }
        }
        errorMessageList = errorMessageList.stream().distinct().collect(Collectors.toList());
        errorMessageList.forEach(errorMsg -> this.addFatalErrorMessage(dataEntity, (String)errorMsg));
    }

    private void checkEntryRowMustInput(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData, AdjAttributionType attributionType) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkEntryRowMustInput", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        List<String> mustInputFieldFromCfg = this.getMustInputFieldFromCfg(dataEntity.getDataEntity());
        boolean approveWfPageFlag = this.getOption().tryGetVariableValue("approvewfpageflag", new RefObject());
        if (approveWfPageFlag) {
            mustInputFieldFromCfg.add("standarditem");
            mustInputFieldFromCfg.add("salbsed");
        } else if ("donothing_submiteffect".equals(this.getOperateKey())) {
            mustInputFieldFromCfg.add("standarditem");
            mustInputFieldFromCfg.add("salbsed");
        }
        List<String> errorMessageList = DecAdjApprValidateHelper.validateEntryRowMustInputForPerson((DynamicObject[])adjApprPersonData, mustInputFieldFromCfg, (AdjAttributionType)attributionType);
        errorMessageList = errorMessageList.stream().distinct().collect(Collectors.toList());
        errorMessageList.forEach(errorMsg -> this.addFatalErrorMessage(dataEntity, (String)errorMsg));
    }

    private void checkGradeOrRankIsEmpty(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData, AdjAttributionType attributionType) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkGradeOrRankIsEmpty", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        List<Object> errorMessageList = new ArrayList(adjApprPersonData.length);
        String messageTpl = ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u660e\u7ec6\u4fe1\u606f\u4e2d%2$s\uff08%3$s\uff09\u7684\u201c%4$s\u201d\u5b57\u6bb5\u3002", (String)"DecAdjApprValidateHelper_10", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String attributionTypeName = attributionType.getDisplayName();
        EntryProp entryProp = (EntryProp)this.getAdjPersonEntityType().getProperty("entryentity");
        DataEntityPropertyCollection entryPropMap = entryProp.getDynamicCollectionItemPropertyType().getProperties();
        Map itemUseRankFlag = DecAdjApprGridHelper.getItemUseRankFlagDb((List)Lists.newArrayList((Object[])adjApprPersonData));
        String gradeFieldName = ((IDataEntityProperty)entryPropMap.get((Object)"grade")).getDisplayName().getLocaleValue();
        String rankFieldName = ((IDataEntityProperty)entryPropMap.get((Object)"rank")).getDisplayName().getLocaleValue();
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            DynamicObjectCollection itemEntry = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            String personName = adjPersonDyObj.getString("name");
            String empNumber = adjPersonDyObj.getString("number");
            for (DynamicObject itemRow : itemEntry) {
                String isMatchGradeRank;
                DynamicObject salaryStdDyObj = itemRow.getDynamicObject("salarystd");
                if (Objects.isNull(salaryStdDyObj) || !SWCStringUtils.equals((String)"1", (String)(isMatchGradeRank = itemRow.getString("ismatchgraderank")))) continue;
                String calcType = itemRow.getString("calctype");
                boolean isUseRank = DecAdjApprGridHelper.checkItemUseRankDb((DynamicObject)itemRow, (Map)itemUseRankFlag);
                if (AdjAttributionType.DECATTRTYPE != attributionType && (AdjAttributionType.ADJATTRTYPE != attributionType || !CalcType.GRADE_RANK.getCode().equals(calcType))) continue;
                if (itemRow.get("grade") == null) {
                    errorMessageList.add(String.format(Locale.ROOT, messageTpl, attributionTypeName, personName, empNumber, gradeFieldName));
                }
                if (!isUseRank || itemRow.get("rank") != null) continue;
                errorMessageList.add(String.format(Locale.ROOT, messageTpl, attributionTypeName, personName, empNumber, rankFieldName));
            }
        }
        errorMessageList = errorMessageList.stream().distinct().collect(Collectors.toList());
        errorMessageList.forEach(errorMsg -> this.addFatalErrorMessage(dataEntity, (String)errorMsg));
    }

    private void checkExRateDataNotSet(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData, AdjAttributionType attributionType) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkExRateDataNotSet", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        List<Object> errorMessageList = new ArrayList(adjApprPersonData.length);
        String messageTpl = ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\uff1a\u6c47\u7387\u8868\u4e2d\u672a\u627e\u5230%3$s\u7684\u6c47\u7387\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u516c\u5171\u6570\u636e-\u6c47\u7387\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"DecAdjApprValidateHelper_11", (String)"swc-hcdm-business", (Object[])new Object[0]);
        Date rateDate = dataEntity.getDataEntity().getDate("exchangeratedate");
        long excTableId = dataEntity.getDataEntity().getLong("exctable.id");
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            DynamicObjectCollection itemEntry = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            String personName = adjPersonDyObj.getString("name");
            String empNumber = adjPersonDyObj.getString("number");
            for (DynamicObject itemRow : itemEntry) {
                ExchangeRateInfo exrateBd;
                DynamicObject salaryStdDyObj = itemRow.getDynamicObject("salarystd");
                if (Objects.isNull(salaryStdDyObj)) continue;
                if (AdjAttributionType.ADJATTRTYPE == attributionType) {
                    String calcType = itemRow.getString("calctype");
                    BigDecimal actualRange = itemRow.getBigDecimal("actualrange");
                    BigDecimal actualAmount = itemRow.getBigDecimal("actualamount");
                    if (actualRange == null && CalcType.RATIO.getCode().equals(calcType) || actualAmount == null && CalcType.AMOUNT.getCode().equals(calcType)) continue;
                }
                DynamicObject preCurrencyFinal = null;
                DynamicObject currencyFinal = null;
                if (AdjAttributionType.DECATTRTYPE == attributionType) {
                    preCurrencyFinal = salaryStdDyObj.getDynamicObject("currency");
                    currencyFinal = itemRow.getDynamicObject("currency");
                } else {
                    DynamicObject preCurrencyVal = itemRow.getDynamicObject("precurrency");
                    preCurrencyFinal = preCurrencyVal != null ? preCurrencyVal : salaryStdDyObj.getDynamicObject("currency");
                    currencyFinal = itemRow.getDynamicObject("currency");
                }
                if (preCurrencyFinal == null || currencyFinal == null || preCurrencyFinal.getLong("id") == currencyFinal.getLong("id") || excTableId == 0L || (exrateBd = this.rateManager.getExRate(new ExRateKey(Long.valueOf(currencyFinal.getLong("id")), Long.valueOf(preCurrencyFinal.getLong("id")), Long.valueOf(rateDate.getTime()), Long.valueOf(excTableId)))) != null) continue;
                String currencyStr = String.join((CharSequence)"->", preCurrencyFinal.getString("name"), currencyFinal.getString("name"));
                String finalMsg = String.format(Locale.ROOT, messageTpl, personName, empNumber, currencyStr);
                errorMessageList.add(finalMsg);
            }
        }
        errorMessageList = errorMessageList.stream().distinct().collect(Collectors.toList());
        errorMessageList.forEach(errorMsg -> this.addFatalErrorMessage(dataEntity, (String)errorMsg));
    }

    private void checkSalBsledDate(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData, AdjAttributionType attributionType) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkSalBsledDate", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        List<Object> errorMessageList = new ArrayList(adjApprPersonData.length);
        String msgTpl = ResManager.loadKDString((String)"\u5de5\u53f7\uff08%1$s\uff09\uff1a\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08%2$s\uff09\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\uff08%3$s\uff09\u3002", (String)"DecAdjApprBaseValidator_15", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            String number = adjPersonDyObj.getString("number");
            DynamicObjectCollection adjApprPersonEntryDyObjs = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntryDyObj : adjApprPersonEntryDyObjs) {
                Date entBsed = adjApprPersonEntryDyObj.getDate("salbsed");
                Date entBsled = adjApprPersonEntryDyObj.getDate("salbsled");
                if (entBsed == null || entBsled == null || entBsled.compareTo(entBsed) >= 0) continue;
                String formatEntBsed = SWCInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsed", (Date)entBsed);
                String formatEntBsled = SWCInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsled", (Date)entBsled);
                errorMessageList.add(String.format(Locale.ROOT, msgTpl, number, formatEntBsed, formatEntBsled));
            }
        }
        errorMessageList = errorMessageList.stream().distinct().collect(Collectors.toList());
        errorMessageList.forEach(errorMsg -> this.addFatalErrorMessage(dataEntity, (String)errorMsg));
    }

    private MainEntityType getAdjPersonEntityType() {
        if (this.adjPersonEntityType == null) {
            this.adjPersonEntityType = EntityMetadataCache.getDataEntityType((String)"hcdm_adjapprperson");
        }
        return this.adjPersonEntityType;
    }

    private void checkOperationWithScm(ExtendedDataEntity dataEntity) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkOperationWithScm", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        String attributionType = dataEntity.getDataEntity().getString("salaryadjrsn.attributiontype");
        if (StringUtils.isEmpty((String)attributionType) || AdjAttributionType.getByCode((String)attributionType) != AdjAttributionType.ADJATTRTYPE) {
            return;
        }
        DynamicObject adjScmDyObj = dataEntity.getDataEntity().getDynamicObject("salaryadjscm");
        if (StringUtils.equals((String)this.getOperateKey(), (String)"submit") && adjScmDyObj != null && !adjScmDyObj.getBoolean("isapprwf")) {
            String needSubmitEffectMessage = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u65b9\u6848\u4e2d\u7533\u8bf7\u5355\u5ba1\u6279\u914d\u7f6e\u672a\u542f\u7528\u5ba1\u6279\u6d41\uff0c\u5219\u9700\u70b9\u51fb\u63d0\u4ea4\u5e76\u751f\u6548\u6309\u94ae\u8fdb\u884c\u5ba1\u6279\u3002", (String)"AdjApprSaveValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, needSubmitEffectMessage, ErrorLevel.Error);
        }
        if (StringUtils.equals((String)this.getOperateKey(), (String)"donothing_submiteffect")) {
            String needSubmitMessage;
            if (adjScmDyObj != null && adjScmDyObj.getBoolean("isapprwf")) {
                needSubmitMessage = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u65b9\u6848\u4e2d\u7533\u8bf7\u5355\u5ba1\u6279\u914d\u7f6e\u4e3a\u542f\u7528\u5ba1\u6279\u6d41\uff0c\u5219\u9700\u70b9\u51fb\u63d0\u4ea4\u6309\u94ae\u89e6\u53d1\u5ba1\u6279\u6d41\u3002", (String)"AdjApprSaveValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, needSubmitMessage, ErrorLevel.Error);
            }
            if (adjScmDyObj == null) {
                needSubmitMessage = ResManager.loadKDString((String)"\u82e5\u672a\u9009\u62e9\u5b9a\u8c03\u85aa\u65b9\u6848\uff0c\u5219\u5c06\u89e6\u53d1\u5ba1\u6279\u6d41\u7a0b\uff0c\u9700\u70b9\u51fb\u201c\u63d0\u4ea4\u201d\u6309\u94ae\u3002", (String)"AdjApprSaveValidator_3", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, needSubmitMessage, ErrorLevel.Error);
            }
        }
    }

    @Deprecated
    private void groupExtendedDataEntityBySubmitType(Map<String, List<ExtendedDataEntity>> submitTypeDataEntityMaps, ExtendedDataEntity dataEntity) {
    }
}

