/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.salaryadjfile;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AdjFileCertValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(AdjFileCertValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validateFileCert(dataEntities);
    }

    private void validateFileCert(ExtendedDataEntity[] dataEntities) {
        String operateKey = this.getOperateKey();
        ArrayList<Long> personIds = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            if (SWCStringUtils.equals((String)operateKey, (String)"save") && !SWCStringUtils.equals((String)data.getString("status"), (String)"C")) continue;
            personIds.add(data.getLong("person.id"));
        }
        if (personIds.size() == 0) {
            return;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hrpi_person");
        QFilter idFilter = new QFilter("id", "in", personIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)idFilter);
        DynamicObjectCollection persons = serviceHelper.queryOriginalCollection("id,personindexid", new QFilter[]{idFilter});
        Map<Long, Long> personIndexMap = persons.stream().collect(Collectors.toMap(o1 -> o1.getLong("id"), o1 -> o1.getLong("personindexid"), (x1, y1) -> x1));
        Map veryfiResult = AdjFileCertCommonHelper.verifyCert((List)persons);
        Set failList = (Set)veryfiResult.get("failList");
        String message = (String)veryfiResult.get("message");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long id = dataEntity.getDataEntity().getLong("person.id");
            Long pid = personIndexMap.get(id);
            if (!failList.contains(pid)) continue;
            LOGGER.info("[cert]:validateSinSurSalaryFileImportCert cert fail,pid={}", (Object)pid);
            this.addFatalErrorMessage(dataEntity, message);
        }
        Map checkCountMap = (Map)veryfiResult.get("msg");
        LOGGER.info("AdjFileCertValidator sinSurVerifyCertForApply: {}", (Object)JSON.toJSONString((Object)checkCountMap));
        String showMessageType = (String)checkCountMap.get("showMessageType");
        String infoType = (String)checkCountMap.get("infoType");
        if ("true".equals(checkCountMap.get("showMessage"))) {
            this.getOption().setVariableValue("showWarningTip", (String)checkCountMap.get("message"));
        }
    }
}

