/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.salaryadjfile;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;

public class AdjFileCommonValidator
extends AbstractValidator {
    public boolean isAddBillNoForContent() {
        String operationKey = this.getOperateKey();
        return !"save".equals(operationKey) && !"saveafteraudit".equals(operationKey);
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Long> personIdList = new ArrayList<Long>();
        HashSet<Long> empposgrelIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            personIdList.add(dataEntity.getDataEntity().getLong("person.id"));
            empposgrelIds.add(dataEntity.getDataEntity().getLong("empposorgrel.id"));
        }
        Set abandonPersonIds = SalaryAdjFileServiceHelper.getAbandonIds((String)"hrpi_person", personIdList);
        String msg = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\uff08{0}\uff09: {1}\uff08{2}\uff09\u7684\u5165\u804c\u5df2\u88ab\u64a4\u9500\uff0c\u4e0d\u5141\u8bb8{3}\u6863\u6848\u3002", (String)"AdjFileCommonValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String opName = this.getOperationName();
        Set abandonEmpposgrelIds = SalaryAdjFileServiceHelper.getAbandonIds((String)"hrpi_empposorgrel", empposgrelIds);
        String errorMsg = ResManager.loadKDString((String)"\u6863\u6848\u5173\u8054\u5c97\u4f4d\u7684\u4eba\u5458\u4efb\u804c\u5df2\u5e9f\u5f03\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileCommonValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String firstBsedMsg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u9700\u665a\u4e8e\u85aa\u916c\u4f53\u7cfb\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\uff08{0}\uff09\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileCommonValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject fileDy = dataEntity.getDataEntity();
            Long personId = fileDy.getLong("person.id");
            Long empposgrelId = fileDy.getLong("empposorgrel.id");
            if (abandonPersonIds.contains(personId)) {
                this.addErrorMessage(dataEntity, MessageFormat.format(msg, fileDy.getString("number"), fileDy.getString("person.name"), fileDy.getString("person.number"), opName));
            }
            if (abandonEmpposgrelIds.contains(empposgrelId)) {
                this.addFatalErrorMessage(dataEntity, errorMsg);
            }
            Date fileBsed = fileDy.getDate("bsed");
            Date scmFirstBsed = fileDy.getDate("stdscm.firstbsed");
            if (fileBsed == null || scmFirstBsed == null || !SWCDateTimeUtils.dayBefore((Date)fileBsed, (Date)scmFirstBsed)) continue;
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(firstBsedMsg, SWCInteDateTimeUtil.formatDate((String)"hcdm_stdscm", (String)"firstbsed", (Date)scmFirstBsed)));
        }
    }
}

