/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.salaryadjfile;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjfile.SalaryAdjFileHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class AdjFileSaveOpValidator
extends SWCDataBaseValidator {
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private static Log LOGGER = LogFactory.getLog(AdjFileSaveOpValidator.class);
    private Map<Long, DynamicObject> dempMap = new ConcurrentHashMap<Long, DynamicObject>(16);

    public boolean isAddBillNoForContent() {
        return false;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validateExistsCodeRule(dataEntities);
        List boIdSet = Arrays.stream(dataEntities).map(o1 -> o1.getDataEntity().getLong("boid")).filter(o1 -> o1 > 0L).collect(Collectors.toList());
        List idSet = Arrays.stream(dataEntities).map(o1 -> o1.getDataEntity().getLong("id")).filter(o1 -> o1 > 0L).collect(Collectors.toList());
        Set depempIdSet = Arrays.stream(dataEntities).map(o1 -> o1.getDataEntity().getLong("depemp.id")).filter(o1 -> o1 > 0L).collect(Collectors.toSet());
        Set salaystructureIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("salaystructure.id")).filter(dy -> dy > 0L).collect(Collectors.toSet());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        DynamicObject[] datas = serviceHelper.query("id, status", new QFilter[]{new QFilter("id", "in", idSet)});
        Map<Long, String> dataMap = Arrays.stream(datas).collect(Collectors.toMap(o1 -> o1.getLong("id"), o1 -> o1.getString("status")));
        String messageTpl = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\uff08%1$s\uff09\uff1a\u6863\u6848\u518d\u6b21\u751f\u6548\u65f6\u751f\u6548\u65e5\u671f\u9700\u5728\u4e0a\u4e00\u6b21\u5931\u6548\u65e5\u671f\u4e4b\u540e\uff08%2$s\uff09\u3002", (String)"AdjFileSaveOpValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String cannotModifyTpl = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\uff1a%s \u53ea\u6709\u5b9a\u8c03\u85aa\u6863\u6848\u72b6\u6001\u4e3a\u6682\u5b58\u3001\u5df2\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjFileSaveOpValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        Map maxDisableDynMap = this.adjFileApplicationService.getMaxDisableDate("hcdm_adjfileinfo", boIdSet);
        ArrayList<String> statusList = new ArrayList<String>(10);
        statusList.add("A");
        statusList.add("C");
        DynamicObject[] salaryAdjFiles = SalaryAdjFileServiceHelper.queryFileDataByDepempId((String)"boid,person.name,employee.empnumber,number,depemp.id,bsed,bsled,status,datastatus,iscurrentversion,biznumber", depempIdSet);
        Map<Long, List<DynamicObject>> map = Arrays.stream(salaryAdjFiles).collect(Collectors.groupingBy(e1 -> e1.getLong("depemp.id")));
        HashSet set = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        Map structureIdsAndStdscmIds = SalaryAdjFileHelper.getStdscmIdsBySalaryStructureIdsNoPerm((Set)Sets.newHashSet(salaystructureIds));
        this.doValidate(dataEntities, dataMap, messageTpl, cannotModifyTpl, maxDisableDynMap, statusList, salaryAdjFiles, map, set, structureIdsAndStdscmIds);
    }

    private void doValidate(ExtendedDataEntity[] dataEntities, Map<Long, String> dataMap, String messageTpl, String cannotModifyTpl, Map<Long, DynamicObject> maxDisableDynMap, List<String> statusList, DynamicObject[] salaryAdjFiles, Map<Long, List<DynamicObject>> map, Set<ExtendedDataEntity> set, Map<Long, Set<Long>> structureIdsAndStdscmIds) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Date disableDate;
            DynamicObject dy = dataEntity.getDataEntity();
            String status = dataMap.get(dy.getLong("id"));
            String number = dy.getString("number");
            String enable = dy.getString("enable");
            if (!(!StringUtils.isNotBlank((CharSequence)status) || statusList.contains(status) && "1".equals(enable))) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, cannotModifyTpl, number));
                set.add(dataEntity);
            }
            long boId = dy.getLong("boid");
            DynamicObject maxDisableDyn = maxDisableDynMap.get(boId);
            Date bsed = dy.getDate("bsed");
            if (maxDisableDyn != null && bsed.before(disableDate = maxDisableDyn.getDate("bsed"))) {
                String disableDateStr = HRInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsed", (Date)disableDate);
                String message = String.format(messageTpl, number, disableDateStr);
                this.addFatalErrorMessage(dataEntity, message);
                set.add(dataEntity);
            }
            if (set.contains(dataEntity)) continue;
            long salaystructureId = dy.getLong("salaystructure.id");
            Set<Long> stdscmIds = structureIdsAndStdscmIds.get(salaystructureId);
            Map variablesMap = this.getOption().getVariables();
            boolean checkStdScm = true;
            String isFromApiService = (String)variablesMap.get("isfromapiservice");
            if ("true".equals(isFromApiService)) {
                checkStdScm = false;
            }
            if (checkStdScm && salaystructureId != 0L && (CollectionUtils.isEmpty(stdscmIds) || !stdscmIds.contains(dy.getLong("stdscm.id")))) {
                String msg = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a{1}\u7684\u57fa\u672c\u4fe1\u606f\uff0c\u85aa\u916c\u4f53\u7cfb\u4e0d\u5c5e\u4e8e\u201c{2}\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileSaveOpValidator_3", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                String salayStructureError = MessageFormat.format(msg, dy.getString("employee.empnumber"), dy.getString("person.name"), dy.getString("salaystructure.name"));
                this.addFatalErrorMessage(dataEntity, salayStructureError);
            }
            if (set.contains(dataEntity)) continue;
            long depempId = dy.getLong("depemp.id");
            List<DynamicObject> list = map.get(depempId);
            if (ArrayUtils.isEmpty((Object[])salaryAdjFiles)) {
                if (null == this.dempMap.get(depempId)) {
                    this.dempMap.put(depempId, dy);
                    continue;
                }
                this.setRepeatErrMsg(this.dempMap.get(depempId), dataEntity);
                set.add(dataEntity);
                continue;
            }
            if (!CollectionUtils.isEmpty(list)) {
                for (DynamicObject dynamicObject : list) {
                    if (dy.getLong("boid") == dynamicObject.getLong("boid") || dy.getLong("id") == dynamicObject.getLong("boid") || !SalaryAdjFileHelper.isCover((DynamicObject)dy, (DynamicObject)dynamicObject)) continue;
                    this.setRepeatErrMsg(dynamicObject, dataEntity);
                    set.add(dataEntity);
                    break;
                }
            }
            if (set.contains(dataEntity)) continue;
            if (null == this.dempMap.get(depempId)) {
                this.dempMap.put(depempId, dy);
                continue;
            }
            this.setRepeatErrMsg(this.dempMap.get(depempId), dataEntity);
            set.add(dataEntity);
        }
    }

    private void setRepeatErrMsg(DynamicObject dynamicObject, ExtendedDataEntity dataEntity) {
        String repeatErrorMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5df2\u88ab\u5173\u8054\u5230\u5b9a\u8c03\u85aa\u6863\u6848{2}\u4e14\u751f\u5931\u6548\u65e5\u671f\u4e3a{3}\u81f3{4}\uff0c\u4e0d\u5141\u8bb8\u65e5\u671f\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"AdjFileSaveOpValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        Date oldBsed = dynamicObject.getDate("bsed");
        Date maxLoseEffectDate = SWCBaseUtils.getMaxLoseEffectDate();
        Date oldBsled = dynamicObject.getDate("bsled") == null ? maxLoseEffectDate : dynamicObject.getDate("bsled");
        String bsedStr = HRInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsed", (Date)oldBsed);
        String bsledStr = HRInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsled", (Date)oldBsled);
        String msg = MessageFormat.format(repeatErrorMsg, dynamicObject.getString("person.name"), dynamicObject.getString("employee.empnumber"), dynamicObject.getString("number"), bsedStr, bsledStr);
        this.addFatalErrorMessage(dataEntity, msg);
    }

    private void validateExistsCodeRule(ExtendedDataEntity[] dataEntities) {
        String errorMsg = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848\u65e0\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u201c\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u201d\u3002", (String)"AdjFileSaveOpValidator_5", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            CodeRuleInfo codeRuleInfo;
            DynamicObject dy = dataEntity.getDataEntity();
            if (!SWCStringUtils.isEmpty((String)dy.getString("number")) || !SWCObjectUtils.isEmpty((Object)(codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"hcdm_adjfileinfo", (DynamicObject)dy, null)))) continue;
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

