/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.salaryadjfile;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.adjfile.AdjFileMatchParam;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileMatchResult;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileNotFoundErrorEnum;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprOpHelper;
import kd.swc.hcdm.business.adjapprbill.entity.AdjApprPerQueryParam;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.common.enums.ConfirmStatusEnum;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hcdm.opplugin.salaryadjfile.AdjApprovalOp;
import kd.swc.hcdm.opplugin.validator.InteractionExceptionWrapper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DecAdjApprBaseValidator
extends SWCDataBaseValidator {
    private static Log logger = LogFactory.getLog(DecAdjApprBaseValidator.class);
    public static final int BATCH_SIZE = 500;
    public static final String INTERACTION_MSG = "msgList";
    protected final String adjApprPerSelectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_adjapprperson");
    private static List<List<Object>> validationToOperationStatusTable = Lists.newArrayListWithExpectedSize((int)10);
    private static final String DETAIL_PAGE = "DetailView";
    private static final String AUDIT_PAGE = "AuditView";
    private static final String LIST_PAGE = "ListView";
    private static final String DRAFT = "draft";
    private static final String NOT_DRAFT = "not_draft";
    protected AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
    protected AdjFileApplicationService fileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    protected static String CHECKISOVERSTANDARD_SPONSOR;
    protected static String CHECKEXRATECHANGED_SPONSOR;
    protected InteractionExceptionWrapper checkIsOverStandardException;
    protected InteractionExceptionWrapper checkExRateChangedException;

    private static String joinSep(String chars) {
        return chars + ";";
    }

    protected boolean needValidateByOpkeyAndBillStatusNew(String validation, String billStatus, boolean isDraft) {
        String opKeyStr = DecAdjApprBaseValidator.joinSep(this.getOperateKey());
        String viewStr = DecAdjApprBaseValidator.joinSep(DETAIL_PAGE);
        if (this.getOption().tryGetVariableValue("approvewfpageflag", new RefObject())) {
            viewStr = DecAdjApprBaseValidator.joinSep(AUDIT_PAGE);
        }
        if (this.getOption().tryGetVariableValue("listpageflag", new RefObject())) {
            viewStr = DecAdjApprBaseValidator.joinSep(LIST_PAGE);
        }
        String billStatusStr = DecAdjApprBaseValidator.joinSep(billStatus);
        String draftStr = isDraft ? DecAdjApprBaseValidator.joinSep(DRAFT) : DecAdjApprBaseValidator.joinSep(NOT_DRAFT);
        for (List<Object> configRow : validationToOperationStatusTable) {
            String billStatusListStr = (String)configRow.get(0);
            String opKeyListStr = (String)configRow.get(1);
            String viewListStr = (String)configRow.get(2);
            String draftListStr = (String)configRow.get(3);
            List validations = (List)configRow.get(4);
            if (!billStatusListStr.contains(billStatusStr) || !opKeyListStr.contains(opKeyStr) || !viewListStr.contains(viewStr) || !draftListStr.contains(draftStr) || !validations.contains(validation)) continue;
            return true;
        }
        return false;
    }

    protected boolean validateCountry(ExtendedDataEntity dataEntity) {
        if (!this.needValidateByOpkeyAndBillStatusNew("validateCountry", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return false;
        }
        StringJoiner errMandatoryField = CountryHelper.validate((DynamicObject)dataEntity.getDataEntity());
        if (errMandatoryField.length() > 0) {
            this.addErrorMessage(dataEntity, HCDMErrInfoEnum.COMMON_MUST_INPUT_VALUE.getMsg(new Object[]{errMandatoryField.toString()}));
            return true;
        }
        return false;
    }

    @Deprecated
    protected void checkCannotSubmit(DynamicObject dataEntity) {
    }

    @Deprecated
    protected void checkHasPerson(ExtendedDataEntity extendedDataEntity, AdjAttributionType attributionType) {
    }

    protected void checkHasPersonNew(ExtendedDataEntity extendedDataEntity, AdjAttributionType adjAttributionType) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkHasPersonNew", extendedDataEntity.getDataEntity().getString("billstatus"), extendedDataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        int totalPerson = extendedDataEntity.getDataEntity().getInt("totalperson");
        if (totalPerson == 0) {
            String noPersonMessage = ResManager.loadKDString((String)"\u201c{0}\u201d\u4e2d\u65e0{1}\u4eba\u5458\u3002", (String)"AdjApprSaveValidator_4", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
            String billName = StringUtils.isEmpty((CharSequence)dataEntity.getString("billname")) ? ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"AdjApprSaveValidator_6", (String)"swc-hcdm-opplugin", (Object[])new Object[0]) : dataEntity.getString("billname");
            String format = MessageFormat.format(noPersonMessage, billName, adjAttributionType.getDisplayName());
            this.addFatalErrorMessage(extendedDataEntity, format);
        }
    }

    @Deprecated
    protected void checkBillDraftStatus(ExtendedDataEntity extendedDataEntity) {
    }

    protected void checkRepeatDecAdj(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkRepeatDecAdj", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        if (dataEntity == null || ArrayUtils.isEmpty((Object[])adjApprPersonData)) {
            return;
        }
        HashSet depEmpIds = new HashSet(adjApprPersonData.length);
        Arrays.stream(adjApprPersonData).forEach(obj -> depEmpIds.add(obj.getLong("adjfile.depemp.id")));
        Map adjBillMap = CommonHcdmBizHelper.getInvalidAdjBillByDepEmpId(depEmpIds);
        String repeatOldBillMessage = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7{0}: {1}\uff08{2}\uff09 \u5728\u5355\u636e\u7f16\u53f7\uff08{3}\uff09\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\u4e2d\u5df2\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u5b9a\u8c03\u85aa\u3002", (String)"DecAdjApprBaseValidator_4", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        for (DynamicObject adjPerson : adjApprPersonData) {
            Long depempId = adjPerson.getLong("adjfile.depemp.id");
            if (!MapUtils.isNotEmpty((Map)adjBillMap) || !adjBillMap.containsKey(depempId)) continue;
            Set billnoSet = (Set)adjBillMap.get(depempId);
            billnoSet.remove(dataEntity.getDataEntity().getString("billno"));
            if (!CollectionUtils.isNotEmpty((Collection)billnoSet)) continue;
            String adjFileNumber = adjPerson.getString("adjfile.number");
            String personName = adjPerson.getString("name");
            String empNumber = adjPerson.getString("number");
            String formatMsg = MessageFormat.format(repeatOldBillMessage, adjFileNumber, personName, empNumber, Joiner.on((String)",").join((Iterable)billnoSet));
            this.addFatalErrorMessage(dataEntity, formatMsg);
        }
    }

    private void compareWithDb(Map<Long, List<Long>> adjFileToItemMap, Map<String, List<Long>> oldDataGroupByItem, Map<Long, DynamicObject> apprBillMap, Map<String, DynamicObject> confirmPersonMap, String repeatOldBillMessage, Map<String, String> errorMsgMap, DynamicObject adjApprPerson, Long fileId, DynamicObjectCollection adjApprPersonEntryDyObjs) {
        for (DynamicObject adjApprPersonEntry : adjApprPersonEntryDyObjs) {
            Long itemId = adjApprPersonEntry.getLong("standarditem.id");
            List<Long> existBillIdList = oldDataGroupByItem.get(fileId + "_" + itemId);
            if (CollectionUtils.isEmpty(existBillIdList)) continue;
            for (Long existBillId : existBillIdList) {
                DynamicObject adjApprBillObj = apprBillMap.get(existBillId);
                List<Long> itemList = adjFileToItemMap.get(fileId);
                if (CollectionUtils.isEmpty(itemList) || !itemList.contains(itemId) || "E".equals(adjApprBillObj.getString("billstatus")) || adjApprBillObj.getBoolean("isdraft")) continue;
                if ("C".equals(adjApprBillObj.getString("billstatus"))) {
                    DynamicObject confirmPersonObj;
                    Boolean enableConfirm;
                    DynamicObject salaryAdjScmObj = adjApprBillObj.getDynamicObject("salaryadjscm");
                    if (salaryAdjScmObj == null || !(enableConfirm = Boolean.valueOf(adjApprBillObj.getBoolean("salaryadjscm.enableconfirm"))).booleanValue() || (confirmPersonObj = confirmPersonMap.get(adjApprBillObj.getLong("id") + "_" + fileId)) == null) continue;
                    String confirmStatus = confirmPersonObj.getString("confirmstatus");
                    if (!ConfirmStatusEnum.UN_CONFIRM.getCode().equals(confirmStatus)) continue;
                }
                String adjFileNumber = adjApprPerson.getString("adjfile.number");
                Long adjFileId = adjApprPerson.getLong("adjfile.id");
                String personName = adjApprPerson.getString("name");
                String empNumber = adjApprPerson.getString("number");
                String formatMsg = MessageFormat.format(repeatOldBillMessage, adjFileNumber, personName, empNumber, apprBillMap.get(existBillId).get("billno"));
                errorMsgMap.put(String.valueOf(adjFileId), formatMsg);
            }
        }
    }

    protected boolean checkExRateChanged(ExtendedDataEntity extendedDataEntity, AdjAttributionType attributionType, DynamicObject[] adjApprPersonData) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkExRateChanged", extendedDataEntity.getDataEntity().getString("billstatus"), extendedDataEntity.getDataEntity().getBoolean("isdraft"))) {
            return false;
        }
        if (this.getFalseDataEntities().contains(extendedDataEntity)) {
            return false;
        }
        String messageTitle = MessageFormat.format(ResManager.loadKDString((String)"\u6240\u9009\u6c47\u7387\u65e5\u671f\u7684\u6c47\u7387\u5728\u201c{0}\u201d\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DecAdjApprBaseValidator_5", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), this.getOperationName());
        String tempMessage = null;
        tempMessage = AdjAttributionType.ADJATTRTYPE == attributionType ? ResManager.loadKDString((String)"{0}: {1}\uff08{2}\uff09\u5b9a\u8c03\u85aa\u524d\u540e\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u5b9e\u9645\u8c03\u5e45\uff08\u91d1\u989d\uff09\u3001\u91d1\u989d\u3001\u85aa\u916c\u6bd4\u7387\uff08CR\uff09\u3001\u85aa\u916c\u6e17\u900f\u7387\uff08PR\uff09\u5c06\u6839\u636e\u6700\u65b0\u6c47\u7387\u91cd\u65b0\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"DecAdjApprBaseValidator_17", (String)"swc-hcdm-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"{0}: {1}\uff08{2}\uff09\u91d1\u989d\u4e0e\u85aa\u916c\u6807\u51c6\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u91d1\u989d\u5c06\u6839\u636e\u6700\u65b0\u6c47\u7387\u91cd\u65b0\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"DecAdjApprBaseValidator_18", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        boolean hasChanged = false;
        DynamicObject billEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection personRow = DecAdjApprOpHelper.getExRateChangedRowFromDb((DynamicObject)billEntity, (AdjAttributionType)attributionType, (DynamicObject[])adjApprPersonData);
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)personRow.size());
        if (!personRow.isEmpty()) {
            hasChanged = true;
            for (DynamicObject row : personRow) {
                String fileNumber = row.getString("adjfile.number");
                String personName = row.getString("name");
                String personNumber = row.getString("number");
                String message = MessageFormat.format(tempMessage, fileNumber, personName, personNumber);
                msgList.add(message);
            }
        }
        if (hasChanged) {
            this.showConfirmMessage(messageTitle, msgList, this.getOption());
        }
        return hasChanged;
    }

    @Deprecated
    private void showMessageNoConfirm(String messageTitle, String message) {
        InteractionContext interactionContext = new InteractionContext();
        interactionContext.setCustShowFormId("hsbp_operationresult");
        interactionContext.getCustShowParameter().put("title", messageTitle);
        interactionContext.getCustShowParameter().put("errorMsg", message);
        throw new KDInteractionException(AdjApprovalOp.class.getName(), interactionContext);
    }

    private void showConfirmMessage(String messageTitle, List<String> msgList, OperateOption operateOption) {
        String confirmResultString = operateOption.getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        logger.info("show confirm message1 is {}", (Object)confirmResultString);
        if (confirmResult.getResults().containsKey(CHECKEXRATECHANGED_SPONSOR)) {
            String result = (String)confirmResult.getResults().get(CHECKEXRATECHANGED_SPONSOR);
            logger.info("show confirm message2 is {}", (Object)result);
            if (result == null) {
                return;
            }
            if ("true".equals(result)) {
                operateOption.setVariableValue("re_calcrate_confirmed", "true");
            }
        } else {
            boolean approveWfPageFlag = this.getOption().tryGetVariableValue("approvewfpageflag", new RefObject());
            if (!approveWfPageFlag) {
                if (this.checkExRateChangedException == null) {
                    InteractionContext interactionContext = new InteractionContext();
                    interactionContext.setCustShowFormId("hsbp_operationconfirm");
                    interactionContext.getCustShowParameter().put("title", messageTitle);
                    InteractionExceptionWrapper exceptionWrapper = new InteractionExceptionWrapper(new KDInteractionException(CHECKEXRATECHANGED_SPONSOR, interactionContext));
                    exceptionWrapper.getCustomParam().put(INTERACTION_MSG, msgList);
                    this.checkExRateChangedException = exceptionWrapper;
                } else {
                    List allMsgList = (List)this.checkExRateChangedException.getCustomParam().get(INTERACTION_MSG);
                    if (allMsgList != null) {
                        allMsgList.addAll(msgList);
                    }
                }
            } else {
                operateOption.setVariableValue("re_calcrate_confirmed", "true");
            }
        }
    }

    protected void checkInitExists(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkInitExists", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        Set adjFileIdSet = Arrays.stream(adjApprPersonData).map(dyObj -> dyObj.getLong("adjfile.id")).collect(Collectors.toSet());
        Map invalidAdjRecordMap = new HashMap(16);
        try {
            invalidAdjRecordMap = CommonHcdmBizHelper.getInvalidAdjRecordByAdjFileId(adjFileIdSet);
        }
        catch (Exception e) {
            logger.error("check init exists get invalid adj record by adjfileid failed", (Throwable)e);
        }
        if (!MapUtils.isEmpty(invalidAdjRecordMap)) {
            for (DynamicObject billEntry : adjApprPersonData) {
                long adjFileId = billEntry.getLong("adjfile.id");
                String personName = billEntry.getString("name");
                String empNumber = billEntry.getString("number");
                List invalidAdjRecord = (List)invalidAdjRecordMap.get(adjFileId);
                if (invalidAdjRecord == null || invalidAdjRecord.isEmpty()) continue;
                String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5b58\u5728\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u521d\u59cb\u5316\u6570\u636e\uff0c\u9700\u521d\u59cb\u5316\u5b8c\u6210\u540e\u624d\u80fd\u8fdb\u884c\u5b9a\u8c03\u85aa\u3002", (String)"DecAdjApprBaseValidator_8", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), personName, empNumber);
                this.addFatalErrorMessage(dataEntity, errorMsg);
            }
        }
    }

    protected void checkCandidateExists(ExtendedDataEntity dataEntity, AdjAttributionType attributionType, DynamicObject[] adjApprPersonData) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkCandidateExists", dataEntity.getDataEntity().getString("billstatus"), dataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        Set<Long> adjFileIdSet = Arrays.stream(adjApprPersonData).map(dyObj -> dyObj.getLong("adjfile.id")).collect(Collectors.toSet());
        Map<Long, Set<String>> inTransitCandSetSalApplications = this.getInTransitCandSetSalApplications(adjFileIdSet, attributionType);
        if (inTransitCandSetSalApplications.isEmpty()) {
            return;
        }
        for (DynamicObject billEntry : adjApprPersonData) {
            long adjFileId = billEntry.getLong("adjfile.id");
            String name = billEntry.getString("name");
            String number = billEntry.getString("number");
            Set<String> candidateBillNos = inTransitCandSetSalApplications.get(adjFileId);
            if (candidateBillNos == null || candidateBillNos.isEmpty()) continue;
            String billNos = String.join((CharSequence)",", candidateBillNos);
            this.addFatalErrorMessage(dataEntity, HCDMErrInfoEnum.ADJ_APPR_BILL_EMPLOYEE_EXISTS_CANDIDATE.getMsg(new Object[]{name, number, billNos}));
        }
    }

    @Deprecated
    protected void checkListData() {
    }

    @Deprecated
    private void checkListData(ExtendedDataEntity[] dataEntities, Map.Entry<AdjAttributionType, List<ExtendedDataEntity>> attributionTypeEntry, List<ExtendedDataEntity> extendedDataEntityList) {
    }

    @Deprecated
    private void checkEmployExistsAndStdBsedInvalid(ExtendedDataEntity dataEntity, DynamicObject[] adjApprPersonData, boolean isList, AdjAttributionType attributionType) {
    }

    @Deprecated
    private StringJoiner checkCandidateExists(Set<Long> invalidAdjFileIds, DynamicObject[] adjApprPersonData, boolean isList) {
        return null;
    }

    @Deprecated
    private StringJoiner checkItemBsed(DynamicObject[] adjApprPersonData, Set<Long> invalidAdjFileIds, boolean isList, AdjAttributionType attributionType) {
        return null;
    }

    @Deprecated
    private void findMaxBsedByType(AdjAttributionType attributionType, StringJoiner errEmploySj, Set<Long> repeatedAdjFileIds, long adjFileId, String fileNumber, String name, String number, long stdItemId, Date stdBsed) {
    }

    private Map<Long, Set<String>> getInTransitCandSetSalApplications(Set<Long> adjFileIdSet, AdjAttributionType attributionType) {
        HashSet statusSet = Sets.newHashSet((Object[])new String[]{"A", "B", "G", "D", "C"});
        Map adjFileIdAndCandSetSalApplidDysMap = new HashMap(16);
        try {
            long startTime = System.currentTimeMillis();
            adjFileIdAndCandSetSalApplidDysMap = CommonHcdmBizHelper.getCandSetSalApplidMapByAdjFile(adjFileIdSet, (Set)Sets.newHashSet((Iterable)statusSet));
            logger.info("adj approval save validator validate dec entity get audited candsetsal applications take {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            logger.info("get audited candsetsal applications failed", (Object)e);
        }
        if (MapUtils.isNotEmpty(adjFileIdAndCandSetSalApplidDysMap)) {
            HashMap<Long, Set<String>> adjFileIdAndCandSetSalApplidsInTransitMap = new HashMap<Long, Set<String>>(adjFileIdAndCandSetSalApplidDysMap.size());
            for (Map.Entry candSetSalApplidEntry : adjFileIdAndCandSetSalApplidDysMap.entrySet()) {
                Long adjFileId = (Long)candSetSalApplidEntry.getKey();
                for (DynamicObject candSetSalApplidBillDy : (List)candSetSalApplidEntry.getValue()) {
                    if ("C".equals(candSetSalApplidBillDy.getString("billstatus"))) continue;
                    adjFileIdAndCandSetSalApplidsInTransitMap.computeIfAbsent(adjFileId, key -> new LinkedHashSet(16)).add(candSetSalApplidBillDy.getString("billno"));
                }
            }
            return adjFileIdAndCandSetSalApplidsInTransitMap;
        }
        return Collections.emptyMap();
    }

    @Deprecated
    private void getStandardItemBsed(Long adjFileId, DynamicObject candSetSalApplidBillDy, AdjAttributionType attributionType) {
    }

    @Deprecated
    private String getKeyByType(AdjAttributionType attributionType, long adjFileId, long stdItemId) {
        return AdjAttributionType.DECATTRTYPE == attributionType ? String.valueOf(adjFileId) : adjFileId + "," + stdItemId;
    }

    protected DynamicObject[] getAdjApprPersonData(DynamicObject dataEntity, List<Long> adjPersonIds) {
        AdjApprPerQueryParam adjApprPerQueryParam = new AdjApprPerQueryParam();
        Long adjBillId = dataEntity.getLong("id");
        adjApprPerQueryParam.setAdjApprBillId(adjBillId);
        adjApprPerQueryParam.setAdjPersonIdList(adjPersonIds);
        adjApprPerQueryParam.setDefaultOrderBy("updatetime desc, adjfile asc,entryentity.seq asc");
        return DecAdjApprGridHelper.getAdjApprPersonData((String)this.adjApprPerSelectProperties, (AdjApprPerQueryParam)adjApprPerQueryParam);
    }

    protected List<Long> getAllAdjApprPersonId(DynamicObject dataEntity) {
        Long adjBillId = dataEntity.getLong("id");
        return DecAdjApprGridHelper.queryAllAdjPersonId((Long)adjBillId);
    }

    protected void checkEffectiveDate(ExtendedDataEntity extendedDataEntity, DynamicObject[] adjApprPersonData, AdjAttributionType attributionType) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkEffectiveDate", extendedDataEntity.getDataEntity().getString("billstatus"), extendedDataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        List<Object> errorMessageList = new ArrayList(adjApprPersonData.length);
        Set dbAdjFileIdSet = Arrays.stream(adjApprPersonData).map(item -> item.getLong("adjfile.id")).collect(Collectors.toSet());
        ArrayList<AdjFileMatchParam> params = new ArrayList<AdjFileMatchParam>(10);
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            Long adjFileId = adjPersonDyObj.getLong("adjfile.id");
            DynamicObjectCollection adjApprPersonEntryDyObjs = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntryDyObj : adjApprPersonEntryDyObjs) {
                Date entBsed = adjApprPersonEntryDyObj.getDate("salbsed");
                if (entBsed == null) continue;
                String pkID = adjApprPersonEntryDyObj.getString("id");
                Date entBsled = adjApprPersonEntryDyObj.getDate("salbsled");
                if (entBsled == null) {
                    entBsled = SWCDateTimeUtils.getMaxBsled();
                }
                AdjFileMatchParam matchParam = new AdjFileMatchParam();
                matchParam.setAdjFileBoId(adjFileId);
                matchParam.setBsed(entBsed);
                matchParam.setBsled(entBsled);
                matchParam.setUnionId(DecAdjApprCreateGridHelper.combineStrings((String[])new String[]{String.valueOf(adjFileId), pkID, SWCDateTimeUtils.format((Date)entBsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)entBsled, (String)"yyyy-MM-dd")}));
                matchParam.setBeforeAdjFileMinBsed(false);
                params.add(matchParam);
            }
        }
        Map adjfileMatchResultMap = this.fileApplicationService.batchMatchEffectiveAdjfileVersion(params);
        Map maxBsedOfFile = null;
        Map maxBsedOfFileForAdjBill = null;
        if (AdjAttributionType.DECATTRTYPE == attributionType) {
            maxBsedOfFile = this.fileApplicationService.getMaxBsedOfRecordForDecType(dbAdjFileIdSet);
        } else if (AdjAttributionType.ADJATTRTYPE == attributionType) {
            Map<Long, Set<Long>> fileItemIdMap = DecAdjApprBaseValidator.getFileItemMap(adjApprPersonData);
            maxBsedOfFileForAdjBill = this.fileApplicationService.getMaxBsedOfRecordForAdjType(fileItemIdMap);
        }
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            Long adjFileId = adjPersonDyObj.getLong("adjfile.id");
            String number = adjPersonDyObj.getString("number");
            DynamicObjectCollection adjApprPersonEntryDyObjs = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntryDyObj : adjApprPersonEntryDyObjs) {
                Date entBsed = adjApprPersonEntryDyObj.getDate("salbsed");
                if (entBsed == null) continue;
                Date entBsled = adjApprPersonEntryDyObj.getDate("salbsled");
                if (entBsled == null) {
                    entBsled = SWCDateTimeUtils.getMaxBsled();
                }
                Long stdItemId = adjApprPersonEntryDyObj.getLong("standarditem.id");
                String pkID = adjApprPersonEntryDyObj.getString("id");
                String unionId = DecAdjApprCreateGridHelper.combineStrings((String[])new String[]{String.valueOf(adjFileId), pkID, SWCDateTimeUtils.format((Date)entBsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)entBsled, (String)"yyyy-MM-dd")});
                AdjfileMatchResult adjfileMatchResult = (AdjfileMatchResult)adjfileMatchResultMap.get(unionId);
                boolean hasError = this.getMsgByFileMatchResult(errorMessageList, number, adjfileMatchResult);
                if (hasError) continue;
                this.getMsgByCompareMaxBsed(attributionType, errorMessageList, maxBsedOfFile, maxBsedOfFileForAdjBill, adjFileId, number, entBsed, stdItemId);
            }
        }
        errorMessageList = errorMessageList.stream().distinct().collect(Collectors.toList());
        errorMessageList.forEach(errorMsg -> this.addFatalErrorMessage(extendedDataEntity, (String)errorMsg));
    }

    private boolean getMsgByCompareMaxBsed(AdjAttributionType attributionType, List<String> errorMessageList, Map<Long, Date> maxBsedOfFile, Map<Long, Map<Long, Date>> maxBsedOfFileForAdjBill, Long adjFileId, String number, Date entBsed, Long stdItemId) {
        Map<Long, Date> adjFileToItemMaxDateEntityMap;
        Date maxBsed = null;
        if (maxBsedOfFile != null && AdjAttributionType.DECATTRTYPE == attributionType) {
            maxBsed = maxBsedOfFile.get(adjFileId);
        } else if (maxBsedOfFileForAdjBill != null && AdjAttributionType.ADJATTRTYPE == attributionType && (adjFileToItemMaxDateEntityMap = maxBsedOfFileForAdjBill.get(adjFileId)) != null) {
            maxBsed = adjFileToItemMaxDateEntityMap.get(stdItemId);
        }
        if (maxBsed == null) {
            return false;
        }
        if (entBsed.compareTo(maxBsed) <= 0) {
            String formatEntBsed = HRInteDateTimeUtil.formatDate((String)"hcdm_salaryadjrecord", (String)"bsed", (Date)entBsed);
            String formatMaxBsed = HRInteDateTimeUtil.formatDate((String)"hcdm_salaryadjrecord", (String)"bsed", (Date)maxBsed);
            errorMessageList.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5de5\u53f7\uff08%1$s\uff09\uff1a\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08%2$s\uff09\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u6b21\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08%3$s\uff09\u3002", (String)"DecAdjApprBaseValidator_11", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), number, formatEntBsed, formatMaxBsed));
            return true;
        }
        return false;
    }

    private boolean getMsgByFileMatchResult(List<String> errorMessageList, String number, AdjfileMatchResult adjfileMatchResult) {
        if (null != adjfileMatchResult && adjfileMatchResult.getAdjfileVersion() == null) {
            AdjfileNotFoundErrorEnum notFoundErrorEnum = adjfileMatchResult.getAdjfileNotFoundErrorEnum();
            String errorMsg = notFoundErrorEnum.getLocaleName().loadKDString();
            if (notFoundErrorEnum == AdjfileNotFoundErrorEnum.BSED_NOTMATCH_FILE) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5de5\u53f7\uff08%1$s\uff09\uff1a\u5f53\u524d\u6240\u9009\u751f\u6548\u65e5\u671f\u4e0b\uff0c\u5b9a\u8c03\u85aa\u6863\u6848\u5df2\u5931\u6548\uff0c\u4e0d\u53ef\u8fdb\u884c\u5b9a\u8c03\u85aa\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjApprBaseValidator_13", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), number);
            } else if (notFoundErrorEnum == AdjfileNotFoundErrorEnum.COVER_UNABLE_FILE) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5de5\u53f7\uff08%1$s\uff09\uff1a\u5f53\u524d\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185\uff0c\u5b58\u5728\u5b9a\u8c03\u85aa\u6863\u6848\u5931\u6548\u4e0d\u53ef\u7528\uff0c\u4e0d\u53ef\u8fdb\u884c\u5b9a\u8c03\u85aa\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjApprBaseValidator_14", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), number);
            }
            errorMessageList.add(errorMsg);
            return true;
        }
        return false;
    }

    protected void checkStandardItemRepeat(ExtendedDataEntity extendedDataEntity, DynamicObject[] adjApprPersonData) {
        if (!this.needValidateByOpkeyAndBillStatusNew("checkStandardItemRepeat", extendedDataEntity.getDataEntity().getString("billstatus"), extendedDataEntity.getDataEntity().getBoolean("isdraft"))) {
            return;
        }
        HashSet<Long> stdItemSet = new HashSet<Long>(16);
        List<Object> errorMessageList = new ArrayList(adjApprPersonData.length);
        String msgTpl = ResManager.loadKDString((String)"\u6863\u6848%1$s:\u5b9a\u8c03\u85aa\u9879\u76ee%2$s\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjApprBaseValidator_12", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            stdItemSet.clear();
            String adjFileNumber = adjPersonDyObj.getString("adjfile.number");
            DynamicObjectCollection adjApprPersonEntryDyObjs = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntryDyObj : adjApprPersonEntryDyObjs) {
                boolean add;
                long stdItemId = adjApprPersonEntryDyObj.getLong("standarditem.id");
                String stdItemName = adjApprPersonEntryDyObj.getString("standarditem.name");
                if (stdItemId <= 0L || (add = stdItemSet.add(stdItemId))) continue;
                String errorMsg2 = String.format(Locale.ROOT, msgTpl, adjFileNumber, stdItemName);
                errorMessageList.add(errorMsg2);
            }
        }
        stdItemSet.clear();
        errorMessageList = errorMessageList.stream().distinct().collect(Collectors.toList());
        errorMessageList.forEach(errorMsg -> this.addFatalErrorMessage(extendedDataEntity, (String)errorMsg));
    }

    private static Map<Long, Set<Long>> getFileItemMap(DynamicObject[] adjApprPersonData) {
        HashMap<Long, Set<Long>> fileToItemMap = new HashMap<Long, Set<Long>>(adjApprPersonData.length);
        for (DynamicObject adjPersonDyObj : adjApprPersonData) {
            long fileId = adjPersonDyObj.getLong("adjfile.id");
            DynamicObjectCollection adjApprPersonEntryDyObjs = adjPersonDyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntryDyObj : adjApprPersonEntryDyObjs) {
                long itemId = adjApprPersonEntryDyObj.getLong("standarditem.id");
                if (fileId <= 0L) continue;
                Set itemIdList = fileToItemMap.computeIfAbsent(fileId, value -> Sets.newHashSet());
                if (itemId <= 0L) continue;
                itemIdList.add(itemId);
            }
        }
        return fileToItemMap;
    }

    static {
        validationToOperationStatusTable.add(Lists.newArrayList((Object[])new Object[]{DecAdjApprBaseValidator.joinSep("A"), DecAdjApprBaseValidator.joinSep("save"), DecAdjApprBaseValidator.joinSep(DETAIL_PAGE), DecAdjApprBaseValidator.joinSep(DRAFT) + DecAdjApprBaseValidator.joinSep(NOT_DRAFT), Lists.newArrayList((Object[])new String[]{"validateCountry", "checkOperationWithScm", "checkHasPersonNew", "checkEntryRowMustInput", "checkMatchStdRange", "checkGradeOrRankIsEmpty", "checkExRateDataNotSet", "checkIsOverStandard", "checkEmpposorgrelAvailable", "checkRepeatDecAdj", "checkStandardItemRepeat", "checkSalBsledDate", "checkEffectiveDate", "checkExRateChanged", "checkCandidateExists", "checkInitExists"})}));
        validationToOperationStatusTable.add(Lists.newArrayList((Object[])new Object[]{DecAdjApprBaseValidator.joinSep("A"), DecAdjApprBaseValidator.joinSep("submit") + DecAdjApprBaseValidator.joinSep("donothing_submiteffect"), DecAdjApprBaseValidator.joinSep(DETAIL_PAGE), DecAdjApprBaseValidator.joinSep(DRAFT) + DecAdjApprBaseValidator.joinSep(NOT_DRAFT), Lists.newArrayList((Object[])new String[]{"validateCountry", "checkOperationWithScm", "checkHasPersonNew", "checkEntryRowMustInput", "checkMatchStdRange", "checkGradeOrRankIsEmpty", "checkExRateDataNotSet", "checkIsOverStandard", "checkEmpposorgrelAvailable", "checkRepeatDecAdj", "checkStandardItemRepeat", "checkSalBsledDate", "checkEffectiveDate", "checkExRateChanged", "checkCandidateExists", "checkInitExists"})}));
        validationToOperationStatusTable.add(Lists.newArrayList((Object[])new Object[]{DecAdjApprBaseValidator.joinSep("A"), DecAdjApprBaseValidator.joinSep("submit") + DecAdjApprBaseValidator.joinSep("donothing_submiteffect"), DecAdjApprBaseValidator.joinSep(LIST_PAGE), DecAdjApprBaseValidator.joinSep(NOT_DRAFT), Lists.newArrayList((Object[])new String[]{"checkOperationWithScm", "checkEmpposorgrelAvailable", "checkEffectiveDate", "checkCandidateExists", "checkInitExists"})}));
        validationToOperationStatusTable.add(Lists.newArrayList((Object[])new Object[]{DecAdjApprBaseValidator.joinSep("B"), DecAdjApprBaseValidator.joinSep("save"), DecAdjApprBaseValidator.joinSep(AUDIT_PAGE), DecAdjApprBaseValidator.joinSep(DRAFT) + DecAdjApprBaseValidator.joinSep(NOT_DRAFT), Lists.newArrayList((Object[])new String[]{"checkEntryRowMustInput", "checkMatchStdRange", "checkGradeOrRankIsEmpty", "checkExRateDataNotSet", "checkIsOverStandard", "checkSalBsledDate", "checkEffectiveDate"})}));
        validationToOperationStatusTable.add(Lists.newArrayList((Object[])new Object[]{DecAdjApprBaseValidator.joinSep("G"), DecAdjApprBaseValidator.joinSep("save"), DecAdjApprBaseValidator.joinSep(DETAIL_PAGE), DecAdjApprBaseValidator.joinSep(DRAFT) + DecAdjApprBaseValidator.joinSep(NOT_DRAFT), Lists.newArrayList((Object[])new String[]{"validateCountry", "checkOperationWithScm", "checkHasPersonNew", "checkEntryRowMustInput", "checkMatchStdRange", "checkGradeOrRankIsEmpty", "checkExRateDataNotSet", "checkIsOverStandard", "checkEmpposorgrelAvailable", "checkRepeatDecAdj", "checkStandardItemRepeat", "checkSalBsledDate", "checkEffectiveDate", "checkExRateChanged", "checkCandidateExists", "checkInitExists"})}));
        validationToOperationStatusTable.add(Lists.newArrayList((Object[])new Object[]{DecAdjApprBaseValidator.joinSep("G"), DecAdjApprBaseValidator.joinSep("submit") + DecAdjApprBaseValidator.joinSep("donothing_submiteffect"), DecAdjApprBaseValidator.joinSep(DETAIL_PAGE), DecAdjApprBaseValidator.joinSep(DRAFT) + DecAdjApprBaseValidator.joinSep(NOT_DRAFT), Lists.newArrayList((Object[])new String[]{"validateCountry", "checkOperationWithScm", "checkHasPersonNew", "checkEntryRowMustInput", "checkMatchStdRange", "checkGradeOrRankIsEmpty", "checkExRateDataNotSet", "checkIsOverStandard", "checkEmpposorgrelAvailable", "checkRepeatDecAdj", "checkStandardItemRepeat", "checkSalBsledDate", "checkEffectiveDate", "checkExRateChanged", "checkCandidateExists", "checkInitExists"})}));
        validationToOperationStatusTable.add(Lists.newArrayList((Object[])new Object[]{DecAdjApprBaseValidator.joinSep("G"), DecAdjApprBaseValidator.joinSep("submit") + DecAdjApprBaseValidator.joinSep("donothing_submiteffect"), DecAdjApprBaseValidator.joinSep(LIST_PAGE), DecAdjApprBaseValidator.joinSep(NOT_DRAFT), Lists.newArrayList((Object[])new String[]{"checkOperationWithScm", "checkEmpposorgrelAvailable", "checkEffectiveDate", "checkCandidateExists", "checkInitExists"})}));
        validationToOperationStatusTable.add(Lists.newArrayList((Object[])new Object[]{DecAdjApprBaseValidator.joinSep("D"), DecAdjApprBaseValidator.joinSep("save"), DecAdjApprBaseValidator.joinSep(AUDIT_PAGE), DecAdjApprBaseValidator.joinSep(DRAFT) + DecAdjApprBaseValidator.joinSep(NOT_DRAFT), Lists.newArrayList((Object[])new String[]{"checkEntryRowMustInput", "checkMatchStdRange", "checkGradeOrRankIsEmpty", "checkExRateDataNotSet", "checkIsOverStandard", "checkSalBsledDate", "checkEffectiveDate"})}));
        CHECKISOVERSTANDARD_SPONSOR = "AdjApprovalSaveValidator.checkIsOverStandard";
        CHECKEXRATECHANGED_SPONSOR = "DecAdjApprBaseValidator.checkExRateChanged";
    }
}

