/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.salaryadjfile;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DecAdjCommonValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        String operateKey = this.getOperateKey();
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
        if ("submit".equals(operateKey) || "donothing_submiteffect".equals(operateKey)) {
            List billNames = Arrays.stream(dataEntities).map(obj -> obj.getDataEntity().getString("billname")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("billname", "in", billNames);
            DynamicObject[] billObjs = serviceHelper.query("id,billname", new QFilter[]{qFilter});
            Map<String, List<DynamicObject>> billMap = Arrays.stream(billObjs).collect(Collectors.groupingBy(key -> key.getString("billname")));
            block0: for (ExtendedDataEntity dataEntity : dataEntities) {
                String billName = dataEntity.getDataEntity().getString("billname");
                if (StringUtils.isBlank((String)billName)) {
                    String msg = ResManager.loadKDString((String)"\u201c\u5355\u636e\u540d\u79f0\u201d \u7a7a\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DecAdjCommonValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, msg);
                    continue;
                }
                List<DynamicObject> adjApprBillArray = billMap.get(billName);
                if (!CollectionUtils.isNotEmpty(adjApprBillArray)) continue;
                for (DynamicObject adjApprBillDyObj : adjApprBillArray) {
                    if (adjApprBillDyObj.getLong("id") == ((Long)dataEntity.getBillPkId()).longValue()) continue;
                    String msg = ResManager.loadKDString((String)"\u201c\u5355\u636e\u540d\u79f0\u201d \u503c \u201c%1$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DecAdjCommonValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, msg, billName));
                    continue block0;
                }
            }
        }
    }
}

