/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.salaryadjfile;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjfile.SalaryAdjFileHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class SalaryAdjFileAgainEffectValidator
extends SWCDataBaseValidator {
    private static Log logger = LogFactory.getLog(SalaryAdjFileAgainEffectValidator.class);
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);

    public boolean isAddBillNoForContent() {
        return false;
    }

    public void validate() {
        String formatStr = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7(%1$s)\uff1a%2$s", (String)"SalaryAdjFileUnableValidator_10", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String statusErrorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5931\u6548\u7684\u6570\u636e\u5141\u8bb8\u751f\u6548\u3002", (String)"SalaryAdjFileAgainEffectValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String dateErrorMsg = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\uff08%1$s\uff09\uff1a\u751f\u6548\u65e5\u671f\u9700\u665a\u4e8e\u6216\u7b49\u4e8e\u5931\u6548\u65e5\u671f\uff08%2$s\uff09\u3002", (String)"SalaryAdjFileAgainEffectValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List boIdSet = Arrays.stream(dataEntities).map(entity -> entity.getDataEntity().getLong("boid")).filter(aLong -> aLong > 0L).collect(Collectors.toList());
        Map maxDisableDyMap = this.adjFileApplicationService.getMaxDisableDate("hcdm_adjfileinfo", boIdSet);
        Map variables = this.getOption().getVariables();
        String bsedValue = (String)variables.get("var_bsed");
        try {
            Date newBsed = SWCStringUtils.isEmpty((String)bsedValue) ? null : SWCDateTimeUtils.parseDate((String)bsedValue);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dy = dataEntity.getDataEntity();
                String number = dy.getString("number");
                String status = dy.getString("status");
                if (!SWCStringUtils.equals((String)status, (String)"D")) {
                    this.addFatalErrorMessage(dataEntity, String.format(formatStr, number, statusErrorMsg));
                    continue;
                }
                long boId = dy.getLong("boid");
                DynamicObject maxDisableDy = (DynamicObject)maxDisableDyMap.get(boId);
                if (maxDisableDy == null) continue;
                Date disableDate = maxDisableDy.getDate("bsed");
                if (newBsed != null && !newBsed.before(disableDate)) continue;
                this.addFatalErrorMessage(dataEntity, String.format(dateErrorMsg, number, HRInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsed", (Date)disableDate)));
            }
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        Set depempIdSet = Arrays.stream(dataEntities).map(o1 -> o1.getDataEntity().getLong("depemp.id")).filter(o1 -> o1 > 0L).collect(Collectors.toSet());
        DynamicObject[] salaryAdjFiles = SalaryAdjFileServiceHelper.queryFileDataByDepempId((String)"boid,person.name,employee.empnumber,number,depemp.id,bsed,bsled,status,datastatus,iscurrentversion,biznumber", depempIdSet);
        Map<Long, List<DynamicObject>> depempAdjFileMap = Arrays.stream(salaryAdjFiles).collect(Collectors.groupingBy(e1 -> e1.getLong("depemp.id")));
        block3: for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            long depempId = dy.getLong("depemp.id");
            List<DynamicObject> adjFileList = depempAdjFileMap.get(depempId);
            if (CollectionUtils.isEmpty(adjFileList)) continue;
            for (DynamicObject dynamicObject : adjFileList) {
                if (dy.getLong("boid") == dynamicObject.getLong("boid") || dy.getLong("id") == dynamicObject.getLong("boid") || !SalaryAdjFileHelper.isCover((DynamicObject)dy, (DynamicObject)dynamicObject)) continue;
                this.setRepeatErrMsg(dynamicObject, dataEntity);
                continue block3;
            }
        }
    }

    private void setRepeatErrMsg(DynamicObject dynamicObject, ExtendedDataEntity dataEntity) {
        String repeatErrorMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5df2\u88ab\u5173\u8054\u5230\u5b9a\u8c03\u85aa\u6863\u6848{2}\u4e14\u751f\u5931\u6548\u65e5\u671f\u4e3a{3}\u81f3{4}\uff0c\u4e0d\u5141\u8bb8\u65e5\u671f\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"AdjFileSaveOpValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        Date oldBsed = dynamicObject.getDate("bsed");
        Date maxLoseEffectDate = SWCBaseUtils.getMaxLoseEffectDate();
        Date oldBsled = dynamicObject.getDate("bsled") == null ? maxLoseEffectDate : dynamicObject.getDate("bsled");
        String bsedStr = HRInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsed", (Date)oldBsed);
        String bsledStr = HRInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsled", (Date)oldBsled);
        String msg = MessageFormat.format(repeatErrorMsg, dynamicObject.getString("person.name"), dynamicObject.getString("employee.empnumber"), dynamicObject.getString("number"), bsedStr, bsledStr);
        this.addFatalErrorMessage(dataEntity, msg);
    }
}

