/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.salaryadjfile;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import org.apache.commons.lang3.StringUtils;

public class SalaryAdjFileUnableValidator
extends SWCDataBaseValidator {
    private static Log logger = LogFactory.getLog(SalaryAdjFileUnableValidator.class);
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);

    public boolean isAddBillNoForContent() {
        return false;
    }

    public void validate() {
        long startTime = System.currentTimeMillis();
        Map variables = this.getOption().getVariables();
        String bsledValue = (String)variables.get("var_bsled");
        Date newBsled = null;
        try {
            if (SWCStringUtils.isNotEmpty((String)bsledValue)) {
                newBsled = SWCDateTimeUtils.parseDate((String)bsledValue);
            }
        }
        catch (ParseException e1) {
            logger.error("\u586b\u5199\u7684\u5931\u6548\u65e5\u671f\u8f6c\u6362\u51fa\u9519,\u83b7\u53d6\u5230\u7684\u5b57\u7b26\u4e32\u503c\u4e3a{}", (Object)bsledValue);
            logger.error("\u9519\u8bef\u4fe1\u606f\u4e3a{}", (Object)e1.getMessage());
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        String formatStr = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7(%1$s)\uff1a%2$s", (String)"SalaryAdjFileUnableValidator_10", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String relateFormatStr = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7(%1$s)\uff1a%2$s%3$s%4$s", (String)"SalaryAdjFileUnableValidator_9", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String statusErrorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u5141\u8bb8\u5931\u6548\u3002", (String)"SalaryAdjFileUnableValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String formatErrorStr = ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u65e5\u671f\u683c\u5f0f\u3002", (String)"SalaryAdjFileUnableValidator_1", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String partTooEarlyBsled = ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u65e9\u4e8e%s\u751f\u6548\u65e5\u671f\u3002\u65e0\u6cd5\u8fdb\u884c\u5931\u6548\u64cd\u4f5c\u3002", (String)"SalaryAdjFileUnableValidator_4", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String adjFileName = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848", (String)"SalaryAdjFileUnableValidator_5", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String decideSalaryName = ResManager.loadKDString((String)"\u5b9a\u85aa", (String)"SalaryAdjFileUnableValidator_6", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String adjSalaryName = ResManager.loadKDString((String)"\u8c03\u85aa", (String)"SalaryAdjFileUnableValidator_7", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        Set fileIds = Arrays.stream(dataEntities).map(exEntity -> {
            DynamicObject dy = exEntity.getDataEntity();
            return dy.getLong("id");
        }).collect(Collectors.toSet());
        String opName = ResManager.loadKDString((String)"\u5931\u6548", (String)"SalaryAdjFileUnableValidator_8", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        Map relateMap = SalaryAdjFileServiceHelper.buildAdjFileRelateLog(fileIds, (String)opName);
        Map apprBillRelateLog = (Map)relateMap.get("apprBillRelateLog");
        Map adjSalSynRelateLog = (Map)relateMap.get("adjSalSynRelateLog");
        Map fileIdRecordMap = this.adjFileApplicationService.getDecideAdjSalaryObj(fileIds, true);
        for (ExtendedDataEntity exEntity2 : dataEntities) {
            String adjSalSynRelateMsg;
            DynamicObject dy = exEntity2.getDataEntity();
            if (!SWCStringUtils.equals((String)dy.getString("status"), (String)"C")) {
                this.addFatalErrorMessage(exEntity2, String.format(formatStr, dy.getString("number"), statusErrorMsg));
                continue;
            }
            if (null == newBsled) {
                this.addFatalErrorMessage(exEntity2, String.format(formatStr, dy.getString("number"), formatErrorStr));
                continue;
            }
            Long fileId = dy.getLong("id");
            List itemDyns = (List)fileIdRecordMap.get(fileId);
            HashMap attributionTypeMap = Maps.newHashMapWithExpectedSize((int)2);
            if (null != itemDyns) {
                for (DynamicObject itemDyn : itemDyns) {
                    String attributionType = itemDyn.getString("salaryadjrsn.attributiontype");
                    Date itemDate = itemDyn.getDate("bsed");
                    if (!SWCDateTimeUtils.dayBefore((Date)newBsled, (Date)itemDate) || !SWCStringUtils.isNotEmpty((String)attributionType)) continue;
                    attributionTypeMap.put(attributionType, itemDyn);
                }
            }
            StringJoiner sj = new StringJoiner("\u3001");
            Date adjFileBsedDate = dy.getDate("bsed");
            if (SWCDateTimeUtils.dayBefore((Date)newBsled, (Date)adjFileBsedDate)) {
                sj.add(adjFileName);
            }
            if (!attributionTypeMap.isEmpty()) {
                Set attributionTypeSet = attributionTypeMap.keySet();
                if (attributionTypeSet.contains(AdjAttributionType.DECATTRTYPE.getCode())) {
                    sj.add(decideSalaryName);
                }
                if (attributionTypeSet.contains(AdjAttributionType.ADJATTRTYPE.getCode())) {
                    sj.add(adjSalaryName);
                }
            }
            if (sj.length() > 0) {
                this.addFatalErrorMessage(exEntity2, String.format(Locale.ROOT, formatStr, dy.getString("number"), String.format(Locale.ROOT, partTooEarlyBsled, sj.toString())));
                continue;
            }
            String personNum = dy.getString("person.number");
            String personName = dy.getString("person.name");
            String number = dy.getString("number");
            String apprBillRelateRelateMsg = (String)apprBillRelateLog.get(fileId);
            if (StringUtils.isNotBlank((CharSequence)apprBillRelateRelateMsg)) {
                this.addFatalErrorMessage(exEntity2, String.format(relateFormatStr, number, personName, personNum, apprBillRelateRelateMsg));
            }
            if (!StringUtils.isNotBlank((CharSequence)(adjSalSynRelateMsg = (String)adjSalSynRelateLog.get(fileId)))) continue;
            this.addFatalErrorMessage(exEntity2, String.format(relateFormatStr, number, personName, personNum, adjSalSynRelateMsg));
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("SalaryAdjFileUnableValidator.validate: it takes {} milliseconds.", (Object)costTime);
    }
}

