/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.salaryadjfile;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.opplugin.validator.salaryadjfile.SalaryAdjFileUnableValidator;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;

public class SalaryAjdFileAbandonValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(SalaryAdjFileUnableValidator.class);

    public boolean isAddBillNoForContent() {
        return false;
    }

    public void validate() {
        long startTime = System.currentTimeMillis();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, ExtendedDataEntity> idExtendsedDataMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        String formatStr = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7(%1$s)\uff1a%2$s", (String)"SalaryAdjFileUnableValidator_10", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            String status = entity.getString("status");
            String number = entity.getString("number");
            if (SWCStringUtils.equals((String)status, (String)"E")) {
                this.addFatalErrorMessage(dataEntity, String.format(formatStr, number, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u5e9f\u5f03\u7684\u6570\u636e\u5141\u8bb8\u5e9f\u5f03\u3002", (String)"SalaryAjdFileAbandonValidator_0", (String)"swc-hcdm-opplugin", (Object[])new Object[0])));
                continue;
            }
            idExtendsedDataMap.put(dataEntity.getDataEntity().getLong("id"), dataEntity);
        }
        Set fileIdSet = idExtendsedDataMap.keySet();
        String relateFormatStr = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7(%1$s)\uff1a%2$s%3$s%4$s", (String)"SalaryAdjFileUnableValidator_9", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        String opName = ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"SalaryAjdFileAbandonValidator_2", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
        Map relateMap = SalaryAdjFileServiceHelper.buildAdjFileRelateLog(fileIdSet, (String)opName);
        Map apprBillRelateLog = (Map)relateMap.get("apprBillRelateLog");
        Map adjSalSynRelateLog = (Map)relateMap.get("adjSalSynRelateLog");
        for (Map.Entry entry : idExtendsedDataMap.entrySet()) {
            String adjSalSynRelateMsg;
            ExtendedDataEntity extendedFile = (ExtendedDataEntity)entry.getValue();
            DynamicObject adjFile = extendedFile.getDataEntity();
            String personNum = adjFile.getString("person.number");
            String personName = adjFile.getString("person.name");
            String number = adjFile.getString("number");
            String apprBillRelateRelateMsg = (String)apprBillRelateLog.get(entry.getKey());
            if (StringUtils.isNotBlank((String)apprBillRelateRelateMsg)) {
                this.addFatalErrorMessage(extendedFile, String.format(relateFormatStr, number, personName, personNum, apprBillRelateRelateMsg));
            }
            if (!StringUtils.isNotBlank((String)(adjSalSynRelateMsg = (String)adjSalSynRelateLog.get(entry.getKey())))) continue;
            this.addFatalErrorMessage(extendedFile, String.format(relateFormatStr, number, personName, personNum, adjSalSynRelateMsg));
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("SalaryAjdFileAbandonValidator.validate: it takes {} milliseconds.", (Object)costTime);
    }
}

