/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.opplugin.validator.scheme;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;

public class SalaryStdScmSubmitAndSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(SalaryStdScmSubmitAndSaveValidator.class);
    private static Date defaultDate;

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<String, ExtendedDataEntity> scmEntityMap = new HashMap<String, ExtendedDataEntity>(dataEntities.length);
        HashMap<String, ArrayList<Long>> scmStdIdMap = new HashMap<String, ArrayList<Long>>(16);
        HashSet<Long> salaryStdIdSet = new HashSet<Long>(16);
        HashMap<String, Object> scmNameMap = new HashMap<String, Object>(16);
        HashMap scmStdObjectMap = new HashMap(16);
        HashMap orgStructureIdsMap = new HashMap(16);
        String number = null;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            StringJoiner errMandatoryField;
            if (!SWCListUtils.isEmpty((List)this.validateContext.getValidateResults().getValidateErrors()) && ((ValidateResult)this.validateContext.getValidateResults().getValidateErrors().get(0)).getAllErrorInfo().size() > 0) continue;
            number = dataEntity.getDataEntity().getString("number");
            String name = dataEntity.getDataEntity().getString("name");
            scmNameMap.put(number, name);
            Long createOrg = dataEntity.getDataEntity().getLong("createorg.id");
            MulBasedataDynamicObjectCollection salaryStructure = (MulBasedataDynamicObjectCollection)dataEntity.getDataEntity().get("salaystructure");
            List salaryStructureIds = salaryStructure.stream().map(old -> old.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (SWCListUtils.isEmpty(salaryStructureIds)) {
                this.addErrorMessage(dataEntity, HCDMErrInfoEnum.COMMON_MUST_INPUT_VALUE.getMsg(new Object[]{ResManager.loadKDString((String)"\u85aa\u916c\u7ed3\u6784", (String)"AdjFileSaveOpValidator_4", (String)"swc-hcdm-opplugin", (Object[])new Object[0])}));
            }
            if ((errMandatoryField = CountryHelper.validate((DynamicObject)dataEntity.getDataEntity())).length() > 0) {
                this.addErrorMessage(dataEntity, HCDMErrInfoEnum.COMMON_MUST_INPUT_VALUE.getMsg(new Object[]{errMandatoryField.toString()}));
            }
            if (SWCListUtils.isEmpty(salaryStructureIds) || CountryHelper.validate((DynamicObject)dataEntity.getDataEntity()).length() > 0) continue;
            orgStructureIdsMap.put(createOrg, salaryStructureIds);
            DynamicObjectCollection collection = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            ArrayList mapList = new ArrayList(10);
            for (DynamicObject dynamicObject : collection) {
                if (!new HashSet(salaryStructureIds).contains(dynamicObject.getLong("salstructurent.id"))) {
                    this.addErrorMessage(dataEntity, HCDMErrInfoEnum.COMMON_MUST_INPUT_VALUE.getMsg(new Object[]{ResManager.loadKDString((String)"\u85aa\u916c\u7ed3\u6784", (String)"AdjFileSaveOpValidator_4", (String)"swc-hcdm-opplugin", (Object[])new Object[0])}));
                }
                long stdId = dynamicObject.getLong("salarystandard.id");
                String stdName = dynamicObject.getString("salarystandard.name");
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("stdId", stdId);
                map.put("stdName", stdName);
                if (dynamicObject.containsProperty("coefficienttabent")) {
                    map.put("stdName", stdName);
                }
                if (dynamicObject.containsProperty("standarditem")) {
                    map.put("itemId", dynamicObject.getLong("standarditem.id"));
                    map.put("itemName", dynamicObject.getString("standarditem.name"));
                }
                mapList.add(map);
                salaryStdIdSet.add(stdId);
                ArrayList<Long> list = (ArrayList<Long>)scmStdIdMap.get(number);
                if (null != list && !list.isEmpty()) {
                    list.add(stdId);
                    scmStdIdMap.put(number, list);
                    continue;
                }
                list = new ArrayList<Long>();
                list.add(stdId);
                scmStdIdMap.put(number, list);
            }
            scmStdObjectMap.put(number, mapList);
            scmEntityMap.put(number, dataEntity);
        }
        Map salaryStdItemMap = SalaryStdItemHelper.queryItemEntities(salaryStdIdSet);
        HashSet errorList = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry entry : scmStdObjectMap.entrySet()) {
            for (Object ent : (List)entry.getValue()) {
                Set itemIds;
                List itemEntities = (List)salaryStdItemMap.get(ent.get("stdId"));
                if (SWCListUtils.isEmpty((List)itemEntities) || (itemIds = itemEntities.stream().map(SalaryStdItemEntity::getSalaryItemId).collect(Collectors.toSet())) == null || itemIds.contains(ent.get("itemId"))) continue;
                String pattern = ResManager.loadKDString((String)"%1$s\uff1a%2$s\u7684%3$s\u4e2d\u4e0d\u5b58\u5728%4$s\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u6dfb\u52a0\u3002", (String)"SalaryStdScmSubmitAndSaveValidator_3", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                String content = String.format(pattern, entry.getKey(), scmNameMap.get(entry.getKey()), ent.get("stdName"), ent.get("itemName"));
                errorList.add(content);
            }
        }
        if (errorList.size() > 0) {
            for (Map.Entry scmEntityEntry : scmEntityMap.entrySet()) {
                ExtendedDataEntity scmEntity = (ExtendedDataEntity)scmEntityEntry.getValue();
                for (ExtendedDataEntity[] error : errorList) {
                    this.addFatalErrorMessage(scmEntity, (String)error);
                }
            }
            return;
        }
        SWCDataServiceHelper service = new SWCDataServiceHelper("hcdm_stdscm");
        QFilter qFilter = new QFilter("createorg", "in", orgStructureIdsMap.keySet());
        qFilter.and(new QFilter("status", "=", (Object)"A").or(new QFilter("status", "=", (Object)"B")).or(new QFilter("status", "=", (Object)"C")));
        qFilter.and(new QFilter("number", "!=", (Object)number));
        qFilter.and(new QFilter("datastatus", "not in", (Object)new String[]{"-2"}));
        DynamicObject[] stdScms = service.query("number,name,createorg,salaystructure,bsed,bsled", new QFilter[]{qFilter});
        if (stdScms.length > 0) {
            List<DynamicObject> stdScmsList = Arrays.asList(stdScms);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                ArrayList salaryStructureIdsList = Lists.newArrayListWithExpectedSize((int)10);
                for (DynamicObject stdScm : stdScmsList) {
                    if (stdScm.get("number").equals(dataEntity.getDataEntity().get("number")) || !this.checkDate(stdScm, dataEntity)) continue;
                    MulBasedataDynamicObjectCollection salaryStructure = (MulBasedataDynamicObjectCollection)stdScm.get("salaystructure");
                    Set salaryStructureIdsPage = salaryStructure.stream().map(old -> old.getLong("fbasedataid_id")).collect(Collectors.toSet());
                    salaryStructureIdsList.add(salaryStructureIdsPage);
                }
                Set<Long> salaryStructureIds = this.getSalaryStructureIds(salaryStructureIdsList);
                SWCDataServiceHelper structureService = new SWCDataServiceHelper("hcdm_salaystructure");
                QFilter structureQFilter = new QFilter("id", "in", salaryStructureIds);
                DynamicObject[] candiDatEntObj = structureService.query("id,name", new QFilter[]{structureQFilter});
                Map<Long, String> salaryStructureMap = Arrays.stream(candiDatEntObj).collect(Collectors.toMap(object -> object.getLong("id"), object -> object.getString("name")));
                MulBasedataDynamicObjectCollection salaryStructure = (MulBasedataDynamicObjectCollection)dataEntity.getDataEntity().get("salaystructure");
                Set salaryStructureIdsPage = salaryStructure.stream().map(old -> old.getLong("fbasedataid_id")).collect(Collectors.toSet());
                salaryStructureIds.retainAll(salaryStructureIdsPage);
                if (salaryStructureIds.size() <= 0) continue;
                for (Long salaryStructureId : salaryStructureIds) {
                    errorList.add(salaryStructureMap.get(salaryStructureId));
                }
            }
            if (errorList.size() > 0) {
                for (Map.Entry scmEntityEntry : scmEntityMap.entrySet()) {
                    ExtendedDataEntity dataEntity;
                    ExtendedDataEntity scmEntity = (ExtendedDataEntity)scmEntityEntry.getValue();
                    dataEntity = scmEntity.getDataEntity();
                    String createOrgName = dataEntity.getString("createorg.name");
                    String pattern = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u4e3a%2$s\u4e14\u85aa\u916c\u7ed3\u6784\u4e3a%3$s\u7684\u85aa\u916c\u4f53\u7cfb\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u6dfb\u52a0\u3002", (String)"SalaryStdScmSubmitAndSaveValidator_4", (String)"swc-hcdm-opplugin", (Object[])new Object[0]);
                    for (String error : errorList) {
                        String content = String.format(pattern, dataEntity.getString("number"), createOrgName, error);
                        this.addFatalErrorMessage(scmEntity, content);
                    }
                }
            }
        }
    }

    private boolean checkDate(DynamicObject stdsCms, ExtendedDataEntity dataEntity) {
        return SWCDateTimeUtils.isDateRangeOverlap((Date)dataEntity.getDataEntity().getDate("bsed"), (Date)dataEntity.getDataEntity().getDate("bsled"), (Date)stdsCms.getDate("bsed"), (Date)stdsCms.getDate("bsled"));
    }

    private Set<Long> getSalaryStructureIds(List<Set<Long>> salaryStructureIdsList) {
        HashSet salaryStructureIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Set<Long> ids : salaryStructureIdsList) {
            salaryStructureIds.addAll(ids);
        }
        return salaryStructureIds;
    }

    static {
        try {
            defaultDate = SWCDateTimeUtils.parseDate((String)"2999-12-31");
        }
        catch (ParseException e) {
            LOGGER.error("\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff1a{}", (Object)e.getMessage());
        }
    }
}

