/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.report;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.swc.hcdm.business.report.AdjDetailReportDisplayHelper;
import kd.swc.hcdm.business.report.entity.AdjDetailRptQueryInfo;
import kd.swc.hcdm.report.AdjDetailReportAbstractPlugin;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjDetailReportPlugin
extends AdjDetailReportAbstractPlugin {
    private final Log logger = LogFactory.getLog(AdjDetailReportPlugin.class);

    @Override
    protected DataSet queryBatchBy(ReportQueryParam queryParam, AdjDetailRptQueryInfo queryInfo, boolean isLoadAll) {
        int queryByBatchSize = queryInfo.getQueryByBatchSize();
        int batchSize = queryInfo.getBatchSize();
        List<QFilter> filters = queryInfo.getFilters().stream().filter(query -> !SWCObjectUtils.isEmpty((Object)query)).collect(Collectors.toList());
        this.logger.info("AdjDetailReportPlugin doQueryBatchBy filters 111:{}", filters);
        if (SWCStringUtils.isEmpty((String)queryInfo.getOrderByStr())) {
            queryInfo.setOrderByStr("hcdm_decadjrelperson.empnumber ASC,bsed DESC");
        }
        this.logger.info("AdjDetailReportPlugin doQueryBatchBy orderByStr:{}", (Object)queryInfo.getOrderByStr());
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryInfo.getQueryEntityCode());
        this.logger.info("AdjDetailReportPlugin doQueryBatchBy start");
        List idList = !isLoadAll ? HRQueryEntityHelper.getInstance().queryAllPkByKSql(queryEntityType, filters.toArray(new QFilter[0]), queryInfo.getOrderByStr(), 0, queryByBatchSize) : HRQueryEntityHelper.getInstance().queryAllPkByKSql(queryEntityType, filters.toArray(new QFilter[0]), queryInfo.getOrderByStr());
        this.logger.info("AdjDetailReportPlugin doQueryBatchBy end");
        if (CollectionUtils.isEmpty((Collection)idList)) {
            queryInfo.setLoadAll(true);
            RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType)});
            DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
            dataSetBuilder.append(new Object[]{0L});
            return dataSetBuilder.build();
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        queryParam.byBatchInfo().setCountPerBatch(batchSize);
        int total = idList.size();
        this.logger.info("AdjDetailReportPlugin doQueryBatchBy total:{}", (Object)total);
        queryInfo.setTotalBatch(this.getPageCount(total, queryInfo.getBatchSize()));
        if (total < queryByBatchSize) {
            queryInfo.setLoadAll(true);
            this.cacheIsLoadAll(queryInfo);
        }
        for (Object id : idList) {
            dataSetBuilder.append(new Object[]{id});
        }
        return dataSetBuilder.build();
    }

    @Override
    protected DataSet query(ReportQueryParam reportQueryParam, Object obj, AdjDetailRptQueryInfo queryInfo) {
        List currentBatchRows = reportQueryParam.byBatchInfo().getCurrentBatchRows();
        int currentBatchIndex = reportQueryParam.byBatchInfo().getCurrentBatchIndex();
        HashSet idList = Sets.newHashSetWithExpectedSize((int)queryInfo.getQueryByBatchSize());
        if (currentBatchRows != null && !currentBatchRows.isEmpty()) {
            for (Row currentBatchRow : currentBatchRows) {
                Long matId = currentBatchRow.getLong("id");
                idList.add(matId);
            }
        }
        if (idList.isEmpty()) {
            this.logger.info("AdjDetailReportPlugin doQuery currentBatchIndex:{} idList is null or empty, return null.", (Object)currentBatchIndex);
            RowMeta rowMeta = queryInfo.getRowMeta();
            if (null == queryInfo.getRowMeta()) {
                rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType)});
            }
            return AdjDetailReportDisplayHelper.buildDataSet((RowMeta)rowMeta, null, (String)((Object)((Object)this)).getClass().getName());
        }
        this.logger.info("AdjDetailReportPlugin doQuery idList:{},{}", (Object)idList.size(), (Object)idList);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryInfo.getQueryEntityCode());
        List mainSelectFieldList = queryInfo.getMainSelectFields();
        if (SWCListUtils.isEmpty((List)mainSelectFieldList)) {
            RowMeta rowMeta = queryInfo.getRowMeta();
            if (null == queryInfo.getRowMeta()) {
                rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType)});
            }
            return AdjDetailReportDisplayHelper.buildDataSet((RowMeta)rowMeta, null, (String)((Object)((Object)this)).getClass().getName());
        }
        HashSet mainSelectFields = new HashSet(mainSelectFieldList);
        if (!mainSelectFields.contains("relpersonid")) {
            mainSelectFieldList.add("relpersonid");
        }
        if (!mainSelectFields.contains("currency.id")) {
            mainSelectFieldList.add("currency.id");
        }
        if (!mainSelectFields.contains("bsed")) {
            mainSelectFieldList.add("bsed");
        }
        if (!mainSelectFields.contains("hcdm_decadjrelperson.empnumber")) {
            mainSelectFieldList.add("hcdm_decadjrelperson.empnumber");
        }
        if (!mainSelectFields.contains("salargrel")) {
            mainSelectFieldList.add("salargrel");
        }
        if (!mainSelectFields.contains("salarystd.id")) {
            mainSelectFieldList.add("salarystd.id");
        }
        if (!mainSelectFields.contains("salaryadjrsn.attributiontype")) {
            mainSelectFieldList.add("salaryadjrsn.attributiontype");
        }
        if (!mainSelectFields.contains("standarditem.id")) {
            mainSelectFieldList.add("standarditem.id");
        }
        String selectProperties = String.join((CharSequence)",", mainSelectFieldList);
        this.logger.info("AdjDetailReportPlugin#query:{}", (Object)selectProperties);
        QFilter qFilter = new QFilter("id", "in", (Object)idList);
        long startTime = System.currentTimeMillis();
        DataSet dataSet = HRQueryEntityHelper.getInstance().getQueryDataSet(queryEntityType, selectProperties, new QFilter[]{qFilter}, "", 0, idList.size());
        long endTime = System.currentTimeMillis();
        this.logger.info("SalaryDetailQueryRpt doQuery \u6839\u636eid\u67e5\u8be2 \u7ed3\u675f\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
        if (dataSet == null) {
            this.logger.info("SalaryDetailQueryRpt doQuery no data");
            RowMeta rowMeta = queryInfo.getRowMeta();
            if (null == queryInfo.getRowMeta()) {
                rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType)});
            }
            return AdjDetailReportDisplayHelper.buildDataSet((RowMeta)rowMeta, null, (String)((Object)((Object)this)).getClass().getName());
        }
        String[] orderBy = this.getOrderBy(queryInfo);
        if (orderBy != null) {
            return dataSet.orderBy(orderBy);
        }
        return dataSet;
    }

    private int getPageCount(int totalCount, int pageSize) {
        return totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1;
    }

    private String[] getOrderBy(AdjDetailRptQueryInfo queryInfo) {
        String orderByStr = queryInfo.getOrderByStr();
        if (StringUtils.isEmpty((CharSequence)orderByStr)) {
            return null;
        }
        String[] orderBy = orderByStr.split(",");
        if ("2".equals(queryInfo.getSumTypeSign())) {
            String[] newOrderBy = (String[])queryInfo.getCustomPara("newOrderBy", String[].class);
            if (newOrderBy == null) {
                newOrderBy = new String[orderBy.length + 1];
                for (int i = 0; i < newOrderBy.length; ++i) {
                    newOrderBy[i] = i < 2 ? orderBy[i] : (i == 2 ? "rowtype" : orderBy[i - 1]);
                }
                queryInfo.addCustomPara("newOrderBy", (Object)newOrderBy);
            }
            return newOrderBy;
        }
        return orderBy;
    }
}

