/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.mservice;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.OnBrdInfoPushToCandSetSalApplService;
import kd.swc.hcdm.mservice.api.ICandidateSalaryService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections4.MapUtils;

public class CandidateSalaryServiceImpl
implements ICandidateSalaryService {
    private static Log logger = LogFactory.getLog(CandidateSalaryServiceImpl.class);
    public static final String SQL_HOLDER = "?";
    public static final String SUCCESS = "success";
    public static final String MESSAGE = "message";
    public static final String DATA = "data";
    public static final String AESKEY = "@Salary&Offer123";
    public static final char SPACE = ' ';

    public Map<String, Object> queryCandidateSalaryByOffer(String offerCode, List<Long> list) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        ArrayList result = new ArrayList();
        try {
            SWCDataServiceHelper service = new SWCDataServiceHelper("hcdm_candidatebill");
            QFilter qFilter = new QFilter("offercode", "=", (Object)offerCode);
            qFilter.and(new QFilter("entryentityoffer.standarditemoffer.id", "in", (Object)list.toArray()));
            DynamicObject candiDatEntObj = service.queryOne("id, currency,currency.number, entryentityoffer, entryentityoffer.standarditemoffer, entryentityoffer.standarditemoffer.id, entryentityoffer.confirmedamountoffer", new QFilter[]{qFilter});
            if (!SWCObjectUtils.isEmpty((Object)candiDatEntObj)) {
                DynamicObjectCollection entryEntityOffer = candiDatEntObj.getDynamicObjectCollection("entryentityoffer");
                DynamicObject currency = candiDatEntObj.getDynamicObject("currency");
                entryEntityOffer.forEach(object -> {
                    StringBuilder sb = new StringBuilder();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("salarystditemoffid", object.getLong("standarditemoffer.id"));
                    if (!SWCObjectUtils.isEmpty((Object)currency)) {
                        BigDecimal amount = object.getBigDecimal("confirmedamountoffer");
                        int amtprecision = currency.getInt("amtprecision");
                        amount = amount.setScale(amtprecision, 5);
                        DecimalFormat df = new DecimalFormat(this.decimalFormat(amtprecision));
                        sb.append(currency.get("name")).append(' ').append(currency.get("number")).append(' ').append(currency.get("sign"));
                        sb.append(df.format(amount));
                    }
                    map.put("currency", EncrypterFactory.getAesEncrypter().encrypt(sb.toString(), AESKEY, 128));
                    result.add(map);
                });
            }
            resultMap.put(SUCCESS, Boolean.TRUE);
            resultMap.put(DATA, result);
        }
        catch (Exception ex) {
            resultMap.put(SUCCESS, Boolean.FALSE);
            resultMap.put(MESSAGE, ex.getMessage());
        }
        return resultMap;
    }

    private String decimalFormat(int amtprecision) {
        if (amtprecision <= 0) {
            return "###,###";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("###,###0.");
        for (int i = 0; i < amtprecision; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }

    public Map<String, Object> addCandidateSalary(List<Map<String, Object>> list) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        try {
            if (!SWCListUtils.isEmpty(list)) {
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_candidatebill");
                ArrayList emptyCandidates = new ArrayList(list.size());
                list.stream().forEach(map -> {
                    DynamicObject emptyCandidate = helper.generateEmptyDynamicObject();
                    this.dealDate(emptyCandidate, (Map<String, Object>)map, false);
                    emptyCandidates.add(emptyCandidate);
                });
                OperationServiceImpl opImpl = new OperationServiceImpl();
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("skipCheckDataPermission", "true");
                option.setVariableValue("skipCheckSpecialDataPermission", "true");
                OperationResult result = opImpl.localInvokeOperation("save", emptyCandidates.toArray(new DynamicObject[0]), option);
                if (result.isSuccess()) {
                    this.getErrMsg(resultMap, result);
                } else {
                    resultMap.put(SUCCESS, Boolean.TRUE);
                }
            }
        }
        catch (Exception ex) {
            resultMap.put(SUCCESS, Boolean.FALSE);
            resultMap.put(MESSAGE, ex.getMessage());
        }
        return resultMap;
    }

    private void dealDate(DynamicObject emptyCandidate, Map<String, Object> data, boolean isEdit) {
        emptyCandidate.set("recruitmenttype", data.get("recruitmentType"));
        emptyCandidate.set("offercode", data.get("offerCode"));
        emptyCandidate.set("offerid", data.get("offerId"));
        emptyCandidate.set("recruitId", data.get("recruitId"));
        emptyCandidate.set("salarystructure", (Object)this.setEntityInfo("hcdm_salaystructure", data.get("salaryStructureId")));
        emptyCandidate.set("currency", (Object)this.setEntityInfo("bd_currency", data.get("currencyId")));
        emptyCandidate.set("salarytype", data.get("salaryType"));
        emptyCandidate.set("stdscm", (Object)this.setEntityInfo("hcdm_stdscm", data.get("stdscm")));
        emptyCandidate.set("salaryadjorg", (Object)this.setEntityInfo("bos_org", data.get("salaryAdjOrg")));
        emptyCandidate.set("billstatus", (Object)"A");
        if (!isEdit) {
            String billNo = CodeRuleServiceHelper.getNumber((String)"hcdm_candidatebill", (DynamicObject)emptyCandidate, null);
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                emptyCandidate.set("billno", (Object)billNo);
            } else {
                emptyCandidate.set("billno", (Object)String.valueOf(System.currentTimeMillis() / 1000L));
            }
            emptyCandidate.set("org", (Object)RequestContext.get().getOrgId());
            emptyCandidate.set("creator", (Object)RequestContext.get().getCurrUserId());
            emptyCandidate.set("createtime", (Object)new Date());
        }
        emptyCandidate.set("org", (Object)RequestContext.get().getOrgId());
        emptyCandidate.set("creator", (Object)RequestContext.get().getCurrUserId());
        emptyCandidate.set("createtime", (Object)new Date());
        DynamicObjectCollection entry = emptyCandidate.getDynamicObjectCollection("entryentity");
        List entryEntity = (List)data.get("entryEntity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            entry.clear();
            entryEntity.stream().forEach(map -> {
                DynamicObject entity = new DynamicObject(entry.getDynamicObjectType());
                entity.set("standarditem", (Object)this.setEntityInfo("hsbs_standarditem", map.get("salarystditemId")));
                entity.set("currencyent", (Object)this.setEntityInfo("bd_currency", map.get("currencyentId")));
                entity.set("frequency", (Object)this.setEntityInfo("hsbs_calfrequency", map.get("frequencyId")));
                entity.set("issend", map.get("isSend"));
                entity.set("remark", map.get("remark"));
                entity.set("confirmedamount", map.get("confirmedamount"));
                entry.add((Object)entity);
            });
        }
        DynamicObjectCollection entryOffer = emptyCandidate.getDynamicObjectCollection("entryentityoffer");
        List entryentityoffer = (List)data.get("entryEntityOffer");
        if (!CollectionUtils.isEmpty((Collection)entryentityoffer)) {
            entryOffer.clear();
            entryentityoffer.stream().forEach(map -> {
                DynamicObject entityOffer = new DynamicObject(entryOffer.getDynamicObjectType());
                entityOffer.set("standarditemoffer", (Object)this.setEntityInfo("hsbs_standarditem", map.get("salaryStdItemOfferId")));
                entityOffer.set("confirmedamountoffer", map.get("confirmedAmountOffer"));
                entryOffer.add((Object)entityOffer);
            });
        }
    }

    private void dealDateCandecidedPage(DynamicObject emptyCandidate, Map<String, Object> data) {
        emptyCandidate.set("offercode", data.get("offerCode"));
        emptyCandidate.set("offerid", data.get("offerId"));
        emptyCandidate.set("recruitId", data.get("recruitId"));
        emptyCandidate.set("salarystructure", (Object)this.setEntityInfo("hcdm_salaystructure", data.get("salaryStructureId")));
        emptyCandidate.set("currency", (Object)this.setEntityInfo("bd_currency", data.get("currencyId")));
        emptyCandidate.set("salarytypenew", (Object)this.setEntityInfo("hsbs_salaryadjustrsn", data.get("salaryType")));
        emptyCandidate.set("stdscm", (Object)this.setEntityInfo("hcdm_stdscm", data.get("stdscm")));
        emptyCandidate.set("salaryadjorg", (Object)this.setEntityInfo("bos_org", data.get("salaryAdjOrg")));
        DynamicObjectCollection entry = emptyCandidate.getDynamicObjectCollection("entryentity");
        List entryEntity = (List)data.get("entryEntity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            entryEntity.stream().forEach(map -> {
                DynamicObject entity = new DynamicObject(entry.getDynamicObjectType());
                entity.set("standarditem", (Object)this.setEntityInfo("hsbs_standarditem", map.get("salarystditemId")));
                entity.set("currencyent", (Object)this.setEntityInfo("bd_currency", map.get("currencyentId")));
                entity.set("frequency", (Object)this.setEntityInfo("hsbs_calfrequency", map.get("frequencyId")));
                entity.set("issend", map.get("isSend"));
                entity.set("remark", map.get("remark"));
                entity.set("confirmedamount", map.get("confirmedamount"));
                entry.add((Object)entity);
            });
        }
        DynamicObjectCollection entryOffer = emptyCandidate.getDynamicObjectCollection("entryentityoffer");
        List entryentityoffer = (List)data.get("entryEntityOffer");
        if (!CollectionUtils.isEmpty((Collection)entryentityoffer)) {
            entryentityoffer.stream().forEach(map -> {
                DynamicObject entityOffer = new DynamicObject(entryOffer.getDynamicObjectType());
                entityOffer.set("standarditemoffer", (Object)this.setEntityInfo("hsbs_standarditem", map.get("salaryStdItemOfferId")));
                entityOffer.set("confirmedamountoffer", map.get("confirmedAmountOffer"));
                entryOffer.add((Object)entityOffer);
            });
        }
    }

    private DynamicObject setEntityInfo(String entityName, Object Id) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
        dynamicObject.set("id", Id);
        return dynamicObject;
    }

    public Map<Long, DynamicObject> generateFullCandSetSalAppl(Map<Long, DynamicObject> originDynamicObjectMap) {
        return OnBrdInfoPushToCandSetSalApplService.generateFullCandSetSalAppl(originDynamicObjectMap);
    }

    public Map<String, Object> queryCandidateSalaryByOfferId(Long offerId, List<Long> list) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        ArrayList result = new ArrayList();
        try {
            SWCDataServiceHelper service = new SWCDataServiceHelper("hcdm_candidatebill");
            QFilter qFilter = new QFilter("offerid", "=", (Object)offerId);
            qFilter.and(new QFilter("entryentityoffer.standarditemoffer.id", "in", (Object)list.toArray()));
            DynamicObject candiDatEntObj = service.queryOne("id, currency,currency.number, entryentityoffer, entryentityoffer.standarditemoffer, entryentityoffer.standarditemoffer.id, entryentityoffer.confirmedamountoffer", new QFilter[]{qFilter});
            if (!SWCObjectUtils.isEmpty((Object)candiDatEntObj)) {
                DynamicObjectCollection entryEntityOffer = candiDatEntObj.getDynamicObjectCollection("entryentityoffer");
                DynamicObject currency = candiDatEntObj.getDynamicObject("currency");
                entryEntityOffer.forEach(object -> {
                    StringBuilder sb = new StringBuilder();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("salarystditemoffid", object.getLong("standarditemoffer.id"));
                    if (!SWCObjectUtils.isEmpty((Object)currency)) {
                        BigDecimal amount = object.getBigDecimal("confirmedamountoffer");
                        int amtprecision = currency.getInt("amtprecision");
                        amount = amount.setScale(amtprecision, 5);
                        DecimalFormat df = new DecimalFormat(this.decimalFormat(amtprecision));
                        sb.append(currency.get("name")).append(' ').append(currency.get("number")).append(' ').append(currency.get("sign"));
                        sb.append(df.format(amount));
                    }
                    map.put("currency", EncrypterFactory.getAesEncrypter().encrypt(sb.toString(), AESKEY, 128));
                    result.add(map);
                });
            }
            resultMap.put(SUCCESS, Boolean.TRUE);
            resultMap.put(DATA, result);
        }
        catch (Exception ex) {
            resultMap.put(SUCCESS, Boolean.FALSE);
            resultMap.put(MESSAGE, ex.getMessage());
        }
        return resultMap;
    }

    public Map<String, Object> checkPermissionOfCandidateSalaryByOfferId(Long offerId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_candidatebill");
        QFilter offerIdFilter = new QFilter("offerid", "=", (Object)offerId);
        DynamicObject dynamicObject = helper.queryOne("id,salarytype,stdscm,salaryadjorg,salarystructure", new QFilter[]{offerIdFilter});
        if (null == dynamicObject) {
            resultMap.put(SUCCESS, Boolean.TRUE);
            return resultMap;
        }
        Long salarystructureID = dynamicObject.getLong("salarystructure.id");
        Long salaryadjorgID = dynamicObject.getLong("salaryadjorg.id");
        String message = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u85aa\u916c\u5b9a\u85aa>\u5b9a\u85aa\u201d\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CandidateSalaryServiceImpl_0", (String)"swc-hcdm-mservice", (Object[])new Object[0]);
        if (this.checkCandidateDataPermission(salarystructureID, salaryadjorgID)) {
            resultMap.put(SUCCESS, Boolean.FALSE);
            resultMap.put(MESSAGE, message);
            return resultMap;
        }
        resultMap.put(SUCCESS, Boolean.TRUE);
        return resultMap;
    }

    private boolean checkCandidateDataPermission(Object salarystructureID, Object salaryadjorgID) {
        Set salaryStructureIds = SWCPermissionServiceHelper.getSalayStructureSetByPermItem((String)"tsrsc", (String)"hcdm_candecidedpage", (String)"47150e89000000ac");
        Set salaryPayrollCdmIds = SWCPermissionServiceHelper.getPayrollCdmSetByPermItem((String)"tsrsc", (String)"hcdm_candecidedpage", (String)"47150e89000000ac");
        if (null != salaryStructureIds && !salaryStructureIds.contains(salarystructureID)) {
            return true;
        }
        return null != salaryPayrollCdmIds && !salaryPayrollCdmIds.contains(salaryadjorgID);
    }

    public Map<String, Object> saveCandidateSalary(Map<String, Object> data) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        try {
            Object emptyCandidate;
            if (CollectionUtils.isEmpty(data) || null == data.get("offerId")) {
                resultMap.put(SUCCESS, Boolean.FALSE);
                resultMap.put(MESSAGE, "offerId is empty");
                return resultMap;
            }
            String operation = MapUtils.getString(data, (Object)"operation");
            if (StringUtils.isEmpty((CharSequence)operation)) {
                resultMap.put(SUCCESS, Boolean.FALSE);
                resultMap.put(MESSAGE, "operation is empty");
                return resultMap;
            }
            Long salaryAdjOrg = MapUtils.getLong(data, (Object)"salaryAdjOrg");
            Long salaryStructureId = MapUtils.getLong(data, (Object)"salaryStructureId");
            String message = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u85aa\u916c\u5b9a\u85aa>\u5b9a\u85aa\u201d\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CandidateSalaryServiceImpl_0", (String)"swc-hcdm-mservice", (Object[])new Object[0]);
            if (this.checkCandidateDataPermission(salaryStructureId, salaryAdjOrg)) {
                resultMap.put(SUCCESS, Boolean.FALSE);
                resultMap.put(MESSAGE, message);
                return resultMap;
            }
            SWCDataServiceHelper candidatePageHelper = new SWCDataServiceHelper("hcdm_candecidedpage");
            DynamicObject emptyCandidateDy = candidatePageHelper.generateEmptyDynamicObject();
            this.dealDateCandecidedPage(emptyCandidateDy, data);
            String operationKey = "";
            if (StringUtils.equals((CharSequence)operation, (CharSequence)"save")) {
                operationKey = "donothing_save";
            } else if (StringUtils.equals((CharSequence)operation, (CharSequence)"submit")) {
                operationKey = "donothing_submit";
            } else {
                resultMap.put(SUCCESS, Boolean.FALSE);
                resultMap.put(MESSAGE, "operation is error");
                return resultMap;
            }
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("skipCheckDataPermission", "true");
            option.setVariableValue("skipCheckSpecialDataPermission", "true");
            OperationResult result = opImpl.localInvokeOperation(operationKey, new DynamicObject[]{emptyCandidateDy}, option);
            if (!result.isSuccess()) {
                resultMap.put("operation_result", this.getNewResult(result));
                resultMap.put(SUCCESS, Boolean.FALSE);
                return resultMap;
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_candidatebill");
            Object offerId = data.get("offerId");
            QFilter offerIdFilter = new QFilter("offerid", "=", offerId);
            Object[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{offerIdFilter});
            boolean isEdit = false;
            if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
                emptyCandidate = helper.generateEmptyDynamicObject();
            } else {
                emptyCandidate = dynamicObjects[0];
                isEdit = true;
            }
            this.dealDate((DynamicObject)emptyCandidate, data, isEdit);
            OperationServiceImpl saveOpImpl = new OperationServiceImpl();
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("ishasright", "true");
            saveOption.setVariableValue("skipCheckDataPermission", "true");
            saveOption.setVariableValue("skipCheckSpecialDataPermission", "true");
            result = saveOpImpl.localInvokeOperation("save", new DynamicObject[]{emptyCandidate}, saveOption);
            if (!result.isSuccess()) {
                resultMap.put("operation_result", this.getNewResult(result));
                resultMap.put(SUCCESS, Boolean.FALSE);
            } else {
                resultMap.put(SUCCESS, Boolean.TRUE);
            }
        }
        catch (Exception ex) {
            resultMap.put(SUCCESS, Boolean.FALSE);
            resultMap.put(MESSAGE, ex.getMessage());
        }
        return resultMap;
    }

    private OperationResult getNewResult(OperationResult result) {
        if (result == null) {
            return null;
        }
        OperationResult newResult = new OperationResult();
        newResult.setSuccess(result.isSuccess());
        newResult.setValidateResult(result.getValidateResult());
        newResult.setCancelWriteLog(result.isCancelWriteLog());
        newResult.setMessage(result.getMessage());
        newResult.setBillCount(result.getBillCount());
        return newResult;
    }

    private void getErrMsg(Map<String, Object> resultMap, OperationResult result) {
        StringBuilder msgSb = new StringBuilder();
        msgSb.append(result.getMessage());
        List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            allErrorOrValidateInfo.forEach(obj -> {
                logger.info("CandidateSalaryServiceImpl.invokeOperate invoke OP error : operationKey=save entityNumber = hcdm_candidatebill id = {} ------ msg = {} ", obj.getPkValue(), (Object)obj.getMessage());
                msgSb.append(obj.getMessage());
            });
        }
        resultMap.put(SUCCESS, Boolean.FALSE);
        resultMap.put(MESSAGE, msgSb.toString());
    }
}

