/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.mservice;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.swc.hcdm.mservice.api.IHCDMCandidateService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class HCDMCandidateService
implements IHCDMCandidateService {
    private static final Log log = LogFactory.getLog(HCDMCandidateService.class);
    private static final String DELETE = "delete";
    private static final String DISCARD = "discard";
    private static final String BILL_STATUS = "billstatus";
    private static final String BILL_STATUS_DELETE = "H";
    private static final String BILL_STATUS_DISCARD = "I";

    public HRMServiceResult consumerSaveMsg(DynamicObject dynamicObject) {
        try {
            String content = dynamicObject.getString("msgcontent");
            if (StringUtils.isEmpty((CharSequence)content)) {
                return HRMServiceResult.fail((String)"msgcontent is empty");
            }
            Map contentMap = (Map)SerializationUtils.deSerializeFromBase64((String)content);
            List offerCodeList = (List)contentMap.get("offerCode");
            List offerIdList = (List)contentMap.get("offerId");
            String offerStatus = (String)contentMap.get("offerStatus");
            if (CollectionUtils.isEmpty((Collection)offerCodeList)) {
                return HRMServiceResult.fail((String)"offerCode is empty");
            }
            if (CollectionUtils.isEmpty((Collection)offerIdList)) {
                return HRMServiceResult.fail((String)"offerId is empty");
            }
            log.info("offerCode::{}", (Object)offerCodeList.toString());
            log.info("offerStatus::{}", (Object)offerStatus);
            SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hcdm_candidatebill");
            QFilter qFilter = new QFilter("offercode", "in", (Object)offerCodeList);
            QFilter offerIdFilter = new QFilter("offerid", "in", (Object)offerIdList);
            Object[] dys = fileHelper.query("id,billstatus", new QFilter[]{qFilter, offerIdFilter});
            if (ArrayUtils.isEmpty((Object[])dys)) {
                return HRMServiceResult.success();
            }
            block10: for (Object dbDynamicObj : dys) {
                if (SWCObjectUtils.isEmpty((Object)offerStatus)) continue;
                switch (offerStatus) {
                    case "delete": {
                        dbDynamicObj.set(BILL_STATUS, (Object)BILL_STATUS_DELETE);
                        continue block10;
                    }
                    case "discard": {
                        dbDynamicObj.set(BILL_STATUS, (Object)BILL_STATUS_DISCARD);
                        continue block10;
                    }
                    default: {
                        dbDynamicObj.set(BILL_STATUS, (Object)offerStatus);
                    }
                }
            }
            fileHelper.update((DynamicObject[])dys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return HRMServiceResult.fail((String)e.getMessage());
        }
        return HRMServiceResult.success();
    }
}

