/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.mservice;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActEntryService;
import kd.swc.hcdm.business.mq.CandSetSalActConsumer;
import kd.swc.hcdm.mservice.api.IHCDMConfirmEntryService;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import org.apache.commons.collections4.MapUtils;

public class HCDMConfirmEntryServiceImpl
implements IHCDMConfirmEntryService {
    private static final Log logger = LogFactory.getLog(CandSetSalActConsumer.class);

    public HRMServiceResult consumerSaveMsg(DynamicObject paraDyn) {
        logger.info("HCDMConfirmEntryServiceImpl consumerSaveMsg start...");
        if (paraDyn == null) {
            logger.info("HCDMConfirmEntryServiceImpl consumerSaveMsg paraDyn is null.");
            throw new KDBizException("HCDMConfirmEntryServiceImpl consumerSaveMsg paraDyn is null.");
        }
        try {
            Map<Long, Long> onbrdBillAndDepIdMap = this.getOnbrdBillId(paraDyn);
            if (CollectionUtils.isEmpty(onbrdBillAndDepIdMap)) {
                logger.info("HCDMConfirmEntryServiceImpl consumerSaveMsg error: onbrdBillAndDepIdMap is null.");
                return HRMServiceResult.fail((String)ResManager.loadKDString((String)"\u5165\u804c\u5355\u636eID\u4e3a\u7a7a\u3002", (String)"HCDMConfirmEntryServiceImpl_1", (String)"swc-hcdm-mservice", (Object[])new Object[0]));
            }
            new CandSetSalActEntryService().confirmEntryAppl(onbrdBillAndDepIdMap);
        }
        catch (Exception e) {
            logger.error("HCDMConfirmEntryServiceImpl consumerSaveMsg error: ", (Throwable)e);
            throw e;
        }
        logger.info("HCDMConfirmEntryServiceImpl consumerSaveMsg end...");
        return HRMServiceResult.success();
    }

    private Map<Long, Long> getOnbrdBillId(DynamicObject paraDyn) {
        String msgContent = paraDyn.getString("msgcontent");
        if (StringUtils.isEmpty((Object)msgContent)) {
            logger.info("HCDMConfirmEntryServiceImpl consumerSaveMsg msgcontent is null.");
            throw new KDBizException("paraDyn.msgcontent is null.");
        }
        Map contentMap = (Map)SerializationUtils.deSerializeFromBase64((String)msgContent);
        logger.info("HCDMConfirmEntryServiceImpl.getOnbrdBillId,, contentMap = {}", (Object)contentMap);
        Long recordId = this.getChgrecordId(contentMap);
        Map recordResult = (Map)SWCMServiceUtils.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoByRecordId", (Object[])new Object[]{recordId});
        Boolean success = MapUtils.getBoolean((Map)recordResult, (Object)"success", (Boolean)Boolean.FALSE);
        if (!success.booleanValue()) {
            throw new KDBizException("IHPFSPersonChgService.getChgInfoByRecordId is not success:recordId = " + recordId);
        }
        logger.info("HCDMConfirmEntryServiceImpl.getOnbrdBillId,recordId = {},result = {}", (Object)recordId, (Object)recordResult);
        Map datas = MapUtils.getMap((Map)recordResult, (Object)"data", new HashMap(0));
        if (CollectionUtils.isEmpty((Map)datas)) {
            throw new KDBizException("IHPFSPersonChgService.getChgInfoByRecordId recordResult.datas is null.");
        }
        Long billId = MapUtils.getLong((Map)datas, (Object)"billId", (Long)0L);
        if (billId == 0L) {
            throw new KDBizException("IHPFSPersonChgService.getChgInfoByRecordId recordResult.datas.billId is null.");
        }
        Object data = datas.get("data");
        if (data == null) {
            throw new KDBizException("IHPFSPersonChgService.getChgInfoByRecordId recordResult.datas.data is null.");
        }
        List dataList = (List)data;
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            throw new KDBizException("IHPFSPersonChgService.getChgInfoByRecordId recordResult.datas.dataList is null.");
        }
        HashMap<Long, Long> onbrdBillAndDepIdMap = new HashMap<Long, Long>(16);
        for (Map personMap : dataList) {
            Map depeMap = (Map)personMap.get("hrpi_depemp");
            if (depeMap == null) {
                logger.info("HCDMConfirmEntryServiceImpl getOnbrdBillId depeMap is null...recordId = {},result = {}", (Object)recordId, (Object)recordResult);
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u5355\u201c%s\u201d\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4eba\u4e0d\u5b58\u5728\u3002", (String)"HCDMConfirmEntryServiceImpl_0", (String)"swc-hcdm-mservice", (Object[])new Object[0]), billId));
            }
            Object boid = depeMap.get("boid");
            if (boid == null) {
                logger.info("HCDMConfirmEntryServiceImpl getOnbrdBillId depeMap.boid is null...recordId = {},result = {}", (Object)recordId, (Object)recordResult);
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u5355\u201c%s\u201d\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4eba\u4e0d\u5b58\u5728\u3002", (String)"HCDMConfirmEntryServiceImpl_0", (String)"swc-hcdm-mservice", (Object[])new Object[0]), billId));
            }
            onbrdBillAndDepIdMap.put(billId, (Long)boid);
        }
        return onbrdBillAndDepIdMap;
    }

    private Long getChgrecordId(Map<String, Object> contentMap) {
        Long chgrecordId = (Long)contentMap.get("chgrecordId");
        if (chgrecordId != null && chgrecordId > 0L) {
            return chgrecordId;
        }
        Long recordId = (Long)contentMap.get("recordId");
        return recordId != null && recordId > 0L ? recordId : null;
    }
}

