/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.mservice;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActDynHelper;
import kd.swc.hcdm.business.activity.dealer.ActivityDealer;
import kd.swc.hcdm.business.mq.CandSetSalActConsumer;
import kd.swc.hcdm.mservice.api.IHCDMStopEntryService;

public class HCDMStopEntryServiceImpl
implements IHCDMStopEntryService {
    private static final Log logger = LogFactory.getLog(CandSetSalActConsumer.class);

    public HRMServiceResult consumerSaveMsg(DynamicObject dynamicObject) {
        try {
            return this.cancelCandSetSalAct(dynamicObject);
        }
        catch (Exception e) {
            logger.info("HCDMStopEntryServiceImpl consumerSaveMsg error: {}", (Object)e);
            return HRMServiceResult.fail((String)e.getMessage());
        }
    }

    private HRMServiceResult cancelCandSetSalAct(DynamicObject dynamicObject) {
        String msgContent = dynamicObject.getString("msgcontent");
        List bizDataInfos = (List)SerializationUtils.deSerializeFromBase64((String)msgContent);
        if (CollectionUtils.isEmpty((Collection)bizDataInfos)) {
            logger.info("HCDMStopEntryServiceImpl consumerSaveMsg param is null : bizDataInfos");
            return HRMServiceResult.success();
        }
        List bizBillIds = bizDataInfos.stream().map(obj -> (Long)obj.get("bizBillId")).collect(Collectors.toList());
        DynamicObject[] bizActDyns = CandSetSalActDynHelper.queryByOnbrdInfoIds(bizBillIds);
        if (bizActDyns == null || bizActDyns.length == 0) {
            logger.info("HCDMStopEntryServiceImpl consumerSaveMsg bizBillIds query result is null: {}", bizBillIds);
            return HRMServiceResult.success();
        }
        ActivityDealer activityDealer = ActivityDealer.getActivityDealer((String)"hcdm_candsetsalact");
        activityDealer.batchCancelActivity(bizActDyns, "2");
        return HRMServiceResult.success();
    }
}

