/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.mservice.update.candidate;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CandidateSalaryOfferIdUpdateService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(CandidateSalaryOfferIdUpdateService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        log.info("CandidateSalaryUpdateService update");
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateOfferId();
            result.setSuccess(true);
        }
        catch (Exception ex) {
            result.setErrorInfo(ex.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    public void updateOfferId() {
        String querySql = "SELECT FID,FOFFERCODE FROM T_HCDM_CANDIDATE WHERE FOFFERID = 0 OR FOFFERID is null";
        HashSet offerCodeSet = Sets.newHashSetWithExpectedSize((int)16);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryHCDMCandidateBill", (DBRoute)new DBRoute("hcdm"), (String)querySql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row next = dateSet.next();
                offerCodeSet.add(next.getString("FOFFERCODE"));
                map.put(next.getLong("FID"), next.getString("FOFFERCODE"));
            }
        }
        if (CollectionUtils.isEmpty((Collection)offerCodeSet)) {
            return;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID ,FNUMBER FROM T_TSO_OFFER WHERE FNUMBER IN ('");
        sqlBuilder.append(Joiner.on((String)"','").join((Iterable)offerCodeSet)).append("')");
        HashMap offerMap = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryTSCOfferInfo", (DBRoute)new DBRoute("tsc"), (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row next = dateSet.next();
                if (SWCStringUtils.isEmpty((String)next.getString("FNUMBER"))) continue;
                offerMap.put(next.getString("FNUMBER"), next.getLong("FID"));
            }
        }
        if (CollectionUtils.isEmpty((Map)offerMap)) {
            return;
        }
        ArrayList updateParams = Lists.newArrayListWithExpectedSize((int)map.size());
        for (Map.Entry entry : map.entrySet()) {
            Long id = (Long)entry.getKey();
            Long offerId = (Long)offerMap.get(entry.getValue());
            if (null == offerId) continue;
            Object[] upParam = new Object[]{offerId, id};
            updateParams.add(upParam);
        }
        if (!CollectionUtils.isEmpty((Collection)updateParams)) {
            String updateSql = "UPDATE T_HCDM_CANDIDATE SET FOFFERID = ? WHERE FID = ? ";
            SWCDbUtil.executeBatch((DBRoute)new DBRoute("hcdm"), (String)updateSql, (List)updateParams);
        }
    }
}

