/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;

public class HCDMColorHelper {
    private static final String[] RED = new String[]{"FFF0F1", "FFE2E5", "FFCCD1", "FFBBC2", "FF929D", "F57582", "E65E67", "D9333B", "B8292F", "800D00", "660A00", "520800"};
    private static final String[] ORANGE = new String[]{"FFF8EB", "FFF0D5", "FFE7BA", "FFD591", "FFBC5C", "FFA960", "F88D48", "DD7836", "AD4E00", "873800", "702F00", "5C2600"};
    private static final String[] YELLOW = new String[]{"FEFFE6", "FDFFCE", "FFFFB8", "FFF690", "FFE86B", "FBE139", "F4D40A", "D4B106", "AD8B00", "876800", "705600", "5C4700"};
    private static final String[] GREEN = new String[]{"EFFCE3", "E6FDD1", "D9F7BE", "B7EBBF", "95DE64", "73D13D", "52C41A", "389E0D", "237804", "135200", "237804", "135200"};
    private static final String[] CYAN = new String[]{"E8FFFB", "D3FFF8", "B5F5EC", "87E8DE", "45DAD1", "26C9C3", "0FB4B4", "06868A", "00646C", "00474F", "00373D", "002E33"};
    private static final String[] BLUE = new String[]{"F5FCFF", "E6F7FF", "BAE7FF", "91D5FF", "69C0FF", "40A9FF", "1890FF", "096DD9", "0050B3", "003A8C", "003073", "002559"};
    private static final String[] PURPLE = new String[]{"FAF5FF", "F8EFFF", "EFDBFF", "D3ADF7", "B889EA", "9F69E2", "8049C6", "531DAB", "391085", "22075E", "190545", "10032B"};
    private static final String[] RED_PURPLE = new String[]{"FCF2F6", "FCE2ED", "FFD6E7", "FFADD2", "F78ABF", "F273B5", "EC58A9", "C41D7F", "9E106B", "780650", "610541", "520436"};
    private static final String[] ORANGE_RED = new String[]{"FFF2EB", "FFE4D6", "FFD2B9", "FFB186", "FF8F50", "FF762A", "F55C0B", "D94F03", "AD2102", "871400", "701100", "5C0E00"};
    private static final String[] ORANGE_YELLOW = new String[]{"FFFBE6", "FFF7CD", "FFF1B8", "FFE58F", "FFD666", "FFC53D", "FAAD14", "D48806", "AD6800", "874D00", "704000", "5C3400"};
    private static final String[] BLUE_PURPLE = new String[]{"F5F8FF", "F0F5FF", "D6E4FF", "ADC6FF", "8BA2FF", "6682F5", "4465EB", "1D39C4", "10239E", "061178", "050D5E", "040A45"};
    private static final String[] YELLOW_GREEN = new String[]{"F9FFDB", "F4FFB8", "EAFF8F", "D3F261", "BAE637", "A0D911", "7CB305", "5B8C00", "3F6600", "2B4500", "203300", "192900"};

    private HCDMColorHelper() {
    }

    private static int getStartIndex(int num) {
        switch (num) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 2;
            }
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
        }
        return 0;
    }

    public static List<String> getColors(ColorParam param) {
        if (null == param) {
            return null;
        }
        int step = 1;
        int num = param.getNum();
        ArrayList<String> list = new ArrayList<String>(num);
        int startIndex = HCDMColorHelper.getStartIndex(num);
        Color color = param.getColor();
        String[] values = color.getValues();
        int length = values.length;
        if (startIndex == 0) {
            for (int i = startIndex; i < num; ++i) {
                list.add(param.getPrefix() + values[i % length]);
            }
        } else {
            for (int i = 0; i < num; ++i) {
                list.add(param.getPrefix() + values[startIndex]);
                startIndex += step;
            }
        }
        return list;
    }

    public static Map<String, List<String>> batchGetColors(List<ColorParam> params) {
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }
        int size = params.size();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(size);
        for (ColorParam param : params) {
            String key = param.getKey();
            map.put(key, HCDMColorHelper.getColors(param));
        }
        return map;
    }

    static /* synthetic */ String[] access$000() {
        return BLUE_PURPLE;
    }

    static /* synthetic */ String[] access$100() {
        return BLUE;
    }

    static /* synthetic */ String[] access$200() {
        return CYAN;
    }

    public static class ColorParam {
        private String key;
        private Color color;
        private int num;
        private String prefix;

        public ColorParam(String key, int num, Color color, String prefix) {
            this.key = key;
            this.num = num;
            this.color = color;
            this.prefix = prefix;
        }

        public String getKey() {
            return this.key;
        }

        public int getNum() {
            return this.num;
        }

        public Color getColor() {
            return this.color;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static enum Color {
        BLUE_PURPLE(1, HCDMColorHelper.access$000()),
        BLUE(2, HCDMColorHelper.access$100()),
        CYAN(3, HCDMColorHelper.access$200());

        private int code;
        private String[] values;

        private Color(int code, String[] values) {
            this.code = code;
            this.values = values;
        }

        public int getCode() {
            return this.code;
        }

        public String[] getValues() {
            return this.values;
        }
    }
}

