/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.swc.hcdm.business.SalaryStandardFilterHelper;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.service.SalaryStdDomainService;
import kd.swc.hcdm.common.entity.filter.FilterParam;

public class SalaryStandardDeleteEntHelper {
    public static void deleteEntData(DynamicObjectCollection coll, FilterParam<?> filter) {
        if (coll == null || filter == null) {
            return;
        }
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyObj = (DynamicObject)iterator.next();
            if (!SalaryStandardFilterHelper.condition(dyObj, filter)) continue;
            iterator.remove();
        }
    }

    public static void deleteEntData(DynamicObjectCollection coll, FilterParam<?>[] filters) {
        if (coll == null || filters == null || filters.length < 1) {
            return;
        }
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyObj = (DynamicObject)iterator.next();
            if (!SalaryStandardFilterHelper.condition(dyObj, filters)) continue;
            iterator.remove();
        }
    }

    public static void deleteEntDataByFilterAnd(DynamicObjectCollection coll, List<FilterParam<?>> filters) {
        if (coll == null || filters == null || filters.size() < 1) {
            return;
        }
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyObj = (DynamicObject)iterator.next();
            if (!SalaryStandardFilterHelper.condition(dyObj, filters)) continue;
            iterator.remove();
        }
    }

    public static void deleteStdData(DynamicObjectCollection coll, String fieldType, Collection<Long> identityIds, boolean isIn, Map<String, Map<Integer, Long>> gradeRankSeqMap, List<Long> delDataItemIds) {
        if (coll == null || fieldType == null || identityIds == null || identityIds.size() < 1) {
            return;
        }
        switch (fieldType) {
            case "salarystditemid": {
                Iterator iterator = coll.iterator();
                while (iterator.hasNext()) {
                    DynamicObject dyObj = (DynamicObject)iterator.next();
                    long salaryStdItemId = dyObj.getLong("salarystditemid_a");
                    if (isIn && identityIds.contains(salaryStdItemId)) {
                        iterator.remove();
                    }
                    if (isIn || identityIds.contains(salaryStdItemId)) continue;
                    iterator.remove();
                }
                break;
            }
            case "salarydatarank": {
                SalaryStandardDeleteEntHelper.removeStdData(coll, identityIds, isIn, "rankIdentity", gradeRankSeqMap, null);
                break;
            }
            case "salarydatagrade": {
                SalaryStandardDeleteEntHelper.removeStdData(coll, identityIds, isIn, "gradeIdentity", gradeRankSeqMap, null);
                break;
            }
            case "rankInItems": {
                SalaryStandardDeleteEntHelper.removeStdData(coll, identityIds, isIn, "rankIdentity", gradeRankSeqMap, delDataItemIds);
                break;
            }
        }
    }

    private static void removeStdData(DynamicObjectCollection coll, Collection<Long> identityIds, boolean isIn, String gradeOrRankKey, Map<String, Map<Integer, Long>> gradeRankSeqMap, List<Long> delDataItemIds) {
        Iterator iterator = coll.iterator();
        SalaryStdDomainService salaryStdDomainService = new SalaryStdDomainService();
        while (iterator.hasNext()) {
            DynamicObject dyObj = (DynamicObject)iterator.next();
            if (delDataItemIds != null && !delDataItemIds.contains(dyObj.getLong("salarystditemid_a"))) continue;
            String stdDataJsonStr = dyObj.getString("stddata");
            Map<String, Map<String, String>> stdDataMap = salaryStdDomainService.parseJsonToMap(stdDataJsonStr);
            Iterator<Map.Entry<String, Map<String, String>>> iteratorIn = stdDataMap.entrySet().iterator();
            while (iteratorIn.hasNext()) {
                Map.Entry<String, Map<String, String>> stdDataMapEntry = iteratorIn.next();
                String gradeRankKey = stdDataMapEntry.getKey();
                Map<String, Long> gradeAndRankIdFromCombineKey = salaryStdDomainService.getGradeAndRankIdFromCombineKey(gradeRankKey, gradeRankSeqMap);
                Long gradeIdentity = gradeAndRankIdFromCombineKey.get(gradeOrRankKey);
                if (isIn) {
                    if (!identityIds.contains(gradeIdentity)) continue;
                    iteratorIn.remove();
                    continue;
                }
                if (identityIds.contains(gradeIdentity)) continue;
                iteratorIn.remove();
            }
            dyObj.set("stddata", (Object)JSON.toJSONString(stdDataMap));
            if (!stdDataMap.isEmpty()) continue;
            iterator.remove();
        }
    }

    public static void deleteEntDataByFilterOr(DynamicObjectCollection coll, List<FilterParam<?>> filters) {
        if (coll == null || filters == null || filters.size() < 1) {
            return;
        }
        Iterator iterator = coll.iterator();
        block0: while (iterator.hasNext()) {
            DynamicObject dyObj = (DynamicObject)iterator.next();
            for (FilterParam<?> filterParam : filters) {
                if (!SalaryStandardFilterHelper.condition(dyObj, filterParam)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    public static void batchDeleteEntData(DynamicObjectCollection cols, List<List<FilterParam<?>>> delParmsList) {
        if (cols == null || delParmsList == null || delParmsList.size() < 1) {
            return;
        }
        Iterator iterator = cols.iterator();
        block0: while (iterator.hasNext()) {
            DynamicObject dyObj = (DynamicObject)iterator.next();
            for (List<FilterParam<?>> delParms : delParmsList) {
                if (!SalaryStandardFilterHelper.condition(dyObj, delParms)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }
}

