/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.activity;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.activity.ActInstanceHelper;
import kd.swc.hcdm.business.activity.msg.ActivityMsgHelper;
import kd.swc.hcdm.common.enums.ActivityMsgSceneEnum;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class ActivityBaseDynHelper {
    private static Log LOGGER = LogFactory.getLog(ActivityBaseDynHelper.class);
    static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_activitybase");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject createActBaseByInsId(Long instanceId) {
        DynamicObject activityBaseDyn = serviceHelper.generateEmptyDynamicObject();
        try {
            CodeRuleServiceHelper.injectNumbers((String)"hcdm_activitybase", (List)Lists.newArrayList((Object[])new DynamicObject[]{activityBaseDyn}));
            if (StringUtils.isEmpty((CharSequence)activityBaseDyn.getString("number"))) {
                throw new KDBizException("generateActivity generate number is null...");
            }
        }
        catch (Exception ext) {
            LOGGER.error("ActivityBaseDynHelper createActBaseByInsId generate activity number is error:", (Throwable)ext);
            String lockKey = "_generateCandidateNumberErrMsgSendCount_" + instanceId;
            DLock lock = DLock.create((String)lockKey);
            try {
                if (lock.tryLock(10000L)) {
                    if (ActivityBaseDynHelper.getMsgByInstanceId(instanceId, ActivityMsgSceneEnum.GENERATE_NUMBER_ERROR)) {
                        ActivityMsgHelper.sendMsgByInstanceId(instanceId, ActivityMsgSceneEnum.GENERATE_NUMBER_ERROR);
                        LOGGER.info("ActivityBaseDynHelper sendMsgByInstanceId generate activity number error msg success");
                    }
                } else {
                    LOGGER.info("ActivityBaseDynHelper sendMsgByInstanceId generate activity number error msg fail");
                }
            }
            finally {
                lock.unlock();
                lock.close();
            }
            throw new KDBizException((Throwable)ext, new ErrorCode(ActivityMsgSceneEnum.GENERATE_NUMBER_ERROR.getSceneCode(), "generate activity number is error..."), new Object[0]);
        }
        DynamicObject activityInsDyn = serviceHelper.generateEmptyDynamicObject("hrcs_activityins");
        activityInsDyn.set("id", (Object)instanceId);
        activityBaseDyn.set("activityins", (Object)activityInsDyn);
        activityBaseDyn.set("activitystatus", (Object)"0");
        return activityBaseDyn;
    }

    public static boolean getMsgByInstanceId(Long instanceId, ActivityMsgSceneEnum generateNumberError) {
        DynamicObject instanceDyn = ActInstanceHelper.getActivityInsById("bizbillid,bizkey,handlers", instanceId);
        if (instanceDyn == null) {
            LOGGER.info("ActivityMsgHelper sendMsgByInstanceId error instanceId is not exist : {}", (Object)instanceId);
            return false;
        }
        long bizBillId = instanceDyn.getLong("bizbillid");
        String cacheKey = generateNumberError.getSceneCode() + "_" + bizBillId;
        ISWCAppCache appCache = SWCAppCache.get((String)cacheKey);
        Integer sendCount = (Integer)appCache.get("sendCount", Integer.class);
        if (sendCount == null) {
            sendCount = 0;
        }
        return sendCount < 3;
    }

    public static Set<Long> queryIdByCurrUser() {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject[] query = serviceHelper.query("id", new QFilter[]{new QFilter("activityins.handlers.fbasedataid_id", "=", (Object)currUserId)});
        if (query == null || query.length == 0) {
            return new HashSet<Long>(0);
        }
        return Arrays.stream(query).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
    }

    public static void saveOne(DynamicObject activityBaseDyn) {
        serviceHelper.saveOne(activityBaseDyn);
    }

    public static void save(DynamicObject[] activityBaseDyns) {
        serviceHelper.save(activityBaseDyns);
    }

    public static QFilter getDefaultFilter() {
        return new QFilter("activitystatus", "!=", (Object)"40");
    }
}

