/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.activity;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.activity.ActivityBaseDynHelper;
import kd.swc.hcdm.common.enums.ActivityErrorEnum;

public class ActivityDealHelper {
    private static Log LOGGER = LogFactory.getLog(ActivityDealHelper.class);

    public static Map<Long, String> getErrorMap(OperationResult result) {
        HashMap<Long, String> errorMap = new HashMap<Long, String>(0);
        List errorInfos = result.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)errorInfos)) {
            for (IOperateInfo errorInfo : errorInfos) {
                String message = errorInfo.getMessage();
                if (StringUtils.isEmpty((CharSequence)message)) {
                    message = ((OperateErrorInfo)errorInfo).getErrorCode();
                }
                errorMap.put((Long)errorInfo.getPkValue(), message);
            }
        }
        return errorMap;
    }

    public static void logErrorInfo(DynamicObject activityBaseDyn, boolean isActRight, ActivityErrorEnum errorEnum, String errorMsg) {
        String errorType = null;
        if (!isActRight) {
            errorType = errorEnum.addError(activityBaseDyn.getString("errortype"));
            errorMsg = "traceId: " + RequestContext.get().getTraceId() + "; " + errorMsg;
            if (errorMsg.length() > 255) {
                errorMsg = errorMsg.substring(0, 255);
            }
        }
        activityBaseDyn.set("isactright", (Object)isActRight);
        activityBaseDyn.set("errortype", (Object)errorType);
        activityBaseDyn.set("errormsg", (Object)errorMsg);
    }

    public static void logErrorInfo(Set<DynamicObject> actBaseDyns, boolean isActRight, ActivityErrorEnum errorEnum, String errorMsg) {
        if (CollectionUtils.isEmpty(actBaseDyns)) {
            return;
        }
        for (DynamicObject actBaseDyn : actBaseDyns) {
            ActivityDealHelper.logErrorInfo(actBaseDyn, isActRight, errorEnum, errorMsg);
        }
    }

    public static void saveErrorInfo(List<DynamicObject> actBaseDyns, boolean isActRight, ActivityErrorEnum errorEnum, String errorMsg) {
        if (CollectionUtils.isEmpty(actBaseDyns)) {
            return;
        }
        for (DynamicObject actBaseDyn : actBaseDyns) {
            ActivityDealHelper.logErrorInfo(actBaseDyn, isActRight, errorEnum, errorMsg);
        }
        ActivityBaseDynHelper.save(actBaseDyns.toArray(new DynamicObject[actBaseDyns.size()]));
    }
}

