/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.activity.candsetsal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActDynHelper;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyService;
import kd.swc.hcdm.business.candidatesetsalaryappl.OnBrdInfoPushToCandSetSalApplService;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.CandSetSalApplyRefreshService;
import kd.swc.hcdm.business.candidatesetsalaryappl.refresh.entity.RefreshResult;
import kd.swc.hcdm.business.candidatesetsalaryappl.syncfile.CandSetSalApplySynFileService;

public class CandSetSalActEntryService {
    private static final Log logger = LogFactory.getLog(CandSetSalActEntryService.class);

    public void confirmEntryAppl(Map<Long, Long> onbrdBillAndDepIdMap) {
        DynamicObject[] appls = CandidateSetSalApplyService.queryNotConfirmEntryAppl(null, onbrdBillAndDepIdMap.keySet());
        if (appls == null || appls.length == 0) {
            this.createCandSetSalApply(onbrdBillAndDepIdMap);
        } else {
            this.confirmEntryToAppl(appls, onbrdBillAndDepIdMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmEntryToAppl(DynamicObject[] appls, Map<Long, Long> onbrdBillAndDepIdMap) {
        Set<Long> synFileApplyIds;
        String entityId = "hcdm_singlecandsetsalappl";
        String groupId = MutexHelper.getMutexGroupId((String)entityId, (String)"refreshonbrd");
        HashSet lockFailApplyIds = Sets.newHashSetWithExpectedSize((int)appls.length);
        ArrayList lockApplys = Lists.newArrayListWithCapacity((int)appls.length);
        try {
            for (DynamicObject appl : appls) {
                long applyId = appl.getLong("id");
                if (!this.addMutexLock(entityId, String.valueOf(applyId), groupId, "refreshonbrd")) {
                    lockFailApplyIds.add(applyId);
                    continue;
                }
                lockApplys.add(appl);
            }
            CandSetSalActEntryService.refreshCandSetSalApply(lockApplys);
            synFileApplyIds = CandidateSetSalApplyService.confirmEntryToAppl(lockApplys.toArray(new DynamicObject[0]), onbrdBillAndDepIdMap);
        }
        finally {
            this.removeMutexLock(entityId, lockApplys.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet()), "refreshonbrd");
        }
        if (!CollectionUtils.isEmpty(synFileApplyIds)) {
            CandSetSalApplySynFileService.synCandSetSalApply(new ArrayList<Long>(synFileApplyIds), "4");
        }
        if (!CollectionUtils.isEmpty((Collection)lockFailApplyIds)) {
            logger.info("addMutexLock error lockFailApplyIds:", (Object)lockFailApplyIds);
            throw new KDBizException(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u6b63\u88ab\u5176\u4ed6\u64cd\u4f5c\uff08\u5982\u4fee\u6539\u3001\u66f4\u65b0\u5165\u804c\u4fe1\u606f\uff09\u5360\u7528\uff0c\u8bf7\u5148\u9000\u51fa\u64cd\u4f5c\u6216\u5220\u9664\u7f51\u7edc\u4e92\u65a5\u540e\u518d\u91cd\u8bd5\u3002", (String)"", (String)"", (Object[])new Object[0]));
        }
    }

    public static void refreshCandSetSalApply(List<DynamicObject> appls) {
        List<DynamicObject> canRefreshApplies = CandSetSalApplyRefreshHelper.filterCanRefreshApply(appls);
        if (CollectionUtils.isEmpty(canRefreshApplies)) {
            logger.info("CandSetSalActEntryService refreshCandSetSalApply canRefreshApplies is null.");
            return;
        }
        Map<Long, RefreshResult> resultMap = CandSetSalApplyRefreshService.refreshPersonAndItemByApplies(canRefreshApplies);
        if (CollectionUtils.isEmpty(resultMap)) {
            resultMap = new HashMap<Long, RefreshResult>(0);
        }
        for (DynamicObject appl : canRefreshApplies) {
            DynamicObjectCollection personDyns = appl.getDynamicObjectCollection("candsetsalperson");
            if (personDyns == null || personDyns.size() == 0) continue;
            for (DynamicObject personDyn : personDyns) {
                long personDynId = personDyn.getLong("id");
                RefreshResult result = resultMap.get(personDynId);
                if (result == null) {
                    logger.info("CandSetSalActEntryService refreshCandSetSalApply result is null : personDynId = {}", (Object)personDynId);
                    throw new KDBizException("CandSetSalActEntryService refreshCandSetSalApply result is null...");
                }
                if (result.isSuccess()) continue;
                logger.info("CandSetSalActEntryService refreshCandSetSalApply result is error :{}", (Object)result);
                throw new KDBizException("CandSetSalActEntryService refreshCandSetSalApply result is error : " + result.getErrorMsg());
            }
        }
    }

    private void createCandSetSalApply(Map<Long, Long> onbrdBillAndDepIdMap) {
        DynamicObject[] candSetSalActDyns = CandSetSalActDynHelper.queryNoStartActByOnbrdInfoIds(onbrdBillAndDepIdMap.keySet());
        if (candSetSalActDyns == null || candSetSalActDyns.length == 0) {
            return;
        }
        ArrayList candidateSetSalActs = Lists.newArrayListWithCapacity((int)onbrdBillAndDepIdMap.size());
        HashMap onbrdInfoIdToActIdMap = Maps.newHashMapWithExpectedSize((int)onbrdBillAndDepIdMap.size());
        String entityId = "hcdm_candsetsalact";
        String groupId = MutexHelper.getMutexGroupId((String)entityId, (String)"createappl");
        HashSet lockFailOnbrdBillIds = Sets.newHashSetWithExpectedSize((int)onbrdBillAndDepIdMap.size());
        for (DynamicObject candSetSalActDyn : candSetSalActDyns) {
            DynamicObject actBase = candSetSalActDyn.getDynamicObject("activitybase");
            boolean isCandSetSal = candSetSalActDyn.getBoolean("iscandsetsal");
            if (actBase == null) {
                logger.info("CandSetSalActEntryService createCandSetSalApply candSetSalActDyn{} actBase is null.", (Object)candSetSalActDyn.getLong("id"));
                continue;
            }
            if (!isCandSetSal) continue;
            long onbrdBillId = candSetSalActDyn.getLong("onbrdinfoid");
            long candSetSalActId = candSetSalActDyn.getLong("id");
            if (!this.addMutexLock(entityId, String.valueOf(candSetSalActId), groupId, "createappl")) {
                lockFailOnbrdBillIds.add(onbrdBillId);
                continue;
            }
            onbrdInfoIdToActIdMap.put(onbrdBillId, candSetSalActId);
            candidateSetSalActs.add(candSetSalActDyn);
        }
        if (!CollectionUtils.isEmpty(onbrdBillAndDepIdMap)) {
            try {
                this.createOnbrdBill(onbrdBillAndDepIdMap, onbrdInfoIdToActIdMap, candidateSetSalActs);
            }
            catch (Exception e) {
                logger.error("createCandSetSalApply createOnbrdBill error:", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", "createCandSetSalApply createOnbrdBill error:" + e.getMessage()), new Object[0]);
            }
            finally {
                this.removeMutexLock(entityId, onbrdInfoIdToActIdMap.values(), "createappl");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)lockFailOnbrdBillIds)) {
            throw new KDBizException("addMutexLock error lockFailOnbrdBillIds:" + lockFailOnbrdBillIds);
        }
    }

    private void createOnbrdBill(Map<Long, Long> onbrdBillAndDepIdMap, Map<Long, Long> onbrdInfoIdToActIdMap, List<DynamicObject> candidateSetSalActs) {
        List<Map<String, Object>> result = OnBrdInfoPushToCandSetSalApplService.pushToCandSetSalAppl(onbrdInfoIdToActIdMap);
        Set<Long> applyIds = CandSetSalActHelper.updateActStatus(candidateSetSalActs, result);
        try (TXHandle txHandle = TX.requiresNew();){
            CandSetSalActHelper.saveAct(candidateSetSalActs);
            if (!CollectionUtils.isEmpty(applyIds)) {
                DynamicObject[] applyDyns = CandidateSetSalApplyService.queryApplById(applyIds);
                CandidateSetSalApplyService.confirmEntryToAppl(applyDyns, onbrdBillAndDepIdMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMutexLock(String entityId, Collection<Long> ids, String op) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        DataMutex dataMutex = DataMutex.create();
        try {
            for (Long id : ids) {
                dataMutex.release(String.valueOf(id), entityId, op);
            }
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException e) {
                logger.error("removeMutexLock dataMutex close error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMutexLock(String entityId, String id, String groupId, String op) {
        DataMutex dataMutex = DataMutex.create();
        try {
            Map lockInfo = dataMutex.getLockInfo(id, groupId, entityId);
            if (null != lockInfo && !lockInfo.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = dataMutex.require(id, groupId, entityId, op);
            return bl;
        }
        catch (Exception e) {
            logger.error("{} addMutexLock error ", (Object)groupId, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException e) {
                logger.error("close dataMutex error ", (Throwable)e);
            }
        }
    }
}

